function a_p = plotAllIVs(a_vc, title_str, props)

% plotAllIVs - Plot superposed I/V curves for activation, inactivation and steady-state.
%
% Usage:
% a_p = plotAllIVs(a_vc, title_str, props)
%
% Parameters:
%   a_vc: A voltage_clamp object.
%   title_str: (Optional) Text to appear in the plot title.
%   props: A structure with any optional properties.
%     quiet: If 1, only use given title_str.
%     skipStep: Number of voltage steps to skip at the start (default=0).
%		
% Returns:
%   a_p: A plot_abstract object.
%
% Description:
%
% Example:
% >> plotFigure(plotAllIVs(data_vc, 'I/V curves'))
%
% See also: model_data_vcs, voltage_clamp, plot_abstract, plotFigure
%
% $Id: plotAllIVs.m 1334 2012-04-19 18:02:13Z cengique $
%
% Author: Cengiz Gunay <cgunay@emory.edu>, 2011/07/16

props = defaultValue('props', struct);
title_str = defaultValue('title_str', '');

if isfield(props, 'quiet')
  all_title = title_str;
else
  all_title = [' IV act, steady, inact' title_str ];
end

% modify time steps since all peaks are calculated using calcCurPeaks here
skip_step = getFieldDefault(props, 'skipStep', 0);

% plot comparison of data and model peaks 
a_p = ...
    plot_superpose({...
      plotSteadyIV(calcCurPeaks(a_vc, 2 + skip_step, ...
                                struct('pulseStartRel', [1 + skip_step 1], 'pulseEndRel', [1 + skip_step 10], ...
                                       'avgAroundMs', .3)), ...
                   2 + skip_step, '', ...
                   struct('noTitle', 1, ...
                          'label', 'act peak', 'plotPeaks', 1, ...
                          'plotProps', ...
                          struct('Color', 'b'))), ... 
      plotSteadyIV(a_vc, ...
                   2 + skip_step, '', ...
                   struct('noTitle', 1, ...
                          'stepRange', [2 + skip_step -15 -5], ...
                          'label', 'steady', ...
                          'plotProps', ...
                          struct('Color', 'r'))), ...
      plotSteadyIV(calcCurPeaks(a_vc, 3 + skip_step, ...
                                struct('pulseStartRel', [2 + skip_step .1], 'pulseEndRel', [2 + skip_step 10], ...
                                       'avgAroundMs', .3)), ...
                   2 + skip_step, '', ...
                   struct('noTitle', 1, ...
                          'label', 'inact peak', ...
                          'plotPeaks', 1, ...
                          'plotProps', ...
                          struct('Color', 'g')))}, ...
                   {}, '', ...
                   mergeStructs(props, struct('noCombine', 1, ...
                                              'fixedSize', [2.5 2])));
