function item = getItem(dataset, index)

% getItem - Returns the dataset item at given index.
%
% Usage:
% item = getItem(dataset, index)
%
% Description:
%
%   Parameters:
%	dataset: A params_tests_dataset.
%	index: Index of item in dataset.
%		
%   Returns:
%	item: Object, filename, etc.
%
% See also: itemResultsRow, params_tests_dataset, paramNames, testNames
%
% $Id: getItem.m 1335 2012-04-19 18:04:32Z cengique $
%
% Author: Cengiz Gunay <cgunay@emory.edu>, 2004/12/03

% Copyright (c) 2007 Cengiz Gunay <cengique@users.sf.net>.
% This work is licensed under the Academic Free License ("AFL")
% v. 3.0. To view a copy of this license, please look at the COPYING
% file distributed with this software or visit
% http://opensource.org/licenses/afl-3.0.php.

if iscell(dataset.list)
  item = dataset.list{index};
else
  item = dataset.list(index);
end
