# OO-NVU
Object-oriented implementation of the NVU model and code.

Master branch: NVU 1.2

NVU 1.2
-------
Contains the following components that were not present in NVU 1.1:
* Extracellular space compartment
* Astrocytic calcium pathway with EETs
* TRPV4 channel on the astrocytic endfoot
* Nitric oxide pathway

Code 
----
The code is run in Matlab:
1) To solve the system use the script nvu_run_script.m
2) To quickly plot all variables use the script plot_all_variables.m 

Courtesy of the research group at University of Canterbury lead by Tim David. Majority of credit goes to:
Allanah Kenny, Dr Katharina Dormanns

For further information on the model refer to the following papers:

Farr, H., & David, T. (2011). Models of neurovascular coupling via potassium and EET signalling. Journal of Theoretical Biology, 286(1), 13–23. http://doi.org/10.1016/j.jtbi.2011.07.006

Dormanns, K., van Disseldorp, E. M. J., Brown, R. G., & David, T. (2015). Neurovascular coupling and the influence of luminal agonists via the endothelium. Journal of Theoretical Biology, 364, 49–70. http://doi.org/10.1016/j.jtbi.2014.08.029

Dormanns, K., Brown, R. G. G., & David, T. (2016). The role of nitric oxide in neurovascular coupling. Journal of Theoretical Biology, 394, 1–17. http://doi.org/10.1016/j.jtbi.2016.01.009
