/*
 *  muscle_names.cpp
 *
 *  Copyright (C) 2017 Lorenzo Vannucci
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "muscle_names.h"


namespace muscle {

namespace names {

const Name primary_rate("primary_rate");
const Name secondary_rate("secondary_rate");

const Name L("L");
const Name dL("dL");

const Name T_bag1("T_bag1");
const Name T_bag2("T_bag2");
const Name T_chain("T_chain");

const Name primary("primary");

const Name tau_dyn("tau_dyn");
const Name a_dyn("a_dyn");
const Name tau_st("tau_st");
const Name a_st("a_st");

const Name bag1_beta0("bag1_beta0");
const Name bag1_beta("bag1_beta");
const Name bag1_gamma("bag1_gamma");
const Name bag1_Ksr("bag1_Ksr");
const Name bag1_Kpr("bag1_Kpr");
const Name bag1_a("bag1_a");
const Name bag1_R("bag1_R");
const Name bag1_Lsr0("bag1_Lsr0");
const Name bag1_Lpr0("bag1_Lpr0");
const Name bag1_G("bag1_G");
const Name bag1_LsrN("bag1_LsrN");
const Name bag1_X("bag1_X");
const Name bag1_Lsec("bag1_Lsec");
const Name bag1_LprN("bag1_LprN");

const Name bag2_beta0("bag2_beta0");
const Name bag2_beta("bag2_beta");
const Name bag2_gamma("bag2_gamma");
const Name bag2_Ksr("bag2_Ksr");
const Name bag2_Kpr("bag2_Kpr");
const Name bag2_a("bag2_a");
const Name bag2_R("bag2_R");
const Name bag2_Lsr0("bag2_Lsr0");
const Name bag2_Lpr0("bag2_Lpr0");
const Name bag2_G("bag2_G");
const Name bag2_LsrN("bag2_LsrN");
const Name bag2_X("bag2_X");
const Name bag2_Lsec("bag2_Lsec");
const Name bag2_LprN("bag2_LprN");

const Name chain_beta0("chain_beta0");
const Name chain_beta("chain_beta");
const Name chain_gamma("chain_gamma");
const Name chain_Ksr("chain_Ksr");
const Name chain_Kpr("chain_Kpr");
const Name chain_a("chain_a");
const Name chain_R("chain_R");
const Name chain_Lsr0("chain_Lsr0");
const Name chain_Lpr0("chain_Lpr0");
const Name chain_G("chain_G");
const Name chain_LsrN("chain_LsrN");
const Name chain_X("chain_X");
const Name chain_Lsec("chain_Lsec");
const Name chain_LprN("chain_LprN");

}

}
