function [fitresult, gof] = createFit_WTD1(dist_WTD1, amp_WTD1)
%CREATEFIT(DIST_WTD1,AMP_WTD1)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input : dist_WTD1
%      Y Output: amp_WTD1
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 12-Dec-2017 15:32:22


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( dist_WTD1, amp_WTD1 );

% Set up fittype and options.
ft = fittype( 'exp1' );
opts = fitoptions( 'Method', 'NonlinearLeastSquares' );
opts.Display = 'Off';
opts.Normalize = 'on';
opts.StartPoint = [0.0162312691731286 -0.225671213654268];

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );
size(fitresult)
size(xData)
size(yData)
figure(1)
% Plot fit with data.
% figure( 'Name', 'untitled fit 1' );
h = plot( fitresult, xData, yData );
xlim([0 350]);
ylim([0 0.018]);
legend( h, 'amp_WTD1 vs. dist_WTD1', 'untitled fit 1', 'Location', 'NorthEast' );
% Label axes
% xlabel dist_WTD1
% ylabel amp_WTD1
% grid on


