: $Id: netstim.mod,v 1.2 2003/03/31 13:27:47 hines Exp $
: comments at end

NEURON	{ 
  ARTIFICIAL_CELL stim
  RANGE y, frequency, number, start, noise, change, event, flag, hey, on, end
}

PARAMETER {
	frequency	= 1 (1/s) <1e-9,1e9>: mean frequency of spiking = 1000/interval (from netstim.mod)
	number	= 10 <0,1e9>	: number of spikes
	start		= 50 (ms)	: start of first spike
	noise		= 0 <0,1>	: amount of randomeaness (0.0 - 1.0)
}

ASSIGNED {
	y
	event (ms)
	on
	end (ms)
	change	(ms)	: the frequency will change at thist time, so recalculate
	hey 
}

PROCEDURE seed(x) {
	set_seed(x)
:	VERBATIM
:		printf("Seed is %g\n", _lx);
:	ENDVERBATIM
}

INITIAL {
	on = 0
	y = 0

	if (noise < 0) {
		noise = 0
	}
	if (noise > 1) {
		noise = 1
	}
	if (start >= 0 && number > 0) {
		: randomize the first spike so on average it occurs at
		: start + noise*(1/frequency)*(1000)
		event = start + invl((1/frequency)*(1000)) - (1/frequency)*(1000)*(1. - noise)
		: but not earlier than 0
		if (event < 0) {
			event = 0
		}
		if (event > change) { init_sequence(t) net_send(change-t, 4) hey = 4}	: next spike is after frequency change, so it must be recalculated
		else {	net_send(event-t, 3) hey = 3}
	}
}	

PROCEDURE init_sequence(t(ms)) {
	if (number > 0) {
		on = 1
		event = t
		end = t + 1e-6 + invl((1/frequency)*(1000))*(number-1)	: controls how many spikes are generated by defining mean 
	: time to stop spiking - so with noise = 0, it's exact, with noise number becomes a mean number of spikes
	}
}

FUNCTION invl(mean (ms)) (ms) {
	if (mean <= 0.) {
		mean = .01 (ms) : I would worry if it were 0.
	}
	if (noise == 0) {
		invl = mean
	}else{
		invl = (1. - noise)*mean + noise*mean*exprand(1)
	}
}

PROCEDURE event_time() {
	if (number > 0) {
		event = event + invl((1/frequency)*(1000))
	}
	if (event > end) {
		on = 0			: stop spiking (based on number?)
	}
}

NET_RECEIVE (w) {
	if (flag == 0) { : external event 
		y = 2
		net_event(t)		: sends event at time t to all processes connected to jstim
		net_send(.1, 2)		: spike ends in 0.1 ms
		hey = 2
	}
	if (flag == 3) { : from INITIAL
		if (on == 0) {
			init_sequence(t)
			net_send(0, 1)	: net_send(interval, flag) is self event to arrive at t+interval
			hey = 1
		}
	}
	if (flag == 1 && on == 1) {
		y = 2
		net_event(t)		: sends event at time t to all processes connected to jstim
		event = t
		event_time()

		if (event > change) {
			net_send(change-t, 4)	: at time of frequency change, recalculate next spike w/ new frequency
			hey = 4
		} else { 
			if (on == 1) {
				net_send(event - t, 1)
				hey = 1
			}
		}

		net_send(.1, 2)		: spike ends in 0.1 ms
		hey = 2
	}
	if (flag == 2) {
		y = 0
	}
	if (flag == 4) {
		event = t
		event_time()		: recalculate next event time with new frequency
		if (on == 1) {
			if (event > change) {
				net_send(change - t, 4)	: at time of frequency change, recalculate next spike w/ new frequency
				hey = 4
			} else { 
				net_send(event - t, 1)
				hey = 1
			}
		}
	}
}

COMMENT
Presynaptic spike generator
---------------------------

This mechanism has been written to be able to use synapses in a single
neuron receiving various types of presynaptic trains.  This is a "fake"
presynaptic compartment containing a spike generator.  The trains
of spikes can be either periodic or noisy (Poisson-distributed)

Parameters;
   noise: 	between 0 (no noise-periodic) and 1 (fully noisy)
   interval: 	mean time between spikes (ms)
   number: 	mean number of spikes

Written by Z. Mainen, modified by A. Destexhe, The Salk Institute

Modified by Michael Hines for use with CVode
The intrinsic bursting parameters have been removed since
generators can stimulate other generators to create complicated bursting
patterns with independent statistics (see below)

Modified by Michael Hines to use logical event style with NET_RECEIVE
This stimulator can also be triggered by an input event.
If the stimulator is in the on=0 state and receives a positive weight
event, then the stimulator changes to the on=1 state and goes through
its entire spike sequence before changing to the on=0 state. During
that time it ignores any positive weight events. If, in the on=1 state,
the stimulator receives a negative weight event, the stimulator will
change to the off state. In the off state, it will ignore negative weight
events. A change to the on state immediately fires the first spike of
its sequence.

ENDCOMMENT

