(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    455476,      11221]
NotebookOptionsPosition[    444294,      10960]
NotebookOutlinePosition[    444649,      10976]
CellTagsIndexPosition[    444606,      10973]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
    "Twist", " ", "Chain", " ", "Simulation", "\[IndentingNewLine]", "Jihwan",
      " ", "Myung", " ", "2016"}], "-", 
    RowBox[{
    "2017", "\[IndentingNewLine]", "For", "\[IndentingNewLine]", 
     "\"\<The Choroid Plexus is an Important Circadian Clock Component\>\"", 
     "\[IndentingNewLine]", "By", "\[IndentingNewLine]", "Jihwan", " ", 
     "Myung"}]}], ",", " ", 
   RowBox[{"Christoph", " ", "Schmal"}], ",", " ", 
   RowBox[{"Sungho", " ", "Hong"}], ",", " ", 
   RowBox[{"Yoshiaki", " ", "Tsukizawa"}], ",", " ", 
   RowBox[{"Pia", " ", "Rose"}], ",", " ", 
   RowBox[{"Yong", " ", "Zhang"}], ",", " ", 
   RowBox[{"Michael", " ", 
    RowBox[{"J", ".", "Holtzman"}]}], ",", " ", 
   RowBox[{"Erik", " ", "De", " ", "Schutter"}], ",", 
   RowBox[{"Hanspeter", " ", "Herzel"}], ",", 
   RowBox[{"Grigory", " ", "Bordyugov"}], ",", 
   RowBox[{"Toru", " ", "Takumi", " ", "\[IndentingNewLine]", " ", 
    StyleBox["Nature",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontSlant->"Italic"], 
    StyleBox["Communications",
     FontSlant->"Italic"], " ", 
    RowBox[{"(", "2018", ")"}]}]}], "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.727326706834606*^9, 
  3.727326873653687*^9}},ExpressionUUID->"ed107204-e754-43c2-b95d-\
2e659720d2f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Call", " ", "the", " ", "basic", " ", "analysis", " ", "package"}], ",", 
    " ", 
    RowBox[{
    "FFTPeriod", " ", "is", " ", "the", " ", "function", " ", "that", " ", 
     "will", " ", "be", " ", "used"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"<<", "PMTAnalysis`"}]}]], "Input",
 CellChangeTimes->{{3.7015943711552467`*^9, 3.701594378937586*^9}, 
   3.727326876750806*^9, {3.727326939924287*^9, 
   3.727326978897518*^9}},ExpressionUUID->"db001ea4-3807-4c4a-8381-\
1049b979bfd0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Graph", " ", "display", " ", "settings"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetOptions", "[", 
    RowBox[{"ListPlot", ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "16"}]}], "]"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"AbsoluteThickness", "[", "1.1", "]"}]}], "]"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "None"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.70168039306341*^9, 3.701680503614414*^9}, {
  3.7016805398779383`*^9, 3.7016805463595877`*^9}, {3.701680594525426*^9, 
  3.701680661226947*^9}, {3.727326984412957*^9, 
  3.727326998477683*^9}},ExpressionUUID->"d5bcdbbf-dec5-4380-9550-\
08e1d28f80b7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot", ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "16"}]}], "]"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"AbsoluteThickness", "[", "1.1", "]"}]}], "]"}]}], ",", 
    RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.701716337588092*^9, 3.701716345965666*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "4", " ", "random", " ", "seeds", " ", "make", " ", "4", " ", "replicate", 
   " ", "sets"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.702630979652981*^9, 3.702630986023934*^9}, {
  3.7273272148490257`*^9, 
  3.727327242184656*^9}},ExpressionUUID->"c2e21d84-a06f-4af5-970a-\
9adb5175834d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"normPer", "=", "25.5"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Mean", " ", "period"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stdPer", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Standard", " ", "deviation", " ", "of", " ", "period"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stdPha", "=", "1"}], ";", " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Standard", " ", "deviation", " ", "of", " ", "inital", " ", "phases"}], 
   " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.702636555498034*^9, 3.702636583866912*^9}, {
  3.7026378212612953`*^9, 3.702637821492156*^9}, {3.702663362541938*^9, 
  3.7026633630801497`*^9}, {3.7026641379757757`*^9, 3.702664138517108*^9}, {
  3.702666248348237*^9, 3.702666267300962*^9}, {3.702667500593507*^9, 
  3.702667501636098*^9}, {3.702671410530266*^9, 3.7026714212948713`*^9}, {
  3.7026727567546463`*^9, 3.702672760505747*^9}, {3.702673267855795*^9, 
  3.702673268023431*^9}, {3.702703086857801*^9, 3.7027030873579617`*^9}, {
  3.7027038883334417`*^9, 3.7027038923322077`*^9}, {3.727327244207469*^9, 
  3.727327291390029*^9}},ExpressionUUID->"ea794ded-181d-4323-a0cb-\
0e238e330180"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Gaussian", " ", "period", " ", "distribution", " ", "and", " ", "initial", 
   " ", "phases"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.727327299127243*^9, 
  3.727327321232677*^9}},ExpressionUUID->"2af6f99b-b914-4bcf-9353-\
712fa020f89d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"omega", "[", "n", "]"}], "=", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"normPer", ",", "stdPer"}], "]"}], "]"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.702627515676042*^9, {3.702629848349822*^9, 3.7026298501965837`*^9}, 
   3.702630966844348*^9, {3.702631068509531*^9, 3.7026310745001*^9}, {
   3.7026327207942867`*^9, 3.702632724518775*^9}, {3.702633330718072*^9, 
   3.7026333323914337`*^9}, 3.702633496496318*^9, {3.702634178382641*^9, 
   3.702634181602103*^9}, {3.702634745028792*^9, 3.702634746083631*^9}, 
   3.70263648700212*^9, {3.702636587205291*^9, 
   3.702636591320702*^9}},ExpressionUUID->"2e6a3634-3a34-49ad-afef-\
dad2f78c199b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.22361457111321073`", ",", "0.24771850970543288`", ",", 
   "0.23518750921142773`", ",", "0.24088467739397332`", ",", 
   "0.2552692972220819`", ",", "0.25412735293971417`", ",", 
   "0.24247741841888257`", ",", "0.24608800299774983`", ",", 
   "0.24552643939669`", ",", "0.24672358076629072`", ",", 
   "0.25398716161052437`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7026309672368517`*^9, 3.70263239713384*^9, 3.702632767700246*^9, 
   3.702633583346405*^9, 3.702634189438202*^9, 3.702634502627626*^9, 
   3.702634816562166*^9, {3.702636279763309*^9, 3.7026362913217497`*^9}, 
   3.702636538854249*^9, 3.702636629977323*^9, 3.702637824171933*^9, 
   3.7026381884932613`*^9, 3.702638604922359*^9, 3.702639939205027*^9, 
   3.702640097844412*^9, 3.702640297205229*^9, 3.702640541992735*^9, 
   3.70265829706925*^9, 3.702663158944153*^9, 3.70266415617066*^9, 
   3.702664362719488*^9, 3.7026662944249287`*^9, 3.702667514923016*^9, {
   3.7026706204297647`*^9, 3.7026706503692007`*^9}, 3.702670828988545*^9, 
   3.70267117542316*^9, 3.702671460141212*^9, 3.702672762159815*^9, 
   3.7026730188026876`*^9, 3.702673288792775*^9, 3.7027027284848537`*^9, 
   3.702703119141548*^9, 3.702703631935924*^9, 
   3.7027039931562967`*^9},ExpressionUUID->"114f4469-80da-4df8-861a-\
d51f96de633e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"initphi", "[", "n", "]"}], "=", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "stdPha"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7026301856976*^9, 3.7026302335134*^9}, {
  3.7026311126777563`*^9, 3.702631112804646*^9}, {3.702634441091703*^9, 
  3.702634441885377*^9}, {3.702636241175712*^9, 3.7026362416787663`*^9}, {
  3.702636594010034*^9, 
  3.702636595091591*^9}},ExpressionUUID->"7aa82007-fa57-47e5-802b-\
6c52be603e7e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.8687734880172023`"}], ",", 
   RowBox[{"-", "2.5321853334049838`"}], ",", "0.22203550223699198`", ",", 
   RowBox[{"-", "0.3141446873556963`"}], ",", 
   RowBox[{"-", "0.03207444051495094`"}], ",", 
   RowBox[{"-", "1.4025229831260142`"}], ",", 
   RowBox[{"-", "0.8196904631368045`"}], ",", "0.06850092270219259`", ",", 
   "2.492496285935787`", ",", "1.0575760533697127`", ",", 
   "1.4706422733769111`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.702630233863492*^9, 3.70263028986205*^9, 3.7026311153186483`*^9, 
   3.702632397233273*^9, 3.702632767793921*^9, 3.702633583424601*^9, 
   3.702634189531955*^9, 3.702634502721115*^9, 3.702634816638171*^9, {
   3.702636279861964*^9, 3.702636291539783*^9}, 3.7026365389554157`*^9, 
   3.702636630082082*^9, 3.7026378242159367`*^9, 3.702638188575901*^9, 
   3.702638605001369*^9, 3.702639939289213*^9, 3.7026400978933687`*^9, 
   3.702640297287846*^9, 3.702640542076219*^9, 3.702658297149086*^9, 
   3.702663159042283*^9, 3.702664156245514*^9, 3.702664362810207*^9, 
   3.7026662945054483`*^9, 3.702667515005863*^9, {3.702670620530964*^9, 
   3.702670650441019*^9}, 3.702670829076673*^9, 3.702671175550527*^9, 
   3.70267146024724*^9, 3.702672762238791*^9, 3.702673018888905*^9, 
   3.702673288851598*^9, 3.7027027285275497`*^9, 3.7027031191844063`*^9, 
   3.702703632011609*^9, 
   3.702703993238945*^9},ExpressionUUID->"0ab6591d-4ea9-4cc6-8c41-\
d89336af77b2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Poincare", " ", "oscillator", " ", "parameters"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.727327337906952*^9, 
  3.727327345540402*^9}},ExpressionUUID->"3cdf83fd-a99e-4fed-97df-\
5670b88aba59"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"A", "[", "n", "]"}], "=", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ";", " ", 
  RowBox[{"(*", " ", "Amplitude", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"lambda", "[", "n", "]"}], "=", "0.02"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"epsilon", "[", "n", "]"}], "=", 
     RowBox[{"-", "0.01"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.701592109123899*^9, 3.701592187655644*^9}, {
   3.701592292376863*^9, 3.70159229757843*^9}, {3.701593177499959*^9, 
   3.70159318354132*^9}, {3.701594795571322*^9, 3.7015948122744226`*^9}, {
   3.701595679610372*^9, 3.7015956891429043`*^9}, 3.701597297497655*^9, 
   3.7015987516895657`*^9, {3.701598979329241*^9, 3.701598980086918*^9}, {
   3.7016304786960907`*^9, 3.7016304792601423`*^9}, {3.70163412484762*^9, 
   3.701634127214263*^9}, {3.701634793202614*^9, 3.7016347971711807`*^9}, {
   3.7016348923286133`*^9, 3.701634896438542*^9}, {3.7016349861047583`*^9, 
   3.701634991859316*^9}, {3.7016351307830153`*^9, 3.701635131472205*^9}, {
   3.7016358560832033`*^9, 3.70163586251119*^9}, {3.7016359631797256`*^9, 
   3.701635963319414*^9}, {3.701636062740675*^9, 3.701636066171221*^9}, 
   3.701636192242647*^9, {3.70167870805737*^9, 3.701678708546014*^9}, {
   3.701715257394617*^9, 3.701715259331745*^9}, 3.7017155464459887`*^9, {
   3.701715665391807*^9, 3.701715669818822*^9}, {3.701864800572988*^9, 
   3.701864802173258*^9}, {3.702115107822256*^9, 3.7021151112498083`*^9}, 
   3.702119990477234*^9, 3.702120119336974*^9, {3.702571790007826*^9, 
   3.70257179443744*^9}, 3.70262524986236*^9, {3.702625461793284*^9, 
   3.7026254827254143`*^9}, {3.702625812224172*^9, 3.702625816330701*^9}, {
   3.702625963591008*^9, 3.7026259641699457`*^9}, {3.7026259967797832`*^9, 
   3.702625997421143*^9}, {3.702626849432908*^9, 3.702626851539234*^9}, 
   3.702627024098254*^9, {3.702627214259529*^9, 3.702627220864999*^9}, {
   3.702627520480261*^9, 3.70262753913258*^9}, {3.702627924267459*^9, 
   3.702627930065922*^9}, 3.70262812732815*^9, 3.702628869562608*^9, 
   3.702629841066773*^9, {3.702632734950327*^9, 3.702632735176022*^9}, 
   3.70263326986335*^9, {3.702634472046775*^9, 3.70263447282276*^9}, {
   3.702634804827936*^9, 3.702634805068267*^9}, {3.702636267569186*^9, 
   3.70263627666136*^9}, {3.7026365069614887`*^9, 3.702636509450933*^9}, {
   3.7026378072474823`*^9, 3.7026378084400682`*^9}, 3.702638181596671*^9, 
   3.7026385942771187`*^9, {3.7026399297057858`*^9, 3.702639932751007*^9}, {
   3.7026400862302027`*^9, 3.702640087191649*^9}, {3.702640284898651*^9, 
   3.702640286387514*^9}, 3.7026405393178596`*^9, {3.7026582903220387`*^9, 
   3.7026582953836613`*^9}, {3.702663150381201*^9, 3.702663157102*^9}, {
   3.702663351849606*^9, 3.702663353907886*^9}, {3.70266414033636*^9, 
   3.70266414259426*^9}, {3.702667510344653*^9, 3.702667513233349*^9}, 
   3.702670615014789*^9, {3.7026706482245197`*^9, 3.702670648279421*^9}, {
   3.702670816204686*^9, 3.702670819872957*^9}, 3.7027026134456663`*^9, {
   3.702702722032317*^9, 3.702702724020857*^9}, {3.702703091161525*^9, 
   3.702703095756929*^9}, {3.702703985846612*^9, 3.702703991552011*^9}, {
   3.7273273260337887`*^9, 
   3.727327336654686*^9}},ExpressionUUID->"65d33015-6847-4c09-8013-\
1098c699d8f2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"r1", "[", "t_", "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x1", "[", "t", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"y1", "[", "t", "]"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"r2", "[", "t_", "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x2", "[", "t", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"y2", "[", "t", "]"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"r3", "[", "t_", "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x3", "[", "t", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"y3", "[", "t", "]"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"r4", "[", "t_", "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x4", "[", "t", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"y4", "[", "t", "]"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"r5", "[", "t_", "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x5", "[", "t", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"y5", "[", "t", "]"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"r6", "[", "t_", "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x6", "[", "t", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"y6", "[", "t", "]"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"r7", "[", "t_", "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x7", "[", "t", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"y7", "[", "t", "]"}], "^", "2"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.702114766586936*^9, 3.7021148236293716`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"phi1", "[", "t_", "]"}], ":=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"x1", "[", "t", "]"}], ",", 
     RowBox[{"y1", "[", "t", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi2", "[", "t_", "]"}], ":=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"x2", "[", "t", "]"}], ",", 
     RowBox[{"y2", "[", "t", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi3", "[", "t_", "]"}], ":=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"x3", "[", "t", "]"}], ",", 
     RowBox[{"y3", "[", "t", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi4", "[", "t_", "]"}], ":=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"x4", "[", "t", "]"}], ",", 
     RowBox[{"y4", "[", "t", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi5", "[", "t_", "]"}], ":=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"x5", "[", "t", "]"}], ",", 
     RowBox[{"y5", "[", "t", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi6", "[", "t_", "]"}], ":=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"x6", "[", "t", "]"}], ",", 
     RowBox[{"y6", "[", "t", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi7", "[", "t_", "]"}], ":=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"x7", "[", "t", "]"}], ",", 
     RowBox[{"y7", "[", "t", "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.70211482670691*^9, 3.7021149100220757`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"coupling1", "[", "t_", "]"}], ":=", 
   RowBox[{"0.0025", "*", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"t", "<", 
       RowBox[{"24", "*", "30"}]}], ",", "1", ",", "0"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coupling2", "[", "t_", "]"}], ":=", 
   RowBox[{"0.0025", "*", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"t", "<", 
       RowBox[{"24", "*", "30"}]}], ",", "1", ",", "0"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coupling3", "[", "t_", "]"}], ":=", 
   RowBox[{"0.0025", "*", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"t", "<", 
       RowBox[{"24", "*", "30"}]}], ",", "1", ",", "0"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coupling4", "[", "t_", "]"}], ":=", 
   RowBox[{"0.0025", "*", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"t", "<", 
       RowBox[{"24", "*", "30"}]}], ",", "1", ",", "0"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coupling5", "[", "t_", "]"}], ":=", 
   RowBox[{"0.0025", "*", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"t", "<", 
       RowBox[{"24", "*", "30"}]}], ",", "1", ",", "0"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coupling6", "[", "t_", "]"}], ":=", 
   RowBox[{"0.0025", "*", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"t", "<", 
       RowBox[{"24", "*", "30"}]}], ",", "1", ",", "0"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coupling7", "[", "t_", "]"}], ":=", 
   RowBox[{"0.0025", "*", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"t", "<", 
       RowBox[{"24", "*", "30"}]}], ",", "1", ",", "0"}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJwdyk0og3EAx/GR8lY7OKDs4GUH1JY027w1Y8LQhBrJ0thWJitxYImyHeRE
pmTN+2je04Y8NJJk5WUkHLCLra1mLhJN/r/n8O1z+aYpdfWqSAaDwSJBR0mQ
VWQKiLdbeOnwc7gnD6ra5vhw82xNmTwVED/GN7RDebRiN4dI3SzbYUfxjjqX
+Hwn1cDSla0RuLdaYoRq9oAJmnllU/DPlvQNB7f1tDnx2gwecV8apmUzX2TQ
OdlcByn/khrqj8waGLKPj/GJCdV/tI1DsntY536lTTl0/EADp+8X9j+9/wqI
uo3OMPSL5BYh8SKbNQsrCr4uYa9g3gXd4jdGPpFpEkbAlZrAMuzmGqyQ6+WH
JcTz1hnaROPBZDmxcjTLBD2KIFVJlC5ojmAUx+eFhYJjH7RaPLFVRI3QFge7
nNPrMFW0uAFPJUtXMCYi8xo+TLg+oFrmD9H/be1JE1F7QNH+A/zc5wo=
  "]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"ODE", " ", "solver"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.727327362691436*^9, 
  3.7273273658408117`*^9}},ExpressionUUID->"051b3946-a49a-4681-bede-\
4133431e7496"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"nsol1", "[", "q", "]"}], "=", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "1", "]"}], "-", 
               RowBox[{"r1", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "1", "]"}], "*", 
                RowBox[{"x1", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "1", "]"}], "*", 
                RowBox[{"y1", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "1", "]"}], "*", 
             RowBox[{"y1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "1", "]"}], "-", 
               RowBox[{"r1", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "1", "]"}], "*", 
                RowBox[{"y1", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "1", "]"}], "*", 
                RowBox[{"x1", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "1", "]"}], "*", 
             RowBox[{"x1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "2", "]"}], "-", 
               RowBox[{"r2", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "2", "]"}], "*", 
                RowBox[{"x2", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "2", "]"}], "*", 
                RowBox[{"y2", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "2", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling1", "[", "t", "]"}], "*", 
             RowBox[{"x1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "2", "]"}], "-", 
               RowBox[{"r2", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "2", "]"}], "*", 
                RowBox[{"y2", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "2", "]"}], "*", 
                RowBox[{"x2", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "2", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling1", "[", "t", "]"}], "*", 
             RowBox[{"y1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x3", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "3", "]"}], "-", 
               RowBox[{"r3", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "3", "]"}], "*", 
                RowBox[{"x3", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "3", "]"}], "*", 
                RowBox[{"y3", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "3", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y3", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "3", "]"}], "-", 
               RowBox[{"r3", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "3", "]"}], "*", 
                RowBox[{"y3", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "3", "]"}], "*", 
                RowBox[{"x3", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "3", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x4", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "4", "]"}], "-", 
               RowBox[{"r4", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "4", "]"}], "*", 
                RowBox[{"x4", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "4", "]"}], "*", 
                RowBox[{"y4", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "4", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y4", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "4", "]"}], "-", 
               RowBox[{"r4", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "4", "]"}], "*", 
                RowBox[{"y4", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "4", "]"}], "*", 
                RowBox[{"x4", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "4", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x5", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "5", "]"}], "-", 
               RowBox[{"r5", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "5", "]"}], "*", 
                RowBox[{"x5", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "5", "]"}], "*", 
                RowBox[{"y5", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "5", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y5", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "5", "]"}], "-", 
               RowBox[{"r5", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "5", "]"}], "*", 
                RowBox[{"y5", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "5", "]"}], "*", 
                RowBox[{"x5", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "5", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x6", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "6", "]"}], "-", 
               RowBox[{"r6", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "6", "]"}], "*", 
                RowBox[{"x6", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "6", "]"}], "*", 
                RowBox[{"y6", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "6", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling7", "[", "t", "]"}], "*", 
             RowBox[{"x7", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y6", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "6", "]"}], "-", 
               RowBox[{"r6", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "6", "]"}], "*", 
                RowBox[{"y6", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "6", "]"}], "*", 
                RowBox[{"x6", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "6", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling7", "[", "t", "]"}], "*", 
             RowBox[{"y7", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x7", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "7", "]"}], "-", 
               RowBox[{"r7", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "7", "]"}], "*", 
                RowBox[{"x7", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "7", "]"}], "*", 
                RowBox[{"y7", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "7", "]"}], "*", 
             RowBox[{"y7", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y7", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "7", "]"}], "-", 
               RowBox[{"r7", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "7", "]"}], "*", 
                RowBox[{"y7", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "7", "]"}], "*", 
                RowBox[{"x7", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "7", "]"}], "*", 
             RowBox[{"x7", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x1", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "1", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "1", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y1", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "1", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "1", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x2", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "2", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "2", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y2", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "2", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "2", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x3", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "3", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "3", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y3", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "3", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "3", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x4", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "4", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "4", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y4", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "4", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "4", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x5", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "5", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "5", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y5", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "5", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "5", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x6", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "6", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "6", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y6", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "6", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "6", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x7", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "7", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "7", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y7", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "7", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "7", "]"}]}], "]"}]}]}]}], 
         "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1", "[", "t", "]"}], ",", 
          RowBox[{"y1", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x2", "[", "t", "]"}], ",", 
          RowBox[{"y2", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x3", "[", "t", "]"}], ",", 
          RowBox[{"y3", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x4", "[", "t", "]"}], ",", 
          RowBox[{"y4", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x5", "[", "t", "]"}], ",", 
          RowBox[{"y5", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x6", "[", "t", "]"}], ",", 
          RowBox[{"y6", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x7", "[", "t", "]"}], ",", 
          RowBox[{"y7", "[", "t", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{
           RowBox[{"-", "24"}], "*", "30"}], ",", 
          RowBox[{"24", "*", "60"}]}], "}"}]}], "]"}]}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.701591718892396*^9, 3.701591897153792*^9}, {
   3.70159193612114*^9, 3.701592044219096*^9}, {3.7015922312566032`*^9, 
   3.701592231920807*^9}, 3.701592996929915*^9, {3.7015931365814667`*^9, 
   3.701593327361679*^9}, {3.7015934451291027`*^9, 3.70159348707015*^9}, {
   3.701593552339876*^9, 3.70159362199056*^9}, {3.7015937331196404`*^9, 
   3.7015937703330927`*^9}, {3.7015938590594063`*^9, 3.701593896523637*^9}, 
   3.701594007267749*^9, {3.7015948173953037`*^9, 3.701594858297886*^9}, {
   3.7015957507163486`*^9, 3.701595869089676*^9}, {3.701596683247538*^9, 
   3.7015968144522123`*^9}, {3.701596882937251*^9, 3.701596928295043*^9}, {
   3.701598519853422*^9, 3.701598533274139*^9}, {3.701631074856678*^9, 
   3.70163107580549*^9}, {3.7016347833910723`*^9, 3.701634791097128*^9}, {
   3.702114073497793*^9, 3.702114670643611*^9}, {3.702114707601068*^9, 
   3.7021147086373997`*^9}, 3.7021150206751213`*^9, {3.702115140450263*^9, 
   3.70211514069913*^9}, 3.7021151835665007`*^9, {3.702115669833634*^9, 
   3.702115739385852*^9}, {3.702119447851729*^9, 3.7021194536820517`*^9}, {
   3.702120468623344*^9, 3.70212067637958*^9}, {3.702626952691313*^9, 
   3.702626954478498*^9}, {3.702626986313326*^9, 3.7026270148052597`*^9}, {
   3.702628975730795*^9, 3.7026289832591143`*^9}, {3.7026300051632643`*^9, 
   3.702630048274618*^9}, {3.7026301369648037`*^9, 3.702630181987328*^9}, {
   3.7026302269681873`*^9, 3.702630286912737*^9}, {3.702631126001769*^9, 
   3.702631156827696*^9}, 3.70263119571216*^9}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Repeats", " ", "for", " ", "other", " ", "replicates", " ", "follow"}], 
  " ", "*)"}]], "Input",
 CellChangeTimes->{{3.727327403704874*^9, 
  3.727327413542292*^9}},ExpressionUUID->"d936d38a-8ed5-4e78-993d-\
9d40454d3624"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"omega", "[", "n", "]"}], "=", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"normPer", ",", "stdPer"}], "]"}], "]"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.702627515676042*^9, {3.702629848349822*^9, 3.7026298501965837`*^9}, 
   3.702630966844348*^9, {3.702631068509531*^9, 3.7026310745001*^9}, {
   3.7026327207942867`*^9, 3.702632724518775*^9}, {3.702633330718072*^9, 
   3.7026333323914337`*^9}, 3.702633496496318*^9, {3.702634178382641*^9, 
   3.702634181602103*^9}, {3.702634745028792*^9, 3.702634746083631*^9}, 
   3.70263648700212*^9, {3.702636587205291*^9, 3.702636591320702*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.25638540420035716`", ",", "0.237907737097574`", ",", 
   "0.2452855363142141`", ",", "0.2472123821359679`", ",", 
   "0.2507556786689174`", ",", "0.24679202889040708`", ",", 
   "0.23189201172229085`", ",", "0.24621427667778686`", ",", 
   "0.24139400746760298`", ",", "0.2267771573467593`", ",", 
   "0.24495327355763433`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7026309672368517`*^9, 3.70263239713384*^9, 3.702632767700246*^9, 
   3.702633583346405*^9, 3.702634189438202*^9, 3.702634502627626*^9, 
   3.702634816562166*^9, {3.702636279763309*^9, 3.7026362913217497`*^9}, 
   3.702636538854249*^9, 3.7026366310149107`*^9, 3.702637825053956*^9, 
   3.702638189492388*^9, 3.702638605805916*^9, 3.70263994025238*^9, 
   3.702640099217704*^9, 3.702640298762285*^9, 3.702640543522723*^9, 
   3.702658299515173*^9, 3.7026631599708853`*^9, 3.70266415719497*^9, 
   3.7026643636176577`*^9, 3.702666295322936*^9, 3.7026675159181423`*^9, {
   3.702670621654572*^9, 3.7026706513571787`*^9}, 3.702670830064083*^9, 
   3.702671176566367*^9, 3.702671461210998*^9, 3.702672763055347*^9, 
   3.702673019758462*^9, 3.702702729468688*^9, 3.702703120066965*^9, 
   3.7027036328004827`*^9, 3.702703994132127*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"initphi", "[", "n", "]"}], "=", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "stdPha"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7026301856976*^9, 3.7026302335134*^9}, {
  3.7026311126777563`*^9, 3.702631112804646*^9}, {3.702634441091703*^9, 
  3.702634441885377*^9}, {3.702636241175712*^9, 3.7026362416787663`*^9}, {
  3.702636594010034*^9, 3.702636595091591*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.09031713290202076`"}], ",", 
   RowBox[{"-", "0.17093946505981075`"}], ",", 
   RowBox[{"-", "0.7153832081983846`"}], ",", 
   RowBox[{"-", "0.006139651268173137`"}], ",", "0.9369002842300758`", ",", 
   RowBox[{"-", "0.7195529363501589`"}], ",", "0.41030876562014185`", ",", 
   "0.5219995775300044`", ",", 
   RowBox[{"-", "0.8460568397408681`"}], ",", "0.9026960371206944`", ",", 
   "0.9044044128982951`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.702630233863492*^9, 3.70263028986205*^9, 3.7026311153186483`*^9, 
   3.702632397233273*^9, 3.702632767793921*^9, 3.702633583424601*^9, 
   3.702634189531955*^9, 3.702634502721115*^9, 3.702634816638171*^9, {
   3.702636279861964*^9, 3.702636291539783*^9}, 3.7026365389554157`*^9, 
   3.7026366311187696`*^9, 3.702637825134536*^9, 3.702638189585335*^9, 
   3.70263860589743*^9, 3.702639940335511*^9, 3.702640099298246*^9, 
   3.702640298813965*^9, 3.702640543599476*^9, 3.702658299562861*^9, 
   3.702663160061967*^9, 3.702664157275743*^9, 3.702664363704625*^9, 
   3.70266629539625*^9, 3.702667516002429*^9, {3.702670621743593*^9, 
   3.702670651443541*^9}, 3.702670830155644*^9, 3.702671176645072*^9, 
   3.7026714613093843`*^9, 3.702672763140993*^9, 3.702673019848907*^9, 
   3.702702729515635*^9, 3.702703120148985*^9, 3.702703632893059*^9, 
   3.7027039942196693`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"nsol2", "[", "q", "]"}], "=", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "1", "]"}], "-", 
               RowBox[{"r1", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "1", "]"}], "*", 
                RowBox[{"x1", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "1", "]"}], "*", 
                RowBox[{"y1", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "1", "]"}], "*", 
             RowBox[{"y1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "1", "]"}], "-", 
               RowBox[{"r1", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "1", "]"}], "*", 
                RowBox[{"y1", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "1", "]"}], "*", 
                RowBox[{"x1", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "1", "]"}], "*", 
             RowBox[{"x1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "2", "]"}], "-", 
               RowBox[{"r2", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "2", "]"}], "*", 
                RowBox[{"x2", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "2", "]"}], "*", 
                RowBox[{"y2", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "2", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling1", "[", "t", "]"}], "*", 
             RowBox[{"x1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "2", "]"}], "-", 
               RowBox[{"r2", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "2", "]"}], "*", 
                RowBox[{"y2", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "2", "]"}], "*", 
                RowBox[{"x2", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "2", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling1", "[", "t", "]"}], "*", 
             RowBox[{"y1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x3", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "3", "]"}], "-", 
               RowBox[{"r3", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "3", "]"}], "*", 
                RowBox[{"x3", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "3", "]"}], "*", 
                RowBox[{"y3", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "3", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y3", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "3", "]"}], "-", 
               RowBox[{"r3", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "3", "]"}], "*", 
                RowBox[{"y3", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "3", "]"}], "*", 
                RowBox[{"x3", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "3", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x4", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "4", "]"}], "-", 
               RowBox[{"r4", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "4", "]"}], "*", 
                RowBox[{"x4", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "4", "]"}], "*", 
                RowBox[{"y4", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "4", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y4", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "4", "]"}], "-", 
               RowBox[{"r4", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "4", "]"}], "*", 
                RowBox[{"y4", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "4", "]"}], "*", 
                RowBox[{"x4", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "4", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x5", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "5", "]"}], "-", 
               RowBox[{"r5", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "5", "]"}], "*", 
                RowBox[{"x5", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "5", "]"}], "*", 
                RowBox[{"y5", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "5", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y5", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "5", "]"}], "-", 
               RowBox[{"r5", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "5", "]"}], "*", 
                RowBox[{"y5", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "5", "]"}], "*", 
                RowBox[{"x5", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "5", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x6", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "6", "]"}], "-", 
               RowBox[{"r6", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "6", "]"}], "*", 
                RowBox[{"x6", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "6", "]"}], "*", 
                RowBox[{"y6", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "6", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling7", "[", "t", "]"}], "*", 
             RowBox[{"x7", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y6", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "6", "]"}], "-", 
               RowBox[{"r6", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "6", "]"}], "*", 
                RowBox[{"y6", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "6", "]"}], "*", 
                RowBox[{"x6", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "6", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling7", "[", "t", "]"}], "*", 
             RowBox[{"y7", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x7", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "7", "]"}], "-", 
               RowBox[{"r7", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "7", "]"}], "*", 
                RowBox[{"x7", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "7", "]"}], "*", 
                RowBox[{"y7", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "7", "]"}], "*", 
             RowBox[{"y7", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y7", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "7", "]"}], "-", 
               RowBox[{"r7", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "7", "]"}], "*", 
                RowBox[{"y7", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "7", "]"}], "*", 
                RowBox[{"x7", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "7", "]"}], "*", 
             RowBox[{"x7", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x1", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "1", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "1", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y1", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "1", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "1", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x2", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "2", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "2", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y2", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "2", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "2", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x3", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "3", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "3", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y3", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "3", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "3", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x4", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "4", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "4", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y4", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "4", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "4", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x5", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "5", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "5", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y5", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "5", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "5", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x6", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "6", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "6", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y6", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "6", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "6", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x7", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "7", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "7", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y7", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "7", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "7", "]"}]}], "]"}]}]}]}], 
         "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1", "[", "t", "]"}], ",", 
          RowBox[{"y1", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x2", "[", "t", "]"}], ",", 
          RowBox[{"y2", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x3", "[", "t", "]"}], ",", 
          RowBox[{"y3", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x4", "[", "t", "]"}], ",", 
          RowBox[{"y4", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x5", "[", "t", "]"}], ",", 
          RowBox[{"y5", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x6", "[", "t", "]"}], ",", 
          RowBox[{"y6", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x7", "[", "t", "]"}], ",", 
          RowBox[{"y7", "[", "t", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{
           RowBox[{"-", "24"}], "*", "30"}], ",", 
          RowBox[{"24", "*", "60"}]}], "}"}]}], "]"}]}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.701591718892396*^9, 3.701591897153792*^9}, {
   3.70159193612114*^9, 3.701592044219096*^9}, {3.7015922312566032`*^9, 
   3.701592231920807*^9}, 3.701592996929915*^9, {3.7015931365814667`*^9, 
   3.701593327361679*^9}, {3.7015934451291027`*^9, 3.70159348707015*^9}, {
   3.701593552339876*^9, 3.70159362199056*^9}, {3.7015937331196404`*^9, 
   3.7015937703330927`*^9}, {3.7015938590594063`*^9, 3.701593896523637*^9}, 
   3.701594007267749*^9, {3.7015948173953037`*^9, 3.701594858297886*^9}, {
   3.7015957507163486`*^9, 3.701595869089676*^9}, {3.701596683247538*^9, 
   3.7015968144522123`*^9}, {3.701596882937251*^9, 3.701596928295043*^9}, {
   3.701598519853422*^9, 3.701598533274139*^9}, {3.701631074856678*^9, 
   3.70163107580549*^9}, {3.7016347833910723`*^9, 3.701634791097128*^9}, {
   3.702114073497793*^9, 3.702114670643611*^9}, {3.702114707601068*^9, 
   3.7021147086373997`*^9}, 3.7021150206751213`*^9, {3.702115140450263*^9, 
   3.70211514069913*^9}, 3.7021151835665007`*^9, {3.702115669833634*^9, 
   3.702115739385852*^9}, {3.702119447851729*^9, 3.7021194536820517`*^9}, {
   3.702120468623344*^9, 3.70212067637958*^9}, {3.702626952691313*^9, 
   3.702626954478498*^9}, {3.702626986313326*^9, 3.7026270148052597`*^9}, {
   3.702628975730795*^9, 3.7026289832591143`*^9}, {3.7026300051632643`*^9, 
   3.702630048274618*^9}, {3.7026301369648037`*^9, 3.702630181987328*^9}, {
   3.7026302269681873`*^9, 3.702630286912737*^9}, {3.702631126001769*^9, 
   3.702631156827696*^9}, {3.70263119571216*^9, 3.70263121800716*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"omega", "[", "n", "]"}], "=", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"normPer", ",", "stdPer"}], "]"}], "]"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.702627515676042*^9, {3.702629848349822*^9, 3.7026298501965837`*^9}, 
   3.702630966844348*^9, {3.702631068509531*^9, 3.7026310745001*^9}, {
   3.7026327207942867`*^9, 3.702632724518775*^9}, {3.702633330718072*^9, 
   3.7026333323914337`*^9}, 3.702633496496318*^9, {3.702634178382641*^9, 
   3.702634181602103*^9}, {3.702634745028792*^9, 3.702634746083631*^9}, 
   3.70263648700212*^9, {3.702636587205291*^9, 3.702636591320702*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.24455600476047687`", ",", "0.2508358855402223`", ",", 
   "0.24612364592553485`", ",", "0.2411230367282691`", ",", 
   "0.25370330069846314`", ",", "0.25386500335196754`", ",", 
   "0.2619267082373927`", ",", "0.24790064416016805`", ",", 
   "0.24234714082990705`", ",", "0.2417216702630059`", ",", 
   "0.24571243058778244`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7026309672368517`*^9, 3.70263239713384*^9, 3.702632767700246*^9, 
   3.702633583346405*^9, 3.702634189438202*^9, 3.702634502627626*^9, 
   3.702634816562166*^9, {3.702636279763309*^9, 3.7026362913217497`*^9}, 
   3.702636538854249*^9, 3.7026366319486017`*^9, 3.702637825811899*^9, 
   3.702638190262175*^9, 3.702638606659898*^9, 3.702639941121243*^9, 
   3.702640100268285*^9, 3.702640300112378*^9, 3.702640544732151*^9, 
   3.70265830197003*^9, 3.702663160734886*^9, 3.702664158028735*^9, 
   3.7026643643455544`*^9, 3.70266629604941*^9, 3.702667516685112*^9, {
   3.7026706225812798`*^9, 3.7026706522110567`*^9}, 3.702670830873602*^9, 
   3.702671177433881*^9, 3.702671462139275*^9, 3.7026727637670097`*^9, 
   3.702673020458783*^9, 3.702702730306568*^9, 3.70270312077351*^9, 
   3.7027036336337852`*^9, 3.70270399485219*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"initphi", "[", "n", "]"}], "=", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "stdPha"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7026301856976*^9, 3.7026302335134*^9}, {
  3.7026311126777563`*^9, 3.702631112804646*^9}, {3.702634441091703*^9, 
  3.702634441885377*^9}, {3.702636241175712*^9, 3.7026362416787663`*^9}, {
  3.702636594010034*^9, 3.702636595091591*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9746956037770861`", ",", 
   RowBox[{"-", "0.8096349148709342`"}], ",", "0.7651354436065751`", ",", 
   "1.039510948451522`", ",", "0.3410169899671941`", ",", 
   "0.18130651357384614`", ",", 
   RowBox[{"-", "1.0657271243462925`"}], ",", 
   RowBox[{"-", "0.6159337388719014`"}], ",", "1.7547592159932333`", ",", 
   RowBox[{"-", "0.6140217409361771`"}], ",", "0.4212300248990073`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.702630233863492*^9, 3.70263028986205*^9, 3.7026311153186483`*^9, 
   3.702632397233273*^9, 3.702632767793921*^9, 3.702633583424601*^9, 
   3.702634189531955*^9, 3.702634502721115*^9, 3.702634816638171*^9, {
   3.702636279861964*^9, 3.702636291539783*^9}, 3.7026365389554157`*^9, 
   3.702636632048191*^9, 3.702637825869039*^9, 3.702638190359766*^9, 
   3.702638606744452*^9, 3.7026399411703978`*^9, 3.7026401003166523`*^9, 
   3.702640300198291*^9, 3.7026405448208637`*^9, 3.7026583020530777`*^9, 
   3.7026631608107433`*^9, 3.702664158108478*^9, 3.702664364438816*^9, 
   3.702666296130397*^9, 3.7026675167735147`*^9, {3.70267062267791*^9, 
   3.702670652253734*^9}, 3.702670830966754*^9, 3.7026711774799023`*^9, 
   3.7026714622465363`*^9, 3.702672763812436*^9, 3.702673020552327*^9, 
   3.70270273039082*^9, 3.7027031208474293`*^9, 3.702703633724781*^9, 
   3.702703994898644*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"nsol3", "[", "q", "]"}], "=", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "1", "]"}], "-", 
               RowBox[{"r1", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "1", "]"}], "*", 
                RowBox[{"x1", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "1", "]"}], "*", 
                RowBox[{"y1", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "1", "]"}], "*", 
             RowBox[{"y1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "1", "]"}], "-", 
               RowBox[{"r1", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "1", "]"}], "*", 
                RowBox[{"y1", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "1", "]"}], "*", 
                RowBox[{"x1", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "1", "]"}], "*", 
             RowBox[{"x1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "2", "]"}], "-", 
               RowBox[{"r2", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "2", "]"}], "*", 
                RowBox[{"x2", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "2", "]"}], "*", 
                RowBox[{"y2", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "2", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling1", "[", "t", "]"}], "*", 
             RowBox[{"x1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "2", "]"}], "-", 
               RowBox[{"r2", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "2", "]"}], "*", 
                RowBox[{"y2", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "2", "]"}], "*", 
                RowBox[{"x2", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "2", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling1", "[", "t", "]"}], "*", 
             RowBox[{"y1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x3", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "3", "]"}], "-", 
               RowBox[{"r3", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "3", "]"}], "*", 
                RowBox[{"x3", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "3", "]"}], "*", 
                RowBox[{"y3", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "3", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y3", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "3", "]"}], "-", 
               RowBox[{"r3", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "3", "]"}], "*", 
                RowBox[{"y3", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "3", "]"}], "*", 
                RowBox[{"x3", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "3", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x4", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "4", "]"}], "-", 
               RowBox[{"r4", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "4", "]"}], "*", 
                RowBox[{"x4", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "4", "]"}], "*", 
                RowBox[{"y4", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "4", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y4", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "4", "]"}], "-", 
               RowBox[{"r4", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "4", "]"}], "*", 
                RowBox[{"y4", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "4", "]"}], "*", 
                RowBox[{"x4", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "4", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x5", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "5", "]"}], "-", 
               RowBox[{"r5", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "5", "]"}], "*", 
                RowBox[{"x5", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "5", "]"}], "*", 
                RowBox[{"y5", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "5", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y5", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "5", "]"}], "-", 
               RowBox[{"r5", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "5", "]"}], "*", 
                RowBox[{"y5", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "5", "]"}], "*", 
                RowBox[{"x5", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "5", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x6", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "6", "]"}], "-", 
               RowBox[{"r6", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "6", "]"}], "*", 
                RowBox[{"x6", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "6", "]"}], "*", 
                RowBox[{"y6", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "6", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling7", "[", "t", "]"}], "*", 
             RowBox[{"x7", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y6", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "6", "]"}], "-", 
               RowBox[{"r6", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "6", "]"}], "*", 
                RowBox[{"y6", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "6", "]"}], "*", 
                RowBox[{"x6", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "6", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling7", "[", "t", "]"}], "*", 
             RowBox[{"y7", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x7", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "7", "]"}], "-", 
               RowBox[{"r7", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "7", "]"}], "*", 
                RowBox[{"x7", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "7", "]"}], "*", 
                RowBox[{"y7", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "7", "]"}], "*", 
             RowBox[{"y7", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y7", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "7", "]"}], "-", 
               RowBox[{"r7", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "7", "]"}], "*", 
                RowBox[{"y7", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "7", "]"}], "*", 
                RowBox[{"x7", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "7", "]"}], "*", 
             RowBox[{"x7", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x1", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "1", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "1", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y1", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "1", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "1", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x2", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "2", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "2", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y2", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "2", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "2", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x3", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "3", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "3", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y3", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "3", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "3", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x4", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "4", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "4", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y4", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "4", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "4", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x5", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "5", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "5", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y5", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "5", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "5", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x6", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "6", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "6", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y6", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "6", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "6", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x7", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "7", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "7", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y7", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "7", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "7", "]"}]}], "]"}]}]}]}], 
         "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1", "[", "t", "]"}], ",", 
          RowBox[{"y1", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x2", "[", "t", "]"}], ",", 
          RowBox[{"y2", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x3", "[", "t", "]"}], ",", 
          RowBox[{"y3", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x4", "[", "t", "]"}], ",", 
          RowBox[{"y4", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x5", "[", "t", "]"}], ",", 
          RowBox[{"y5", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x6", "[", "t", "]"}], ",", 
          RowBox[{"y6", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x7", "[", "t", "]"}], ",", 
          RowBox[{"y7", "[", "t", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{
           RowBox[{"-", "24"}], "*", "30"}], ",", 
          RowBox[{"24", "*", "60"}]}], "}"}]}], "]"}]}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.701591718892396*^9, 3.701591897153792*^9}, {
   3.70159193612114*^9, 3.701592044219096*^9}, {3.7015922312566032`*^9, 
   3.701592231920807*^9}, 3.701592996929915*^9, {3.7015931365814667`*^9, 
   3.701593327361679*^9}, {3.7015934451291027`*^9, 3.70159348707015*^9}, {
   3.701593552339876*^9, 3.70159362199056*^9}, {3.7015937331196404`*^9, 
   3.7015937703330927`*^9}, {3.7015938590594063`*^9, 3.701593896523637*^9}, 
   3.701594007267749*^9, {3.7015948173953037`*^9, 3.701594858297886*^9}, {
   3.7015957507163486`*^9, 3.701595869089676*^9}, {3.701596683247538*^9, 
   3.7015968144522123`*^9}, {3.701596882937251*^9, 3.701596928295043*^9}, {
   3.701598519853422*^9, 3.701598533274139*^9}, {3.701631074856678*^9, 
   3.70163107580549*^9}, {3.7016347833910723`*^9, 3.701634791097128*^9}, {
   3.702114073497793*^9, 3.702114670643611*^9}, {3.702114707601068*^9, 
   3.7021147086373997`*^9}, 3.7021150206751213`*^9, {3.702115140450263*^9, 
   3.70211514069913*^9}, 3.7021151835665007`*^9, {3.702115669833634*^9, 
   3.702115739385852*^9}, {3.702119447851729*^9, 3.7021194536820517`*^9}, {
   3.702120468623344*^9, 3.70212067637958*^9}, {3.702626952691313*^9, 
   3.702626954478498*^9}, {3.702626986313326*^9, 3.7026270148052597`*^9}, {
   3.702628975730795*^9, 3.7026289832591143`*^9}, {3.7026300051632643`*^9, 
   3.702630048274618*^9}, {3.7026301369648037`*^9, 3.702630181987328*^9}, {
   3.7026302269681873`*^9, 3.702630286912737*^9}, {3.702631126001769*^9, 
   3.702631156827696*^9}, {3.70263119571216*^9, 3.702631225249617*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"omega", "[", "n", "]"}], "=", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"normPer", ",", "stdPer"}], "]"}], "]"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.702627515676042*^9, {3.702629848349822*^9, 3.7026298501965837`*^9}, 
   3.702630966844348*^9, {3.702631068509531*^9, 3.7026310745001*^9}, {
   3.7026327207942867`*^9, 3.702632724518775*^9}, {3.702633330718072*^9, 
   3.7026333323914337`*^9}, 3.702633496496318*^9, {3.702634178382641*^9, 
   3.702634181602103*^9}, {3.702634745028792*^9, 3.702634746083631*^9}, 
   3.70263648700212*^9, {3.702636587205291*^9, 3.702636591320702*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.24336278300659125`", ",", "0.25963706356609356`", ",", 
   "0.25011551247883057`", ",", "0.24000895709254996`", ",", 
   "0.26028640488329613`", ",", "0.24696102185015623`", ",", 
   "0.25924226625093105`", ",", "0.254164646997944`", ",", 
   "0.24641783150911756`", ",", "0.24112477825407388`", ",", 
   "0.2497650687863376`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7026309672368517`*^9, 3.70263239713384*^9, 3.702632767700246*^9, 
   3.702633583346405*^9, 3.702634189438202*^9, 3.702634502627626*^9, 
   3.702634816562166*^9, {3.702636279763309*^9, 3.7026362913217497`*^9}, 
   3.702636538854249*^9, 3.702636632728813*^9, 3.7026378265810623`*^9, 
   3.7026381910527353`*^9, 3.702638607455472*^9, 3.702639941942873*^9, 
   3.702640101214053*^9, 3.702640301604292*^9, 3.702640546035755*^9, 
   3.702658304559375*^9, 3.702663161519664*^9, 3.7026641587791233`*^9, 
   3.7026643651290607`*^9, 3.7026662967851543`*^9, 3.702667517510058*^9, {
   3.702670623558043*^9, 3.7026706531094313`*^9}, 3.7026708317202*^9, 
   3.702671178297924*^9, 3.702671462997396*^9, 3.702672764483498*^9, 
   3.702673021207645*^9, 3.702702731076063*^9, 3.702703121484565*^9, 
   3.70270363437803*^9, 3.7027039955698843`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"initphi", "[", "n", "]"}], "=", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "stdPha"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7026301856976*^9, 3.7026302335134*^9}, {
  3.7026311126777563`*^9, 3.702631112804646*^9}, {3.702634441091703*^9, 
  3.702634441885377*^9}, {3.702636241175712*^9, 3.7026362416787663`*^9}, {
  3.702636594010034*^9, 3.702636595091591*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.6997002660347507`"}], ",", "0.2884043296495384`", ",", 
   RowBox[{"-", "1.3588916796242179`"}], ",", "0.5959158551992928`", ",", 
   "0.39930020752190276`", ",", 
   RowBox[{"-", "0.04661443171592267`"}], ",", "0.36289985646386796`", ",", 
   "1.1014141945136833`", ",", 
   RowBox[{"-", "0.019533937224221462`"}], ",", 
   RowBox[{"-", "0.2698202873697087`"}], ",", "1.4384778043224262`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.702630233863492*^9, 3.70263028986205*^9, 3.7026311153186483`*^9, 
   3.702632397233273*^9, 3.702632767793921*^9, 3.702633583424601*^9, 
   3.702634189531955*^9, 3.702634502721115*^9, 3.702634816638171*^9, {
   3.702636279861964*^9, 3.702636291539783*^9}, 3.7026365389554157`*^9, 
   3.702636632835227*^9, 3.7026378266706667`*^9, 3.702638191135344*^9, 
   3.702638607543481*^9, 3.702639942021923*^9, 3.7026401012634773`*^9, 
   3.7026403016787786`*^9, 3.702640546115686*^9, 3.7026583046203814`*^9, 
   3.70266316160815*^9, 3.702664158862088*^9, 3.702664365221731*^9, 
   3.702666296839096*^9, 3.70266751762234*^9, {3.702670623643035*^9, 
   3.702670653192436*^9}, 3.7026708317878313`*^9, 3.7026711783814297`*^9, 
   3.702671463096957*^9, 3.7026727645725*^9, 3.7026730213274717`*^9, 
   3.702702731137827*^9, 3.702703121564591*^9, 3.702703634476742*^9, 
   3.7027039956527576`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"nsol4", "[", "q", "]"}], "=", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "1", "]"}], "-", 
               RowBox[{"r1", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "1", "]"}], "*", 
                RowBox[{"x1", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "1", "]"}], "*", 
                RowBox[{"y1", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "1", "]"}], "*", 
             RowBox[{"y1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "1", "]"}], "-", 
               RowBox[{"r1", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "1", "]"}], "*", 
                RowBox[{"y1", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "1", "]"}], "*", 
                RowBox[{"x1", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "1", "]"}], "*", 
             RowBox[{"x1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "2", "]"}], "-", 
               RowBox[{"r2", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "2", "]"}], "*", 
                RowBox[{"x2", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "2", "]"}], "*", 
                RowBox[{"y2", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "2", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling1", "[", "t", "]"}], "*", 
             RowBox[{"x1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "2", "]"}], "-", 
               RowBox[{"r2", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "2", "]"}], "*", 
                RowBox[{"y2", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "2", "]"}], "*", 
                RowBox[{"x2", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "2", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling1", "[", "t", "]"}], "*", 
             RowBox[{"y1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x3", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "3", "]"}], "-", 
               RowBox[{"r3", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "3", "]"}], "*", 
                RowBox[{"x3", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "3", "]"}], "*", 
                RowBox[{"y3", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "3", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y3", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "3", "]"}], "-", 
               RowBox[{"r3", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "3", "]"}], "*", 
                RowBox[{"y3", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "3", "]"}], "*", 
                RowBox[{"x3", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "3", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x4", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "4", "]"}], "-", 
               RowBox[{"r4", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "4", "]"}], "*", 
                RowBox[{"x4", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "4", "]"}], "*", 
                RowBox[{"y4", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "4", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y4", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "4", "]"}], "-", 
               RowBox[{"r4", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "4", "]"}], "*", 
                RowBox[{"y4", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "4", "]"}], "*", 
                RowBox[{"x4", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "4", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x5", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "5", "]"}], "-", 
               RowBox[{"r5", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "5", "]"}], "*", 
                RowBox[{"x5", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "5", "]"}], "*", 
                RowBox[{"y5", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "5", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y5", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "5", "]"}], "-", 
               RowBox[{"r5", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "5", "]"}], "*", 
                RowBox[{"y5", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "5", "]"}], "*", 
                RowBox[{"x5", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "5", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x6", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "6", "]"}], "-", 
               RowBox[{"r6", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "6", "]"}], "*", 
                RowBox[{"x6", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "6", "]"}], "*", 
                RowBox[{"y6", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "6", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling7", "[", "t", "]"}], "*", 
             RowBox[{"x7", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y6", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "6", "]"}], "-", 
               RowBox[{"r6", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "6", "]"}], "*", 
                RowBox[{"y6", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "6", "]"}], "*", 
                RowBox[{"x6", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "6", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling7", "[", "t", "]"}], "*", 
             RowBox[{"y7", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x7", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "7", "]"}], "-", 
               RowBox[{"r7", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "7", "]"}], "*", 
                RowBox[{"x7", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "7", "]"}], "*", 
                RowBox[{"y7", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "7", "]"}], "*", 
             RowBox[{"y7", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y7", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "7", "]"}], "-", 
               RowBox[{"r7", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "7", "]"}], "*", 
                RowBox[{"y7", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "7", "]"}], "*", 
                RowBox[{"x7", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "7", "]"}], "*", 
             RowBox[{"x7", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x1", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "1", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "1", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y1", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "1", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "1", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x2", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "2", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "2", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y2", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "2", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "2", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x3", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "3", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "3", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y3", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "3", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "3", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x4", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "4", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "4", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y4", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "4", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "4", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x5", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "5", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "5", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y5", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "5", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "5", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x6", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "6", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "6", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y6", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "6", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "6", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x7", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "7", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "7", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y7", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "7", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "7", "]"}]}], "]"}]}]}]}], 
         "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1", "[", "t", "]"}], ",", 
          RowBox[{"y1", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x2", "[", "t", "]"}], ",", 
          RowBox[{"y2", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x3", "[", "t", "]"}], ",", 
          RowBox[{"y3", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x4", "[", "t", "]"}], ",", 
          RowBox[{"y4", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x5", "[", "t", "]"}], ",", 
          RowBox[{"y5", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x6", "[", "t", "]"}], ",", 
          RowBox[{"y6", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x7", "[", "t", "]"}], ",", 
          RowBox[{"y7", "[", "t", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{
           RowBox[{"-", "24"}], "*", "30"}], ",", 
          RowBox[{"24", "*", "60"}]}], "}"}]}], "]"}]}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.701591718892396*^9, 3.701591897153792*^9}, {
   3.70159193612114*^9, 3.701592044219096*^9}, {3.7015922312566032`*^9, 
   3.701592231920807*^9}, 3.701592996929915*^9, {3.7015931365814667`*^9, 
   3.701593327361679*^9}, {3.7015934451291027`*^9, 3.70159348707015*^9}, {
   3.701593552339876*^9, 3.70159362199056*^9}, {3.7015937331196404`*^9, 
   3.7015937703330927`*^9}, {3.7015938590594063`*^9, 3.701593896523637*^9}, 
   3.701594007267749*^9, {3.7015948173953037`*^9, 3.701594858297886*^9}, {
   3.7015957507163486`*^9, 3.701595869089676*^9}, {3.701596683247538*^9, 
   3.7015968144522123`*^9}, {3.701596882937251*^9, 3.701596928295043*^9}, {
   3.701598519853422*^9, 3.701598533274139*^9}, {3.701631074856678*^9, 
   3.70163107580549*^9}, {3.7016347833910723`*^9, 3.701634791097128*^9}, {
   3.702114073497793*^9, 3.702114670643611*^9}, {3.702114707601068*^9, 
   3.7021147086373997`*^9}, 3.7021150206751213`*^9, {3.702115140450263*^9, 
   3.70211514069913*^9}, 3.7021151835665007`*^9, {3.702115669833634*^9, 
   3.702115739385852*^9}, {3.702119447851729*^9, 3.7021194536820517`*^9}, {
   3.702120468623344*^9, 3.70212067637958*^9}, {3.702626952691313*^9, 
   3.702626954478498*^9}, {3.702626986313326*^9, 3.7026270148052597`*^9}, {
   3.702628975730795*^9, 3.7026289832591143`*^9}, {3.7026300051632643`*^9, 
   3.702630048274618*^9}, {3.7026301369648037`*^9, 3.702630181987328*^9}, {
   3.7026302269681873`*^9, 3.702630286912737*^9}, {3.702631126001769*^9, 
   3.702631156827696*^9}, 3.70263119571216*^9, {3.702631231445427*^9, 
   3.702631231651105*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"omega", "[", "n", "]"}], "=", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"normPer", ",", "stdPer"}], "]"}], "]"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.702627515676042*^9, {3.702629848349822*^9, 3.7026298501965837`*^9}, 
   3.702630966844348*^9, {3.702631068509531*^9, 3.7026310745001*^9}, {
   3.7026327207942867`*^9, 3.702632724518775*^9}, {3.702633330718072*^9, 
   3.7026333323914337`*^9}, 3.702633496496318*^9, {3.702634178382641*^9, 
   3.702634181602103*^9}, {3.702634745028792*^9, 3.702634746083631*^9}, 
   3.70263648700212*^9, {3.702636587205291*^9, 3.702636591320702*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.2588313888477648`", ",", "0.2302655613921736`", ",", 
   "0.2422691571065359`", ",", "0.2424213306329327`", ",", 
   "0.24934630353891837`", ",", "0.247775444883755`", ",", 
   "0.24421242885171307`", ",", "0.2404495661329976`", ",", 
   "0.23010978696426385`", ",", "0.2394001404209587`", ",", 
   "0.25334417368897316`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7026309672368517`*^9, 3.70263239713384*^9, 3.702632767700246*^9, 
   3.702633583346405*^9, 3.702634189438202*^9, 3.702634502627626*^9, 
   3.702634816562166*^9, {3.702636279763309*^9, 3.7026362913217497`*^9}, 
   3.702636538854249*^9, 3.702636632728813*^9, 3.7026378265810623`*^9, 
   3.7026381910527353`*^9, 3.702638607455472*^9, 3.702639941942873*^9, 
   3.702640101214053*^9, 3.702640301604292*^9, 3.702640546035755*^9, 
   3.702658304559375*^9, 3.702663161519664*^9, 3.7026641587791233`*^9, 
   3.7026643651290607`*^9, 3.7026662967851543`*^9, 3.702667517510058*^9, {
   3.702670623558043*^9, 3.7026706531094313`*^9}, 3.7026708317202*^9, 
   3.702671178297924*^9, 3.702671462997396*^9, 3.702672765228307*^9, 
   3.70267302197628*^9, 3.702702731875458*^9, 3.702703122186285*^9, 
   3.7027036351388617`*^9, 3.702703996274262*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"initphi", "[", "n", "]"}], "=", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "stdPha"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7026301856976*^9, 3.7026302335134*^9}, {
  3.7026311126777563`*^9, 3.702631112804646*^9}, {3.702634441091703*^9, 
  3.702634441885377*^9}, {3.702636241175712*^9, 3.7026362416787663`*^9}, {
  3.702636594010034*^9, 3.702636595091591*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.032844765693488`"}], ",", 
   RowBox[{"-", "0.3389628357481085`"}], ",", "1.517591814644361`", ",", 
   "0.45674575763974157`", ",", "0.5553985516515167`", ",", 
   "0.011267263837107607`", ",", 
   RowBox[{"-", "0.842118237989376`"}], ",", "0.5046745878720234`", ",", 
   RowBox[{"-", "0.32915020870388323`"}], ",", "1.860483696522325`", ",", 
   RowBox[{"-", "1.1538140682835114`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.702630233863492*^9, 3.70263028986205*^9, 3.7026311153186483`*^9, 
   3.702632397233273*^9, 3.702632767793921*^9, 3.702633583424601*^9, 
   3.702634189531955*^9, 3.702634502721115*^9, 3.702634816638171*^9, {
   3.702636279861964*^9, 3.702636291539783*^9}, 3.7026365389554157`*^9, 
   3.702636632835227*^9, 3.7026378266706667`*^9, 3.702638191135344*^9, 
   3.702638607543481*^9, 3.702639942021923*^9, 3.7026401012634773`*^9, 
   3.7026403016787786`*^9, 3.702640546115686*^9, 3.7026583046203814`*^9, 
   3.70266316160815*^9, 3.702664158862088*^9, 3.702664365221731*^9, 
   3.702666296839096*^9, 3.70266751762234*^9, {3.702670623643035*^9, 
   3.702670653192436*^9}, 3.7026708317878313`*^9, 3.7026711783814297`*^9, 
   3.702671463096957*^9, 3.7026727652713747`*^9, 3.702673022055108*^9, 
   3.7027027319742537`*^9, 3.702703122267436*^9, 3.702703635188273*^9, 
   3.702703996351754*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"nsol5", "[", "q", "]"}], "=", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "1", "]"}], "-", 
               RowBox[{"r1", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "1", "]"}], "*", 
                RowBox[{"x1", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "1", "]"}], "*", 
                RowBox[{"y1", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "1", "]"}], "*", 
             RowBox[{"y1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "1", "]"}], "-", 
               RowBox[{"r1", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "1", "]"}], "*", 
                RowBox[{"y1", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "1", "]"}], "*", 
                RowBox[{"x1", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "1", "]"}], "*", 
             RowBox[{"x1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "2", "]"}], "-", 
               RowBox[{"r2", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "2", "]"}], "*", 
                RowBox[{"x2", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "2", "]"}], "*", 
                RowBox[{"y2", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "2", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling1", "[", "t", "]"}], "*", 
             RowBox[{"x1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "2", "]"}], "-", 
               RowBox[{"r2", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "2", "]"}], "*", 
                RowBox[{"y2", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "2", "]"}], "*", 
                RowBox[{"x2", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "2", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling1", "[", "t", "]"}], "*", 
             RowBox[{"y1", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x3", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "3", "]"}], "-", 
               RowBox[{"r3", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "3", "]"}], "*", 
                RowBox[{"x3", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "3", "]"}], "*", 
                RowBox[{"y3", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "3", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"x2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y3", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "3", "]"}], "-", 
               RowBox[{"r3", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "3", "]"}], "*", 
                RowBox[{"y3", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "3", "]"}], "*", 
                RowBox[{"x3", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "3", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling2", "[", "t", "]"}], "*", 
             RowBox[{"y2", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x4", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "4", "]"}], "-", 
               RowBox[{"r4", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "4", "]"}], "*", 
                RowBox[{"x4", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "4", "]"}], "*", 
                RowBox[{"y4", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "4", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"x3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y4", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "4", "]"}], "-", 
               RowBox[{"r4", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "4", "]"}], "*", 
                RowBox[{"y4", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "4", "]"}], "*", 
                RowBox[{"x4", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "4", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling3", "[", "t", "]"}], "*", 
             RowBox[{"y3", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x5", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "5", "]"}], "-", 
               RowBox[{"r5", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "5", "]"}], "*", 
                RowBox[{"x5", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "5", "]"}], "*", 
                RowBox[{"y5", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "5", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"x4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y5", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "5", "]"}], "-", 
               RowBox[{"r5", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "5", "]"}], "*", 
                RowBox[{"y5", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "5", "]"}], "*", 
                RowBox[{"x5", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "5", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling4", "[", "t", "]"}], "*", 
             RowBox[{"y4", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x6", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "6", "]"}], "-", 
               RowBox[{"r6", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "6", "]"}], "*", 
                RowBox[{"x6", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "6", "]"}], "*", 
                RowBox[{"y6", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "6", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"x5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling7", "[", "t", "]"}], "*", 
             RowBox[{"x7", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y6", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "6", "]"}], "-", 
               RowBox[{"r6", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "6", "]"}], "*", 
                RowBox[{"y6", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "6", "]"}], "*", 
                RowBox[{"x6", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "6", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling5", "[", "t", "]"}], "*", 
             RowBox[{"y5", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling7", "[", "t", "]"}], "*", 
             RowBox[{"y7", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"x7", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "7", "]"}], "-", 
               RowBox[{"r7", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "7", "]"}], "*", 
                RowBox[{"x7", "[", "t", "]"}]}], "-", 
               RowBox[{
                RowBox[{"epsilon", "[", "7", "]"}], "*", 
                RowBox[{"y7", "[", "t", "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"omega", "[", "7", "]"}], "*", 
             RowBox[{"y7", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"x6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
            RowBox[{"y7", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "[", "7", "]"}], "-", 
               RowBox[{"r7", "[", "t", "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"lambda", "[", "7", "]"}], "*", 
                RowBox[{"y7", "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"epsilon", "[", "7", "]"}], "*", 
                RowBox[{"x7", "[", "t", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"omega", "[", "7", "]"}], "*", 
             RowBox[{"x7", "[", "t", "]"}]}], "+", 
            RowBox[{"q", "*", 
             RowBox[{"coupling6", "[", "t", "]"}], "*", 
             RowBox[{"y6", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x1", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "1", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "1", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y1", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "1", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "1", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x2", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "2", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "2", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y2", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "2", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "2", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x3", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "3", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "3", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y3", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "3", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "3", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x4", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "4", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "4", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y4", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "4", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "4", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x5", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "5", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "5", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y5", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "5", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "5", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x6", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "6", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "6", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y6", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "6", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "6", "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x7", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "7", "]"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "7", "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"y7", "[", 
            RowBox[{
             RowBox[{"-", "24"}], "*", "30"}], "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"A", "[", "7", "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", 
                RowBox[{"Pi", "/", "24"}]}], ")"}], "*", 
              RowBox[{"initphi", "[", "7", "]"}]}], "]"}]}]}]}], 
         "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1", "[", "t", "]"}], ",", 
          RowBox[{"y1", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x2", "[", "t", "]"}], ",", 
          RowBox[{"y2", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x3", "[", "t", "]"}], ",", 
          RowBox[{"y3", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x4", "[", "t", "]"}], ",", 
          RowBox[{"y4", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x5", "[", "t", "]"}], ",", 
          RowBox[{"y5", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x6", "[", "t", "]"}], ",", 
          RowBox[{"y6", "[", "t", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"x7", "[", "t", "]"}], ",", 
          RowBox[{"y7", "[", "t", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{
           RowBox[{"-", "24"}], "*", "30"}], ",", 
          RowBox[{"24", "*", "60"}]}], "}"}]}], "]"}]}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.701591718892396*^9, 3.701591897153792*^9}, {
   3.70159193612114*^9, 3.701592044219096*^9}, {3.7015922312566032`*^9, 
   3.701592231920807*^9}, 3.701592996929915*^9, {3.7015931365814667`*^9, 
   3.701593327361679*^9}, {3.7015934451291027`*^9, 3.70159348707015*^9}, {
   3.701593552339876*^9, 3.70159362199056*^9}, {3.7015937331196404`*^9, 
   3.7015937703330927`*^9}, {3.7015938590594063`*^9, 3.701593896523637*^9}, 
   3.701594007267749*^9, {3.7015948173953037`*^9, 3.701594858297886*^9}, {
   3.7015957507163486`*^9, 3.701595869089676*^9}, {3.701596683247538*^9, 
   3.7015968144522123`*^9}, {3.701596882937251*^9, 3.701596928295043*^9}, {
   3.701598519853422*^9, 3.701598533274139*^9}, {3.701631074856678*^9, 
   3.70163107580549*^9}, {3.7016347833910723`*^9, 3.701634791097128*^9}, {
   3.702114073497793*^9, 3.702114670643611*^9}, {3.702114707601068*^9, 
   3.7021147086373997`*^9}, 3.7021150206751213`*^9, {3.702115140450263*^9, 
   3.70211514069913*^9}, 3.7021151835665007`*^9, {3.702115669833634*^9, 
   3.702115739385852*^9}, {3.702119447851729*^9, 3.7021194536820517`*^9}, {
   3.702120468623344*^9, 3.70212067637958*^9}, {3.702626952691313*^9, 
   3.702626954478498*^9}, {3.702626986313326*^9, 3.7026270148052597`*^9}, {
   3.702628975730795*^9, 3.7026289832591143`*^9}, {3.7026300051632643`*^9, 
   3.702630048274618*^9}, {3.7026301369648037`*^9, 3.702630181987328*^9}, {
   3.7026302269681873`*^9, 3.702630286912737*^9}, {3.702631126001769*^9, 
   3.702631156827696*^9}, 3.70263119571216*^9, {3.702631231445427*^9, 
   3.702631231651105*^9}, {3.7026723027269163`*^9, 
   3.702672303362288*^9}},ExpressionUUID->"03b0def1-4975-42d5-b917-\
3af65aa05e85"],

Cell[BoxData[
 RowBox[{"(*", " ", "Data", " ", "*)"}]], "Input",
 CellChangeTimes->{{3.702631300974743*^9, 3.702631302382794*^9}, {
  3.727327426185186*^9, 
  3.727327426444688*^9}},ExpressionUUID->"c361900c-ee46-42bd-959d-\
8d234df67be1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"s1", "[", "1", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi1", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s1", "[", "2", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi2", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s1", "[", "3", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi3", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s1", "[", "4", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi4", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s1", "[", "5", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi5", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s1", "[", "6", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi6", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s1", "[", "7", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi7", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7015993313472567`*^9, 3.701599376679276*^9}, {
  3.701599416206396*^9, 3.7015994296627827`*^9}, {3.701600235829925*^9, 
  3.701600325957499*^9}, {3.701600391681017*^9, 3.70160043335913*^9}, {
  3.701602601781192*^9, 3.7016026158329163`*^9}, {3.7016316498971157`*^9, 
  3.701631659239801*^9}, {3.702631352219335*^9, 3.702631391018187*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"s2", "[", "1", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi1", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s2", "[", "2", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi2", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s2", "[", "3", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi3", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s2", "[", "4", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi4", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s2", "[", "5", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi5", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s2", "[", "6", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi6", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s2", "[", "7", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi7", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7015993313472567`*^9, 3.701599376679276*^9}, {
  3.701599416206396*^9, 3.7015994296627827`*^9}, {3.701600235829925*^9, 
  3.701600325957499*^9}, {3.701600391681017*^9, 3.70160043335913*^9}, {
  3.701602601781192*^9, 3.7016026158329163`*^9}, {3.7016316498971157`*^9, 
  3.701631659239801*^9}, {3.702631352219335*^9, 3.702631419264337*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"s3", "[", "1", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi1", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s3", "[", "2", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi2", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s3", "[", "3", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi3", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s3", "[", "4", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi4", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s3", "[", "5", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi5", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s3", "[", "6", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi6", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s3", "[", "7", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi7", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7015993313472567`*^9, 3.701599376679276*^9}, {
  3.701599416206396*^9, 3.7015994296627827`*^9}, {3.701600235829925*^9, 
  3.701600325957499*^9}, {3.701600391681017*^9, 3.70160043335913*^9}, {
  3.701602601781192*^9, 3.7016026158329163`*^9}, {3.7016316498971157`*^9, 
  3.701631659239801*^9}, {3.702631352219335*^9, 3.702631425359475*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"s4", "[", "1", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi1", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s4", "[", "2", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi2", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s4", "[", "3", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi3", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s4", "[", "4", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi4", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s4", "[", "5", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi5", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s4", "[", "6", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi6", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s4", "[", "7", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi7", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7015993313472567`*^9, 3.701599376679276*^9}, {
  3.701599416206396*^9, 3.7015994296627827`*^9}, {3.701600235829925*^9, 
  3.701600325957499*^9}, {3.701600391681017*^9, 3.70160043335913*^9}, {
  3.701602601781192*^9, 3.7016026158329163`*^9}, {3.7016316498971157`*^9, 
  3.701631659239801*^9}, {3.702631352219335*^9, 3.702631431398057*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"s5", "[", "1", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi1", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s5", "[", "2", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi2", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s5", "[", "3", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi3", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s5", "[", "4", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi4", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s5", "[", "5", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi5", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s5", "[", "6", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi6", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s5", "[", "7", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"phi7", "[", "t", "]"}], "]"}], "/.", 
         RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"24", "*", "0"}], ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7015993313472567`*^9, 3.701599376679276*^9}, {
  3.701599416206396*^9, 3.7015994296627827`*^9}, {3.701600235829925*^9, 
  3.701600325957499*^9}, {3.701600391681017*^9, 3.70160043335913*^9}, {
  3.701602601781192*^9, 3.7016026158329163`*^9}, {3.7016316498971157`*^9, 
  3.701631659239801*^9}, {3.702631352219335*^9, 3.702631431398057*^9}, {
  3.702672320154504*^9, 3.7026723307897673`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", "Results", " ", "*)"}]], "Input",
 CellChangeTimes->{{3.702631209950345*^9, 3.70263121198005*^9}, 
   3.727327205042178*^9},ExpressionUUID->"a93da747-18af-4d87-9866-\
df363185e63f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"amptableA", "=", "\[IndentingNewLine]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r1", "[", "t", "]"}], "/.", 
        RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r2", "[", "t", "]"}], "/.", 
        RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r3", "[", "t", "]"}], "/.", 
        RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r4", "[", "t", "]"}], "/.", 
        RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r5", "[", "t", "]"}], "/.", 
        RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r6", "[", "t", "]"}], "/.", 
        RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r7", "[", "t", "]"}], "/.", 
        RowBox[{"nsol1", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", 
     "Flatten"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.701597136351624*^9, 3.701597241382781*^9}, {
  3.701598548679574*^9, 3.701598559088554*^9}, {3.702631563209771*^9, 
  3.70263157000383*^9}, {3.702633222858886*^9, 3.7026332465701323`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.9999997806233389`", ",", "1.0681223602373853`", ",", 
     "1.0277850212258095`", ",", "1.0150992489494441`", ",", 
     "1.2116702992033261`", ",", "0.9683334448118309`", ",", 
     "1.3427913573404406`", ",", "1.6592523641223658`", ",", 
     "1.8578655606517935`", ",", "1.8384828296005833`", ",", 
     "2.0501075020050283`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999997445069885`", ",", "1.0050277594811654`", ",", 
     "1.169635536773099`", ",", "1.3984662916866692`", ",", 
     "1.6586659524114207`", ",", "1.7428833007195745`", ",", 
     "2.020807584765022`", ",", "2.321731048877221`", ",", 
     "2.5351775759314954`", ",", "2.533890487434562`", ",", 
     "2.8096814966166863`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999997583217871`", ",", "0.9030207611338279`", ",", 
     "1.3510262736712957`", ",", "1.6146805781618194`", ",", 
     "1.92243510592228`", ",", "2.1280449540839825`", ",", 
     "2.359103373721223`", ",", "2.6266387412030983`", ",", 
     "2.7671144941771613`", ",", "2.624504590229897`", ",", 
     "3.0305115587373206`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999997503316865`", ",", "0.8695621500611048`", ",", 
     "1.3270313878513098`", ",", "1.467336425392538`", ",", 
     "1.9408013420723613`", ",", "2.163927465121408`", ",", 
     "2.384934066843111`", ",", "2.657233823722855`", ",", 
     "2.690334836270105`", ",", "2.052706519735641`", ",", 
     "2.9462725713529827`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999997443269829`", ",", "1.0423936116880903`", ",", 
     "1.3065104546066921`", ",", "1.4564727425779032`", ",", 
     "1.8761582720301364`", ",", "2.125090571887475`", ",", 
     "2.3680346574546185`", ",", "2.62691951793468`", ",", 
     "2.6383736094450683`", ",", "2.2904344550091675`", ",", 
     "3.099356323669729`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999997438588346`", ",", "1.0898894735913243`", ",", 
     "1.2521358207121518`", ",", "1.2930055105869145`", ",", 
     "1.6426889639913829`", ",", "1.9269726821865936`", ",", 
     "2.19518792518372`", ",", "2.433076547764343`", ",", 
     "2.5769884797658857`", ",", "2.7766881334366533`", ",", 
     "3.16253528717508`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999997485693288`", ",", "0.9475239100295176`", ",", 
     "1.0535795952804952`", ",", "0.6282577417000986`", ",", 
     "1.2463062212266938`", ",", "1.478987733902503`", ",", 
     "1.6900415981925054`", ",", "1.8725277760918335`", ",", 
     "2.0771546087436477`", ",", "2.325078635132631`", ",", 
     "2.514774482593408`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.702632496548161*^9, 3.702632877104208*^9, 
  3.70263368182873*^9, 3.702634295778089*^9, 3.702634604426435*^9, 
  3.7026349225862293`*^9, 3.702636397580085*^9, 3.702636735672287*^9, 
  3.702637934728592*^9, 3.702638289881606*^9, 3.702638706874194*^9, 
  3.702640041799334*^9, 3.702640198081493*^9, 3.702640407907209*^9, 
  3.702640648674021*^9, 3.7026584115697203`*^9, 3.702663258696611*^9, 
  3.702664261518093*^9, 3.702664462254798*^9, 3.702666400483437*^9, 
  3.7026676162443438`*^9, 3.702670758739047*^9, 3.7026709370951757`*^9, 
  3.70267128497569*^9, 3.702671564850162*^9, 3.702672895656814*^9, 
  3.7026731549611464`*^9, 3.702702859742085*^9, 3.702703245610672*^9, 
  3.702703769834674*^9, 3.702704131346542*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"amptableB", "=", "\[IndentingNewLine]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r1", "[", "t", "]"}], "/.", 
        RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r2", "[", "t", "]"}], "/.", 
        RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r3", "[", "t", "]"}], "/.", 
        RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r4", "[", "t", "]"}], "/.", 
        RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r5", "[", "t", "]"}], "/.", 
        RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r6", "[", "t", "]"}], "/.", 
        RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r7", "[", "t", "]"}], "/.", 
        RowBox[{"nsol2", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", 
     "Flatten"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.701597136351624*^9, 3.701597241382781*^9}, {
  3.701598548679574*^9, 3.701598559088554*^9}, {3.702631563209771*^9, 
  3.7026315886635036`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.0000002745086274`", ",", "0.9921053593532451`", ",", 
     "1.0771614615816583`", ",", "1.280375697413976`", ",", 
     "1.501240008846987`", ",", "1.6918986816756925`", ",", 
     "1.8718388778323145`", ",", "2.045947576130867`", ",", 
     "2.2216327451289417`", ",", "2.3966238426074`", ",", 
     "2.569521410803056`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0000001458490364`", ",", "1.007973227585958`", ",", 
     "1.1418029478043872`", ",", "1.5397673051898242`", ",", 
     "1.8325563888536094`", ",", "2.0903611574591237`", ",", 
     "2.3351043522276567`", ",", "2.5720740725025575`", ",", 
     "2.806786169074841`", ",", "3.039821338378259`", ",", 
     "3.2708168367826045`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0000001889805445`", ",", "1.0064768452576982`", ",", 
     "1.139454052274183`", ",", "1.634802617348544`", ",", 
     "1.9299377637461783`", ",", "2.195444809594851`", ",", 
     "2.4486953282316763`", ",", "2.6933801564348214`", ",", 
     "2.938471881924812`", ",", "3.1847866135510445`", ",", 
     "3.4299744112621595`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0000002019096996`", ",", "1.0307293755049867`", ",", 
     "1.2643952273400405`", ",", "1.6672953242523534`", ",", 
     "1.9459864654504753`", ",", "2.2001101707799924`", ",", 
     "2.4345711135658687`", ",", "2.657595542237662`", ",", 
     "2.9052348812779902`", ",", "3.16335702343866`", ",", 
     "3.4185385128202523`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0000002276895652`", ",", "1.1285262194705956`", ",", 
     "1.3775639377867794`", ",", "1.6196785124221467`", ",", 
     "1.82961217494657`", ",", "2.0577382905296284`", ",", 
     "2.2430953803336617`", ",", "2.4204937188428755`", ",", 
     "2.6863574711996643`", ",", "2.971893417493913`", ",", 
     "3.2446931903102403`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0000001990258016`", ",", "1.060176745181077`", ",", 
     "1.230605969693154`", ",", "1.2559733605841121`", ",", 
     "1.4058681354199116`", ",", "1.646343970754534`", ",", 
     "1.7313787485039225`", ",", "1.9183613972083622`", ",", 
     "2.2682475351493125`", ",", "2.59406586354378`", ",", 
     "2.8818925977405745`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0000001172423911`", ",", "0.9339974372686936`", ",", 
     "0.8931427756869232`", ",", "0.5607136003435902`", ",", 
     "0.883685571168316`", ",", "1.1125550874004952`", ",", 
     "0.9778664307543898`", ",", "1.2981656404521722`", ",", 
     "1.676864394499368`", ",", "1.9518451568804616`", ",", 
     "2.1796794886107635`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.70263249666218*^9, 3.702632877193795*^9, 
  3.7026336819217978`*^9, 3.702634295879799*^9, 3.702634604505928*^9, 
  3.7026349226759043`*^9, 3.702636397692849*^9, 3.70263673577691*^9, 
  3.7026379348465014`*^9, 3.7026382899675303`*^9, 3.702638706923664*^9, 
  3.702640042050989*^9, 3.702640198162651*^9, 3.702640407980483*^9, 
  3.702640648746249*^9, 3.7026584116217327`*^9, 3.702663258772028*^9, 
  3.7026642615695467`*^9, 3.70266446235325*^9, 3.70266640058049*^9, 
  3.702667616317204*^9, 3.702670758837034*^9, 3.702670937191555*^9, 
  3.702671285036831*^9, 3.702671564956032*^9, 3.702672895742487*^9, 
  3.702673155028975*^9, 3.702702859838291*^9, 3.7027032456864853`*^9, 
  3.70270376994128*^9, 3.702704131397464*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"amptableC", "=", "\[IndentingNewLine]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r1", "[", "t", "]"}], "/.", 
        RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r2", "[", "t", "]"}], "/.", 
        RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r3", "[", "t", "]"}], "/.", 
        RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r4", "[", "t", "]"}], "/.", 
        RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r5", "[", "t", "]"}], "/.", 
        RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r6", "[", "t", "]"}], "/.", 
        RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r7", "[", "t", "]"}], "/.", 
        RowBox[{"nsol3", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", 
     "Flatten"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.701597136351624*^9, 3.701597241382781*^9}, {
  3.701598548679574*^9, 3.701598559088554*^9}, {3.702631563209771*^9, 
  3.702631594057674*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.999999421490847`", ",", "1.0179810250283385`", ",", 
     "1.2394010646486011`", ",", "1.3800773983984884`", ",", 
     "1.5483076676802696`", ",", "1.6949850047592452`", ",", 
     "1.849476254961336`", ",", "2.0080026517306315`", ",", 
     "2.169348390182736`", ",", "2.332446547239144`", ",", 
     "2.496634533561546`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999993775207683`", ",", "1.1279540308352562`", ",", 
     "1.389129905421379`", ",", "1.6475682497150541`", ",", 
     "1.8884719904293106`", ",", "2.0963172834581267`", ",", 
     "2.311702318626629`", ",", "2.530246049137411`", ",", 
     "2.751538207195795`", ",", "2.974634681230013`", ",", 
     "3.1988245513571716`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999994105049738`", ",", "1.1858572927782685`", ",", 
     "1.3091086799200657`", ",", "1.6818507073770648`", ",", 
     "1.96753932894135`", ",", "2.1585391326688934`", ",", 
     "2.389147903878012`", ",", "2.626780545130611`", ",", 
     "2.8683170942521614`", ",", "3.1119560121781094`", ",", 
     "3.356610571519411`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999994455030701`", ",", "1.03321651233348`", ",", 
     "1.0516668550336379`", ",", "1.4175456832364992`", ",", 
     "1.9229231224162138`", ",", "1.9258944803887892`", ",", 
     "2.1852549865341304`", ",", "2.464511028154352`", ",", 
     "2.741945843927089`", ",", "3.014875804329447`", ",", 
     "3.2835310122076202`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999993575670718`", ",", "1.0310087486774824`", ",", 
     "0.9955734564734701`", ",", "1.1392927013267047`", ",", 
     "1.907839206733456`", ",", "1.655750079669719`", ",", 
     "2.0154421121958235`", ",", "2.3503213926271704`", ",", 
     "2.6589053924860133`", ",", "2.9504141663568078`", ",", 
     "3.2305964500141604`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999993564462717`", ",", "1.1058609128867818`", ",", 
     "1.1023102210808657`", ",", "1.3310840719708221`", ",", 
     "1.8969416272288957`", ",", "1.7348949211872517`", ",", 
     "2.083215211838943`", ",", "2.3835580941693495`", ",", 
     "2.6591061536379397`", ",", "2.9205692134449928`", ",", 
     "3.1731771737570815`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999993015614024`", ",", "1.01491681667354`", ",", 
     "0.9819443913403904`", ",", "1.2446853568175584`", ",", 
     "1.569533320056579`", ",", "1.5375823149415009`", ",", 
     "1.7697568252728912`", ",", "1.975147369791996`", ",", 
     "2.1676365765819248`", ",", "2.352799235111515`", ",", 
     "2.533348223263136`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.702632496763892*^9, 3.702632877262082*^9, 
  3.702633682003828*^9, 3.70263429599354*^9, 3.702634604588394*^9, 
  3.7026349227601957`*^9, 3.70263639778242*^9, 3.7026367358594837`*^9, 
  3.702637934954936*^9, 3.7026382900535994`*^9, 3.702638707009955*^9, 
  3.702640042300214*^9, 3.7026401982462673`*^9, 3.702640408048543*^9, 
  3.702640648813607*^9, 3.7026584116702747`*^9, 3.702663258861823*^9, 
  3.702664261646701*^9, 3.702664462460142*^9, 3.7026664006626387`*^9, 
  3.702667616381805*^9, 3.702670758942315*^9, 3.702670937276346*^9, 
  3.702671285110746*^9, 3.702671565054659*^9, 3.7026728958258944`*^9, 
  3.702673155091938*^9, 3.702702859956634*^9, 3.70270324575348*^9, 
  3.7027037700383787`*^9, 3.702704131444974*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"amptableD", "=", "\[IndentingNewLine]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r1", "[", "t", "]"}], "/.", 
        RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r2", "[", "t", "]"}], "/.", 
        RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r3", "[", "t", "]"}], "/.", 
        RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r4", "[", "t", "]"}], "/.", 
        RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r5", "[", "t", "]"}], "/.", 
        RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r6", "[", "t", "]"}], "/.", 
        RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r7", "[", "t", "]"}], "/.", 
        RowBox[{"nsol4", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", 
     "Flatten"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.701597136351624*^9, 3.701597241382781*^9}, {
  3.701598548679574*^9, 3.701598559088554*^9}, {3.702631563209771*^9, 
  3.7026316016794558`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.9999990939586171`", ",", "0.9739412742766945`", ",", 
     "1.090174212880703`", ",", "0.9238860444982459`", ",", 
     "1.2533342356910497`", ",", "1.5125703720971564`", ",", 
     "1.7177639585557005`", ",", "1.906442393550088`", ",", 
     "2.0874129534294505`", ",", "2.264090924390313`", ",", 
     "2.4381197703326127`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999989035363737`", ",", "0.9938736841217074`", ",", 
     "1.1906355126564605`", ",", "1.370681426728099`", ",", 
     "1.693118873649516`", ",", "1.9806162327867298`", ",", 
     "2.2355355670427755`", ",", "2.479089259983745`", ",", 
     "2.716901797153788`", ",", "2.9513229129152263`", ",", 
     "3.183549068667809`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999990151226994`", ",", "1.1196308057794637`", ",", 
     "1.0987649478137245`", ",", "1.5691983528700544`", ",", 
     "1.889295660246086`", ",", "2.163476307196422`", ",", 
     "2.420372888475896`", ",", "2.671915583590325`", ",", 
     "2.9207939482083347`", ",", "3.1680729823119846`", ",", 
     "3.4142900080551057`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999991326326975`", ",", "1.1857451051568308`", ",", 
     "0.9844607018121325`", ",", "1.1326166059035263`", ",", 
     "1.703757053634431`", ",", "2.05870721360503`", ",", 
     "2.353348832726998`", ",", "2.6287989874749194`", ",", 
     "2.8948697096716267`", ",", "3.155506485678282`", ",", 
     "3.4126763512421077`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.999998895983704`", ",", "1.1147860190969847`", ",", 
     "1.1751835814090805`", ",", "1.1721298924619254`", ",", 
     "1.6963443068507356`", ",", "2.0480701453322006`", ",", 
     "2.3398367312057946`", ",", "2.6119940411397713`", ",", 
     "2.8745234536877358`", ",", "3.131480366748936`", ",", 
     "3.384891829471452`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999990520696382`", ",", "1.0769744576252067`", ",", 
     "1.263383170025326`", ",", "1.5526966990305353`", ",", 
     "1.8270907018563127`", ",", "2.0941609029287314`", ",", 
     "2.3400448248758225`", ",", "2.577838634718269`", ",", 
     "2.811462384587207`", ",", "3.042630074443885`", ",", 
     "3.272228241592511`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999989081347626`", ",", "1.0734518378704894`", ",", 
     "1.1641567815034446`", ",", "1.3532807352241858`", ",", 
     "1.5235591660520968`", ",", "1.7177353798817372`", ",", 
     "1.8978146759518904`", ",", "2.07208671682338`", ",", 
     "2.2433963746446954`", ",", "2.413019342891849`", ",", 
     "2.581611920902018`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.702632496860292*^9, 3.702632877327936*^9, 
  3.702633682088015*^9, 3.702634296085361*^9, 3.702634604669516*^9, 
  3.702634922843207*^9, 3.702636397882757*^9, 3.702636735942861*^9, 
  3.7026379350712547`*^9, 3.702638290133589*^9, 3.702638707091835*^9, 
  3.702640042549055*^9, 3.7026401983345633`*^9, 3.7026404081133337`*^9, 
  3.702640648880007*^9, 3.702658411718404*^9, 3.702663258938758*^9, 
  3.702664261707859*^9, 3.702664462560658*^9, 3.702666400751137*^9, 
  3.7026676164491243`*^9, 3.702670759125236*^9, 3.702670937368626*^9, 
  3.702671285193647*^9, 3.7026715651531897`*^9, 3.702672895907226*^9, 
  3.702673155175915*^9, 3.702702860055324*^9, 3.702703245817399*^9, 
  3.7027037701343813`*^9, 3.7027041314929457`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"amptableE", "=", "\[IndentingNewLine]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r1", "[", "t", "]"}], "/.", 
        RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r2", "[", "t", "]"}], "/.", 
        RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r3", "[", "t", "]"}], "/.", 
        RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r4", "[", "t", "]"}], "/.", 
        RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r5", "[", "t", "]"}], "/.", 
        RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r6", "[", "t", "]"}], "/.", 
        RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", "Flatten"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r7", "[", "t", "]"}], "/.", 
        RowBox[{"nsol5", "[", "n", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"24", "*", "30"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", 
     "Flatten"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.701597136351624*^9, 3.701597241382781*^9}, {
  3.701598548679574*^9, 3.701598559088554*^9}, {3.702631563209771*^9, 
  3.7026316016794558`*^9}, {3.7026723541831837`*^9, 3.702672363697081*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.9999991501454853`", ",", "1.0478019551339584`", ",", 
     "1.094193026253832`", ",", "1.2431515271467295`", ",", 
     "1.2236827481224015`", ",", "1.5437741623573225`", ",", 
     "1.7698290193869262`", ",", "1.9713571029363757`", ",", 
     "2.1613640239749663`", ",", "2.344829157988844`", ",", 
     "2.5241621951212228`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999993716899463`", ",", "1.0937953364230275`", ",", 
     "0.940552329685064`", ",", "1.2022599421473392`", ",", 
     "1.613289108969529`", ",", "1.9045575264023022`", ",", 
     "2.1881517299186273`", ",", "2.4509743969336175`", ",", 
     "2.70229869094441`", ",", "2.9466715206070373`", ",", 
     "3.1865163721332466`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999992742381492`", ",", "1.176723332230223`", ",", 
     "1.1193128735672915`", ",", "1.2955913149897176`", ",", 
     "1.7520952826738703`", ",", "1.965672531056153`", ",", 
     "2.2618694298130793`", ",", "2.5401439649639`", ",", 
     "2.8072569394213147`", ",", "3.0675957909486122`", ",", 
     "3.3235818364187386`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999992730209128`", ",", "1.2009728336139567`", ",", 
     "1.4039343744941264`", ",", "1.5829316677491176`", ",", 
     "1.2157657561784343`", ",", "1.8768300214077132`", ",", 
     "2.2379267035702672`", ",", "2.5426386690624168`", ",", 
     "2.8248594121710164`", ",", "3.0955786022375316`", ",", 
     "3.3595801850424247`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999992187530974`", ",", "1.1599004510055604`", ",", 
     "1.4355776085238676`", ",", "1.6723215908617834`", ",", 
     "1.2197634189140842`", ",", "1.972463843069224`", ",", 
     "2.3099123404207846`", ",", "2.597167910547629`", ",", 
     "2.8662253571652094`", ",", "3.1263793014799264`", ",", 
     "3.381471184812207`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999992308342842`", ",", "1.030320569163591`", ",", 
     "1.376432899208673`", ",", "1.639532811129395`", ",", 
     "1.768089884007573`", ",", "2.0816022511577956`", ",", 
     "2.333217009857231`", ",", "2.570454775300926`", ",", 
     "2.802470360957068`", ",", "3.031992875798221`", ",", 
     "3.260134881029514`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9999992587603191`", ",", "0.942395296276305`", ",", 
     "1.192016872740464`", ",", "1.37601597520906`", ",", 
     "1.5603966065855397`", ",", "1.740924327706615`", ",", 
     "1.9058423230019526`", ",", "2.0694578873384106`", ",", 
     "2.233184003844571`", ",", "2.397237469614451`", ",", 
     "2.5616169780024878`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.702672895990952*^9, 3.702673155241765*^9, 
  3.7027028601377497`*^9, 3.702703245886223*^9, 3.70270377024074*^9, 
  3.702704131545195*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pertableA1", "=", 
  RowBox[{"Median", "[", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "1", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "1", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "2", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "2", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "3", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "3", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "4", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "4", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "5", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "5", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "6", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "6", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "7", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "7", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1", ",", "60"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701867065805591*^9, 3.701867170684814*^9}, {
  3.702631466246935*^9, 3.702631514739642*^9}, {3.7026316784238663`*^9, 
  3.702631682643775*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "28.17391304347826`", ",", "28.259921500218056`", ",", 
     "27.847013321873657`", ",", "27.504244482173174`", ",", 
     "26.39511201629328`", ",", "25.`", ",", "25.22382249902686`", ",", 
     "24.913494809688583`", ",", "24.76117692013756`", ",", 
     "24.695121951219512`", ",", "24.17910447761194`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.332290852228304`", ",", "25.160164023397456`", ",", 
     "25.909636145541782`", ",", "25.521858999606145`", ",", 
     "25.391849529780565`", ",", "25.0483185156552`", ",", 
     "24.932666410157754`", ",", "24.751718869365927`", ",", 
     "24.638783269961976`", ",", "24.780114722753346`", ",", 
     "24.15206857994782`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26.721649484536083`", ",", "26.341463414634145`", ",", 
     "25.796178343949045`", ",", "25.491738788355626`", ",", 
     "25.233644859813083`", ",", "25.009648784253184`", ",", 
     "24.846625766871167`", ",", "24.59669855156406`", ",", 
     "24.462061155152888`", ",", "24.76117692013756`", ",", 
     "24.2152466367713`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26.139572408229125`", ",", "26.459779501837485`", ",", 
     "26.202992317023856`", ",", "25.25331254871395`", ",", 
     "25.038639876352395`", ",", "24.818077364994256`", ",", 
     "24.629418472063854`", ",", "24.37923250564334`", ",", 
     "24.161073825503355`", ",", "24.508320726172467`", ",", 
     "24.397590361445783`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.60136674259681`", ",", "24.51759364358683`", ",", 
     "24.52687358062074`", ",", "24.70453678993519`", ",", 
     "24.695121951219512`", ",", "24.554755589238347`", ",", 
     "24.27875608842263`", ",", "24.161073825503355`", ",", 
     "23.806024981631154`", ",", "23.09337134711333`", ",", 
     "24.071322436849925`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.732824427480917`", ",", "24.620060790273556`", ",", 
     "24.82758620689655`", ",", "24.306076519129782`", ",", 
     "24.508320726172467`", ",", "24.3884079789236`", ",", 
     "24.08026755852843`", ",", "23.955637707948245`", ",", 
     "23.61516034985423`", ",", "23.184257602862253`", ",", 
     "24.017790956263898`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.83732057416268`", ",", "25.92`", ",", "25.194401244167963`", ",", 
     "27.11297071129707`", ",", "24.443606186344777`", ",", 
     "24.19716206123973`", ",", "24.026696329254726`", ",", 
     "23.762376237623762`", ",", "23.529411764705884`", ",", 
     "23.376623376623378`", ",", "24.00889218228974`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJwVzVsowwEcxfH/IlPLeLAixQhJJJcNc2vCNuSBGisMRVqEElK8uEdyGbGE
pomyhUiSmrCYKM0TL8zdYsSIJn7n4fR5OfUNrKjLr2QxDJNC83d2yI1qmzij
TTkAT76lN7D0vYe7Q94lRcynjtnEQatLd3BWZf2UkluTxjwZ6f24sAjlUce8
HHLo2VoWPW4Tu/S+10Kr4aMdeu2aB+HZDG8GhrjuJ8aQoiq+GTY9Rl7Bitzb
X+jUFWTHkqGSRiXU66ZaYCfrVQsZBccCg15Pn2C1e0N4HGnnhkvg3LBJAfUr
5h3o2c/+hhynyk1I1h/9CeBx14gGulrK76Em7cYjnuxW6QXwZ4z3Ap9Win0S
SEel0ABbL0fPYfDGKjeRlA1p1+G4PeAQ+h0UXsMwu4olIif2TPp0crZkgZNJ
1hjYffDB4aeF6uFqdRa5PK2IkJA6h2hdiv9m8xFUCou/oHvym6+MNJwWGCE/
fu0S5s5flBehE+w2AmN1agusat1mFOQ//7X86g==
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pertableB1", "=", 
  RowBox[{"Median", "[", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "1", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "1", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "2", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "2", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "3", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "3", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "4", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "4", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "5", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "5", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "6", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "6", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "7", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "7", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1", ",", "60"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701867065805591*^9, 3.701867170684814*^9}, {
  3.702631466246935*^9, 3.702631514739642*^9}, {3.7026316784238663`*^9, 
  3.702631682643775*^9}, {3.7026317172076178`*^9, 3.702631734158778*^9}, {
  3.702631912580658*^9, 3.702631912780178*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "24.47129909365559`", ",", "24.60136674259681`", ",", 
     "24.360902255639097`", ",", "24.942263279445726`", ",", 
     "24.71395881006865`", ",", "24.462061155152888`", ",", 
     "24.370063933809703`", ",", "24.098177761249534`", ",", 
     "23.98223538119911`", ",", "23.727572317832294`", ",", 
     "23.537958590628406`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26.39511201629328`", ",", "25.909636145541782`", ",", 
     "26.622843056696794`", ",", "24.923076923076923`", ",", 
     "24.71395881006865`", ",", "24.47129909365559`", ",", 
     "24.37923250564334`", ",", "24.08921933085502`", ",", 
     "24.00889218228974`", ",", "23.71020856201976`", ",", 
     "23.546511627906977`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.653206650831354`", ",", "25.3125`", ",", "25.01930501930502`", ",", 
     "24.923076923076923`", ",", "24.71395881006865`", ",", 
     "24.47129909365559`", ",", "24.37923250564334`", ",", 
     "24.098177761249534`", ",", "24.00889218228974`", ",", 
     "23.718887262079065`", ",", "23.542235109267693`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.401803214425716`", ",", "25.342197888150174`", ",", 
     "25.087108013937282`", ",", "24.89435266999616`", ",", 
     "24.695121951219512`", ",", "24.480544012089158`", ",", 
     "24.370063933809703`", ",", "24.107142857142858`", ",", 
     "24.017790956263898`", ",", "23.727572317832294`", ",", 
     "23.546511627906977`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.0483185156552`", ",", "25.194401244167963`", ",", 
     "25.077399380804952`", ",", "24.856156501726122`", ",", 
     "24.638783269961976`", ",", "24.462061155152888`", ",", 
     "24.370063933809703`", ",", "24.107142857142858`", ",", 
     "24.03560830860534`", ",", "23.71020856201976`", ",", 
     "23.563636363636363`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.401803214425716`", ",", "25.292740046838407`", ",", 
     "25.174825174825173`", ",", "25.`", ",", "24.554755589238347`", ",", 
     "24.360902255639097`", ",", "24.315196998123827`", ",", 
     "24.19716206123973`", ",", "24.00889218228974`", ",", 
     "23.718887262079065`", ",", "23.58937022206043`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "27.06766917293233`", ",", "26.799007444168733`", ",", 
     "26.39511201629328`", ",", "26.192400970088926`", ",", 
     "27.72785622593068`", ",", "24.443606186344777`", ",", 
     "24.260576563084985`", ",", "24.233358264771876`", ",", 
     "23.929098966026586`", ",", "23.806024981631154`", ",", 
     "23.555070883315157`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.702632501995233*^9, 3.70263288269484*^9, 
  3.702633687177616*^9, 3.7026343018175898`*^9, 3.702634609686483*^9, 
  3.702634928295594*^9, 3.7026364036138372`*^9, 3.7026367421926947`*^9, 
  3.702637940393786*^9, 3.702638295178955*^9, 3.702638712185245*^9, 
  3.702640047886591*^9, 3.702640203710308*^9, 3.702640413678152*^9, 
  3.702640653861886*^9, 3.702658416783643*^9, 3.7026632636426153`*^9, 
  3.70266426681931*^9, 3.702664467287736*^9, 3.702666405796638*^9, 
  3.702667621236071*^9, 3.702670764850644*^9, 3.702670942242429*^9, 
  3.7026712934728937`*^9, 3.702671570098215*^9, 3.702672901334434*^9, 
  3.7026731601185493`*^9, 3.702702865345523*^9, 3.702703250546371*^9, 
  3.702703775130702*^9, 3.702704136355859*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pertableC1", "=", 
  RowBox[{"Median", "[", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "1", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "1", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "2", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "2", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "3", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "3", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "4", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "4", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "5", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "5", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "6", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "6", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "7", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "7", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1", ",", "60"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701867065805591*^9, 3.701867170684814*^9}, {
   3.702631466246935*^9, 3.702631514739642*^9}, {3.7026316784238663`*^9, 
   3.702631682643775*^9}, 3.7026317188864603`*^9, {3.702631751304564*^9, 
   3.702631754500791*^9}, {3.702631914943738*^9, 3.702631915238028*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "25.744934445768774`", ",", "25.41176470588235`", ",", 
     "25.126017836370686`", ",", "24.856156501726122`", ",", 
     "24.573378839590443`", ",", "24.360902255639097`", ",", 
     "24.00889218228974`", ",", "23.876197494473104`", ",", 
     "23.61516034985423`", ",", "23.38505954529051`", ",", 
     "23.184257602862253`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.02896871378911`", ",", "25.43171114599686`", ",", 
     "25.204200700116687`", ",", "24.88479262672811`", ",", 
     "24.554755589238347`", ",", "24.370063933809703`", ",", 
     "24.03560830860534`", ",", "23.83229128356013`", ",", 
     "23.64963503649635`", ",", "23.38505954529051`", ",", 
     "23.184257602862253`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.461689587426328`", ",", "25.491738788355626`", ",", 
     "25.25331254871395`", ",", "24.942263279445726`", ",", 
     "24.582701062215477`", ",", "24.37923250564334`", ",", 
     "24.053452115812917`", ",", "23.806024981631154`", ",", 
     "23.65826944140197`", ",", "23.38505954529051`", ",", 
     "23.192555476020043`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26.05548854041013`", ",", "25.7040856802856`", ",", 
     "24.971098265895954`", ",", "25.038639876352395`", ",", 
     "24.620060790273556`", ",", "24.37923250564334`", ",", 
     "24.08026755852843`", ",", "23.788546255506606`", ",", 
     "23.65826944140197`", ",", "23.38505954529051`", ",", 
     "23.192555476020043`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.770642201834864`", ",", "24.780114722753346`", ",", 
     "24.443606186344777`", ",", "26.03455202892728`", ",", 
     "24.76117692013756`", ",", "24.269662921348313`", ",", 
     "24.125093075204767`", ",", "23.797282409107602`", ",", 
     "23.60655737704918`", ",", "23.401950162513543`", ",", 
     "23.192555476020043`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.76117692013756`", ",", "24.88479262672811`", ",", 
     "24.35174746335964`", ",", "23.771093176815846`", ",", 
     "24.508320726172467`", ",", "24.296962879640045`", ",", 
     "24.026696329254726`", ",", "23.85861561119293`", ",", 
     "23.572208075663877`", ",", "23.410404624277458`", ",", 
     "23.192555476020043`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.04452690166976`", ",", "23.911439114391143`", ",", 
     "24.370063933809703`", ",", "24.134078212290504`", ",", 
     "24.397590361445783`", ",", "24.315196998123827`", ",", 
     "23.97336293007769`", ",", "23.876197494473104`", ",", 
     "23.563636363636363`", ",", "23.410404624277458`", ",", 
     "23.192555476020043`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.702632505096384*^9, 3.702632885397017*^9, 
  3.7026336897362947`*^9, 3.702634304643861*^9, 3.702634612269473*^9, 
  3.702634931017144*^9, 3.702636406511801*^9, 3.702636745073496*^9, 
  3.702637943081703*^9, 3.702638297814123*^9, 3.702638714794669*^9, 
  3.702640050656946*^9, 3.702640206282346*^9, 3.702640416359252*^9, 
  3.7026406564095716`*^9, 3.702658419380013*^9, 3.702663266024845*^9, 
  3.702664269439282*^9, 3.702664469717813*^9, 3.702666408297056*^9, 
  3.702667623745737*^9, 3.702670767487804*^9, 3.7026709446682453`*^9, 
  3.702671295914548*^9, 3.702671572735339*^9, 3.702672904076851*^9, 
  3.702673162701202*^9, 3.7027028678413982`*^9, 3.702703252921953*^9, 
  3.7027037777547703`*^9, 3.702704138963612*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pertableD1", "=", 
  RowBox[{"Median", "[", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "1", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "1", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "2", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "2", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "3", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "3", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "4", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "4", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "5", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "5", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "6", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "6", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "7", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "7", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1", ",", "60"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701867065805591*^9, 3.701867170684814*^9}, {
   3.702631466246935*^9, 3.702631514739642*^9}, {3.7026316784238663`*^9, 
   3.702631682643775*^9}, 3.702631720499362*^9, {3.702631756673806*^9, 
   3.7026317599769917`*^9}, {3.7026319178741083`*^9, 3.70263191972968*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "25.75516693163752`", ",", "25.69389373513085`", ",", 
     "25.145518044237484`", ",", "27.29570345408593`", ",", 
     "24.315196998123827`", ",", "24.`", ",", "23.876197494473104`", ",", 
     "23.60655737704918`", ",", "23.38505954529051`", ",", 
     "23.192555476020043`", ",", "23.02771855010661`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.14307004470939`", ",", "24.251497005988025`", ",", 
     "24.76117692013756`", ",", "24.27875608842263`", ",", 
     "24.35174746335964`", ",", "24.04452690166976`", ",", 
     "23.788546255506606`", ",", "23.64963503649635`", ",", 
     "23.376623376623378`", ",", "23.192555476020043`", ",", 
     "23.011363636363637`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.09682416731216`", ",", "24.923076923076923`", ",", 
     "24.71395881006865`", ",", "24.554755589238347`", ",", 
     "24.360902255639097`", ",", "24.03560830860534`", ",", 
     "23.788546255506606`", ",", "23.64963503649635`", ",", 
     "23.376623376623378`", ",", "23.192555476020043`", ",", 
     "23.003194888178914`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26.234817813765183`", ",", "25.632911392405063`", ",", 
     "25.292740046838407`", ",", "24.71395881006865`", ",", 
     "24.35174746335964`", ",", "24.017790956263898`", ",", 
     "23.797282409107602`", ",", "23.641006931776722`", ",", 
     "23.376623376623378`", ",", "23.192555476020043`", ",", 
     "23.011363636363637`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.098177761249534`", ",", "24.554755589238347`", ",", 
     "24.638783269961976`", ",", "24.47129909365559`", ",", 
     "24.233358264771876`", ",", "24.098177761249534`", ",", 
     "23.758020963386663`", ",", "23.641006931776722`", ",", 
     "23.38505954529051`", ",", "23.192555476020043`", ",", 
     "22.986874778290172`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.401803214425716`", ",", "24.88479262672811`", ",", 
     "24.51759364358683`", ",", "24.480544012089158`", ",", 
     "24.22429906542056`", ",", "24.08921933085502`", ",", 
     "23.75366568914956`", ",", "23.641006931776722`", ",", 
     "23.38505954529051`", ",", "23.192555476020043`", ",", 
     "22.995031937544358`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.19716206123973`", ",", "24.42517904259329`", ",", 
     "24.49905482041588`", ",", "24.49905482041588`", ",", 
     "24.188129899216126`", ",", "24.08921933085502`", ",", 
     "23.762376237623762`", ",", "23.632385120350108`", ",", 
     "23.38505954529051`", ",", "23.192555476020043`", ",", 
     "22.986874778290172`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.702632508228956*^9, 3.7026328880630617`*^9, 
  3.702633692304162*^9, 3.70263430758358*^9, 3.702634614829597*^9, 
  3.702634933579671*^9, 3.702636409537959*^9, 3.702636747810586*^9, 
  3.7026379457934933`*^9, 3.702638300446156*^9, 3.702638717415003*^9, 
  3.7026400535446587`*^9, 3.7026402088422832`*^9, 3.7026404191340714`*^9, 
  3.702640658950632*^9, 3.702658421966374*^9, 3.7026632684344883`*^9, 
  3.702664272047739*^9, 3.70266447210774*^9, 3.702666410976602*^9, 
  3.702667626343511*^9, 3.702670770038555*^9, 3.702670947096148*^9, 
  3.7026712983384733`*^9, 3.702671575643165*^9, 3.7026729067140207`*^9, 
  3.7026731652970943`*^9, 3.702702870456358*^9, 3.702703255284685*^9, 
  3.7027037803765*^9, 3.702704141442227*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pertableE1", "=", 
  RowBox[{"Median", "[", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "1", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "1", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "2", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "2", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "3", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "3", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "4", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "4", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "5", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "5", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "6", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "6", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "7", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ";;", 
              RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "7", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", 
                   RowBox[{"24", "*", "30"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1", ",", "60"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701867065805591*^9, 3.701867170684814*^9}, {
   3.702631466246935*^9, 3.702631514739642*^9}, {3.7026316784238663`*^9, 
   3.702631682643775*^9}, 3.702631720499362*^9, {3.702631756673806*^9, 
   3.7026317599769917`*^9}, {3.7026319178741083`*^9, 3.70263191972968*^9}, {
   3.7026724034308987`*^9, 3.7026724111292953`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "24.315196998123827`", ",", "24.370063933809703`", ",", 
     "24.20620097123646`", ",", "23.867403314917127`", ",", 
     "25.087108013937282`", ",", "24.799081515499427`", ",", 
     "24.489795918367346`", ",", "24.34259954921112`", ",", 
     "24.017790956263898`", ",", "23.849834376150167`", ",", 
     "23.64963503649635`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "27.33024040489245`", ",", "27.597955706984667`", ",", 
     "27.364864864864863`", ",", "26.30937880633374`", ",", 
     "25.11627906976744`", ",", "24.789594491201225`", ",", 
     "24.536160545248013`", ",", "24.324324324324323`", ",", 
     "23.991114402073308`", ",", "23.884998157021748`", ",", 
     "23.623769595333577`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.868263473053894`", ",", "25.765407554671967`", ",", 
     "25.511811023622048`", ",", "25.643055005935892`", ",", 
     "25.09682416731216`", ",", "24.789594491201225`", ",", 
     "24.49905482041588`", ",", "24.34259954921112`", ",", 
     "24.00889218228974`", ",", "23.849834376150167`", ",", 
     "23.64963503649635`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.83732057416268`", ",", "26.139572408229125`", ",", 
     "25.663366336633665`", ",", "25.233644859813083`", ",", 
     "25.11627906976744`", ",", "24.780114722753346`", ",", 
     "24.480544012089158`", ",", "24.306076519129782`", ",", 
     "24.062383958410695`", ",", "23.806024981631154`", ",", 
     "23.675557179393497`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.174825174825173`", ",", "25.243474873393065`", ",", 
     "25.233644859813083`", ",", "25.10654784967067`", ",", 
     "25.009648784253184`", ",", "24.742268041237114`", ",", 
     "24.49905482041588`", ",", "24.242424242424242`", ",", 
     "24.098177761249534`", ",", "23.779816513761467`", ",", 
     "23.675557179393497`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.401803214425716`", ",", "25.421734013338565`", ",", 
     "25.204200700116687`", ",", "25.10654784967067`", ",", 
     "24.95186753946862`", ",", "24.71395881006865`", ",", 
     "24.508320726172467`", ",", "24.22429906542056`", ",", 
     "24.107142857142858`", ",", "23.779816513761467`", ",", 
     "23.675557179393497`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.78591325109431`", ",", "25.362035225048924`", ",", 
     "25.214007782101167`", ",", "25.067698259187623`", ",", 
     "24.932666410157754`", ",", "24.70453678993519`", ",", 
     "24.480544012089158`", ",", "24.242424242424242`", ",", 
     "24.08921933085502`", ",", "23.779816513761467`", ",", 
     "23.675557179393497`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.70267290935848*^9, 3.702673167894102*^9, 
  3.702702872991076*^9, 3.7027032576465473`*^9, 3.702703783043255*^9, 
  3.702704143907851*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pertableA2", "=", 
  RowBox[{"Median", "[", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "1", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "1", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "2", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "2", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "3", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "3", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "4", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "4", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "5", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "5", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "6", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "6", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s1", "[", "7", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "7", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1", ",", "60"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701867065805591*^9, 3.701867224033483*^9}, {
  3.7026316190487747`*^9, 3.70263167482123*^9}, {3.7026319260798187`*^9, 
  3.7026319263441477`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "28.06846544950312`", ",", "28.133483900857076`", ",", 
     "27.596512156328107`", ",", "27.29877500561924`", ",", 
     "27.913640542404046`", ",", "25.33421985815603`", ",", 
     "24.70550244100895`", ",", "24.73569246435845`", ",", 
     "24.60539910858995`", ",", "24.417420587052675`", ",", 
     "24.37821156162184`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.4190560904144`", ",", "25.579665122156698`", ",", 
     "25.87393481039625`", ",", "25.568894736842104`", ",", 
     "25.176668739635158`", ",", "25.041701030927836`", ",", 
     "24.836860940695296`", ",", "24.71555759055759`", ",", 
     "24.437072434607646`", ",", "24.30017006802721`", ",", 
     "24.54572554567502`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26.763386954605554`", ",", "26.1863410952997`", ",", 
     "25.86291524701874`", ",", "25.536637931034484`", ",", 
     "25.166234977206795`", ",", "25.031378812860677`", ",", 
     "24.84702332242226`", ",", "24.745772208638957`", ",", 
     "24.388002008032128`", ",", "24.164793076004774`", ",", 
     "24.79629440587995`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26.051533676533676`", ",", "26.175053879310344`", ",", 
     "25.65531263202366`", ",", "26.242923509075194`", ",", 
     "25.134985513245034`", ",", "25.052031765676567`", ",", 
     "24.745772208638957`", ",", "24.64534293831169`", ",", 
     "24.30017006802721`", ",", "23.973993288590606`", ",", 
     "25.461687631027253`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.57552610279239`", ",", "24.62535482562855`", ",", 
     "24.50610371267151`", ",", "24.251647364217252`", ",", 
     "24.887756147540983`", ",", "24.57552610279239`", ",", 
     "24.53580808080808`", ",", "24.28073770491803`", ",", 
     "24.0690150614348`", ",", "23.776869616288174`", ",", 
     "23.032856059169355`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.755860171218917`", ",", "24.437072434607646`", ",", 
     "24.397800321414223`", ",", "24.69545546970313`", ",", 
     "24.765956362153343`", ",", "24.456755940394682`", ",", 
     "24.40760651125402`", ",", "24.17441281847134`", ",", 
     "23.93619432400473`", ",", "23.628842412451363`", ",", 
     "23.684136115444616`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.929173783091375`", ",", "25.962430525865756`", ",", 
     "25.775095500848895`", ",", "24.887756147540983`", ",", 
     "24.51599717400081`", ",", "24.40760651125402`", ",", 
     "24.309897918334666`", ",", "24.107235013894403`", ",", 
     "23.842216332940716`", ",", "23.509920634920636`", ",", 
     "23.87033215408805`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJwVz00owwEcxvE/FgfzdiCS5a0IU0b7ezlRs9daIeYt7w6yGSekTClLXloa
haJNidJWmpdyoV1opbwUYxuamnaQwjCN33N4+vQcvxmdAzU9YQzDsLRtAxuQ
GP2VtVmJSin5fBncgg8fvCQ5aWot7Sha9Ff+JFVrYGhMOg5jROnz8NfetwYL
X9PKBaT5ZeQMJt9OPsLV5ooQtHZvyopJw+BpG5Rz3oaha1FmhrGj7ZewID3b
D+t09rwS0nczI4aqBl4TVPdknkAm2PINx1yeKCF5r1CxcK7FuQK1s3YfDHLy
41hy3R3JQi7f8AoD6+cppWR9xJwF3ns9d9D6ycSXkY6JyH2o7Vefwa7UIy/c
6beEl5NDtlhLFblR4eSK0C+snYacA6UZhmZ2jdWkZmqJLyYTlg17EvwLiwPm
ule+oD5GnCole3l/x/BKoniCYXpNl4o05egW4Puh4BraomXhjeQ/I1PdKg==

  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pertableB2", "=", 
  RowBox[{"Median", "[", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "1", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "1", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "2", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "2", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "3", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "3", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "4", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "4", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "5", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "5", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "6", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "6", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s2", "[", "7", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "7", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1", ",", "60"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701867065805591*^9, 3.701867224033483*^9}, {
  3.7026316190487747`*^9, 3.70263167482123*^9}, {3.702631781201309*^9, 
  3.7026317962935762`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "24.565584546925567`", ",", "24.57552610279239`", ",", 
     "24.8571940237413`", ",", "24.897960229602297`", ",", 
     "24.64534293831169`", ",", "24.565584546925567`", ",", 
     "24.30017006802721`", ",", "24.155180986475735`", ",", 
     "23.94563288643533`", ",", "23.776869616288174`", ",", 
     "23.555517843289373`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26.368269648284844`", ",", "26.1863410952997`", ",", 
     "26.23158747300216`", ",", "24.8571940237413`", ",", 
     "24.725620928338763`", ",", "24.53580808080808`", ",", "24.29045`", ",", 
     "24.164793076004774`", ",", "23.95507889546351`", ",", 
     "23.786182922052486`", ",", "23.537257751937986`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.590444584913612`", ",", "25.504462410751785`", ",", 
     "24.938860369609856`", ",", "24.8571940237413`", ",", 
     "24.68040134430448`", ",", "24.54572554567502`", ",", "24.29045`", ",", 
     "24.164793076004774`", ",", "23.95507889546351`", ",", 
     "23.786182922052486`", ",", "23.555517843289373`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.451016345347863`", ",", "25.249948024948026`", ",", 
     "25.093440082644626`", ",", "24.92862274220033`", ",", 
     "24.66536352558895`", ",", "24.54572554567502`", ",", "24.29045`", ",", 
     "24.17441281847134`", ",", "23.95507889546351`", ",", 
     "23.786182922052486`", ",", "23.555517843289373`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.021065100947673`", ",", "25.313099208003333`", ",", 
     "25.12458626396359`", ",", "24.990174897119342`", ",", 
     "24.70550244100895`", ",", "24.565584546925567`", ",", "24.29045`", ",", 
     "24.184040223018716`", ",", "23.964532359905288`", ",", 
     "23.786182922052486`", ",", "23.537257751937986`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.504462410751785`", ",", "25.1453933747412`", ",", 
     "25.052031765676567`", ",", "24.84702332242226`", ",", 
     "24.897960229602297`", ",", "24.64534293831169`", ",", 
     "24.319633560272326`", ",", "24.184040223018716`", ",", 
     "23.98346169036335`", ",", "23.76756360078278`", ",", 
     "23.491731141199228`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "27.12804333258879`", ",", "27.33564033310826`", ",", 
     "27.31105239487295`", ",", "26.751596916299558`", ",", 
     "25.472367869127517`", ",", "24.897960229602297`", ",", 
     "24.36842897271268`", ",", "24.164793076004774`", ",", 
     "23.98346169036335`", ",", "23.721142578125`", ",", 
     "23.528138318481208`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.702632513539775*^9, 3.702632893394937*^9, 
  3.702633697329246*^9, 3.702634312795904*^9, 3.702634619882802*^9, 
  3.7026349387690973`*^9, 3.702636415917047*^9, 3.702636753184979*^9, 
  3.702637951035303*^9, 3.702638305554246*^9, 3.7026387226039124`*^9, 
  3.702640058919087*^9, 3.702640214027479*^9, 3.7026404253542347`*^9, 
  3.702640663996628*^9, 3.702658427013706*^9, 3.702663273183353*^9, 
  3.7026642771284313`*^9, 3.702664476850006*^9, 3.7026664162764063`*^9, 
  3.702667631125907*^9, 3.702670774985352*^9, 3.702670951899644*^9, 
  3.702671303469722*^9, 3.702671580837749*^9, 3.702672914530676*^9, 
  3.702673172923398*^9, 3.7027028784417458`*^9, 3.702703262341783*^9, 
  3.7027037880271072`*^9, 3.7027041487975616`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pertableC2", "=", 
  RowBox[{"Median", "[", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "1", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "1", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "2", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "2", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "3", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "3", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "4", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "4", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "5", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "5", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "6", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "6", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s3", "[", "7", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "7", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1", ",", "60"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701867065805591*^9, 3.701867224033483*^9}, {
  3.7026316190487747`*^9, 3.70263167482123*^9}, {3.702631786519106*^9, 
  3.702631801971387*^9}, {3.702631931089264*^9, 3.702631931365192*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "25.67700845665962`", ",", "25.40842050209205`", ",", 
     "25.249948024948026`", ",", "24.90817268252666`", ",", 
     "24.54572554567502`", ",", "24.29045`", ",", "24.078558683584458`", ",", 
     "23.814166666666665`", ",", "23.619651886425515`", ",", 
     "23.455436461954424`", ",", "23.19118770288333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.072718827415358`", ",", "25.355375782881`", ",", 
     "25.218490448504983`", ",", "24.95936087135224`", ",", 
     "24.61537292257803`", ",", "24.29045`", ",", "24.0690150614348`", ",", 
     "23.814166666666665`", ",", "23.582961165048545`", ",", 
     "23.446380308880308`", ",", "23.235555768127032`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.547381152713506`", ",", "25.270963379109446`", ",", 
     "25.1453933747412`", ",", "24.90817268252666`", ",", 
     "24.62535482562855`", ",", "24.30017006802721`", ",", 
     "24.0690150614348`", ",", "23.823509219301688`", ",", 
     "23.564658517656188`", ",", "23.428288966049383`", ",", 
     "23.248899310872893`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26.062714592274677`", ",", "26.564359142607174`", ",", 
     "24.949106409202958`", ",", "24.725620928338763`", ",", 
     "24.64534293831169`", ",", "24.309897918334666`", ",", 
     "24.0690150614348`", ",", "23.842216332940716`", ",", 
     "23.564658517656188`", ",", "23.392189907550076`", ",", 
     "23.257803523554195`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.786173469387755`", ",", "24.51599717400081`", ",", 
     "24.6753860219423`", ",", "24.417420587052675`", ",", 
     "24.979895104895103`", ",", "24.388002008032128`", ",", 
     "24.0690150614348`", ",", "23.860952848722984`", ",", 
     "23.610468506998444`", ",", "23.33824942352037`", ",", 
     "23.217788185815333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.755860171218917`", ",", "24.635344827586206`", ",", 
     "24.397800321414223`", ",", "24.03091610605461`", ",", 
     "24.60539910858995`", ",", "24.309897918334666`", ",", 
     "24.0690150614348`", ",", "23.842216332940716`", ",", 
     "23.647244937694705`", ",", "23.34722222222222`", ",", 
     "23.173487883991605`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "23.99293757408139`", ",", "23.832859105180535`", ",", 
     "24.36842897271268`", ",", "23.91733950374163`", ",", 
     "24.565584546925567`", ",", "24.28073770491803`", ",", 
     "24.059479001584787`", ",", "23.814166666666665`", ",", 
     "23.656456953642383`", ",", "23.36518853405156`", ",", 
     "23.155815061963775`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.702632516127924*^9, 3.70263289610828*^9, 
  3.7026336998455772`*^9, 3.702634315362506*^9, 3.702634622409968*^9, 
  3.702634941298768*^9, 3.702636419496921*^9, 3.702636755917457*^9, 
  3.702637953783414*^9, 3.70263830815204*^9, 3.702638725200481*^9, 
  3.7026400616203747`*^9, 3.702640216981064*^9, 3.7026404282931356`*^9, 
  3.7026406664729853`*^9, 3.702658429634467*^9, 3.7026632755268927`*^9, 
  3.702664279600193*^9, 3.702664479196405*^9, 3.7026664188173122`*^9, 
  3.702667633575088*^9, 3.702670777479475*^9, 3.7026709543028603`*^9, 
  3.702671305890375*^9, 3.7026715834576397`*^9, 3.702672917141368*^9, 
  3.7026731754334307`*^9, 3.702702881041711*^9, 3.702703264683486*^9, 
  3.702703790461832*^9, 3.702704151174733*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pertableD2", "=", 
  RowBox[{"Median", "[", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "1", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "1", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "2", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "2", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "3", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "3", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "4", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "4", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "5", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "5", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "6", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "6", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s4", "[", "7", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "7", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1", ",", "60"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701867065805591*^9, 3.701867224033483*^9}, {
  3.7026316190487747`*^9, 3.70263167482123*^9}, {3.702631788963564*^9, 
  3.702631808743335*^9}, {3.70263193422064*^9, 3.7026319366276093`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "25.818930697278912`", ",", "25.64447846283784`", ",", 
     "25.633653440270155`", ",", "24.92862274220033`", ",", 
     "24.309897918334666`", ",", "24.049950495049504`", ",", 
     "23.795503526645767`", ",", "23.610468506998444`", ",", 
     "23.455436461954424`", ",", "23.18233441496469`", ",", 
     "22.954498204498204`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.2226266453929`", ",", "24.585475708502024`", ",", 
     "24.685416666666665`", ",", "24.685416666666665`", ",", "24.29045`", ",",
      "24.049950495049504`", ",", "23.814166666666665`", ",", 
     "23.555517843289373`", ",", "23.428288966049383`", ",", 
     "23.240001913509378`", ",", "22.954498204498204`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.187111157196185`", ",", "25.103813559322035`", ",", 
     "24.84702332242226`", ",", "24.55565103113627`", ",", 
     "24.28073770491803`", ",", "24.049950495049504`", ",", 
     "23.814166666666665`", ",", "23.555517843289373`", ",", 
     "23.428288966049383`", ",", "23.248899310872893`", ",", 
     "22.963178294573645`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26.14125053809729`", ",", "26.276990480311554`", ",", 
     "26.32255093194625`", ",", "24.918393516618792`", ",", 
     "24.27103317346123`", ",", "24.049950495049504`", ",", 
     "23.804831438651508`", ",", "23.560088180472782`", ",", 
     "23.428288966049383`", ",", "23.240001913509378`", ",", 
     "22.963178294573645`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.13597972972973`", ",", "24.28073770491803`", ",", 
     "24.184040223018716`", ",", "24.23229249800479`", ",", 
     "24.309897918334666`", ",", "24.040429532858273`", ",", 
     "23.832859105180535`", ",", "23.564658517656188`", ",", 
     "23.37418206312548`", ",", "23.257803523554195`", ",", 
     "22.98925799734999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.48305707091901`", ",", "25.228967594515996`", ",", 
     "24.51599717400081`", ",", "24.40760651125402`", ",", 
     "24.30017006802721`", ",", "24.040429532858273`", ",", 
     "23.832859105180535`", ",", "23.555517843289373`", ",", 
     "23.383182518290337`", ",", "23.257803523554195`", ",", 
     "22.980558183538317`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24.26133639632441`", ",", "24.40760651125402`", ",", 
     "24.53580808080808`", ",", "24.397800321414223`", ",", "24.29045`", ",", 
     "24.040429532858273`", ",", "23.842216332940716`", ",", 
     "23.564658517656188`", ",", "23.37418206312548`", ",", 
     "23.257803523554195`", ",", "22.98925799734999`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7026325187417593`*^9, 3.7026328987289*^9, 
  3.702633702377964*^9, 3.7026343178820333`*^9, 3.702634624951413*^9, 
  3.7026349438475447`*^9, 3.7026364223732347`*^9, 3.702636758639777*^9, 
  3.702637956392469*^9, 3.702638310685363*^9, 3.7026387277456417`*^9, 
  3.702640064310111*^9, 3.702640219801796*^9, 3.702640431315982*^9, 
  3.702640668985561*^9, 3.702658432284127*^9, 3.7026632778972263`*^9, 
  3.702664282106419*^9, 3.702664481544997*^9, 3.702666421358136*^9, 
  3.702667636057366*^9, 3.702670780086142*^9, 3.702670956706335*^9, 
  3.702671308256359*^9, 3.70267158716457*^9, 3.7026729196935797`*^9, 
  3.7026731779219427`*^9, 3.702702883405477*^9, 3.702703267028463*^9, 
  3.702703792886973*^9, 3.702704153607379*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pertableE2", "=", 
  RowBox[{"Median", "[", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "1", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "1", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "2", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "2", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "3", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "3", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "4", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "4", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "5", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "5", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "6", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "6", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"FFTPeriod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"s5", "[", "7", "]"}], "[", 
             RowBox[{"[", "n", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"24", "*", "31"}], ";;", 
              RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "+", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", 
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "0.01"}], "]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"s1", "[", "7", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"24", "*", "31"}], ";;", 
                   RowBox[{"24", "*", "60"}]}], "]"}], "]"}], "]"}]}], 
              "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "11"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "1", ",", "60"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701867065805591*^9, 3.701867224033483*^9}, {
  3.7026316190487747`*^9, 3.70263167482123*^9}, {3.702631788963564*^9, 
  3.702631808743335*^9}, {3.70263193422064*^9, 3.7026319366276093`*^9}, {
  3.70267242440026*^9, 3.7026724336760197`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "24.27103317346123`", ",", "24.37821156162184`", ",", 
     "24.09766865079365`", ",", "24.887756147540983`", ",", 
     "25.166234977206795`", ",", "24.867373054873056`", ",", 
     "24.55565103113627`", ",", "24.26133639632441`", ",", 
     "24.059479001584787`", ",", "23.814166666666665`", ",", 
     "23.619651886425515`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "27.29877500561924`", ",", "26.775187389770725`", ",", 
     "27.44683615819209`", ",", "25.525903741067676`", ",", 
     "25.176668739635158`", ",", "24.816561095218635`", ",", 
     "24.496218233158533`", ",", "24.26133639632441`", ",", 
     "24.059479001584787`", ",", "23.814166666666665`", ",", 
     "23.647244937694705`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.94024989320803`", ",", "25.851905065985527`", ",", 
     "25.568894736842104`", ",", "25.775095500848895`", ",", 
     "25.228967594515996`", ",", "24.867373054873056`", ",", 
     "24.54572554567502`", ",", "24.26133639632441`", ",", 
     "24.059479001584787`", ",", "23.814166666666665`", ",", 
     "23.610468506998444`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.929173783091375`", ",", "25.94024989320803`", ",", 
     "25.995772688356166`", ",", "25.764159949087823`", ",", 
     "25.155809859154928`", ",", "24.80642361111111`", ",", 
     "24.57552610279239`", ",", "24.28073770491803`", ",", 
     "24.049950495049504`", ",", "23.832859105180535`", ",", 
     "23.592123154623156`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.23945344970906`", ",", "25.000463153561135`", ",", 
     "25.041701030927836`", ",", "25.072718827415358`", ",", 
     "25.041701030927836`", ",", "24.685416666666665`", ",", 
     "24.525898626817447`", ",", "24.30017006802721`", ",", 
     "24.049950495049504`", ",", "23.851580911233306`", ",", 
     "23.582961165048545`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.34479340567613`", ",", "25.228967594515996`", ",", 
     "25.23945344970906`", ",", "25.062371027651672`", ",", 
     "25.052031765676567`", ",", "24.6753860219423`", ",", 
     "24.50610371267151`", ",", "24.30017006802721`", ",", 
     "24.049950495049504`", ",", "23.851580911233306`", ",", 
     "23.582961165048545`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25.742316659601528`", ",", "25.461687631027253`", ",", 
     "25.20802200083022`", ",", "25.093440082644626`", ",", 
     "25.021065100947673`", ",", "24.66536352558895`", ",", 
     "24.51599717400081`", ",", "24.29045`", ",", "24.049950495049504`", ",", 
     "23.842216332940716`", ",", "23.582961165048545`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.70267292228274*^9, 3.702673180387725*^9, 
  3.702702885769664*^9, 3.702703269410768*^9, 3.7027037952952538`*^9, 
  3.702704156195116*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", "Outputs", " ", "*)"}]], "Input",
 CellChangeTimes->{{3.7026318169577923`*^9, 3.702631820797872*^9}, {
  3.727327154829056*^9, 
  3.727327157377182*^9}},ExpressionUUID->"4a95acdf-6b07-4144-9df8-\
94817cf5e816"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Coupling", " ", "and", " ", "amplitude"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.7273271482016687`*^9, 
  3.727327163950163*^9}},ExpressionUUID->"62441b0a-9107-4b00-8ec9-\
b0941122cc62"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dampA", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", 
          RowBox[{"amptableA", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "n"}], "]"}], "]"}], "]"}], "/", 
         RowBox[{"Total", "[", 
          RowBox[{"amptableA", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "11"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "11", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20", ",", "2"}], "}"}]}], "]"}], ",", 
        
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10", ",", "0.2"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling inhibition (A.U.)\>\"", ",", "\"\<Amplitude ratio\>\""}],
        "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dampB", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", 
          RowBox[{"amptableB", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "n"}], "]"}], "]"}], "]"}], "/", 
         RowBox[{"Total", "[", 
          RowBox[{"amptableB", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "11"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "11", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10", ",", "0.2"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling inhibition (A.U.)\>\"", ",", "\"\<Amplitude ratio\>\""}],
        "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dampC", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", 
          RowBox[{"amptableC", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "n"}], "]"}], "]"}], "]"}], "/", 
         RowBox[{"Total", "[", 
          RowBox[{"amptableC", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "11"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "11", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10", ",", "0.2"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling inhibition (A.U.)\>\"", ",", "\"\<Amplitude ratio\>\""}],
        "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dampD", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", 
          RowBox[{"amptableD", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "n"}], "]"}], "]"}], "]"}], "/", 
         RowBox[{"Total", "[", 
          RowBox[{"amptableD", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "11"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "11", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10", ",", "0.2"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling inhibition (A.U.)\>\"", ",", "\"\<Amplitude ratio\>\""}],
        "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dampE", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", 
          RowBox[{"amptableE", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "n"}], "]"}], "]"}], "]"}], "/", 
         RowBox[{"Total", "[", 
          RowBox[{"amptableE", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "11"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "11", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10", ",", "0.2"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling inhibition (A.U.)\>\"", ",", "\"\<Amplitude ratio\>\""}],
        "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "230"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.9"}]}], "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQA2IQLbd/h5ftlNeOBexbg0D0qlyJCBD9tkEiGkRft5+Y
AaKfVDwD09f0Xnr4AukTK6M8QXSE9ZfzfkCa507XBRAd8HjHNRAd9FbkBoiu
t3vwHETnVVi9ANEn9YyW+ANpCX/fpSB66qf5E0uA9JcrlpNA9L+tE36D6Mv2
58E090P3gFIgrbO+MgREPylhigbRdpI9qSDa4k7GChC949j7UyC6r+r+RRC9
y4jxOohuWtt3F0SnBEy6D6JnN5qbeU597fjpQyOYZtFSNPQC0sYB/kYgel6G
zAnTaa8d93yfeB5EWyzmdrcA0l1888C0IMPmqZ5A+rXUqWkg2vbTkfxYIC3P
lFwKoi+FCdSA6CPLV4JpADdNt4Y=
  "]],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.9999999999999999}}, {{2., 
        0.838300367642005}}, {{3., 0.8740529277603815}}, {{4., 
        0.8258390996130749}}, {{5., 0.7322044258391617}}, {{6., 
        0.6390703754103916}}, {{7., 0.5862736912866233}}, {{8., 
        0.452414740806011}}, {{9., 0.4327538146037221}}, {{10., 
        0.35310536662404285`}}, {{11., 0.356901692334099}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 1.}}, {{2., 
        0.9193753844327546}}, {{3., 0.8336984041661507}}, {{4., 
        0.7433165775582501}}, {{5., 0.6688484089149551}}, {{6., 
        0.618927368189384}}, {{7., 0.5395962692711506}}, {{8., 
        0.4552776090134532}}, {{9., 0.38695314656439894`}}, {{10., 
        0.3410309834310014}}, {{11., 0.3334109326058336}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 1.}}, {{2., 
        0.924079917152134}}, {{3., 0.8469436690570977}}, {{4., 
        0.7680524727710973}}, {{5., 0.6865127678200643}}, {{6., 
        0.6018958413825839}}, {{7., 0.5970818382143497}}, {{8., 
        0.4626631199456287}}, {{9., 0.3793183767602219}}, {{10., 
        0.35335370607464645`}}, {{11., 0.32905969912570937`}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 1.}}, {{2., 
        0.928011358539452}}, {{3., 0.8553071683920416}}, {{4., 
        0.7814763990757372}}, {{5., 0.7056973465043659}}, {{6., 
        0.6259559509797277}}, {{7., 0.534251110166194}}, {{8., 
        0.4184228393011438}}, {{9., 0.36734559977743586`}}, {{10., 
        0.3475942062396439}}, {{11., 0.3227682244703768}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 1.}}, {{2., 
        0.9265280252500169}}, {{3., 0.851859266680224}}, {{4., 
        0.7752069907245475}}, {{5., 0.6948513377228107}}, {{6., 
        0.6059075847435516}}, {{7., 0.47937455672645585`}}, {{8., 
        0.46357250224235563`}}, {{9., 0.39644370781800065`}}, {{10., 
        0.3543032471465503}}, {{11., 0.3241178938274261}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}},
  AspectRatio->0.9,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0.555, 0},
  BaseStyle->Directive[FontFamily -> "Helvetica", FontSize -> 16],
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox["\"Amplitude ratio\"", TraditionalForm], None}, {
     FormBox["\"Coupling inhibition (A.U.)\"", TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1.1]],
  FrameTicks->{{{{0., 
       FormBox["0.`", TraditionalForm], {0, 0.02}}, {0.2, 
       FormBox["0.2`", TraditionalForm], {0, 0.02}}, {0.4, 
       FormBox["0.4`", TraditionalForm], {0, 0.02}}, {0.6000000000000001, 
       FormBox["0.6000000000000001`", TraditionalForm], {0, 0.02}}, {0.8, 
       FormBox["0.8`", TraditionalForm], {0, 0.02}}, {1., 
       FormBox["1.`", TraditionalForm], {0, 0.02}}, {1.2000000000000002`, 
       FormBox["1.2000000000000002`", TraditionalForm], {0, 0.02}}, {
      1.4000000000000001`, 
       FormBox["1.4000000000000001`", TraditionalForm], {0, 0.02}}, {1.6, 
       FormBox["1.6`", TraditionalForm], {0, 0.02}}, {1.8, 
       FormBox["1.8`", TraditionalForm], {0, 0.02}}, {2., 
       FormBox["2.`", TraditionalForm], {0, 0.02}}, {2.2, 
       FormBox["2.2`", TraditionalForm], {0, 0.02}}, {2.4000000000000004`, 
       FormBox["2.4000000000000004`", TraditionalForm], {0, 0.02}}, {2.6, 
       FormBox["2.6`", TraditionalForm], {0, 0.02}}, {2.8000000000000003`, 
       FormBox["2.8000000000000003`", TraditionalForm], {0, 0.02}}, {3., 
       FormBox["3.`", TraditionalForm], {0, 0.02}}, {3.2, 
       FormBox["3.2`", TraditionalForm], {0, 0.02}}, {3.4000000000000004`, 
       FormBox["3.4000000000000004`", TraditionalForm], {0, 0.02}}, {3.6, 
       FormBox["3.6`", TraditionalForm], {0, 0.02}}, {3.8000000000000003`, 
       FormBox["3.8000000000000003`", TraditionalForm], {0, 0.02}}, {4., 
       FormBox["4.`", TraditionalForm], {0, 0.02}}, {4.2, 
       FormBox["4.2`", TraditionalForm], {0, 0.02}}, {4.4, 
       FormBox["4.4`", TraditionalForm], {0, 0.02}}, {4.6000000000000005`, 
       FormBox["4.6000000000000005`", TraditionalForm], {0, 0.02}}, {
      4.800000000000001, 
       FormBox["4.800000000000001`", TraditionalForm], {0, 0.02}}, {5., 
       FormBox["5.`", TraditionalForm], {0, 0.02}}, {5.2, 
       FormBox["5.2`", TraditionalForm], {0, 0.02}}, {5.4, 
       FormBox["5.4`", TraditionalForm], {0, 0.02}}, {5.6000000000000005`, 
       FormBox["5.6000000000000005`", TraditionalForm], {0, 0.02}}, {
      5.800000000000001, 
       FormBox["5.800000000000001`", TraditionalForm], {0, 0.02}}, {6., 
       FormBox["6.`", TraditionalForm], {0, 0.02}}, {6.2, 
       FormBox["6.2`", TraditionalForm], {0, 0.02}}, {6.4, 
       FormBox["6.4`", TraditionalForm], {0, 0.02}}, {6.6000000000000005`, 
       FormBox["6.6000000000000005`", TraditionalForm], {0, 0.02}}, {
      6.800000000000001, 
       FormBox["6.800000000000001`", TraditionalForm], {0, 0.02}}, {7., 
       FormBox["7.`", TraditionalForm], {0, 0.02}}, {7.2, 
       FormBox["7.2`", TraditionalForm], {0, 0.02}}, {7.4, 
       FormBox["7.4`", TraditionalForm], {0, 0.02}}, {7.6000000000000005`, 
       FormBox["7.6000000000000005`", TraditionalForm], {0, 0.02}}, {
      7.800000000000001, 
       FormBox["7.800000000000001`", TraditionalForm], {0, 0.02}}, {8., 
       FormBox["8.`", TraditionalForm], {0, 0.02}}, {8.200000000000001, 
       FormBox["8.200000000000001`", TraditionalForm], {0, 0.02}}, {8.4, 
       FormBox["8.4`", TraditionalForm], {0, 0.02}}, {8.6, 
       FormBox["8.6`", TraditionalForm], {0, 0.02}}, {8.8, 
       FormBox["8.8`", TraditionalForm], {0, 0.02}}, {9., 
       FormBox["9.`", TraditionalForm], {0, 0.02}}, {9.200000000000001, 
       FormBox["9.200000000000001`", TraditionalForm], {0, 0.02}}, {9.4, 
       FormBox["9.4`", TraditionalForm], {0, 0.02}}, {9.600000000000001, 
       FormBox["9.600000000000001`", TraditionalForm], {0, 0.02}}, {9.8, 
       FormBox["9.8`", TraditionalForm], {0, 0.02}}, {10., 
       FormBox["10.`", TraditionalForm], {0, 0.02}}}, {{0., 
       FormBox["0.`", TraditionalForm], {0, 0.02}}, {0.2, 
       FormBox["0.2`", TraditionalForm], {0, 0.02}}, {0.4, 
       FormBox["0.4`", TraditionalForm], {0, 0.02}}, {0.6000000000000001, 
       FormBox["0.6000000000000001`", TraditionalForm], {0, 0.02}}, {0.8, 
       FormBox["0.8`", TraditionalForm], {0, 0.02}}, {1., 
       FormBox["1.`", TraditionalForm], {0, 0.02}}, {1.2000000000000002`, 
       FormBox["1.2000000000000002`", TraditionalForm], {0, 0.02}}, {
      1.4000000000000001`, 
       FormBox["1.4000000000000001`", TraditionalForm], {0, 0.02}}, {1.6, 
       FormBox["1.6`", TraditionalForm], {0, 0.02}}, {1.8, 
       FormBox["1.8`", TraditionalForm], {0, 0.02}}, {2., 
       FormBox["2.`", TraditionalForm], {0, 0.02}}, {2.2, 
       FormBox["2.2`", TraditionalForm], {0, 0.02}}, {2.4000000000000004`, 
       FormBox["2.4000000000000004`", TraditionalForm], {0, 0.02}}, {2.6, 
       FormBox["2.6`", TraditionalForm], {0, 0.02}}, {2.8000000000000003`, 
       FormBox["2.8000000000000003`", TraditionalForm], {0, 0.02}}, {3., 
       FormBox["3.`", TraditionalForm], {0, 0.02}}, {3.2, 
       FormBox["3.2`", TraditionalForm], {0, 0.02}}, {3.4000000000000004`, 
       FormBox["3.4000000000000004`", TraditionalForm], {0, 0.02}}, {3.6, 
       FormBox["3.6`", TraditionalForm], {0, 0.02}}, {3.8000000000000003`, 
       FormBox["3.8000000000000003`", TraditionalForm], {0, 0.02}}, {4., 
       FormBox["4.`", TraditionalForm], {0, 0.02}}, {4.2, 
       FormBox["4.2`", TraditionalForm], {0, 0.02}}, {4.4, 
       FormBox["4.4`", TraditionalForm], {0, 0.02}}, {4.6000000000000005`, 
       FormBox["4.6000000000000005`", TraditionalForm], {0, 0.02}}, {
      4.800000000000001, 
       FormBox["4.800000000000001`", TraditionalForm], {0, 0.02}}, {5., 
       FormBox["5.`", TraditionalForm], {0, 0.02}}, {5.2, 
       FormBox["5.2`", TraditionalForm], {0, 0.02}}, {5.4, 
       FormBox["5.4`", TraditionalForm], {0, 0.02}}, {5.6000000000000005`, 
       FormBox["5.6000000000000005`", TraditionalForm], {0, 0.02}}, {
      5.800000000000001, 
       FormBox["5.800000000000001`", TraditionalForm], {0, 0.02}}, {6., 
       FormBox["6.`", TraditionalForm], {0, 0.02}}, {6.2, 
       FormBox["6.2`", TraditionalForm], {0, 0.02}}, {6.4, 
       FormBox["6.4`", TraditionalForm], {0, 0.02}}, {6.6000000000000005`, 
       FormBox["6.6000000000000005`", TraditionalForm], {0, 0.02}}, {
      6.800000000000001, 
       FormBox["6.800000000000001`", TraditionalForm], {0, 0.02}}, {7., 
       FormBox["7.`", TraditionalForm], {0, 0.02}}, {7.2, 
       FormBox["7.2`", TraditionalForm], {0, 0.02}}, {7.4, 
       FormBox["7.4`", TraditionalForm], {0, 0.02}}, {7.6000000000000005`, 
       FormBox["7.6000000000000005`", TraditionalForm], {0, 0.02}}, {
      7.800000000000001, 
       FormBox["7.800000000000001`", TraditionalForm], {0, 0.02}}, {8., 
       FormBox["8.`", TraditionalForm], {0, 0.02}}, {8.200000000000001, 
       FormBox["8.200000000000001`", TraditionalForm], {0, 0.02}}, {8.4, 
       FormBox["8.4`", TraditionalForm], {0, 0.02}}, {8.6, 
       FormBox["8.6`", TraditionalForm], {0, 0.02}}, {8.8, 
       FormBox["8.8`", TraditionalForm], {0, 0.02}}, {9., 
       FormBox["9.`", TraditionalForm], {0, 0.02}}, {9.200000000000001, 
       FormBox["9.200000000000001`", TraditionalForm], {0, 0.02}}, {9.4, 
       FormBox["9.4`", TraditionalForm], {0, 0.02}}, {9.600000000000001, 
       FormBox["9.600000000000001`", TraditionalForm], {0, 0.02}}, {9.8, 
       FormBox["9.8`", TraditionalForm], {0, 0.02}}, {10., 
       FormBox["10.`", TraditionalForm], {0, 0.02}}}}, {{{1, 
       FormBox["0", TraditionalForm], {0, 0.02}}, {3, 
       FormBox["2", TraditionalForm], {0, 0.02}}, {5, 
       FormBox["4", TraditionalForm], {0, 0.02}}, {7, 
       FormBox["6", TraditionalForm], {0, 0.02}}, {9, 
       FormBox["8", TraditionalForm], {0, 0.02}}, {11, 
       FormBox["10", TraditionalForm], {0, 0.02}}, {13, 
       FormBox["12", TraditionalForm], {0, 0.02}}, {15, 
       FormBox["14", TraditionalForm], {0, 0.02}}, {17, 
       FormBox["16", TraditionalForm], {0, 0.02}}, {19, 
       FormBox["18", TraditionalForm], {0, 0.02}}}, {{1, 
       FormBox["0", TraditionalForm], {0, 0.02}}, {3, 
       FormBox["2", TraditionalForm], {0, 0.02}}, {5, 
       FormBox["4", TraditionalForm], {0, 0.02}}, {7, 
       FormBox["6", TraditionalForm], {0, 0.02}}, {9, 
       FormBox["8", TraditionalForm], {0, 0.02}}, {11, 
       FormBox["10", TraditionalForm], {0, 0.02}}, {13, 
       FormBox["12", TraditionalForm], {0, 0.02}}, {15, 
       FormBox["14", TraditionalForm], {0, 0.02}}, {17, 
       FormBox["16", TraditionalForm], {0, 0.02}}, {19, 
       FormBox["18", TraditionalForm], {0, 0.02}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->230,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.5, 11.5}, {-0.1, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7015988358824368`*^9, 3.7015988702651167`*^9}, {
   3.701598914923244*^9, 3.7015989370856323`*^9}, 3.701599011693509*^9, 
   3.70159904765349*^9, 3.7015991261583776`*^9, 3.701601213954812*^9, 
   3.7016012785375443`*^9, 3.701601335834971*^9, 3.701601481069374*^9, 
   3.701630244419997*^9, 3.701631103078165*^9, 3.7016315635606127`*^9, 
   3.7016341703404303`*^9, 3.701634692914975*^9, {3.701634744637035*^9, 
   3.7016347530390882`*^9}, 3.701634833987108*^9, 3.7016348822483463`*^9, 
   3.701634933820795*^9, 3.7016350267474117`*^9, 3.701635192978374*^9, 
   3.70163590029073*^9, 3.701635997116486*^9, 3.7016361061327257`*^9, 
   3.701636229821229*^9, 3.701636395307214*^9, 3.70167883939499*^9, {
   3.701712014389544*^9, 3.70171201825634*^9}, 3.701712863044403*^9, {
   3.701713552726122*^9, 3.70171357228741*^9}, {3.70171362664466*^9, 
   3.701713708794132*^9}, 3.701714261400714*^9, {3.701714305403102*^9, 
   3.701714463551486*^9}, {3.701714499110756*^9, 3.701714519780066*^9}, {
   3.701714575341304*^9, 3.701714582393059*^9}, 3.701714616596538*^9, {
   3.701714671060396*^9, 3.7017146851463203`*^9}, 3.701715301333894*^9, 
   3.7017155960674458`*^9, 3.701715715742784*^9, 3.701783445277967*^9, 
   3.701861862025173*^9, 3.7018628396742077`*^9, 3.7018634181398907`*^9, 
   3.7021466757655087`*^9, 3.70214686639574*^9, {3.702147506186288*^9, 
   3.702147508652587*^9}, 3.702147705378148*^9, 3.7021484327592707`*^9, {
   3.70214951591953*^9, 3.702149523366601*^9}, 3.70215134568277*^9, 
   3.702622986341585*^9, 3.7026230910130653`*^9, 3.7026232268463993`*^9, 
   3.7026233544767*^9, 3.702623484381588*^9, 3.702624722221324*^9, 
   3.702625876385126*^9, 3.702626060923167*^9, 3.7026262904200373`*^9, 
   3.7026269019430323`*^9, 3.702627070869534*^9, 3.7026272721110477`*^9, 
   3.702627610864646*^9, 3.7026279956928864`*^9, 3.702628185683037*^9, 
   3.70262869469278*^9, 3.7026289266957273`*^9, 3.7026290737532787`*^9, 
   3.702629905617131*^9, 3.702630347645149*^9, 3.702632519344575*^9, 
   3.702632899252707*^9, 3.702633702964754*^9, 3.702634318515011*^9, 
   3.702634625839518*^9, 3.702634944430543*^9, 3.7026364231435738`*^9, 
   3.7026367593146067`*^9, 3.702637117802998*^9, 3.702637956927423*^9, 
   3.7026383112180967`*^9, 3.70263872828893*^9, 3.702640065055624*^9, 
   3.702640220532485*^9, 3.702640431904365*^9, 3.7026406695133677`*^9, 
   3.70265843331997*^9, 3.702663278418489*^9, 3.702664282754938*^9, 
   3.702664482020903*^9, 3.702666421929674*^9, 3.702667636519491*^9, 
   3.70267078072646*^9, 3.7026709575192547`*^9, 3.702671308830248*^9, 
   3.7026715877501574`*^9, 3.7026729229108953`*^9, 3.702673180937106*^9, 
   3.7027028863957253`*^9, 3.702703269941503*^9, 3.7027037959835777`*^9, 
   3.702704157281575*^9, {3.702713214950182*^9, 3.702713259695002*^9}, 
   3.702713317943488*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Coupling", " ", "and", " ", "period"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.727327173768751*^9, 
  3.727327174132925*^9}},ExpressionUUID->"ffb18624-f99c-42f9-ba50-\
35f301b45ad6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dperA1", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Mean", "[", 
          RowBox[{"pertableA1", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "n"}], "]"}], "]"}], "]"}], "-", 
         RowBox[{"Mean", "[", 
          RowBox[{"pertableA1", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "11"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "11", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.2"}], ",", "2.2"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20", ",", "2"}], "}"}]}], "]"}], ",", 
        
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10", ",", "0.4"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling inhibition (A.U.)\>\"", ",", 
        "\"\<Period increase (h)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dperB1", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Mean", "[", 
          RowBox[{"pertableB1", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "n"}], "]"}], "]"}], "]"}], "-", 
         RowBox[{"Mean", "[", 
          RowBox[{"pertableB1", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "11"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "11", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "2.1"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10", ",", "0.4"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling inhibition (A.U.)\>\"", ",", 
        "\"\<Period increase (h)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dperC1", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Mean", "[", 
          RowBox[{"pertableC1", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "n"}], "]"}], "]"}], "]"}], "-", 
         RowBox[{"Mean", "[", 
          RowBox[{"pertableC1", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "11"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "11", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "2.68"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10", ",", "0.4"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling inhibition (A.U.)\>\"", ",", 
        "\"\<Period increase (h)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dperD1", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Mean", "[", 
          RowBox[{"pertableD1", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "n"}], "]"}], "]"}], "]"}], "-", 
         RowBox[{"Mean", "[", 
          RowBox[{"pertableD1", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "11"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "11", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "2.68"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10", ",", "0.4"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling inhibition (A.U.)\>\"", ",", 
        "\"\<Period increase (h)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"dperE1", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Mean", "[", 
          RowBox[{"pertableE1", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "n"}], "]"}], "]"}], "]"}], "-", 
         RowBox[{"Mean", "[", 
          RowBox[{"pertableE1", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "11"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "11", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "2.68"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10", ",", "0.4"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling inhibition (A.U.)\>\"", ",", 
        "\"\<Period increase (h)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "230"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.9"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.701597903891385*^9, 3.701597945914342*^9}, {
   3.701598023150114*^9, 3.701598023250411*^9}, {3.701598153975919*^9, 
   3.701598179924374*^9}, {3.701598260279113*^9, 3.701598271424425*^9}, 
   3.7015984660114098`*^9, {3.701598496996273*^9, 3.701598500846365*^9}, {
   3.701598620812614*^9, 3.701598620927558*^9}, {3.701598886505167*^9, 
   3.701598909054956*^9}, {3.7015990383062057`*^9, 3.701599058173847*^9}, {
   3.701630431975256*^9, 3.701630436431926*^9}, {3.701634670329492*^9, 
   3.701634679171826*^9}, {3.701634732216467*^9, 3.701634768185401*^9}, {
   3.701634871018601*^9, 3.701634873636405*^9}, {3.701636400095812*^9, 
   3.701636403253668*^9}, {3.701712007365151*^9, 3.7017120228318996`*^9}, {
   3.701712827067422*^9, 3.701712827409205*^9}, {3.7017146542527533`*^9, 
   3.701714738135387*^9}, {3.701715947962813*^9, 3.7017159607264833`*^9}, {
   3.702147049014497*^9, 3.702147056000214*^9}, {3.702147532340887*^9, 
   3.702147537189209*^9}, {3.702149497735873*^9, 3.7021495287657146`*^9}, {
   3.702630530455954*^9, 3.702630586159438*^9}, {3.7026320760223017`*^9, 
   3.702632118462867*^9}, {3.702634007631337*^9, 3.702634011556017*^9}, {
   3.70263714249111*^9, 3.7026371469813967`*^9}, {3.702672581662043*^9, 
   3.702672589679575*^9}, 3.7027037759385033`*^9, {3.7027131389255238`*^9, 
   3.702713191919753*^9}, 3.702713392468932*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.}}, {{
        2., -0.09186128347122491}}, {{3., -0.009760480604768418}}, {{4., 
        0.21117383945097856`}}, {{5., 0.4251767847349974}}, {{6., 
        0.5677649518748424}}, {{7., 0.9520399306850891}}, {{8., 
        1.5503890297186445`}}, {{9., 1.6089522184133074`}}, {{10., 
        1.7481381775381593`}}, {{11., 1.785274557361678}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.}}, {{2., 
        0.17686669153877332`}}, {{3., 0.44430224774887606`}}, {{4., 
        0.5784409241327744}}, {{5., 0.7947337070289429}}, {{6., 
        0.8957826467097121}}, {{7., 1.553871291690637}}, {{8., 
        1.5500046918126813`}}, {{9., 1.8366000703970826`}}, {{10., 
        1.9386507266774053`}}, {{11., 2.0797024933567414`}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.}}, {{2., 
        0.20452928662939485`}}, {{3., 0.4274919285256047}}, {{4., 
        0.643408992017136}}, {{5., 0.8531542734212678}}, {{6., 
        1.148565916288998}}, {{7., 1.3809559576069894`}}, {{8., 
        1.618611873780182}}, {{9., 1.6269649069695262`}}, {{10., 
        1.8977648855097655`}}, {{11., 1.9337335321731217`}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.}}, {{2., 
        0.1893523038575431}}, {{3., 0.3782408722706698}}, {{4., 
        0.6341158800835238}}, {{5., 0.786030442802339}}, {{6., 
        1.0503029120515848`}}, {{7., 1.2861370292504724`}}, {{8., 
        1.8959499518340976`}}, {{9., 1.7923433357298997`}}, {{10., 
        1.9062405871461578`}}, {{11., 1.9863713984573899`}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.}}, {{2., 
        0.1578390066196178}}, {{3., 0.3927790089121075}}, {{4., 
        0.6284970151778744}}, {{5., 0.8383152098425128}}, {{6., 
        1.0991257822851246`}}, {{7., 1.3836292383948035`}}, {{8., 
        1.5298582228040765`}}, {{9., 1.8246897360696686`}}, {{10., 
        2.0392821899393923`}}, {{11., 2.0126135292396796`}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}},
  AspectRatio->0.9,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0.555, 0},
  BaseStyle->Directive[FontFamily -> "Helvetica", FontSize -> 16],
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox["\"Period increase (h)\"", TraditionalForm], None}, {
     FormBox["\"Coupling inhibition (A.U.)\"", TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1.1]],
  FrameTicks->{{{{0., 
       FormBox["0.`", TraditionalForm], {0, 0.02}}, {0.4, 
       FormBox["0.4`", TraditionalForm], {0, 0.02}}, {0.8, 
       FormBox["0.8`", TraditionalForm], {0, 0.02}}, {1.2000000000000002`, 
       FormBox["1.2000000000000002`", TraditionalForm], {0, 0.02}}, {1.6, 
       FormBox["1.6`", TraditionalForm], {0, 0.02}}, {2., 
       FormBox["2.`", TraditionalForm], {0, 0.02}}, {2.4000000000000004`, 
       FormBox["2.4000000000000004`", TraditionalForm], {0, 0.02}}, {
      2.8000000000000003`, 
       FormBox["2.8000000000000003`", TraditionalForm], {0, 0.02}}, {3.2, 
       FormBox["3.2`", TraditionalForm], {0, 0.02}}, {3.6, 
       FormBox["3.6`", TraditionalForm], {0, 0.02}}, {4., 
       FormBox["4.`", TraditionalForm], {0, 0.02}}, {4.4, 
       FormBox["4.4`", TraditionalForm], {0, 0.02}}, {4.800000000000001, 
       FormBox["4.800000000000001`", TraditionalForm], {0, 0.02}}, {5.2, 
       FormBox["5.2`", TraditionalForm], {0, 0.02}}, {5.6000000000000005`, 
       FormBox["5.6000000000000005`", TraditionalForm], {0, 0.02}}, {6., 
       FormBox["6.`", TraditionalForm], {0, 0.02}}, {6.4, 
       FormBox["6.4`", TraditionalForm], {0, 0.02}}, {6.800000000000001, 
       FormBox["6.800000000000001`", TraditionalForm], {0, 0.02}}, {7.2, 
       FormBox["7.2`", TraditionalForm], {0, 0.02}}, {7.6000000000000005`, 
       FormBox["7.6000000000000005`", TraditionalForm], {0, 0.02}}, {8., 
       FormBox["8.`", TraditionalForm], {0, 0.02}}, {8.4, 
       FormBox["8.4`", TraditionalForm], {0, 0.02}}, {8.8, 
       FormBox["8.8`", TraditionalForm], {0, 0.02}}, {9.200000000000001, 
       FormBox["9.200000000000001`", TraditionalForm], {0, 0.02}}, {
      9.600000000000001, 
       FormBox["9.600000000000001`", TraditionalForm], {0, 0.02}}, {10., 
       FormBox["10.`", TraditionalForm], {0, 0.02}}}, {{0., 
       FormBox["0.`", TraditionalForm], {0, 0.02}}, {0.4, 
       FormBox["0.4`", TraditionalForm], {0, 0.02}}, {0.8, 
       FormBox["0.8`", TraditionalForm], {0, 0.02}}, {1.2000000000000002`, 
       FormBox["1.2000000000000002`", TraditionalForm], {0, 0.02}}, {1.6, 
       FormBox["1.6`", TraditionalForm], {0, 0.02}}, {2., 
       FormBox["2.`", TraditionalForm], {0, 0.02}}, {2.4000000000000004`, 
       FormBox["2.4000000000000004`", TraditionalForm], {0, 0.02}}, {
      2.8000000000000003`, 
       FormBox["2.8000000000000003`", TraditionalForm], {0, 0.02}}, {3.2, 
       FormBox["3.2`", TraditionalForm], {0, 0.02}}, {3.6, 
       FormBox["3.6`", TraditionalForm], {0, 0.02}}, {4., 
       FormBox["4.`", TraditionalForm], {0, 0.02}}, {4.4, 
       FormBox["4.4`", TraditionalForm], {0, 0.02}}, {4.800000000000001, 
       FormBox["4.800000000000001`", TraditionalForm], {0, 0.02}}, {5.2, 
       FormBox["5.2`", TraditionalForm], {0, 0.02}}, {5.6000000000000005`, 
       FormBox["5.6000000000000005`", TraditionalForm], {0, 0.02}}, {6., 
       FormBox["6.`", TraditionalForm], {0, 0.02}}, {6.4, 
       FormBox["6.4`", TraditionalForm], {0, 0.02}}, {6.800000000000001, 
       FormBox["6.800000000000001`", TraditionalForm], {0, 0.02}}, {7.2, 
       FormBox["7.2`", TraditionalForm], {0, 0.02}}, {7.6000000000000005`, 
       FormBox["7.6000000000000005`", TraditionalForm], {0, 0.02}}, {8., 
       FormBox["8.`", TraditionalForm], {0, 0.02}}, {8.4, 
       FormBox["8.4`", TraditionalForm], {0, 0.02}}, {8.8, 
       FormBox["8.8`", TraditionalForm], {0, 0.02}}, {9.200000000000001, 
       FormBox["9.200000000000001`", TraditionalForm], {0, 0.02}}, {
      9.600000000000001, 
       FormBox["9.600000000000001`", TraditionalForm], {0, 0.02}}, {10., 
       FormBox["10.`", TraditionalForm], {0, 0.02}}}}, {{{1, 
       FormBox["0", TraditionalForm], {0, 0.02}}, {3, 
       FormBox["2", TraditionalForm], {0, 0.02}}, {5, 
       FormBox["4", TraditionalForm], {0, 0.02}}, {7, 
       FormBox["6", TraditionalForm], {0, 0.02}}, {9, 
       FormBox["8", TraditionalForm], {0, 0.02}}, {11, 
       FormBox["10", TraditionalForm], {0, 0.02}}, {13, 
       FormBox["12", TraditionalForm], {0, 0.02}}, {15, 
       FormBox["14", TraditionalForm], {0, 0.02}}, {17, 
       FormBox["16", TraditionalForm], {0, 0.02}}, {19, 
       FormBox["18", TraditionalForm], {0, 0.02}}}, {{1, 
       FormBox["0", TraditionalForm], {0, 0.02}}, {3, 
       FormBox["2", TraditionalForm], {0, 0.02}}, {5, 
       FormBox["4", TraditionalForm], {0, 0.02}}, {7, 
       FormBox["6", TraditionalForm], {0, 0.02}}, {9, 
       FormBox["8", TraditionalForm], {0, 0.02}}, {11, 
       FormBox["10", TraditionalForm], {0, 0.02}}, {13, 
       FormBox["12", TraditionalForm], {0, 0.02}}, {15, 
       FormBox["14", TraditionalForm], {0, 0.02}}, {17, 
       FormBox["16", TraditionalForm], {0, 0.02}}, {19, 
       FormBox["18", TraditionalForm], {0, 0.02}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->230,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.5, 11.5}, {-0.2, 2.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7026305865095463`*^9, 3.7026325194427357`*^9, 3.702632899356224*^9, 
   3.702633703063151*^9, {3.702634008292882*^9, 3.702634012157043*^9}, 
   3.7026343186517572`*^9, 3.702634625983919*^9, 3.702634944529665*^9, 
   3.7026364232901382`*^9, 3.702636759448361*^9, 3.702637147955167*^9, 
   3.702637957026917*^9, 3.702638311320305*^9, 3.702638728390637*^9, 
   3.702640065191053*^9, 3.702640220668109*^9, 3.7026404320157557`*^9, 
   3.702640669615664*^9, 3.702658433469468*^9, 3.702663278521323*^9, 
   3.702664282850395*^9, 3.702664482113758*^9, 3.702666422027465*^9, 
   3.702667636613237*^9, 3.702670780858783*^9, 3.7026709577164288`*^9, 
   3.702671308956275*^9, 3.70267158784486*^9, 3.7026729230425577`*^9, 
   3.7026731810588503`*^9, 3.702702886517667*^9, 3.702703270053219*^9, 
   3.702703796117495*^9, 3.702704157418313*^9, {3.70271313976617*^9, 
   3.7027131925923853`*^9}, 3.702713393351369*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Amplitude", "-", 
   RowBox[{"Period", " ", "relation"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.70171475349201*^9, 3.7017147543229733`*^9}, {
  3.727327055944439*^9, 
  3.727327059020636*^9}},ExpressionUUID->"8ea64b1a-67f9-4232-b753-\
ba2d33027c7a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"{", 
       RowBox[{"cperA1", ",", "campA"}], "}"}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"22.5", ",", "26.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "4.4"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "30"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Period (h)\>\"", ",", "\"\<Amplitude (fold)\>\""}], 
       "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "210"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"{", 
       RowBox[{"cperB1", ",", "campB"}], "}"}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"22.5", ",", "26.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "4.4"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "30"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Period (h)\>\"", ",", "\"\<Amplitude (fold)\>\""}], 
       "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "210"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"{", 
       RowBox[{"cperC1", ",", "campC"}], "}"}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"22.5", ",", "26.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "4.4"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "30"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Period (h)\>\"", ",", "\"\<Amplitude (fold)\>\""}], 
       "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "210"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"{", 
       RowBox[{"cperD1", ",", "campD"}], "}"}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"22.5", ",", "26.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "4.4"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "30"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Period (h)\>\"", ",", "\"\<Amplitude (fold)\>\""}], 
       "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "210"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"{", 
       RowBox[{"cperE1", ",", "campE"}], "}"}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"22.5", ",", "26.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1"}], ",", "4.4"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "30"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Period (h)\>\"", ",", "\"\<Amplitude (fold)\>\""}], 
       "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "210"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.701598183344439*^9, 3.701598218305456*^9}, {
   3.701680122452434*^9, 3.701680122945629*^9}, {3.7017149717488413`*^9, 
   3.701714971889677*^9}, {3.701715043986629*^9, 3.701715138373479*^9}, {
   3.701715170804571*^9, 3.7017152342206783`*^9}, {3.7017156500468073`*^9, 
   3.701715651363948*^9}, 3.701715988392976*^9, {3.702147571922946*^9, 
   3.702147573517741*^9}, {3.702632211616253*^9, 3.70263223909072*^9}, {
   3.702634702345036*^9, 3.702634723594227*^9}, {3.702637162739874*^9, 
   3.702637166957292*^9}, {3.702658264695724*^9, 3.702658277953466*^9}, {
   3.702663120142559*^9, 3.7026631377976303`*^9}, {3.702663309863028*^9, 
   3.702663339108664*^9}, {3.702672617911024*^9, 3.702672623821541*^9}, {
   3.7027035973904676`*^9, 3.702703602364682*^9}, {3.702703694213615*^9, 
   3.70270370075955*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{25.934133933244595`, 
        0.9999997529341353}}, {{25.896997553421077`, 0.9893628608889165}}, {{
        25.757811594296225`, 1.2125291557315505`}}, {{25.699248405601562`, 
        1.2676169341507695`}}, {{25.100899306568007`, 
        1.6426751652653717`}}, {{24.71662432775776, 1.7906057361019099`}}, {{
        24.574036160617915`, 2.0515572233572343`}}, {{24.360033215333896`, 
        2.313911402816628}}, {{24.13909889527815, 2.4490013092835943`}}, {{
        24.056998092411693`, 2.348826521511305}}, {{24.148859375882918`, 
        2.8018913174500333`}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{25.634173125459885`, 
        1.0000001936008094`}}, {{25.49312135878055, 1.0228550299460364`}}, {{
        25.391070702500226`, 1.1605894817381608`}}, {{25.104475323915825`, 
        1.3655152025077923`}}, {{25.10834192379378, 1.6184123583474352`}}, {{
        24.450253278812855`, 1.8563503097420455`}}, {{24.349204339132086`, 
        2.0060786044927843`}}, {{24.132911556235918`, 
        2.2294311576870456`}}, {{23.99877287985202, 2.500513582607847}}, {{
        23.731337323641917`, 2.7574847508419316`}}, {{23.554470632103143`, 
        2.9993023497613787`}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{25.123918187290936`, 
        0.9999993815134864}}, {{25.08794954062758, 1.0738279056018782`}}, {{
        24.81714956208734, 1.152733510559773}}, {{24.808796528897997`, 
        1.4060148812631703`}}, {{24.571140612724804`, 
        1.8145080376408678`}}, {{24.338750571406813`, 
        1.8291376024390753`}}, {{24.043338928539082`, 2.086285087615395}}, {{
        23.83359364713495, 2.3340810186773604`}}, {{23.61767658364342, 
        2.5738282368948084`}}, {{23.39471394174721, 2.808242237127147}}, {{
        23.190184655117815`, 3.0389603593828753`}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{24.98957457061989, 
        0.9999990002054989}}, {{24.909443759308658`, 1.076914740561054}}, {{
        24.7955465078924, 1.1381084154429815`}}, {{24.899153123996598`, 
        1.2963556795309388`}}, {{24.289340201412973`, 
        1.6552142854257468`}}, {{24.053506084214085`, 
        1.9393337934040011`}}, {{23.78923361496484, 2.1863882112621256`}}, {{
        23.637319052246024`, 2.421166516754357}}, {{23.38144404443317, 
        2.6499086601975486`}}, {{23.192555476020043`, 2.875160441340068}}, {{
        23.0032031721625, 3.098195312894802}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{25.673366155796863`, 
        0.9999992539203134}}, {{25.700034816496576`, 1.0931299676923745`}}, {{
        25.485442362626852`, 1.2231457120676168`}}, {{25.19061084936126, 
        1.4302578327475917`}}, {{25.044381864951987`, 
        1.4790118293502046`}}, {{24.759878408842308`, 1.869403523308161}}, {{
        24.499067836399696`, 2.1438212222812667`}}, {{24.289249641735058`, 
        2.3917421010118964`}}, {{24.05353163546929, 2.628236969782651}}, {{
        23.8185916331768, 2.8586121026678026`}}, {{23.660752626557183`, 
        3.0852948046514057`}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}},
  AspectRatio->1,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{22.5185, 0},
  BaseStyle->Directive[FontFamily -> "Helvetica", FontSize -> 16],
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox["\"Amplitude (fold)\"", TraditionalForm], None}, {
     FormBox["\"Period (h)\"", TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1.1]],
  FrameTicks->{{{{0, 
       FormBox["0", TraditionalForm], {0, 0.02}}, {1, 
       FormBox["1", TraditionalForm], {0, 0.02}}, {2, 
       FormBox["2", TraditionalForm], {0, 0.02}}, {3, 
       FormBox["3", TraditionalForm], {0, 0.02}}, {4, 
       FormBox["4", TraditionalForm], {0, 0.02}}, {5, 
       FormBox["5", TraditionalForm], {0, 0.02}}, {6, 
       FormBox["6", TraditionalForm], {0, 0.02}}, {7, 
       FormBox["7", TraditionalForm], {0, 0.02}}, {8, 
       FormBox["8", TraditionalForm], {0, 0.02}}, {9, 
       FormBox["9", TraditionalForm], {0, 0.02}}, {10, 
       FormBox["10", TraditionalForm], {0, 0.02}}}, {{0, 
       FormBox["0", TraditionalForm], {0, 0.02}}, {1, 
       FormBox["1", TraditionalForm], {0, 0.02}}, {2, 
       FormBox["2", TraditionalForm], {0, 0.02}}, {3, 
       FormBox["3", TraditionalForm], {0, 0.02}}, {4, 
       FormBox["4", TraditionalForm], {0, 0.02}}, {5, 
       FormBox["5", TraditionalForm], {0, 0.02}}, {6, 
       FormBox["6", TraditionalForm], {0, 0.02}}, {7, 
       FormBox["7", TraditionalForm], {0, 0.02}}, {8, 
       FormBox["8", TraditionalForm], {0, 0.02}}, {9, 
       FormBox["9", TraditionalForm], {0, 0.02}}, {10, 
       FormBox["10", TraditionalForm], {0, 0.02}}}}, {{{1, 
       FormBox["1", TraditionalForm], {0, 0.02}}, {2, 
       FormBox["2", TraditionalForm], {0, 0.02}}, {3, 
       FormBox["3", TraditionalForm], {0, 0.02}}, {4, 
       FormBox["4", TraditionalForm], {0, 0.02}}, {5, 
       FormBox["5", TraditionalForm], {0, 0.02}}, {6, 
       FormBox["6", TraditionalForm], {0, 0.02}}, {7, 
       FormBox["7", TraditionalForm], {0, 0.02}}, {8, 
       FormBox["8", TraditionalForm], {0, 0.02}}, {9, 
       FormBox["9", TraditionalForm], {0, 0.02}}, {10, 
       FormBox["10", TraditionalForm], {0, 0.02}}, {11, 
       FormBox["11", TraditionalForm], {0, 0.02}}, {12, 
       FormBox["12", TraditionalForm], {0, 0.02}}, {13, 
       FormBox["13", TraditionalForm], {0, 0.02}}, {14, 
       FormBox["14", TraditionalForm], {0, 0.02}}, {15, 
       FormBox["15", TraditionalForm], {0, 0.02}}, {16, 
       FormBox["16", TraditionalForm], {0, 0.02}}, {17, 
       FormBox["17", TraditionalForm], {0, 0.02}}, {18, 
       FormBox["18", TraditionalForm], {0, 0.02}}, {19, 
       FormBox["19", TraditionalForm], {0, 0.02}}, {20, 
       FormBox["20", TraditionalForm], {0, 0.02}}, {21, 
       FormBox["21", TraditionalForm], {0, 0.02}}, {22, 
       FormBox["22", TraditionalForm], {0, 0.02}}, {23, 
       FormBox["23", TraditionalForm], {0, 0.02}}, {24, 
       FormBox["24", TraditionalForm], {0, 0.02}}, {25, 
       FormBox["25", TraditionalForm], {0, 0.02}}, {26, 
       FormBox["26", TraditionalForm], {0, 0.02}}, {27, 
       FormBox["27", TraditionalForm], {0, 0.02}}, {28, 
       FormBox["28", TraditionalForm], {0, 0.02}}, {29, 
       FormBox["29", TraditionalForm], {0, 0.02}}, {30, 
       FormBox["30", TraditionalForm], {0, 0.02}}}, {{1, 
       FormBox["1", TraditionalForm], {0, 0.02}}, {2, 
       FormBox["2", TraditionalForm], {0, 0.02}}, {3, 
       FormBox["3", TraditionalForm], {0, 0.02}}, {4, 
       FormBox["4", TraditionalForm], {0, 0.02}}, {5, 
       FormBox["5", TraditionalForm], {0, 0.02}}, {6, 
       FormBox["6", TraditionalForm], {0, 0.02}}, {7, 
       FormBox["7", TraditionalForm], {0, 0.02}}, {8, 
       FormBox["8", TraditionalForm], {0, 0.02}}, {9, 
       FormBox["9", TraditionalForm], {0, 0.02}}, {10, 
       FormBox["10", TraditionalForm], {0, 0.02}}, {11, 
       FormBox["11", TraditionalForm], {0, 0.02}}, {12, 
       FormBox["12", TraditionalForm], {0, 0.02}}, {13, 
       FormBox["13", TraditionalForm], {0, 0.02}}, {14, 
       FormBox["14", TraditionalForm], {0, 0.02}}, {15, 
       FormBox["15", TraditionalForm], {0, 0.02}}, {16, 
       FormBox["16", TraditionalForm], {0, 0.02}}, {17, 
       FormBox["17", TraditionalForm], {0, 0.02}}, {18, 
       FormBox["18", TraditionalForm], {0, 0.02}}, {19, 
       FormBox["19", TraditionalForm], {0, 0.02}}, {20, 
       FormBox["20", TraditionalForm], {0, 0.02}}, {21, 
       FormBox["21", TraditionalForm], {0, 0.02}}, {22, 
       FormBox["22", TraditionalForm], {0, 0.02}}, {23, 
       FormBox["23", TraditionalForm], {0, 0.02}}, {24, 
       FormBox["24", TraditionalForm], {0, 0.02}}, {25, 
       FormBox["25", TraditionalForm], {0, 0.02}}, {26, 
       FormBox["26", TraditionalForm], {0, 0.02}}, {27, 
       FormBox["27", TraditionalForm], {0, 0.02}}, {28, 
       FormBox["28", TraditionalForm], {0, 0.02}}, {29, 
       FormBox["29", TraditionalForm], {0, 0.02}}, {30, 
       FormBox["30", TraditionalForm], {0, 0.02}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->210,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{22.5, 26.2}, {-0.1, 4.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.701598198654825*^9, 3.701598219028646*^9}, {
   3.70159862457205*^9, 3.7015986362551107`*^9}, 3.701598772051162*^9, 
   3.70159901321329*^9, 3.701599129715362*^9, 3.701601215740918*^9, 
   3.701601280171681*^9, 3.701601337432803*^9, 3.701630246786162*^9, 
   3.701631103179339*^9, 3.701634170491481*^9, 3.701634834070073*^9, 
   3.701634933924498*^9, 3.701635026833967*^9, 3.701635193122493*^9, 
   3.7016359003754683`*^9, 3.7016359972081327`*^9, 3.701636106231103*^9, 
   3.701636229909639*^9, 3.701636347098043*^9, 3.701636414447776*^9, 
   3.701678839540894*^9, 3.701680123705634*^9, {3.7017149597612886`*^9, 
   3.7017149745988407`*^9}, {3.701715056024892*^9, 3.701715138674667*^9}, {
   3.701715173988756*^9, 3.701715234591758*^9}, 3.701715301591103*^9, 
   3.7017155963065243`*^9, 3.701715651895216*^9, 3.701715715991166*^9, 
   3.701715988799943*^9, 3.701783445533381*^9, 3.7018618622451963`*^9, 
   3.701862839994713*^9, 3.7018634184358273`*^9, 3.7021466760056753`*^9, 
   3.7021468666379843`*^9, 3.702147574172955*^9, 3.70214770574308*^9, 
   3.702148433196857*^9, 3.7021513461300373`*^9, 3.702622986695813*^9, 
   3.702623091472603*^9, 3.702623227175568*^9, 3.70262335527631*^9, 
   3.702623484935384*^9, 3.702624722761499*^9, 3.702625876726284*^9, 
   3.702626061382327*^9, 3.70262629074819*^9, 3.702626902375991*^9, 
   3.7026270712150908`*^9, 3.702627272438263*^9, 3.7026276111989813`*^9, 
   3.702627996045134*^9, 3.7026281860031443`*^9, 3.7026286950206013`*^9, 
   3.702628927604341*^9, 3.7026290742269793`*^9, 3.702629905934276*^9, 
   3.702630348108786*^9, 3.702630668070058*^9, 3.70263251963441*^9, 
   3.702632899587659*^9, 3.702633703268902*^9, 3.702634318919118*^9, 
   3.702634626296267*^9, {3.702634704626996*^9, 3.702634724069661*^9}, 
   3.702634944737441*^9, 3.702636423742901*^9, 3.702636759727059*^9, 
   3.70263716760893*^9, 3.702637957227396*^9, 3.702638311527746*^9, 
   3.702638728607399*^9, 3.702640065529973*^9, 3.7026402211026287`*^9, 
   3.70264043228351*^9, 3.702640669817706*^9, 3.702658269178607*^9, 
   3.702658433919072*^9, 3.702663125556407*^9, 3.702663278756997*^9, 
   3.7026633232864723`*^9, 3.7026642830482283`*^9, 3.7026644823027782`*^9, 
   3.702666422280792*^9, 3.702667636802185*^9, 3.7026707811273746`*^9, 
   3.702670958214251*^9, 3.7026713092333527`*^9, 3.7026715880446672`*^9, 
   3.702672923342311*^9, 3.70267318130229*^9, 3.702702886756742*^9, 
   3.702703270271646*^9, {3.7027035984460773`*^9, 3.7027036030814657`*^9}, 
   3.702703796412774*^9, 3.702704157647937*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Kuramoto", " ", "Synchronization", " ", "Index"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.727327103723521*^9, 
  3.727327109854207*^9}},ExpressionUUID->"f135cac4-2fa1-4b60-a19b-\
30b85f71fe01"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"siA", "[", "q", "]"}], "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "/", "7"}], ")"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi1", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi2", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi3", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi4", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi5", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi6", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi7", "[", "t", "]"}]}], "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"Exp", "[", 
              RowBox[{"I", "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"phi1", "[", "t", "]"}], "+", 
                  RowBox[{"phi2", "[", "t", "]"}], "+", 
                  RowBox[{"phi3", "[", "t", "]"}], "+", 
                  RowBox[{"phi4", "[", "t", "]"}], "+", 
                  RowBox[{"phi5", "[", "t", "]"}], "+", 
                  RowBox[{"phi6", "[", "t", "]"}], "+", 
                  RowBox[{"phi7", "[", "t", "]"}]}], ")"}], "/", "7"}]}], 
              "]"}], ")"}]}]}], "]"}], "/.", 
         RowBox[{"nsol1", "[", "q", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.702629197392215*^9, 3.7026292357574863`*^9}, {
  3.702629418273575*^9, 3.702629658422914*^9}, {3.702630700351522*^9, 
  3.702630724366837*^9}, {3.7026322709013653`*^9, 3.702632273134658*^9}, {
  3.702637475894287*^9, 3.7026374765569973`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"siB", "[", "q", "]"}], "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "/", "7"}], ")"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi1", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi2", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi3", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi4", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi5", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi6", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi7", "[", "t", "]"}]}], "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"Exp", "[", 
              RowBox[{"I", "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"phi1", "[", "t", "]"}], "+", 
                  RowBox[{"phi2", "[", "t", "]"}], "+", 
                  RowBox[{"phi3", "[", "t", "]"}], "+", 
                  RowBox[{"phi4", "[", "t", "]"}], "+", 
                  RowBox[{"phi5", "[", "t", "]"}], "+", 
                  RowBox[{"phi6", "[", "t", "]"}], "+", 
                  RowBox[{"phi7", "[", "t", "]"}]}], ")"}], "/", "7"}]}], 
              "]"}], ")"}]}]}], "]"}], "/.", 
         RowBox[{"nsol2", "[", "q", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.702629197392215*^9, 3.7026292357574863`*^9}, {
   3.702629418273575*^9, 3.702629658422914*^9}, {3.702630700351522*^9, 
   3.702630724366837*^9}, {3.7026322709013653`*^9, 3.702632273134658*^9}, {
   3.702632337180369*^9, 3.7026323437165003`*^9}, 3.702637482844678*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"siC", "[", "q", "]"}], "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "/", "7"}], ")"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi1", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi2", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi3", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi4", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi5", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi6", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi7", "[", "t", "]"}]}], "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"Exp", "[", 
              RowBox[{"I", "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"phi1", "[", "t", "]"}], "+", 
                  RowBox[{"phi2", "[", "t", "]"}], "+", 
                  RowBox[{"phi3", "[", "t", "]"}], "+", 
                  RowBox[{"phi4", "[", "t", "]"}], "+", 
                  RowBox[{"phi5", "[", "t", "]"}], "+", 
                  RowBox[{"phi6", "[", "t", "]"}], "+", 
                  RowBox[{"phi7", "[", "t", "]"}]}], ")"}], "/", "7"}]}], 
              "]"}], ")"}]}]}], "]"}], "/.", 
         RowBox[{"nsol3", "[", "q", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.702629197392215*^9, 3.7026292357574863`*^9}, {
   3.702629418273575*^9, 3.702629658422914*^9}, {3.702630700351522*^9, 
   3.702630724366837*^9}, {3.7026322709013653`*^9, 3.702632273134658*^9}, {
   3.702632339511629*^9, 3.7026323451903954`*^9}, 3.702637485950718*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"siD", "[", "q", "]"}], "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "/", "7"}], ")"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi1", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi2", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi3", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi4", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi5", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi6", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi7", "[", "t", "]"}]}], "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"Exp", "[", 
              RowBox[{"I", "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"phi1", "[", "t", "]"}], "+", 
                  RowBox[{"phi2", "[", "t", "]"}], "+", 
                  RowBox[{"phi3", "[", "t", "]"}], "+", 
                  RowBox[{"phi4", "[", "t", "]"}], "+", 
                  RowBox[{"phi5", "[", "t", "]"}], "+", 
                  RowBox[{"phi6", "[", "t", "]"}], "+", 
                  RowBox[{"phi7", "[", "t", "]"}]}], ")"}], "/", "7"}]}], 
              "]"}], ")"}]}]}], "]"}], "/.", 
         RowBox[{"nsol4", "[", "q", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.702629197392215*^9, 3.7026292357574863`*^9}, {
   3.702629418273575*^9, 3.702629658422914*^9}, {3.702630700351522*^9, 
   3.702630724366837*^9}, {3.7026322709013653`*^9, 3.702632273134658*^9}, {
   3.70263234152346*^9, 3.702632347921441*^9}, 3.7026374886407146`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"siE", "[", "q", "]"}], "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "/", "7"}], ")"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi1", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi2", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi3", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi4", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi5", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi6", "[", "t", "]"}]}], "]"}], "+", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", "*", 
                RowBox[{"phi7", "[", "t", "]"}]}], "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"Exp", "[", 
              RowBox[{"I", "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"phi1", "[", "t", "]"}], "+", 
                  RowBox[{"phi2", "[", "t", "]"}], "+", 
                  RowBox[{"phi3", "[", "t", "]"}], "+", 
                  RowBox[{"phi4", "[", "t", "]"}], "+", 
                  RowBox[{"phi5", "[", "t", "]"}], "+", 
                  RowBox[{"phi6", "[", "t", "]"}], "+", 
                  RowBox[{"phi7", "[", "t", "]"}]}], ")"}], "/", "7"}]}], 
              "]"}], ")"}]}]}], "]"}], "/.", 
         RowBox[{"nsol5", "[", "q", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"24", "*", "60"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
      "Flatten"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.702629197392215*^9, 3.7026292357574863`*^9}, {
   3.702629418273575*^9, 3.702629658422914*^9}, {3.702630700351522*^9, 
   3.702630724366837*^9}, {3.7026322709013653`*^9, 3.702632273134658*^9}, {
   3.70263234152346*^9, 3.702632347921441*^9}, 3.7026374886407146`*^9, {
   3.702672655984973*^9, 3.702672661918002*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"meanSiA", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mean", "[", 
      RowBox[{
       RowBox[{"siA", "[", "q", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"4", "*", "24", "*", "25"}], ";;", 
         RowBox[{"4", "*", "24", "*", "29"}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"meanSiB", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mean", "[", 
      RowBox[{
       RowBox[{"siB", "[", "q", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"4", "*", "24", "*", "25"}], ";;", 
         RowBox[{"4", "*", "24", "*", "29"}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"meanSiC", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mean", "[", 
      RowBox[{
       RowBox[{"siC", "[", "q", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"4", "*", "24", "*", "25"}], ";;", 
         RowBox[{"4", "*", "24", "*", "29"}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"meanSiD", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mean", "[", 
      RowBox[{
       RowBox[{"siD", "[", "q", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"4", "*", "24", "*", "25"}], ";;", 
         RowBox[{"4", "*", "24", "*", "29"}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"meanSiE", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mean", "[", 
      RowBox[{
       RowBox[{"siE", "[", "q", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"4", "*", "24", "*", "25"}], ";;", 
         RowBox[{"4", "*", "24", "*", "29"}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7026372161844788`*^9, 3.702637298355267*^9}, {
  3.702637500555765*^9, 3.702637509186544*^9}, {3.702637585148017*^9, 
  3.70263758923127*^9}, {3.7026376943813543`*^9, 3.7026376963182707`*^9}, {
  3.7026726682811317`*^9, 3.702672672548568*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"meanSiA", ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.01"}], ",", "1.01"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OddQ", "[", "n", "]"}], ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}], "*", "0.05"}], ",", 
              "\"\<\>\""}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "1", ",", "0.2"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling strength\>\"", ",", "\"\<Synchronization Index\>\""}], 
       "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"meanSiB", ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.01"}], ",", "1.01"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OddQ", "[", "n", "]"}], ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}], "*", "0.05"}], ",", 
              "\"\<\>\""}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "1", ",", "0.2"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling strength\>\"", ",", "\"\<Synchronization Index\>\""}], 
       "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"meanSiC", ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.01"}], ",", "1.01"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OddQ", "[", "n", "]"}], ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}], "*", "0.05"}], ",", 
              "\"\<\>\""}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "1", ",", "0.2"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling strength\>\"", ",", "\"\<Synchronization Index\>\""}], 
       "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"meanSiD", ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.01"}], ",", "1.01"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OddQ", "[", "n", "]"}], ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}], "*", "0.05"}], ",", 
              "\"\<\>\""}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "1", ",", "0.2"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling strength\>\"", ",", "\"\<Synchronization Index\>\""}], 
       "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"meanSiE", ",", 
     RowBox[{"Joined", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "11.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.01"}], ",", "1.01"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OddQ", "[", "n", "]"}], ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}], "*", "0.05"}], ",", 
              "\"\<\>\""}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"n", ",", "n", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "1", ",", "0.2"}], "}"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Coupling strength\>\"", ",", "\"\<Synchronization Index\>\""}], 
       "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"0.5", ",", "Black"}], "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.701597975621438*^9, 3.7015979840304613`*^9}, {
  3.701598020735353*^9, 3.701598020845694*^9}, {3.701598147352112*^9, 
  3.701598157622013*^9}, {3.701598632433548*^9, 3.701598632575182*^9}, {
  3.701634652918655*^9, 3.7016346532672567`*^9}, {3.701636357758299*^9, 
  3.701636358507728*^9}, {3.701684657274918*^9, 3.701684809603364*^9}, {
  3.701684862609663*^9, 3.701684893156453*^9}, {3.701710936703603*^9, 
  3.701710988807321*^9}, {3.701715931538478*^9, 3.701715931602316*^9}, {
  3.702630649775896*^9, 3.7026306545808907`*^9}, {3.7026309325694103`*^9, 
  3.702630933503653*^9}, {3.7026318284390097`*^9, 3.702631865062469*^9}, {
  3.702637040027907*^9, 3.702637076186941*^9}, {3.702637345039604*^9, 
  3.702637419268436*^9}, {3.702637567963779*^9, 3.702637578351318*^9}, {
  3.702637613631013*^9, 3.702637679441678*^9}, {3.702672680048738*^9, 
  3.7026726926008263`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.25512082386465207`}}, {{2., 
        0.24534331127350317`}}, {{3., 0.27735873088736884`}}, {{4., 
        0.6538648670424655}}, {{5., 0.7967394616912221}}, {{6., 
        0.8050626778374765}}, {{7., 0.8583833064175395}}, {{8., 
        0.8847835278927848}}, {{9., 0.38526060379983335`}}, {{10., 
        0.22256038458857505`}}, {{11., 0.6442015625774429}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.5746647713730251}}, {{2., 
        0.19209847472743474`}}, {{3., 0.3308095225463148}}, {{4., 
        0.6839780544732572}}, {{5., 0.7866762849180413}}, {{6., 
        0.8123334476913876}}, {{7., 0.7314679862222205}}, {{8., 
        0.7158127259533841}}, {{9., 0.7735265797073178}}, {{10., 
        0.8315542758797613}}, {{11., 0.8700753807362488}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.3589614282353784}}, {{2., 
        0.35660878058837736`}}, {{3., 0.3790878250138826}}, {{4., 
        0.3371546148757776}}, {{5., 0.9532376392266438}}, {{6., 
        0.4151259459342742}}, {{7., 0.5190116888974264}}, {{8., 
        0.6171414306589804}}, {{9., 0.6925184528652534}}, {{10., 
        0.7492704515263582}}, {{11., 0.7923360085319938}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.36427473266092325`}}, {{2., 
        0.5653371580368635}}, {{3., 0.2137225342560761}}, {{4., 
        0.24365188214646638`}}, {{5., 0.66589462415018}}, {{6., 
        0.8204970722544804}}, {{7., 0.885685077527056}}, {{8., 
        0.9203395558810287}}, {{9., 0.9409190188440618}}, {{10., 
        0.9540641604386484}}, {{11., 0.9629237909464202}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], Opacity[
      0.5], 
      StyleBox[GeometricTransformationBox[InsetBox[
         StyleBox["\<\"\[FilledCircle]\"\>",
          StripOnInput->False,
          FontSize->8.96], {0., 0.}], {{{1., 0.35084642973221325`}}, {{2., 
        0.5623034188078463}}, {{3., 0.5311603894436558}}, {{4., 
        0.5804103842222675}}, {{5., 0.10882814145418884`}}, {{6., 
        0.6163542849368642}}, {{7., 0.7720516888549678}}, {{8., 
        0.8475010983183571}}, {{9., 0.8900166050142398}}, {{10., 
        0.9163298474855524}}, {{11., 0.9337365493601069}}}],
       FontFamily->"Helvetica",
       FontSize->16]}, {}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0.555, 0},
  BaseStyle->Directive[FontFamily -> "Helvetica", FontSize -> 16],
  DisplayFunction->Identity,
  Frame->{{True, False}, {True, False}},
  FrameLabel->{{
     FormBox["\"Synchronization Index\"", TraditionalForm], None}, {
     FormBox["\"Coupling strength\"", TraditionalForm], None}},
  FrameStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1.1]],
  FrameTicks->{{{{0., 
       FormBox["0.`", TraditionalForm], {0, 0.02}}, {0.2, 
       FormBox["0.2`", TraditionalForm], {0, 0.02}}, {0.4, 
       FormBox["0.4`", TraditionalForm], {0, 0.02}}, {0.6000000000000001, 
       FormBox["0.6000000000000001`", TraditionalForm], {0, 0.02}}, {0.8, 
       FormBox["0.8`", TraditionalForm], {0, 0.02}}, {1., 
       FormBox["1.`", TraditionalForm], {0, 0.02}}}, {{0., 
       FormBox["0.`", TraditionalForm], {0, 0.02}}, {0.2, 
       FormBox["0.2`", TraditionalForm], {0, 0.02}}, {0.4, 
       FormBox["0.4`", TraditionalForm], {0, 0.02}}, {0.6000000000000001, 
       FormBox["0.6000000000000001`", TraditionalForm], {0, 0.02}}, {0.8, 
       FormBox["0.8`", TraditionalForm], {0, 0.02}}, {1., 
       FormBox["1.`", TraditionalForm], {0, 0.02}}}}, {{{1, 
       FormBox["0.`", TraditionalForm], {0, 0.02}}, {2, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {3, 
       FormBox["0.1`", TraditionalForm], {0, 0.02}}, {4, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {5, 
       FormBox["0.2`", TraditionalForm], {0, 0.02}}, {6, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {7, 
       FormBox["0.30000000000000004`", TraditionalForm], {0, 0.02}}, {8, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {9, 
       FormBox["0.4`", TraditionalForm], {0, 0.02}}, {10, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {11, 
       FormBox["0.5`", TraditionalForm], {0, 0.02}}, {12, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {13, 
       FormBox["0.6000000000000001`", TraditionalForm], {0, 0.02}}, {14, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {15, 
       FormBox["0.7000000000000001`", TraditionalForm], {0, 0.02}}, {16, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {17, 
       FormBox["0.8`", TraditionalForm], {0, 0.02}}, {18, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {19, 
       FormBox["0.9`", TraditionalForm], {0, 0.02}}, {20, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}}, {{1, 
       FormBox["0.`", TraditionalForm], {0, 0.02}}, {2, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {3, 
       FormBox["0.1`", TraditionalForm], {0, 0.02}}, {4, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {5, 
       FormBox["0.2`", TraditionalForm], {0, 0.02}}, {6, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {7, 
       FormBox["0.30000000000000004`", TraditionalForm], {0, 0.02}}, {8, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {9, 
       FormBox["0.4`", TraditionalForm], {0, 0.02}}, {10, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {11, 
       FormBox["0.5`", TraditionalForm], {0, 0.02}}, {12, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {13, 
       FormBox["0.6000000000000001`", TraditionalForm], {0, 0.02}}, {14, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {15, 
       FormBox["0.7000000000000001`", TraditionalForm], {0, 0.02}}, {16, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {17, 
       FormBox["0.8`", TraditionalForm], {0, 0.02}}, {18, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}, {19, 
       FormBox["0.9`", TraditionalForm], {0, 0.02}}, {20, 
       FormBox["\"\"", TraditionalForm], {0, 0.02}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.5, 11.5}, {-0.01, 1.01}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.702637419684155*^9, {3.702637520853108*^9, 3.702637524938355*^9}, {
   3.702637569856227*^9, 3.702637598775614*^9}, {3.7026376312912703`*^9, 
   3.702637697861083*^9}, 3.702637996742406*^9, 3.702638349651021*^9, 
   3.70263876660238*^9, 3.7026402588414707`*^9, 3.7026404822453547`*^9, 
   3.702640707921495*^9, 3.7026584725356216`*^9, 3.702663318433896*^9, 
   3.702664324781546*^9, 3.702664519903028*^9, 3.702666462477689*^9, 
   3.702667677339478*^9, 3.70267082199942*^9, 3.702670997897242*^9, 
   3.702671350133573*^9, 3.702671625251004*^9, 3.702672977151552*^9, 
   3.702673232447515*^9, 3.702702937769188*^9, 3.70270331805127*^9, 
   3.7027038495129004`*^9, 3.702704207127495*^9}]
}, Open  ]]
},
WindowSize->{1366, 600},
WindowMargins->{{Automatic, 32}, {Automatic, 0}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 21, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1375, 32, 222, "Input", "ExpressionUUID" -> \
"ed107204-e754-43c2-b95d-2e659720d2f7"],
Cell[1936, 54, 573, 14, 54, "Input", "ExpressionUUID" -> \
"db001ea4-3807-4c4a-8381-1049b979bfd0"],
Cell[2512, 70, 1156, 28, 75, "Input", "ExpressionUUID" -> \
"d5bcdbbf-dec5-4380-9550-08e1d28f80b7"],
Cell[3671, 100, 730, 17, 54, "Input", "ExpressionUUID" -> \
"c15e38f8-d68e-4c5c-ae23-adaf74cbfbeb"],
Cell[4404, 119, 341, 8, 32, "Input", "ExpressionUUID" -> \
"c2e21d84-a06f-4af5-970a-9adb5175834d"],
Cell[4748, 129, 1245, 27, 75, "Input", "ExpressionUUID" -> \
"ea794ded-181d-4323-a0cb-0e238e330180"],
Cell[5996, 158, 293, 7, 32, "Input", "ExpressionUUID" -> \
"2af6f99b-b914-4bcf-9353-712fa020f89d"],
Cell[CellGroupData[{
Cell[6314, 169, 894, 20, 32, "Input", "ExpressionUUID" -> \
"2e6a3634-3a34-49ad-afef-dad2f78c199b"],
Cell[7211, 191, 1329, 23, 32, "Output", "ExpressionUUID" -> \
"114f4469-80da-4df8-861a-d51f96de633e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8577, 219, 639, 15, 32, "Input", "ExpressionUUID" -> \
"7aa82007-fa57-47e5-802b-6c52be603e7e"],
Cell[9219, 236, 1469, 26, 32, "Output", "ExpressionUUID" -> \
"0ab6591d-4ea9-4cc6-8c41-d89336af77b2"]
}, Open  ]],
Cell[10703, 265, 248, 6, 32, "Input", "ExpressionUUID" -> \
"3cdf83fd-a99e-4fed-97df-5670b88aba59"],
Cell[10954, 273, 3640, 64, 75, "Input", "ExpressionUUID" -> \
"65d33015-6847-4c09-8013-1098c699d8f2"],
Cell[14597, 339, 2012, 70, 159, "Input", "ExpressionUUID" -> \
"6810e891-648d-4b8a-9fd4-4e1c390ee6f4"],
Cell[16612, 411, 1643, 50, 159, "Input", "ExpressionUUID" -> \
"c0ca1dbd-f102-4aef-9c47-7dd713bb7e95"],
Cell[18258, 463, 2369, 73, 159, "Input", "ExpressionUUID" -> \
"f3338c43-e354-4361-92c2-f4024adf6e6c"],
Cell[20630, 538, 219, 5, 32, "Input", "ExpressionUUID" -> \
"051b3946-a49a-4681-bede-4133431e7496"],
Cell[20852, 545, 24299, 598, 894, "Input", "ExpressionUUID" -> \
"df0bcbf6-d4bf-4232-b63b-ccca4b3ac1ba"],
Cell[45154, 1145, 272, 7, 32, "Input", "ExpressionUUID" -> \
"d936d38a-8ed5-4e78-993d-9d40454d3624"],
Cell[CellGroupData[{
Cell[45451, 1156, 833, 18, 32, "Input", "ExpressionUUID" -> \
"ee105b80-d4e9-4626-8774-2afd7fa4817c"],
Cell[46287, 1176, 1243, 21, 32, "Output", "ExpressionUUID" -> \
"faabc15c-def5-4355-96d4-b06e012be7f3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47567, 1202, 579, 13, 32, "Input", "ExpressionUUID" -> \
"a2c78963-cd82-4c94-bf03-53ba1ca31f05"],
Cell[48149, 1217, 1384, 24, 32, "Output", "ExpressionUUID" -> \
"4d70c9f7-26fe-4f4f-9bb6-96a9bb438dc2"]
}, Open  ]],
Cell[49548, 1244, 24322, 598, 894, "Input", "ExpressionUUID" -> \
"10a5c105-2a82-45a3-9116-d1eb8416a957"],
Cell[CellGroupData[{
Cell[73895, 1846, 833, 18, 32, "Input", "ExpressionUUID" -> \
"b75fd5a8-cddd-469c-a74f-84d7f1f8f6ed"],
Cell[74731, 1866, 1243, 21, 32, "Output", "ExpressionUUID" -> \
"7190f6e0-19f6-43f6-a175-f61465e18a69"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76011, 1892, 579, 13, 32, "Input", "ExpressionUUID" -> \
"2c6c0b0e-afca-431c-be4f-0b5b6cc1db74"],
Cell[76593, 1907, 1356, 23, 32, "Output", "ExpressionUUID" -> \
"e666c488-8c1a-4c9d-8aef-5df32cdafb03"]
}, Open  ]],
Cell[77964, 1933, 24323, 598, 894, "Input", "ExpressionUUID" -> \
"9b887347-95b1-4b5d-b609-445326ac3dbc"],
Cell[CellGroupData[{
Cell[102312, 2535, 833, 18, 32, "Input", "ExpressionUUID" -> \
"d92b505a-edca-49e0-b1c5-ccdf07587517"],
Cell[103148, 2555, 1247, 21, 32, "Output", "ExpressionUUID" -> \
"d7f184fb-383b-4ab8-9b25-cea47cc41edf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104432, 2581, 579, 13, 32, "Input", "ExpressionUUID" -> \
"99ba0bbc-3121-485e-8262-3e284557e2ba"],
Cell[105014, 2596, 1376, 24, 32, "Output", "ExpressionUUID" -> \
"1b8ea114-c48a-433f-9745-0ccbb086039f"]
}, Open  ]],
Cell[106405, 2623, 24349, 599, 894, "Input", "ExpressionUUID" -> \
"8fabd9a7-6735-4d0a-a162-1fe72512e59f"],
Cell[CellGroupData[{
Cell[130779, 3226, 833, 18, 32, "Input", "ExpressionUUID" -> \
"7e514cd1-82ee-4ae3-b7f7-b196999c56c2"],
Cell[131615, 3246, 1242, 21, 32, "Output", "ExpressionUUID" -> \
"fcfbd62b-6f95-43da-a00f-18b211952fc5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132894, 3272, 579, 13, 32, "Input", "ExpressionUUID" -> \
"35ec11ac-f706-4adf-95f4-32621ac0b506"],
Cell[133476, 3287, 1370, 23, 32, "Output", "ExpressionUUID" -> \
"fcb21efb-f145-43b3-897f-d53638b02f6e"]
}, Open  ]],
Cell[134861, 3313, 24458, 601, 894, "Input", "ExpressionUUID" -> \
"03b0def1-4975-42d5-b917-3af65aa05e85"],
Cell[159322, 3916, 239, 5, 32, "Input", "ExpressionUUID" -> \
"c361900c-ee46-42bd-959d-8d234df67be1"],
Cell[159564, 3923, 4692, 144, 159, "Input", "ExpressionUUID" -> \
"812aa1b0-355d-481a-8def-27ac3ec3bc21"],
Cell[164259, 4069, 4692, 144, 159, "Input", "ExpressionUUID" -> \
"f3550232-2581-4255-94be-e7bbce7d927e"],
Cell[168954, 4215, 4692, 144, 159, "Input", "ExpressionUUID" -> \
"3e66e4df-c51f-4394-8427-afe0b6ca9f1f"],
Cell[173649, 4361, 4692, 144, 159, "Input", "ExpressionUUID" -> \
"c0ac5671-99d2-4210-b877-f828bcf58947"],
Cell[178344, 4507, 4743, 145, 159, "Input", "ExpressionUUID" -> \
"8906facb-b2cb-4013-9d7a-f37f05f861b3"],
Cell[183090, 4654, 215, 4, 32, "Input", "ExpressionUUID" -> \
"a93da747-18af-4d87-9866-df363185e63f"],
Cell[CellGroupData[{
Cell[183330, 4662, 3320, 97, 180, "Input", "ExpressionUUID" -> \
"f4d58ff7-67e4-4091-a7ef-051edd612c29"],
Cell[186653, 4761, 3441, 69, 159, "Output", "ExpressionUUID" -> \
"ccee4f4b-5bf8-4975-8586-55838471bf33"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190131, 4835, 3275, 97, 180, "Input", "ExpressionUUID" -> \
"91c54edd-85a9-4bf3-b77d-1eb6167a8387"],
Cell[193409, 4934, 3441, 69, 159, "Output", "ExpressionUUID" -> \
"7efeb097-d843-4b69-9e5f-94d793eb4614"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196887, 5008, 3273, 97, 180, "Input", "ExpressionUUID" -> \
"90f479c5-9123-4bff-ae0a-b5ea8890e831"],
Cell[200163, 5107, 3443, 69, 159, "Output", "ExpressionUUID" -> \
"81fa7d09-12cc-4042-8fd8-318cb4dc2235"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203643, 5181, 3275, 97, 180, "Input", "ExpressionUUID" -> \
"d30e56c7-9f77-4104-bbea-2465ca74b039"],
Cell[206921, 5280, 3444, 69, 159, "Output", "ExpressionUUID" -> \
"f9e54f42-6d58-409f-b220-82feeb2d9bf6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210402, 5354, 3323, 97, 180, "Input", "ExpressionUUID" -> \
"de21ab6c-ab06-4fe3-9712-1b79981df094"],
Cell[213728, 5453, 2856, 61, 159, "Output", "ExpressionUUID" -> \
"e1e28974-feba-4032-a6fb-bc2b1457492e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[216621, 5519, 8482, 220, 201, "Input", "ExpressionUUID" -> \
"8c2a4b40-c789-4cc5-9a19-4c7f82768a19"],
Cell[225106, 5741, 3233, 68, 159, "Output", "ExpressionUUID" -> \
"dcbb4725-91b1-429c-9d0e-c215900bec42"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228376, 5814, 8579, 221, 201, "Input", "ExpressionUUID" -> \
"3c1dd975-e8e4-408e-b897-b0de4c1432e2"],
Cell[236958, 6037, 3404, 67, 159, "Output", "ExpressionUUID" -> \
"2c478283-250d-4707-b681-58077b5e4f1c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[240399, 6109, 8604, 221, 201, "Input", "ExpressionUUID" -> \
"6fee78b2-fa66-4206-8180-d41bc1b6b2dd"],
Cell[249006, 6332, 3438, 69, 159, "Output", "ExpressionUUID" -> \
"487dd675-9078-42bd-aa7c-47cea72b8cff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[252481, 6406, 8605, 221, 201, "Input", "ExpressionUUID" -> \
"809f216f-ded7-4fc6-b728-48e72956bfa6"],
Cell[261089, 6629, 3420, 68, 159, "Output", "ExpressionUUID" -> \
"01f6a232-63c6-42bb-ab45-b5168944f9d4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[264546, 6702, 8659, 222, 201, "Input", "ExpressionUUID" -> \
"f5a0dd53-6aff-46d1-b95c-f9f0aa4d262b"],
Cell[273208, 6926, 2864, 61, 159, "Output", "ExpressionUUID" -> \
"f591c0f6-164f-4ae1-b32e-2e3297f62c66"]
}, Open  ]],
Cell[CellGroupData[{
Cell[276109, 6992, 9038, 234, 201, "Input", "ExpressionUUID" -> \
"49234aca-5a71-4235-b1c3-17227816a24e"],
Cell[285150, 7228, 3223, 69, 159, "Output", "ExpressionUUID" -> \
"10e42aae-2997-4a7e-b51b-0d2348614f76"]
}, Open  ]],
Cell[CellGroupData[{
Cell[288410, 7302, 9036, 234, 201, "Input", "ExpressionUUID" -> \
"afc0a85a-8325-4b66-9292-cac210f8da30"],
Cell[297449, 7538, 3372, 65, 159, "Output", "ExpressionUUID" -> \
"986c6481-d353-4cdd-8426-400c2b7fc6b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[300858, 7608, 9080, 234, 201, "Input", "ExpressionUUID" -> \
"9002d367-bfe7-410d-9bf0-51cf35a35d1f"],
Cell[309941, 7844, 3405, 67, 159, "Output", "ExpressionUUID" -> \
"4b332898-7d33-4a34-b508-65f2597f11b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[313383, 7916, 9081, 234, 201, "Input", "ExpressionUUID" -> \
"1a027663-b793-4791-ad7e-b39b59ad6a45"],
Cell[322467, 8152, 3418, 68, 159, "Output", "ExpressionUUID" -> \
"6adc84ff-509e-441e-bedd-254f99a48209"]
}, Open  ]],
Cell[CellGroupData[{
Cell[325922, 8225, 9131, 235, 201, "Input", "ExpressionUUID" -> \
"40debb76-cc3a-441c-a73f-0a0cb171c4f6"],
Cell[335056, 8462, 2847, 61, 159, "Output", "ExpressionUUID" -> \
"06110c3e-f9b2-430b-811e-4f1d488921a1"]
}, Open  ]],
Cell[337918, 8526, 244, 5, 32, "Input", "ExpressionUUID" -> \
"4a95acdf-6b07-4144-9df8-94817cf5e816"],
Cell[338165, 8533, 239, 5, 32, "Input", "ExpressionUUID" -> \
"62441b0a-9107-4b00-8ec9-b0941122cc62"],
Cell[CellGroupData[{
Cell[338429, 8542, 10982, 308, 432, "Input", "ExpressionUUID" -> \
"559c8a7f-c54c-48db-b338-0b94b10035b6"],
Cell[349414, 8852, 15877, 270, 222, "Output", "ExpressionUUID" -> \
"3b063fb9-87ae-4016-b644-c7239773adf4"]
}, Open  ]],
Cell[365306, 9125, 234, 5, 32, "Input", "ExpressionUUID" -> \
"ffb18624-f99c-42f9-ba50-35f301b45ad6"],
Cell[CellGroupData[{
Cell[365565, 9134, 11950, 318, 432, "Input", "ExpressionUUID" -> \
"4522c9e6-8f56-4092-b8a5-273773d0db8f"],
Cell[377518, 9454, 10425, 188, 223, "Output", "ExpressionUUID" -> \
"3896ac98-9759-4394-b9c6-2e670151e70c"]
}, Open  ]],
Cell[387958, 9645, 304, 7, 32, "Input", "ExpressionUUID" -> \
"8ea64b1a-67f9-4232-b753-ba2d33027c7a"],
Cell[CellGroupData[{
Cell[388287, 9656, 9101, 238, 348, "Input", "ExpressionUUID" -> \
"04b94251-ddc2-4a07-8bf3-6a4a38f9f42d"],
Cell[397391, 9896, 12940, 231, 232, "Output", "ExpressionUUID" -> \
"8bd0322e-3eaf-4c9d-9bd7-7915b1060161"]
}, Open  ]],
Cell[410346, 10130, 248, 6, 32, "Input", "ExpressionUUID" -> \
"f135cac4-2fa1-4b60-a19b-30b85f71fe01"],
Cell[410597, 10138, 2530, 62, 117, "Input", "ExpressionUUID" -> \
"a2555a08-a90e-4dd7-8ff6-8c271015ba78"],
Cell[413130, 10202, 2555, 62, 117, "Input", "ExpressionUUID" -> \
"4644918f-db76-4e5d-9bd8-1c523b345ded"],
Cell[415688, 10266, 2555, 62, 117, "Input", "ExpressionUUID" -> \
"db1b04eb-b9d8-4167-ab4d-338d9b81d075"],
Cell[418246, 10330, 2554, 62, 117, "Input", "ExpressionUUID" -> \
"19ce3adc-75b1-4ade-8368-360fc9fb3896"],
Cell[420803, 10394, 2604, 63, 117, "Input", "ExpressionUUID" -> \
"8c5296c6-39ea-4153-ab91-6f5c05599e4f"],
Cell[423410, 10459, 2474, 73, 117, "Input", "ExpressionUUID" -> \
"7faec7b2-8a4a-4d6a-824a-85b42aeb2dcb"],
Cell[CellGroupData[{
Cell[425909, 10536, 9649, 259, 327, "Input", "ExpressionUUID" -> \
"bbeb29ea-1897-45f3-9637-821389b34cef"],
Cell[435561, 10797, 8717, 160, 258, "Output", "ExpressionUUID" -> \
"d98fcb5c-ae13-45a3-bac6-4240cf125d70"]
}, Open  ]]
}
]
*)

