function output = bg_loop_step(t, dt, structure, inp_stri, inp_cx, neuromodulator)

    structure.strd1 = leaky_step(t, dt,  structure.strd1, inp_stri +                 ...
                                         structure.crx2.activity(t-1,:)*structure.crx2str, ...
                                         neuromodulator(t-1));
    
    structure.strd2 = leaky_step(t, dt,  structure.strd2, inp_stri +                 ...
                                         structure.crx2.activity(t-1,:)*structure.crx2str, ...
                                         neuromodulator(t-1));
                                     
    structure.stn   = leaky_step(t, dt,  structure.stn, structure.crx2.activity(t-1,:)*structure.crx2stn + ...
                                         structure.gpe.activity(t-1,:)*structure.gpe2stn,  ...
                                         neuromodulator(t-1));
    
    structure.gpe   = leaky_step(t, dt,  structure.gpe, structure.strd2.activity(t-1,:)*structure.str2gpe + ...
                                         structure.stn.activity(t-1,:)*structure.stn2gpe,  ...
                                         neuromodulator(t-1));
    
    structure.gpi   = leaky_step(t, dt,  structure.gpi, structure.strd1.activity(t-1,:)*structure.str2gpi + ...
                                         structure.stn.activity(t-1,:)*structure.stn2gpi + ...
                                         structure.gpe.activity(t-1,:)*structure.gpe2gpi,  ...
                                         neuromodulator(t-1));
    
    structure.thal  = leaky_step(t, dt,  structure.thal, structure.gpi.activity(t-1,:)*structure.gpi2thal + ...
                                         structure.crx2.activity(t-1,:)*structure.crx2thal, ...
                                         neuromodulator(t-1));
    
    structure.crx1  = leaky_step(t, dt,  structure.crx1, inp_cx + structure.thal.activity(t-1,:)*structure.thal2crx + ...
                                         structure.crx2.activity(t-1,:)*structure.crxl2_2crxl1, ...
                                         neuromodulator(t-1));
    
    structure.crx2  = leaky_step(t, dt,  structure.crx2, structure.crx1.activity(t-1,:)*structure.crxl1_2crxl2, ...
                                         neuromodulator(t-1));    

output=structure;