\name{GAR.FB}
\alias{GAR.FB}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
GAR.FB
}
\description{
Graphical LASSO with Adjusted Regularization (GAR) - Full Bayes algorithm
}
\usage{
GAR.FB(X, W1, W2=FALSE, K=5, B=2000, Burn=400, r1=1, s1=1, r2=0.01, s2=0.00001,
       monot.incr=FALSE, mon.tol=0, Plot=TRUE, marg.map=FALSE, zgrid=20, ori3d=200)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{
     An n x d data matrix, where n is the sample size and d is the number of variables.
  }
  \item{W1}{
     Symmetric d x d matrix containing values of auxiliary variable w1 for each pair of the d data variables. Diagonals are not used in computations.
  }
  \item{W2}{
     Symmetric d x d matrix containing values of a second auxiliary variable.
  }
  \item{K}{
  Parameter that specifies the number of steps of the penalty step function. If only W1 is provided, then steps will be at K evenly spaced quantiles of the empirical distribution of the values in W1; if also W2 is provided, steps are at K^2 rectangles obtained with a hierarchical quantile split over W1 first and then W2.
  }
  \item{B, Burn}{
  Number of Gibbs sampling iterations and burn-in.
  }
  \item{r1, r2, s1, s2}{
  Hyperparameters.
  }
  \item{monot.incr}{
   If set to TRUE, then the penalty step function is forced to be increasing with W1 (in the case where W2 is not provided).
  }
  \item{mon.tol}{
   Maximum tolerance for breaking monotonicity constraint, if monot.incr = TRUE.
  }
  \item{Plot}{
  If TRUE, then the step function is showed at each Gibbs iteration.
  }
  \item{marg.map}{
  If TRUE, then an additional Gibbs sampler is run conditionally on the map estimate of the penalty matrix Lambda.
  }
  \item{zgrid, ori3d}{
   Resolution and orientation of 3D plot, if Plot = TRUE and W2 is provided.
  }
}

\details{
Setting Plot = TRUE may slow down computations
}

\value{
\item{Omega.mean}{
Posterior mean of the precision matrix Omega.
}
\item{Omega.map}{
Posterior map of the precision matrix Omega.
}
\item{Alpha.mean, Alpha.map}{
Posterior mean and map of vector alpha (scale coefficients).
}
\item{Beta.mean, Beta.map}{
Posterior mean and map of vector beta (penalty coefficients).
}
\item{Lambda.mean, Lambda.map}{
Posterior mean and map of penalty matrix Lambda.
}
\item{Omegas, Alphas, Betas, Lambdas}{
Gibbs samples of Omega, alpha, beta, and Lambda.
}
}

\references{
Vinci G., Ventura V., Smith M.A., Kass R.E. (2018). "Adjusted Regularization of Cortical Covariance". Journal of Computational Neuroscience.
}

\author{
Giuseppe Vinci, Ph.D. in Statistics; Post-doc researcher at the Department of Statistics, Rice University.
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
# Create a precision matrix related to auxiliary variables W1 and W2
library(scatterplot3d)
library(MASS)

d=50
RHO = matrix(0, nc=d, nr=d)
set.seed(21)
w1=runif(d*(d-1)/2,0,1)
w2=runif(d*(d-1)/2,0,1)
eps=rnorm(d*(d-1)/2)*.01
Q=upper.tri(diag(d))
RHO[Q]=exp(-2*w1+2*w2+eps)*sign(runif(d*(d-1)/2,-1,1))
RHO=RHO+t(RHO)
diag(RHO)=4*max(abs(RHO))
W1=diag(d)*0
W1[Q]=w1
W1=W1+t(W1)
W2=diag(d)*0
W2[Q]=w2
W2=W2+t(W2)
OMEGA.true=cov2cor(RHO)
RHO=2*diag(d)-cov2cor(OMEGA.true)
scatterplot3d(W1[Q],W2[Q],abs(RHO[Q]), xlab='w1', ylab='w2', zlab=expression(abs(rho[ij])), angle=200)


# Generate dataset
library(MASS)
n=1000
X=mvrnorm(n, mu=rep(0,d), Sigma=solve(OMEGA.true))


# Computing GAR.FB univariate (note: Plot=TRUE may slow computation)
mod.FB1 = GAR.FB(X=X, W1=W1, W2=FALSE, K=4, Plot=TRUE)
dev.new()
par(mfrow=c(1,2),mar=c(4,5,1,1))
plot(-cov2cor(OMEGA.true)[Q],-cov2cor(mod.FB1$Omega.mean)[Q], xlab=expression(rho[ij]), ylab=expression(hat(rho)[ij]^mean), pch=4)
abline(a=0,b=1)
plot(-cov2cor(OMEGA.true)[Q],-cov2cor(mod.FB1$Omega.map)[Q], xlab=expression(rho[ij]), ylab=expression(hat(rho)[ij]^map), pch=4)
abline(a=0,b=1)

# Computing GAR.FB bivariate (note: Plot=TRUE may slow computation)
mod.FB2 = GAR.FB(X=X, W1=W1, W2=W2, K=3, Plot=TRUE)
dev.new()
par(mfrow=c(1,2),mar=c(4,5,1,1))
plot(-cov2cor(OMEGA.true)[Q],-cov2cor(mod.FB2$Omega.mean)[Q], xlab=expression(rho[ij]), ylab=expression(hat(rho)[ij]^mean), pch=4)
abline(a=0,b=1)
plot(-cov2cor(OMEGA.true)[Q],-cov2cor(mod.FB2$Omega.map)[Q], xlab=expression(rho[ij]), ylab=expression(hat(rho)[ij]^map), pch=4)
abline(a=0,b=1)


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }% use one of  RShowDoc("KEYWORDS")
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
