\name{GAR.EB}
\alias{GAR.EB}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
GAR.EB
}
\description{
Graphical LASSO with Adjusted Regularization (GAR) - Empirical Bayes algorithm
}
\usage{
GAR.EB(X, W1, W2=FALSE, fit='linear', B0=300, Burn0=100, B = 2000, Burn = 500,
       Mloglik=1000, iters=30, m.iters=200, knots=NULL, Plot=FALSE, mult=1.005)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{
     An n x d data matrix, where n is the sample size and d is the number of variables.
  }
  \item{W1}{
     Symmetric d x d matrix containing values of auxiliary variable w1 for each pair of the d data variables. Diagonals are not used in computations.
  }
  \item{W2}{
     Symmetric d x d matrix containing values of a second auxiliary variable.
  }
  \item{fit}{
   Type of penalty regression: 'linear' or 'splines'. If splines, knots need to be specified.
  }
  \item{B0, Burn0}{
  Number of Gibbs sampler iterations and burn-in for each E-step.
  }
  \item{B, Burn}{
  Number of Gibbs sampling iterations and burn-in for final estimation of Omega.
  }
  \item{Mloglik}{
  Number of Gibbs samples to approximate marginal posterior of Theta.
  }
  \item{iters}{
  Total number of EM steps.
  }
  \item{m.iters}{
  Number of iterations for each M-step.
  }
  \item{knots}{
  Knots of splines, if fit = 'splines'.
  }
  \item{Plot}{
  If TRUE, then penalty function and log marginal posterior are shown at each EM step.
  }
  \item{mult}{
  Multiplier of B0 at each EM step.
  }
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
\item{E.STEP, M.STEP}{
Quantities obtained at last E and M steps.
}
\item{Omega.mean, Omega.map}{
Posterior mean and map of the precision matrix Omega.
}

}
\references{
Vinci G., Ventura V., Smith M.A., Kass R.E. (2018). "Adjusted Regularization of Cortical Covariance". Journal of Computational Neuroscience.
}
\author{
Giuseppe Vinci, Ph.D. in Statistics; Post-doc researcher at the Department of Statistics, Rice University.
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
# Create a precision matrix related to auxiliary variables W1 and W2
library(scatterplot3d)
library(MASS)

d=50
RHO = matrix(0, nc=d, nr=d)
set.seed(21)
w1=runif(d*(d-1)/2,0,1)
w2=runif(d*(d-1)/2,0,1)
eps=rnorm(d*(d-1)/2)*.01
Q=upper.tri(diag(d))
RHO[Q]=exp(-2*w1+2*w2+eps)*sign(runif(d*(d-1)/2,-1,1))
RHO=RHO+t(RHO)
diag(RHO)=4*max(abs(RHO))
W1=diag(d)*0
W1[Q]=w1
W1=W1+t(W1)
W2=diag(d)*0
W2[Q]=w2
W2=W2+t(W2)
OMEGA.true=cov2cor(RHO)
RHO=2*diag(d)-cov2cor(OMEGA.true)
scatterplot3d(W1[Q],W2[Q],abs(RHO[Q]), xlab='w1', ylab='w2',
  zlab=expression(abs(rho[ij])), angle=200)


# Generate dataset
library(MASS)
n=1000
X=mvrnorm(n, mu=rep(0,d), Sigma=solve(OMEGA.true))


# Computing GAR.EB univariate

# linear fit - univariate (using only W1)
dev.new()
mod.EB.linear1=GAR.EB(X=X, W1=W1, W2=FALSE, fit='linear', knots=NULL, Plot=T)
# Plots of partial correlation estimates vs true values
dev.new()
par(mfrow=c(1,2),mar=c(4,5,1,1))
plot(-cov2cor(OMEGA.true)[Q],-cov2cor(mod.EB.linear1$Omega.mean)[Q],
  xlab=expression(rho[ij]), ylab=expression(hat(rho)[ij]^mean), pch=4)
abline(a=0,b=1)
plot(-cov2cor(OMEGA.true)[Q],-cov2cor(mod.EB.linear1$Omega.map)[Q],
  xlab=expression(rho[ij]), ylab=expression(hat(rho)[ij]^map), pch=4)
abline(a=0,b=1)


# splines fit - bivariate (using both W1 and W2)
dev.new()
kk=5
Knots=list(quantile(W1[Q],seq(0,1,len=kk)[-c(1,kk)]),quantile(W2[Q],seq(0,1,len=kk)[-c(1,kk)]))
mod.EB.splines2=GAR.EB(X=X, W1=W1, W2=W2, fit='splines', knots=Knots, Plot=T)
# Plots of partial correlation estimates vs true values
dev.new()
par(mfrow=c(1,2),mar=c(4,5,1,1))
plot(-cov2cor(OMEGA.true)[Q],-cov2cor(mod.EB.splines2$Omega.mean)[Q],
  xlab=expression(rho[ij]), ylab=expression(hat(rho)[ij]^mean), pch=4)
abline(a=0,b=1)
plot(-cov2cor(OMEGA.true)[Q],-cov2cor(mod.EB.splines2$Omega.map)[Q],
  xlab=expression(rho[ij]), ylab=expression(hat(rho)[ij]^map), pch=4)
abline(a=0,b=1)
}


% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }% use one of  RShowDoc("KEYWORDS")
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
