: calcium flux gap junction. 2018
: 04 01 2018
: Modification of ica

NEURON {
    POINT_PROCESS GapCa
    NONSPECIFIC_CURRENT icagap
    USEION ca READ cai WRITE ica
    RANGE TimeRelex, icagap, ica, BasicCa, fluxion, jd, ControlGap
    POINTER gapCaP
}

UNITS {
    (molar) =	(1/liter)
    (mM) =	(millimolar)
    (um) =	(micron)
    (mA) =	(milliamp)
    FARADAY =	(faraday)	(10000 coulomb)
    PI = (pi)	(1)
}

PARAMETER {
    TimeRelex = 10000 (ms) 
    BasicCa = 1 (mM)
	jd = 0 (mA/mM)
	ControlGap = 0
	
}

ASSIGNED {
    cai (mM)
    gapCaP (mM)
    diam (um)
    icagap (nanoamp)
    fluxion (mM ms)
    ica  (nanoamp) : so you can plot the calcium current generated by this mechanism
}

BREAKPOINT {
    fluxion=BasicCa*TimeRelex 
	if (ControlGap < 0.5) {ica = jd * (1e+6)*(cai - 50e-6 (mM))
		 }  else {
			ica = jd * (1e+6)*(cai - gapCaP)
		 }
	
    : ica = (1e+16)*(((cai - 50e-6 (mM))/fluxion)*(2*FARADAY))            : Gap junction between Astrocytes
	
    : ica = jd * (1e+6)*(cai - gapCaP)         : Gap Junction inside the astrocyte   
}