global aboutWindow
   
space = 10;
buttonDimensions = [200 30];
position = [space space];

% Main window
mainDialog = figure('Position', [500 500 space*2+buttonDimensions(1) space*5+buttonDimensions(2)*4], ... 
    'Name', 'Nano', 'NumberTitle', 'off', 'MenuBar', 'none', 'ToolBar', 'none');

% Buttons 
uicontrol('Parent', mainDialog, 'Style', 'pushbutton', 'String', 'About', ...
    'Position', [position buttonDimensions], ...
    'Callback', 'set(aboutWindow, ''Visible'', ''on'', ''Position'', [150 400 300 280]);');

position(2) = position(2) + buttonDimensions(2) + space;

uicontrol('Parent', mainDialog, 'Style', 'pushbutton', 'String', 'Calcium dynamics on cluster', ...
    'Position', [position buttonDimensions], ...
    'Callback', 'cd clusterCaSim/host; run(''START_Simulation.m'');');

position(2) = position(2) + buttonDimensions(2) + space;

uicontrol('Parent', mainDialog, 'Style', 'pushbutton', 'String', 'NEURON Simulations', ...
    'Position', [position buttonDimensions], ...
    'Callback', 'delete(mainDialog); !scripts\run_neuron.bat &');

position(2) = position(2) + buttonDimensions(2) + space;

uicontrol('Parent', mainDialog, 'Style', 'pushbutton', 'String', 'Nano geometry', ...
    'Position', [position buttonDimensions], ...
    'Callback', 'cd nanoGeometry; run(''START_NanoGeometry.m'');');
     
% About window
aboutWindow = figure('Name', 'About Nano', 'NumberTitle', 'off'); 
set(aboutWindow, 'Visible', 'off', 'Position', [0 600 300 280], 'MenuBar', 'none', ...
    'ToolBar', 'none', 'CloseRequestFcn', 'set(gcf, ''Visible'', ''off'');');

aboutText = {
        '', ...
        'Nano, by Leonid Savtchenko ', ...
        'UCL, 2017 (c) MIT licence', ...
        '', ...
        'Nano geometry - ', ...
        'transformation from the real 3D geometry of astrocyte to the cylindrical geometry of astrocyte used NEURON simulations.', ...
        '', ...
        'NEURON Simulations - ', ...
        'set of simulations performed on nano geometry. Requires NEURON installed.', ...
        '', ...
        'Calcium dynamics on cluster - ', ...
        'simulation of calcium executed on the cluster. Part of NEURON Simulations. Requires additional setup of the cluster.'}';
    
uicontrol('Style', 'text', ...
    'Position', [space, space, 300-2*space, 280-2*space], ...
    'String', aboutText, ...
    'HorizontalAlignment', 'center', ...
    'BackgroundColor', 'w', 'Max', 2);