function MakeSectionTable()
%% Make figure with table that contains stored data sections.
%  Has ability to select several rows and buttons to perform
%  actions with selected rows.

    global sectionsTable figures

    figure(figures.tableWindow);

    sectionsTable = uitable('Units', 'pixels', ...
        'Position', [6, 70, 385, 300], ...
        'ColumnName', {'Section name', 'Good', 'Levels', 'Points', 'Use'}, ...
        'ColumnEditable', true);

    set(sectionsTable, 'ColumnWidth', {150, 50, 50, 50, 50});

    % Control buttons
    spaceBetween = 25;
    position = [20, 40];
    dimensions = [70, 20];
    
    uicontrol('Style', 'pushbutton', ...
        'String', 'Save to files', ...
        'Position', [position, dimensions], ...
        'Callback', 'SaveSelectedToFiles()');

    position(1) = position(1) + dimensions(1) + spaceBetween;
    
    uicontrol('Style', 'pushbutton', ...
        'String', 'Show', ...
        'Position', [position, dimensions], ...
        'Callback', 'PlotSelected()');
    
    position(1) = position(1) + dimensions(1) + spaceBetween;
    
    uicontrol('Style', 'pushbutton', ...
        'String', 'Highlight', ...
        'Position', [position, dimensions], ...
        'Callback', 'HighlightSelected()');

    position(1) = position(1) + dimensions(1) + spaceBetween;
    
    uicontrol('Style', 'pushbutton', ...
        'String', 'Simulate', ...
        'Position', [position, dimensions], ...
        'Callback', 'ComputeSelected()');
    
    position(1) = position(1) - dimensions(1) - spaceBetween;
    position(2) = position(2) - dimensions(2) - spaceBetween / 3;
    dimensions(1) = dimensions(1) * 2 + spaceBetween;
    
    uicontrol('Style', 'pushbutton', ...
        'String', 'Simulation settings', ...
        'Position', [position, dimensions], ...
        'Callback', 'ShowSettings()');    
    
    position(1) = position(1) - dimensions(1) - spaceBetween;
    
    uicontrol('Style', 'pushbutton', ...
        'String', 'Cylinder radii distribution', ...
        'Position', [position, dimensions], ...
        'Callback', 'RadiiDistributionSelected()');

    set(figures.tableWindow, ...
        'MenuBar', 'none', ...
        'ToolBar', 'none', ...
        'Visible', 'on');
    
    % TODO Rearrange buttons

end

