function GenerateParamsHoc()
%% Generate "params.hoc" file based on the values from GUI

    global watchedVars vrat_cadifus 
    global geometryFile defaultGeometry
    global params
    
    disp('Preparing input data file ...');
    
    lines = cell(0, 1);
    
    %% Prepare the header
    lines{end + 1, 1} = '// WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING';
    lines{end + 1, 1} = '// WARNING   This file is autogenerated each time you start simulation.    WARNING';
    lines{end + 1}    = '// WARNING   Any changes done here by hand will be lost.                   WARNING';
    lines{end + 1}    = '// WARNING   Use GUI provided by the host to adjust these variables.       WARNING';
    lines{end + 1}    = '// WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING';
    lines{end + 1}    = '';
    
    %% Prepare the watched variables
    
    numWatchedVars = size(watchedVars, 1);
    lines{end + 1} = sprintf('numWatchedVars = %i', numWatchedVars);
    lines{end + 1} = 'objref watchedSecNames, watchedVarNames, watchedSecIdxs, watchedVarCoords';
    lines{end + 1} = 'watchedSecNames = new List()';
    lines{end + 1} = 'watchedVarNames = new List()';
    lines{end + 1} = 'watchedSecIdxs = new Vector(numWatchedVars)';
    lines{end + 1} = 'watchedVarCoords = new Vector(numWatchedVars)';
    
    lines{end + 1} = '';
    
    for idx = 1 : numWatchedVars
        comp  = watchedVars{idx, 1};
        index = watchedVars{idx, 2};
        param = watchedVars{idx, 3};
        coord = watchedVars{idx, 4};
        lines{end + 1} = sprintf('watchedSecNames.append(new String("%s"))', comp); %#ok<*AGROW>
        lines{end + 1} = sprintf('watchedSecIdxs.x[%i] = %i', idx - 1,       index);
        lines{end + 1} = sprintf('watchedVarNames.append(new String("%s"))', param);
        lines{end + 1} = sprintf('watchedVarCoords.x[%i] = %g', idx - 1,     coord);
%         TODO Replace ActiveDendrites with watchedVars?
        lines{end + 1} = sprintf('ActiveDendrite%i = %i', idx, index);
    end
    
    lines{end + 1} = '';
    
    %% Initialize all parameters based on the values from GUI
    
    printedPanels = [2, 3];
    nonPrintedParams = {'vrat_cadifus', 'vrat_cadifus_addRemoveRow'};
    for printPanelIdx = 1 : length(printedPanels)
        panIdx_ = printedPanels(printPanelIdx);
        
        % Loop by all parameters of this panel
        for parIdx = 1 : length(params{panIdx_})
            varName = params{panIdx_}{parIdx}.name;
            if any(strcmp(nonPrintedParams, varName))
                continue
            end
            eval(['global ', varName]);
            linePat = [varName, ' = %g'];
            lines{end + 1} = sprintf(linePat, eval(varName));
        end
    end
    
    for idx = 1 : size(vrat_cadifus, 1)
        linePat = 'vrat_cadifus[%i] = %g';
        lines{end + 1} = sprintf(linePat, vrat_cadifus{idx, 1}, vrat_cadifus{idx, 2});
    end
    
    lines{end + 1} = '';
    
    %% Include the geometry file
    if strcmp(geometryFile, defaultGeometry)
        lines{end + 1} = 'load_file("model/AstroGeometry.hoc")';
    else
        [~, name, ext] = fileparts(geometryFile);
        linePat = 'load_file("user_geometry/%s%s")';
        lines{end + 1} = sprintf(linePat, name, ext);
    end
    
    %% Save the lines to the file
    fid = fopen('params.hoc', 'w');
    for i = 1 : length(lines)
        line = sprintf('%s\n', lines{i});
        fwrite(fid, line);
    end
    fclose(fid);

end