@echo off

rem Run this BAT-script with two arguments:
rem 1) the flag (0/1) indicating whether to compress files before and decompress after uploading;
rem 2) full path to the user geometry file or empty string. 

rem Initialize variables
call Core\scripts\win-lin\params.bat

rem TODO Add zipping of geometry file
if %1 == 1 (
    rem Check if old archives exist, if so -- delete
    if exist params_hoc.zip del params_hoc.zip

    rem Compress files
    %THIRDPARTYDIR%\7za.exe a params_hoc.zip params.hoc > NUL
    
    rem The compressed files will be uploaded
    set FILENAME_HOC=params_hoc.zip
    
) else (
    rem The input files will be uploaded themselves
    set FILENAME_HOC=params.hoc
)

rem Go to 3rd party software directory containing pscp.exe and plink.exe
cd %THIRDPARTYDIR%

rem Upload input files to the head node of HPC cluster
rem TODO Upload all files with a single call to pscp
pscp -pw %PASSWORD% "%MATLABHOSTDIR%\%FILENAME_HOC%" %LOGIN%@%HEADNODEIP%:"%HEADNODEWORKERDIR%" > NUL
if NOT "%2" == "" (
    pscp -pw %PASSWORD% "%2" %LOGIN%@%HEADNODEIP%:"%HEADNODEWORKERDIR%/user_geometry" > NUL
)

if %1 == 1 (
    rem Unzip input files and remove archives
    plink -pw %PASSWORD% %LOGIN%@%HEADNODEIP% cd \"%HEADNODEWORKERDIR%\"; rm params.hoc -f; unzip params_hoc.zip > NUL; rm params_hoc.zip -f;

    rem Delete just uploaded archive
    cd %MATLABHOSTDIR%
    del params_hoc.zip
)

rem Delete the autogenerated file
cd %MATLABHOSTDIR%
del params.hoc