function AddCustomParams()

    AddPanel('Custom');
    
    text = {'customVars.kf = 1000;'};
    desc = {'Text area for custom m-code where you can define any additional variables accessible from the expressions in editboxes.', ...
            'The variables must be put into the %customVars struct.', ...
            '', ...
            '<b>Example:</b>', ...
            '<pre>customCode:  customVars.r = roots([1, -3.1, 0.3]);', ...
            '             customVars.myVar3 = 0.1;', ...
            '             n = 1000; % not exposed variable', ...
            '             customVars.myVar5 = log10(n);</pre>', ...
            '<b>Correct referencing:</b>', ...
            '<pre>cai0:   1.2 * r(1) * r(2)       [mM]', ...
            'DCa:    3.4 * r(1) / r(2)       [um2/ms]', ...
            'TBufs:  5.6 * myVar3 * myVar5   [mM]', ...
            'kfs:    7.8 * myVar5 ^ 2        [/mM-ms]</pre>(no "customVars." prefixes are required here)', ...
            '', ...
            '<b>Incorrect referencing:</b>', ...
            '<pre><font color="red">KDs:    9.0 * n                 [uM]</font></pre>(the variable "n" was not exposed)'};
    
    AddCustomCodeTextArea('customCode', text, 'customVars', desc);
    
end