# Embedded Ensemble Encoding (EEE)

This repo is for the detailed cell model CA229. It includes the simulation, analysis and plotting files to generate paper figures. The code is in python version 3.6 and using NEURON version 7.4, 7.5, or 7.6.

## Description
    Both synaptic AMPARs/NMDARs and exsynaptic NMDARs are activated by one NetStim.
    Synaptic AMPARs/NMDARs get activated 10~100 ms after the stimulation.
    Exsynaptic NMDARs get activated 15~115 ms after the stimulation.
    gmax for AMPA is 0.05nS; gmax for NMDA is 0.005nS.

## Overview of files:

### Tool files

1. CA229.py   - python class with all the cell membrane properties
        (the Geometry and 3d shape is defined in this python class as well
            --- for better usage in network or NetPyNE)

    The ratio of sodium, calcium, A-type potassium and calcium activated potassium channels can be adjusted by call the class with different ratio parameters. For example,

    Using all the default value in cell1

    ```
    cell1 = CA229()
    ```

    Setting the channel conductances to 50% of the default value in cell2

    ```
    cell2 = CA229(Na_ratio = 0.5, HVA_ratio = 0.5, LVA_ratio = 0.5, KA_ratio = 0.5, BK_ratio = 0.5)               
    ```

2. compile.py     - compile all the mod files in folder: mod

3. analysis_utils.py   - calculating the plateau amplitude, plateau duration, interspike interval and number of spikes of the voltage traces generated by model simulation.

4. utils.py    - to save figures and simulation results in a folder with name of today's date or self-defined folder.

### Simulation files

1. Fig2_bAP_exp.py
        - Inject current in soma and record the voltage traces at different locations on all basal dendrites. All the parameters and traces are saved in json file for further analysis.
2. Fig2_bAP_anaPlot.py
        - Load the data generated by Fig2_bAP_exp.py and measure the peak amplitude and latency. Plot all the data.
3. Fig3_exp_dms.py, Fig3_exp_major.py
        - Code to add AMPA and NMDA receptors on basal[34]
        - It will generate figures and json files to store the voltage traces
        - Modify the parameters in "__main__" to choose the input strength
        - "random_2" function is used to generate random activation time within a certain range. The seed is locked for now to get consistent results.
        - "random_beta" function is used to generate alpha random activation time within a certain range. The seed is locked for now to get consistent results.

4. Fig3_dms_trace_plot.py, Fig3_major_trace_plot.py   - Generate trace plots in Fig 3. A2 and B2

5. Fig3_trace_analysis.py - Analyze the recorded traces and plot the plateau amplitude, duration and spikes per plateau against different input strength.

6. Fig5_exp_DMS.py, Fig5_exp_major.py   
        - batch simulation of glutamate input locations range from 0.1-0.9 (step size 0.1) on 6 different basal branches. At each branch and each location, there is also normal and TTX conditions. All the simulation results are saved into json files under each subfolder.
        - The data for generating paper fig5 are saved in subfolder("/Fig5/DMS or /Fig5/major")

7. Fig5_ana_DMS.py, Fig5_ana_major.py, Fig5_plot_DMS.py, Fig5_plot_major.py    
        - Analyze and plot the somatic plateau amplitude, dendritic plateau amplitude, plateau duration and spike numbers against the input distance from soma on basal dendrite.


### Instruction:

1. Compile mod files: python compile.py

2. Fig 2.B2 and B3 (the study of backpropagated action potential)
    - Run: "Fig2_bAP_exp.py"
    run the simulation and save the data in folder "Fig2/"
    This step take ~ 426 seconds on a macbook pro (2018) with processor 2.9 GHz Intel Core i9.
    - Run: "Fig2_bAP_anaPlot.py"
    Analyze the data, plot and save figures in "Fig2/New_Figs/"

3. Fig 3. A2 and B2 - Trace plots
    - Run: "Fig3_exp_dms.py" or "Fig3_exp_major.py"
    run the simulation and save the data in folder "Fig3/DMS/Plot/" or "Fig3/Major/Plot/"
    This step take ~ 251 seconds on a macbook pro (2018) with processor 2.9 GHz Intel Core i9.
    - Run: "Fig3_dms_trace_plot.py" or "Fig3_major_trace_plot.py"
    plot the traces and save the figures in folder "Fig3/DMS/Plot/" or "Fig3/Major/Plot/"

3. Fig 3. D1 - D3 - analysis plots
    - Open "Fig3_exp_dms.py", add # before the code at line 77, remove # before the code in line 78;
    add # before the code at line 254, remove # before the code in line 256.
    This step take ~ 367 seconds on a macbook pro (2018) with processor 2.9 GHz Intel Core i9.
    - Open "Fig3_exp_major.py", add # before the code at line 74, remove # before the code in line 75;
    add # before the code at line 239, remove # before the code in line 241.
    - Run: "Fig3_exp_dms.py" and "Fig3_exp_major.py"
    run the simulation and save the data in folder "Fig3/DMS/Analysis/" or "Fig3/Major/Analysis/"
    - Run: "Fig3_trace_analysis.py"
    Analyze the traces, plot and save the figures in folder "Fig3/"

4. Fig 5.
    - Run: "Fig5_exp_DMS.py" or "Fig5_exp_major.py"
    Run the simulation and save json data in folder "Fig5/DMS/" or "Fig5/major/".
    This step take ~ 1000 seconds on a macbook pro (2018) with processor 2.9 GHz Intel Core i9.
    - Run: "Fig5_ana_DMS.py" or "Fig5_ana_major.py"
    Analyze the traces and generate summary data.
    - Run: "Fig5_plot_DMS.py" or "Fig5_plot_major.py"
    Plot and save all the figures in folder "Fig5/DMS/" or "Fig5/major/".


NOTE: in all the "exp" files, the parameters can be adjusted in "main" manually, eg.
    Fig3_exp_dms.py
        (change number pool1 of synaptic AMPARs and NMDARs;
        change number pool 2 of exsyantpic NMDARs;
        change Beta and Cdur of NMDARs;
        change of stimulation location;
        change of syanptic weights;
        change of stimuation locations)



## Author

**Peng Penny Gao**

## License
The project belongs to:
    Srdjan Antic's lab (https://health.uconn.edu/antic-lab/)
    Neurosim lab (http://www.neurosimlab.com)

For further information please contact: penggao.1987@gmail.com

## Other contributors
Joe W Graham, Sergio L Angulo, Salvador Dura-Bernal, Michael L Hines, William W Lytton, Srdjan D Antic
