#!/bin/bash
# this shell script sets the search path for NEURON to include the following directories 
# and then opens the special executable generated by nrnivmodl

# --- The following 3 lines setup the nrn and python paths. modify and (un)commented as needed ---
export PYTHONPATH=/Applications/NEURON-7.7/nrn/lib/python #added by NEURON installer
export PYTHONHOME="/Library/Frameworks/Python.framework/Versions/2.7" #added by NEURON installer
export LD_LIBRARY_PATH="/Library/Frameworks/Python.framework/Versions/2.7/lib:$LD_LIBRARY_PATH" #added by NEURON installer


currwd=`pwd`	# store the current working directory before changing it

scriptpath=$0

nrndir=${scriptpath%/*}
modelfile=$1

NRNBASE=$nrndir
execdir="$nrndir/x86_64"

echo "Setting NRNBASE to: $NRNBASE" 
echo "Using nrn executable: $execdir"
echo "Using model init file: $modelfile" 

export NRNBASE

# speficy path for local nrn files
export HOC_LIBRARY_PATH=$NRNBASE:$NRNBASE/library

cd ${NRNBASE}

# check if x86_64 directory exists
if [[ ! -d ${execdir} ]]; then
	if [[ -d ./mods ]]; then
		# create new nrn special executable and run init.hoc
		echo "Executable directory 'x86_64' not found. Creating new nrn executable with nrnivmodl"
		nrnivmodl ./mods
	else
		execdir="$nrngui"
	fi
# 	cd ${currdir}
fi

# run special and load libinit.hoc
if [[ -d ${execdir} ]]; then
	if test $# = 0; then
		$execdir/special ./libinit.hoc -
	else
		$execdir/special ./libinit.hoc -c "load_file(\"$modelfile\")" -
	fi
else
	echo "Neuron executable not found.\n"
fi

cd ${currwd}

