// TCRcell.p - Cell parameter file used in TraubFS_B

//	Format of file :
// x,y,z,dia are in microns, all other units are SI (Meter Kilogram Sec Amp)
// In polar mode 'r' is in microns, theta and phi in degrees 
// Control line options start with a '*'
// The format for each compartment parameter line is :
//name	parent	r	theta	phi	d	ch	dens ...
//in polar mode, and in cartesian mode :
//name	parent	x	y	z	d	ch	dens ...
// For channels, "dens" =  maximum conductance per unit area of compartment
// For spike elements, "dens" is the spike threshold
//		Coordinate mode
*relative
*cartesian
*asymmetric

//		Specifying constants
   *set_compt_param	RM	2.50  //0.33333 (2.50)
   *set_compt_param	RA	2.00  //0.3 (2.00)
   *set_compt_param	CM	0.01  //0.01 (0.01)
   *set_compt_param     EREST_ACT	-0.066   // -0.075
   *set_compt_param     ELEAK           -0.066   // -0.075


//SOMA *************************************************************   
// For the soma, use the leakage potential (-0.07 + 0.0106) for Em
//*set_compt_param     ELEAK	-0.0594
// Actually, after Cunningham et al. PNAS 2004;101:7152-7157, will maintain
// leakage potential at ELEAK   -0.07
soma	none	0	0	20	15.0	Ca_s20	-44.38e12	NaF20	1000	NaP20	2.0	KDR20	337.5	KA20	6.00	K220	20.0	CaH20	5.0	KCs20	120	KM20	5	KAHPs20	0.5	AR20	2.5	CaL20	5.0

//*set_compt_param        ELEAK   -0.060 // -0.077
*set_compt_param	RM	2.50  //0.33333 (2.50)
*set_compt_param	RA	2.00  //0.3 (2.00)
*set_compt_param	CM	0.01  //0.01 (0.01)

//PROXIMAL DENDRITE COMPARTMENTS ***************************************

// proxdendNNE   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE	soma	22.5	0	39.0	2.12	Ca_d20	-78.50e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE	soma	39.0	0	22.5	2.12	Ca_d20	-78.50e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE	soma	45	0	0	2.12	Ca_d20	-78.50e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE	soma	39.0	0	-22.5	2.12	Ca_d20	-78.50e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE	soma	22.5	0	-39.0	2.12	Ca_d20	-78.50e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW	soma	-22.5	0	-39.0	2.12	Ca_d20	-78.50e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW	soma	-39.0	0	-22.5	2.12	Ca_d20	-78.50e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW	soma	-45	0	0	2.12	Ca_d20	-78.50e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW	soma	-39.0	0	22.5	2.12	Ca_d20	-78.50e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW	soma	-22.5	0	39.0	2.12	Ca_d20	-78.50e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

*set_compt_param	RM	2.50  //0.33333 (2.50)
*set_compt_param	RA	2.00  //0.3 (2.00)
*set_compt_param	CM	0.01  //0.01 (0.01)
//*set_compt_param     ELEAK	-0.075

//DISTAL Level I DENDRITE COMPARTMENTS ***************************************

// proxdendNNE1   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE1	proxdendNNE	0.0	0	45.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE1   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE1	proxdendNE	22.5	0	39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE1   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE1	proxdendE	39.0	0	22.5	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE1   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE1	proxdendSE	45.0	0	0.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE1   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE1	proxdendSSE	22.5	0	-39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW1   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW1	proxdendSSW	0.0	0	-45.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW1   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW1	proxdendSW	-22.5	0	-39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW1   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW1	proxdendW	-22.5	0	-39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW1   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW1	proxdendNW	-45.0	0	0.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW1   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW1	proxdendNNW	-22.5	0	39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNE2   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE2	proxdendNNE	22.5	0	39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE2   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE2	proxdendNE	39.0	0	22.5	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE2   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE2	proxdendE	45	0	0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE2   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE2	proxdendSE	39.0	0	-22.5	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE2   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE2	proxdendSSE	22.5	0	-39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW2   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW2	proxdendSSW	-22.5	0.0	-39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW2   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW2	proxdendSW	-39.0	0	-22.5	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW2   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW2	proxdendW	-45	0	0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW2   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW2	proxdendNW	-39.0	0	22.5	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW2   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW2	proxdendNNW	-22.5	0	39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNE3   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE3	proxdendNNE	39.0	0	22.5	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE3   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE3	proxdendNE	45.0	0	0.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE3   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE3	proxdendE	39.0	0	22.5	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE3   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE3	proxdendSE	22.5	0	-39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE3   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE3	proxdendSSE	0.0	0	-45.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW3   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW3	proxdendSSW	-39.0	0	-22.5	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW3   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW3	proxdendSW	-45.0	0	0.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW3   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW3	proxdendW	-39.0	0	22.5	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW3   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW3	proxdendNW	-22.5	0	39.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW3   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW3	proxdendNNW	0.0	0	45.0	1.34	Ca_d20	-124.18e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

//DISTAL Level II DENDRITE COMPARTMENTS ***************************************

// proxdendNNE11   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE11	proxdendNNE1	-22.5	0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE11   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE11	proxdendNE1	0.0	0.0	45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE11   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE11	proxdendE1	22.5	0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE11   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE11	proxdendSE1	39.0	0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE11   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE11	proxdendSSE1	45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW11   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW11	proxdendSSW1	22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW11   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW11	proxdendSW1	0.0	0.0	-45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW11   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW11	proxdendW1	-22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW11   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW11	proxdendNW1	-39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW11   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW11	proxdendNNW1	-45.0	0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNE12   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE12	proxdendNNE1	0.0	0.0	45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE12   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE12	proxdendNE1	22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE12   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE12	proxdendE1	39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE12   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE12	proxdendSE1	45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE12   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE12	proxdendSSE1	22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW12   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW12	proxdendSSW1	0.0	0.0	-45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW12   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW12	proxdendSW1	-22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW12   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW12	proxdendW1	-39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW12   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW12	proxdendNW1	-45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW12   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW12	proxdendNNW1	-39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNE13   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE13	proxdendNNE1	22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE13   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE13	proxdendNE1	39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE13   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE13	proxdendE1	45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE13   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE13	proxdendSE1	39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE13   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE13	proxdendSSE1	22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW13   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW13	proxdendSSW1	-22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW13   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW13	proxdendSW1	-39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW13   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW13	proxdendW1	-45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW13   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW13	proxdendNW1	-39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW13   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW13	proxdendNNW1	-22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNE21   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE21	proxdendNNE2	0.0	0.0	45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE21   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE21	proxdendNE2	39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE21   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE21	proxdendE2	39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE21   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE21	proxdendSE2	45.0	0.	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE21   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE21	proxdendSSE2	39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW21   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW21	proxdendSSW2	0.0	0.0	-45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW21   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW21	proxdendSW2	0.0	0.0	-45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW21   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW21	proxdendW2	-39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW21   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW21	proxdendNW2	-45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW21   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW21	proxdendNNW2	-39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNE22   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE22	proxdendNNE2	22.5	0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE22   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE22	proxdendNE2	39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE22   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE22	proxdendE2	45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE22   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE22	proxdendSE2	39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE22   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE22	proxdendSSE2	22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW22   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW22	proxdendSSW2	-22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW22   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW22	proxdendSW2	-39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW22   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW22	proxdendW2	-45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW22   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW22	proxdendNW2	-39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW22   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW22	proxdendNNW2	-22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNE23   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE23	proxdendNNE2	39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE23   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE23	proxdendNE2	45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE23   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE23	proxdendE2	39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE23   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE23	proxdendSE2	22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE23   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE23	proxdendSSE2	0.0	0.0	-45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW23   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW23	proxdendSSW2	-39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW23   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW23	proxdendSW2	-45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW23   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW23	proxdendW2	-39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW23   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW23	proxdendNW2	-22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW23   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW23	proxdendNNW2	0.0	0.0	45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNE31   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE31	proxdendNNE3	22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE31   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE31	proxdendNE3	39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE31   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE31	proxdendE3	45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE31   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE31	proxdendSE3	39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE31   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE31	proxdendSSE3	22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW31   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW31	proxdendSSW3	-22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW31   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW31	proxdendSW3	-39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW31   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW31	proxdendW3	-45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW31   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW31	proxdendNW3	-39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW31   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW31	proxdendNNW3	-22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNE32   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE32	proxdendNNE3	39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE32   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE32	proxdendNE3	45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE32   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE32	proxdendE3	39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE32   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE32	proxdendSE3	22.5	0.0	-39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE32   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE32	proxdendSSE3	0.0	0.0	-45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW32   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW32	proxdendSSW3	-39.0	0.0	-22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW32   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW32	proxdendSW3	-45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW32   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW32	proxdendW3	-39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW32   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW32	proxdendNW3	-22.5	0.0	39.2	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW32   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW32	proxdendNNW3	0.0	0.0	45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNE33   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNE33	proxdendNNE3	45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNE33   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNE33	proxdendNE3	39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendE33   Cunningham et al., PNAS  2004;101:7152-7157
proxdendE33	proxdendE3	22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSE33   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSE33	proxdendSE3	0.0	0.0	-45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSE33   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSE33	proxdendSSE3	-22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSSW33   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSSW33	proxdendSSW3	-45.0	0.0	0.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendSW33   Cunningham et al., PNAS  2004;101:7152-7157
proxdendSW33	proxdendSW3	-39.0	0.0	22.5	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendW33   Cunningham et al., PNAS  2004;101:7152-7157
proxdendW33	proxdendW3	-22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNW33   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNW33	proxdendNW3	0.0	0.0	45.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

// proxdendNNW33   Cunningham et al., PNAS  2004;101:7152-7157
proxdendNNW33	proxdendNNW3	22.5	0.0	39.0	0.84	Ca_d20	-396.21e12	NaF20	1000	NaP20	2.0	KDR20	225	KA20	6.00	K220	20	CaH20	5	KCd20	120	KM20	5	KAHPd20	0.5	AR20	2.5	CaL20	50

//		Specifying constants for axonal compartment

   *set_compt_param	RM	0.1   // (0.1)
   *set_compt_param	RA	1.0   // (1.0)
   *set_compt_param	CM	0.01  // (0.01) RC = 0.001
//*set_compt_param     ELEAK	-0.07441
  
// axona Fig 1. Traub et al., J Neurophysiol 2003;89:909-921
// Differs from Traub et al., in that axon is vertical
axona	soma	0	0	-25	1.8	NaF20	4500	KDR20	4500	KA20	4.00	K220	1

// axonb Fig 1. Traub et al., J Neurophysiol 2003;89:909-921
// Differs from Traub et al., in that axon is vertical
axonb	axona	0	0	-50	1.4	NaF20	4500	KDR20	4500	KA20	4.00	K220	1

// axonLa Fig 1. Traub et al., J Neurophysiol 2003;89:909-921
// Differs from Traub et al., in that axon is vertical
axonLa	axonb	-8.7	0	-49.2	1.2	NaF20	4500	KDR20	4500	KA20	4.00	K220	1

// axonLb Fig 1. Traub et al., J Neurophysiol 2003;89:909-921
// Differs from Traub et al., in that axon is vertical
axonLb	axonLa	-8.7	0	-49.2	1.0	NaF20	4500	KDR20	4500	KA20	4.00	K220	1

// axonRa Fig 1. Traub et al., J Neurophysiol 2003;89:909-921
// Differs from Traub et al., in that axon is vertical
axonRa	axonb	8.7	0	-49.2	1.2	NaF20	4500	KDR20	4500	KA20	4.00	K220	1

// axonRb Fig 1. Traub et al., J Neurophysiol 2003;89:909-921
// Differs from Traub et al., in that axon is vertical
axonRb	axonRa	8.7	0	-49.2	1.0	NaF20	4500	KDR20	4500	KA20	4.00	K220	1
