/*
 * Decompiled with CFR 0.152.
 */
package neurord.disc;

import java.util.HashMap;
import neurord.disc.DiscBoxer;
import neurord.disc.LineBoxer;
import neurord.disc.SegmentSlicer;
import neurord.disc.TreeUtil;
import neurord.numeric.morph.TreePoint;
import neurord.numeric.morph.VolumeGrid;

public class TreeBoxDiscretizer {
    public static VolumeGrid buildGrid(TreePoint[] srcPoints, double d, HashMap<String, Double> resHM, double[] surfaceLayers, VolumeGrid.geometry_t geom, double d2d) {
        TreePoint base = srcPoints[0];
        TreeUtil.parentizeFrom(base, srcPoints);
        TreeUtil.orientAC(base, srcPoints);
        SegmentSlicer ss = new SegmentSlicer(srcPoints);
        TreePoint[] slicedPoints = ss.getFixedWidthSlices(d, resHM);
        VolumeGrid vgrid = null;
        switch (geom) {
            case GEOM_2D: {
                vgrid = LineBoxer.buildGrid(slicedPoints, surfaceLayers, d2d, d, resHM);
                break;
            }
            case GEOM_3D: {
                DiscBoxer db = new DiscBoxer(slicedPoints, surfaceLayers);
                vgrid = db.buildGrid(d, resHM);
                break;
            }
            default: {
                throw new RuntimeException("unknown geometry");
            }
        }
        return vgrid;
    }
}

