/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;
import neurord.model.Segment;
import neurord.numeric.morph.TreePoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MorphPoint {
    static final Logger log = LogManager.getLogger();
    @XmlAttribute
    protected Double x;
    @XmlAttribute
    protected Double y;
    @XmlAttribute
    protected Double z;
    @XmlAttribute
    protected Double r;
    @XmlAttribute
    protected String label;
    private transient Segment r_segment;
    protected transient MorphPoint r_peerPoint;
    private transient ArrayList<MorphPoint> neighbors;
    private transient ArrayList<MorphPoint> offsetNeighbors;
    transient HashMap<MorphPoint, String> segidHM = new HashMap();
    transient HashMap<MorphPoint, String> regionHM = new HashMap();

    protected MorphPoint() {
    }

    public MorphPoint(String label, double x, double y, double z, double r) {
        assert (r > 0.0);
        this.label = label;
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
    }

    public void setSegment(Segment seg) {
        this.r_segment = seg;
    }

    protected void addNeighbor(MorphPoint p) {
        if (this.neighbors == null) {
            this.neighbors = new ArrayList();
        }
        this.neighbors.add(p);
    }

    public void addOffsetChild(MorphPoint p) {
        if (this.offsetNeighbors == null) {
            this.offsetNeighbors = new ArrayList();
        }
        this.offsetNeighbors.add(p);
    }

    public boolean hasOffsetChildren() {
        return this.offsetNeighbors != null;
    }

    public ArrayList<MorphPoint> getOffsetChildren() {
        return this.offsetNeighbors;
    }

    public void removeNeighbor(MorphPoint mp) {
        this.neighbors.remove(mp);
    }

    public boolean redundant() {
        return this.r_peerPoint != null;
    }

    public ArrayList<MorphPoint> getNeighbors() {
        return this.neighbors;
    }

    public TreePoint toTreePoint() {
        assert (this.r > 0.0);
        TreePoint tp = new TreePoint(this.x, this.y, this.z, this.r);
        if (this.label != null) {
            tp.setLabel(this.label);
        }
        return tp;
    }

    public void transferConnections() {
        if (this.r_peerPoint == null) {
            log.error("cannot transfer connections - no peer");
            throw new RuntimeException("cannot transfer connections - no peer");
        }
        if (this.neighbors != null) {
            for (MorphPoint mp : this.neighbors) {
                mp.removeNeighbor(this);
                this.r_peerPoint.addNeighbor(mp);
                mp.addNeighbor(this.r_peerPoint);
                if (this.segidHM.containsKey(mp)) {
                    this.r_peerPoint.setIDWith(mp, this.segidHM.get(mp));
                }
                if (this.regionHM.containsKey(mp)) {
                    this.r_peerPoint.setRegionWith(mp, this.regionHM.get(mp));
                }
                mp.replaceNeighborLabels(this, this.r_peerPoint);
            }
            this.neighbors = null;
        }
        if (this.offsetNeighbors != null) {
            for (MorphPoint mon : this.offsetNeighbors) {
                this.r_peerPoint.addOffsetChild(mon);
            }
            this.offsetNeighbors = null;
        }
    }

    public boolean hasPosition() {
        return this.x != null && this.y != null && this.z != null;
    }

    public double distanceTo(MorphPoint mp) {
        if (!this.hasPosition() || !mp.hasPosition()) {
            log.error("cannot calculate distance (undefined position)");
            throw new RuntimeException("cannot calculate distance (undefined position)");
        }
        double dx = mp.x - this.x;
        double dy = mp.y - this.y;
        double dz = mp.z - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public void setIDWith(MorphPoint end, String id) {
        this.segidHM.put(end, id);
    }

    public void setRegionWith(MorphPoint ep, String r) {
        this.regionHM.put(ep, r);
    }

    public void replaceNeighborLabels(MorphPoint mp, MorphPoint mpnew) {
        if (this.segidHM.containsKey(mp)) {
            this.segidHM.put(mpnew, this.segidHM.get(mp));
            this.segidHM.remove(mp);
        }
        if (this.regionHM.containsKey(mp)) {
            this.regionHM.put(mpnew, this.regionHM.get(mp));
            this.regionHM.remove(mp);
        }
    }

    public String toString() {
        String seg_id = this.r_segment != null && this.r_segment.id != null ? " @" + this.r_segment.id : "";
        String reg_id = this.r_segment != null && this.r_segment.region != null ? " @@" + this.r_segment.region : "";
        return String.format("%s x=%s y=%s z=%s r=%s%s%s", this.getClass().getSimpleName(), this.x, this.y, this.z, this.r, this.label != null ? " \"" + this.label + "\"" : "", seg_id, reg_id);
    }
}

