/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlElement;
import neurord.model.EndPoint;
import neurord.model.MorphPoint;
import neurord.model.Segment;
import neurord.model.SpineAllocation;
import neurord.model.SpineType;
import neurord.numeric.morph.SpineDistribution;
import neurord.numeric.morph.SpinePopulation;
import neurord.numeric.morph.TreePoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Morphology {
    static final Logger log = LogManager.getLogger();
    @XmlElement(name="SpineType")
    public ArrayList<SpineType> spineTypes;
    @XmlElement(name="Segment")
    public ArrayList<Segment> segments;
    @XmlElement(name="SpineAllocation")
    private ArrayList<SpineAllocation> p_spineAllocations;
    private transient boolean resolved = false;
    private transient TreePoint[] tree_points;
    private transient Double depth2D;

    /*
     * WARNING - void declaration
     */
    public synchronized void resolve(double depth2D) {
        TreePoint tp;
        if (this.resolved) {
            assert (this.depth2D == null || this.depth2D == depth2D);
            return;
        }
        this.depth2D = depth2D;
        ArrayList<MorphPoint> p_points = new ArrayList<MorphPoint>();
        HashMap<String, SpineType> spineHM = new HashMap<String, SpineType>();
        if (this.spineTypes != null) {
            for (SpineType spineType : this.spineTypes) {
                spineHM.put(spineType.id, spineType);
            }
        }
        if (this.p_spineAllocations != null) {
            for (SpineAllocation spineAllocation : this.p_spineAllocations) {
                spineAllocation.resolve(spineHM);
            }
        }
        if (this.segments != null) {
            HashMap<String, Segment> segmentHM = new HashMap<String, Segment>();
            for (Segment segment2 : this.segments) {
                segmentHM.put(segment2.getID(), segment2);
            }
            for (Segment segment3 : this.segments) {
                segment3.resolve(segmentHM);
            }
            ArrayList<EndPoint> arrayList = new ArrayList<EndPoint>();
            for (Segment segment4 : this.segments) {
                arrayList.add(segment4.getStart());
                arrayList.add(segment4.getEnd());
            }
            for (MorphPoint morphPoint : arrayList) {
                if (morphPoint.redundant()) {
                    morphPoint.transferConnections();
                    continue;
                }
                p_points.add(morphPoint);
            }
        }
        ArrayList<TreePoint> tpts = new ArrayList<TreePoint>();
        HashMap<MorphPoint, TreePoint> hashMap = new HashMap<MorphPoint, TreePoint>();
        boolean bl = false;
        for (MorphPoint mp : p_points) {
            void var7_19;
            tp = mp.toTreePoint();
            log.debug("new tree point: {}", tp);
            tpts.add(tp);
            hashMap.put(mp, tp);
            tp.setWork((int)(++var7_19));
        }
        for (MorphPoint mp : p_points) {
            tp = (TreePoint)hashMap.get(mp);
            for (MorphPoint pn : mp.getNeighbors()) {
                TreePoint tpn = (TreePoint)hashMap.get(pn);
                if (tp.getWork() >= tpn.getWork()) continue;
                TreePoint.neighborize(tp, tpn);
            }
            for (MorphPoint pn : mp.segidHM.keySet()) {
                tp.setIDWith((TreePoint)hashMap.get(pn), mp.segidHM.get(pn));
            }
            for (MorphPoint pn : mp.regionHM.keySet()) {
                tp.setRegionWith((TreePoint)hashMap.get(pn), mp.regionHM.get(pn));
            }
            if (!mp.hasOffsetChildren()) continue;
            for (MorphPoint oc : mp.getOffsetChildren()) {
                TreePoint tpc = (TreePoint)hashMap.get(oc);
                tp.addOffsetChild(tpc);
            }
        }
        this.tree_points = tpts.toArray(new TreePoint[0]);
        this.resolved = true;
    }

    public synchronized TreePoint[] getTreePoints() {
        assert (this.resolved);
        return this.tree_points;
    }

    public SpineDistribution getSpineDistribution() {
        ArrayList<SpinePopulation> spa = new ArrayList<SpinePopulation>();
        if (this.p_spineAllocations != null) {
            for (SpineAllocation sa : this.p_spineAllocations) {
                SpinePopulation sp = sa.makePopulation(this.depth2D);
                if (sp == null) continue;
                spa.add(sp);
            }
        }
        SpinePopulation[] pa = spa.toArray(new SpinePopulation[0]);
        return new SpineDistribution(pa);
    }
}

