/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import neurord.model.IOutputSet;
import neurord.model.OutputSpecie;
import neurord.util.ArrayUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutputSet
implements IOutputSet {
    static final Logger log = LogManager.getLogger();
    @XmlAttribute
    public String filename;
    @XmlAttribute
    public String region;
    @XmlAttribute
    public Double outputInterval;
    @XmlElement(name="OutputSpecie")
    public ArrayList<OutputSpecie> outputSpecies;

    @Override
    public List<String> getNamesOfOutputSpecies() {
        if (this.outputSpecies == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (OutputSpecie out : this.outputSpecies) {
            names.add(out.name);
        }
        return names;
    }

    public static int[] outputSpecieIndices(String where, List<String> specout, String[] species) {
        if (specout == null) {
            return ArrayUtil.iota(species.length);
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < species.length; ++i) {
            if (species[i].equals("all")) {
                return ArrayUtil.iota(species.length);
            }
            map.put(species[i], i);
        }
        int[] ans = new int[specout.size()];
        int i = 0;
        for (String so : specout) {
            Integer k = (Integer)map.get(so);
            if (k == null) {
                log.error("Unknown output species '{}' (requested for output in {} but not found in ReactionScheme)", so, where);
                throw new RuntimeException("Unknown species '" + so + "'");
            }
            ans[i++] = k;
        }
        return ans;
    }

    @Override
    public int[] getIndicesOfOutputSpecies(String[] species) {
        List<String> output = this.getNamesOfOutputSpecies();
        String where = "OutputSet " + (this.filename != null ? this.filename : "w/o filename");
        return OutputSet.outputSpecieIndices(where, output, species);
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getIdentifier() {
        return this.filename;
    }

    @Override
    public double getOutputInterval(double fallback) {
        if (this.outputInterval != null) {
            return this.outputInterval;
        }
        return fallback;
    }
}

