/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import neurord.inter.FloatValued;
import neurord.model.PicoSD;
import neurord.model.Regional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SurfaceDensitySet
implements Regional {
    static final Logger log = LogManager.getLogger();
    @XmlAttribute
    public String region;
    @XmlElement(name="PicoSD")
    public ArrayList<PicoSD> sds;
    transient HashMap<String, PicoSD> sdHM;

    private synchronized HashMap<String, PicoSD> getSurfaceDensities() {
        if (this.sdHM == null) {
            this.sdHM = new HashMap();
            if (this.sds != null) {
                for (PicoSD sd : this.sds) {
                    this.sdHM.put(sd.specieID, sd);
                }
            }
        }
        return this.sdHM;
    }

    public Double getSurfaceDensity(String species) {
        PicoSD sd = this.getSurfaceDensities().get(species);
        if (sd == null) {
            return null;
        }
        return sd.getValue();
    }

    @Override
    public boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    public void addFloatValued(ArrayList<FloatValued> afv) {
        afv.addAll(this.sds);
    }

    public void verify(String[] regions, String[] species) {
        if (this.hasRegion() && !Arrays.asList(regions).contains(this.region)) {
            log.error("SurfaceDensitySet has region \"{}\", not in {}", this.region, regions);
            throw new RuntimeException("SurfaceDensitySet with bad region: " + this.region);
        }
        for (PicoSD conc : this.sds) {
            conc.verify(regions, species);
        }
    }
}

