/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.grid;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Manifest;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;
import ncsa.hdf.object.h5.H5ScalarDS;
import neurord.model.IOutputSet;
import neurord.numeric.chem.ReactionTable;
import neurord.numeric.chem.StimulationTable;
import neurord.numeric.grid.IGridCalc;
import neurord.numeric.grid.ResultWriter;
import neurord.numeric.morph.VolumeGrid;
import neurord.util.ArrayUtil;
import neurord.util.LibUtil;
import neurord.util.Settings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultWriterHDF5
implements ResultWriter {
    public static final Logger log = LogManager.getLogger();
    static final int compression_level;
    protected final File outputFile;
    protected H5File output;
    protected Group root;
    protected final Map<Integer, Trial> trials = new HashMap<Integer, Trial>();
    public static final H5Datatype double_t;
    public static final H5Datatype int_t;
    public static final H5Datatype long_t;
    public static final H5Datatype short_str_t;
    static final int CACHE_SIZE1 = 1024;
    static final int CACHE_SIZE2 = 8192;
    final String[] species;
    final int[] ispecout1;
    final int nel;
    final int[][] ispecout2;
    final int[][] elementsout2;
    final IOutputSet outputSet;
    final List<? extends IOutputSet> outputSets;
    protected Group model;
    private int users = 0;

    public ResultWriterHDF5(File output, IOutputSet primary, List<? extends IOutputSet> outputSets, String[] species, VolumeGrid grid) {
        this.outputFile = new File(output + ".h5");
        log.debug("Writing HDF5 to {}", this.outputFile);
        this.species = species;
        this.outputSet = primary;
        this.outputSets = outputSets;
        this.ispecout1 = primary.getIndicesOfOutputSpecies(species);
        this.nel = grid.size();
        if (this.outputSets != null) {
            this.ispecout2 = new int[outputSets.size()][];
            this.elementsout2 = new int[outputSets.size()][];
            for (int i = 0; i < this.ispecout2.length; ++i) {
                this.ispecout2[i] = outputSets.get(i).getIndicesOfOutputSpecies(species);
                String region = outputSets.get(i).getRegion();
                if (region != null) {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    for (int j = 0; j < this.nel; ++j) {
                        if (!region.equals(grid.getElementRegion(j))) continue;
                        list.add(j);
                    }
                    this.elementsout2[i] = ArrayUtil.toIntArray(list);
                    continue;
                }
                this.elementsout2[i] = ArrayUtil.iota(this.nel);
            }
        } else {
            this.ispecout2 = null;
            this.elementsout2 = null;
        }
    }

    @Override
    public synchronized void init(String magic) {
        if (this.users++ > 0) {
            return;
        }
        try {
            this._init();
        }
        catch (UnsatisfiedLinkError e) {
            log.warn("java.library.path: {}", Settings.getProperty("java.library.path"));
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            log.warn("java.library.path: {}", Settings.getProperty("java.library.path"));
            throw new RuntimeException(e);
        }
    }

    protected void _init() throws Exception {
        FileFormat fileFormat = FileFormat.getFileFormat("HDF5");
        if (fileFormat == null) {
            throw new UnsatisfiedLinkError("hdf5");
        }
        log.debug("Opening output file {}", this.outputFile);
        this.output = (H5File)fileFormat.create(this.outputFile.toString());
        assert (this.output != null);
        try {
            this.output.open();
        }
        catch (Exception e) {
            log.error("Failed to open results file {}", this.outputFile);
            throw e;
        }
        this.root = (Group)((DefaultMutableTreeNode)this.output.getRootNode()).getUserObject();
        this.writeManifest();
    }

    @Override
    public synchronized void close() {
        if (--this.users > 0) {
            return;
        }
        log.info("Closing output file {}", this.outputFile);
        try {
            for (Map.Entry<Integer, Trial> k_v : this.trials.entrySet()) {
                this.closeTrial(k_v.getKey(), null);
            }
            this.output.close();
        }
        catch (Exception e) {
            log.error("Failed to close results file {}", this.outputFile, e);
        }
    }

    @Override
    public File outputFile() {
        return this.outputFile;
    }

    protected void writeManifest() throws Exception {
        Manifest manifest = Settings.getManifest();
        this.writeMap(this.root, manifest.getMainAttributes().entrySet());
    }

    protected Group model() throws Exception {
        if (this.model == null) {
            this.model = this.output.createGroup("model", this.root);
            ResultWriterHDF5.setAttribute((HObject)this.model, "TITLE", "model parameters");
        }
        return this.model;
    }

    protected Trial getTrial(int trial) throws Exception {
        Trial t = this.trials.get(trial);
        if (t == null) {
            t = this.createTrial(trial);
            Trial old = this.trials.put(trial, t);
            assert (old == null);
        }
        return t;
    }

    protected Trial createTrial(int trial) throws Exception {
        String name = "trial" + trial;
        Group group = this.output.createGroup(name, this.root);
        ResultWriterHDF5.setAttribute((HObject)group, "TITLE", "trial " + trial);
        return new Trial(group);
    }

    protected void closeTrial(int trial, IGridCalc source) throws Exception {
        Trial t = this.trials.get(trial);
        if (t == null) {
            return;
        }
        t.close(source);
        this.trials.remove(trial);
    }

    @Override
    public synchronized void closeTrial(IGridCalc source) {
        try {
            this.closeTrial(source.trial(), source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void writeGrid(VolumeGrid vgrid, double startTime, IGridCalc source) {
        try {
            this._writeGrid(vgrid, startTime, source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void _writeGrid(VolumeGrid vgrid, double startTime, IGridCalc source) throws Exception {
        Trial t = this.getTrial(source.trial());
        t.writeSimulationData(source);
        if (source.trial() > 0) {
            return;
        }
        Group model = this.model();
        t._writeGrid(vgrid, startTime, source);
        this.writeSpeciesVector("species", "names of all species", model, this.species, null);
        t.writeRegionLabels(model, source);
        t.writeStimulationData(model, source);
        t.writeReactionData(model, source);
        t.writeEventData(model, source);
        Group output_info = this.output.createGroup("output", model);
        ResultWriterHDF5.setAttribute((HObject)output_info, "TITLE", "output species");
        t.writeOutputInfo(output_info);
        String s = source.getSource().serialize();
        Dataset ds = this.writeVector("serialized_config", model, s);
        ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "serialized config");
        ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "XML");
    }

    @Override
    public synchronized void writeOutputInterval(double time, IGridCalc source) {
        this.writeOutputScheme(-1, time, source);
    }

    @Override
    public synchronized void writeOutputScheme(int i, double time, IGridCalc source) {
        try {
            Trial t = this.getTrial(source.trial());
            t._writeOutput(i + 1, time, source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void writeEventStatistics(double time, IGridCalc source) {
        try {
            Trial t = this.getTrial(source.trial());
            t.writeEventStatistics(time, source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T getSomething(H5File h5, String path) throws Exception {
        Dataset obj = (Dataset)h5.get(path);
        if (obj == null) {
            log.error("Failed to retrieve \"{}\"", path);
            throw new Exception("Path \"" + path + "\" not found");
        }
        return (T)obj.getData();
    }

    private static int[][] loadPopulationFromTime(H5File h5, int trial, String output_set, double pop_from_time) throws Exception {
        int index;
        String path = "/trial" + trial + "/output/" + output_set;
        double[] times = (double[])ResultWriterHDF5.getSomething(h5, path + "/times");
        if (pop_from_time == -1.0) {
            index = times.length - 1;
        } else {
            if (pop_from_time < 0.0) {
                throw new Exception("Time must be nonnegative or -1");
            }
            index = Arrays.binarySearch(times, pop_from_time);
            if (index < 0) {
                throw new Exception("time= " + pop_from_time + " not found in " + path + "/times");
            }
        }
        String poppath = path + "/population";
        Dataset obj = (Dataset)h5.get(poppath);
        if (obj == null) {
            log.error("Failed to retrieve \"{}\"", path);
            throw new Exception("Path \"" + path + "\" not found");
        }
        obj.init();
        int rank = obj.getRank();
        long[] dims = obj.getDims();
        long[] start = obj.getStartDims();
        long[] selected = obj.getSelectedDims();
        int[] selectedIndex = obj.getSelectedIndex();
        log.info("Retrieving population from {}:{} row {}", h5, poppath, index);
        log.debug("pristine rank={} dims={} start={} selected={} selectedIndex={}", rank, dims, start, selected, selectedIndex);
        start[0] = index;
        selected[0] = 1L;
        selected[1] = dims[1];
        selected[2] = dims[2];
        log.debug("selected rank={} dims={} start={} selected={} selectedIndex={}", rank, dims, start, selected, selectedIndex);
        int[] data = (int[])obj.getData();
        int[][] pop = ArrayUtil.reshape(data, (int)dims[1], (int)dims[2]);
        return pop;
    }

    protected static LoadModelResult _loadModel(File filename, int trial, Double pop_from_time) throws Exception {
        long seed;
        H5File h5;
        FileFormat fileFormat = FileFormat.getFileFormat("HDF5");
        if (fileFormat == null) {
            throw new UnsatisfiedLinkError("hdf5");
        }
        log.debug("Opening input file {}", filename);
        try {
            h5 = (H5File)fileFormat.createInstance(filename.toString(), 0);
        }
        catch (Exception e) {
            log.error("Failed to open input file {}", filename);
            throw e;
        }
        assert (h5 != null);
        String[] data = (String[])ResultWriterHDF5.getSomething(h5, "/model/serialized_config");
        String xml = data[0];
        try {
            long[] data2 = (long[])ResultWriterHDF5.getAttribute(h5, "/trial" + trial, "simulation_seed");
            seed = data2[0];
        }
        catch (Exception e) {
            long[] data3 = (long[])ResultWriterHDF5.getSomething(h5, "/trial" + trial + "/simulation_seed");
            seed = data3[0];
        }
        String[] species = (String[])ResultWriterHDF5.getSomething(h5, "/model/species");
        int[][] pop = null;
        if (!Double.isNaN(pop_from_time)) {
            pop = ResultWriterHDF5.loadPopulationFromTime(h5, trial, "__main__", pop_from_time);
        }
        h5.close();
        return new LoadModelResult(xml, seed, species, pop);
    }

    public static LoadModelResult loadModel(File filename, int trial, double pop_from_time) {
        try {
            return ResultWriterHDF5._loadModel(filename, trial, pop_from_time);
        }
        catch (Exception e) {
            log.error("Failed to read input file \"{}\"", filename);
            throw new RuntimeException(e);
        }
    }

    protected static void setAttribute(HObject obj, String name, String value) throws Exception {
        Attribute attr = new Attribute(name, short_str_t, new long[0], new String[]{value});
        obj.writeMetadata(attr);
        log.debug("Wrote metadata on {} {}={}", obj, name, value);
    }

    protected static void setAttribute(HObject obj, String name, long value) throws Exception {
        Attribute attr = new Attribute(name, long_t, new long[0], new long[]{value});
        obj.writeMetadata(attr);
        log.debug("Wrote metadata on {} {}={}", obj, name, value);
    }

    protected static <T> T getAttribute(H5File h5, String path, String name) throws Exception {
        HObject obj = h5.get(path);
        if (obj == null) {
            log.error("Failed to retrieve \"{}\"", path);
            throw new Exception("Path \"" + path + "\" not found");
        }
        List list = obj.getMetadata();
        for (Attribute attr : list) {
            if (!name.equals(attr.getName())) continue;
            return (T)attr.getValue();
        }
        throw new Exception("Atribute \"" + name + "\" not found on \"" + path + "\"");
    }

    protected Dataset _writeArray(String name, Group parent, H5Datatype type, long[] dims, Object data) throws Exception {
        boolean chunked = ArrayUtil.product(dims) > 0L;
        log.debug("Creating {} with dims=[{}] size=[{}] chunks=[{}]...", name, ArrayUtil.xJoined(dims), "", chunked ? ArrayUtil.xJoined(dims) : "");
        Dataset ds = this.output.createScalarDS(name, parent, type, dims, chunked ? (long[])dims.clone() : null, chunked ? (long[])dims.clone() : null, chunked ? compression_level : 0, data);
        log.info("Created {} with dims=[{}] size=[{}] chunks=[{}]", name, ArrayUtil.xJoined(dims), "", chunked ? ArrayUtil.xJoined(dims) : "");
        return ds;
    }

    protected Dataset writeArray(String name, Group parent, double[][] items) throws Exception {
        int maxlength = ArrayUtil.maxLength(items);
        long[] dims = new long[]{items.length, maxlength};
        double[] flat = ArrayUtil.flatten(items, maxlength);
        return this._writeArray(name, parent, double_t, dims, flat);
    }

    protected Dataset writeArray(String name, Group parent, int[][] items, int fill) throws Exception {
        int maxlength = ArrayUtil.maxLength(items);
        long[] dims = new long[]{items.length, maxlength};
        int[] flat = ArrayUtil.flatten(items, (long)maxlength, fill);
        return this._writeArray(name, parent, int_t, dims, flat);
    }

    protected Dataset writeVector(String name, Group parent, String ... items) throws Exception {
        int maxlength = Math.max(ArrayUtil.maxLength(items) * 4, 1);
        long[] dims = new long[]{items.length};
        H5Datatype string_t = new H5Datatype(3, maxlength, -1, -1);
        return this._writeArray(name, parent, string_t, dims, items);
    }

    protected void writeMap(Group element, Set<Map.Entry<Object, Object>> set) throws Exception {
        for (Map.Entry<Object, Object> entry : set) {
            String key = entry.getKey().toString();
            String value = (String)entry.getValue();
            ResultWriterHDF5.setAttribute((HObject)element, key, value);
        }
    }

    protected Dataset writeVector(String name, Group parent, double ... items) throws Exception {
        long[] dims = new long[]{items.length};
        return this._writeArray(name, parent, double_t, dims, items);
    }

    protected Dataset writeVector(String name, Group parent, int ... items) throws Exception {
        long[] dims = new long[]{items.length};
        return this._writeArray(name, parent, int_t, dims, items);
    }

    protected Dataset writeVector(String name, Group parent, long ... items) throws Exception {
        long[] dims = new long[]{items.length};
        return this._writeArray(name, parent, long_t, dims, items);
    }

    protected void writeSpeciesVector(String name, String title, Group parent, String[] species, int[] which) throws Exception {
        String[] specout;
        if (which == null) {
            specout = species;
        } else {
            specout = new String[which.length];
            for (int i = 0; i < which.length; ++i) {
                specout[i] = species[which[i]];
            }
        }
        Dataset ds = this.writeVector(name, parent, specout);
        ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", title);
        ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nspecies]");
        ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "text");
    }

    protected H5ScalarDS createExtensibleArray(String name, Group parent, Datatype type, String TITLE, String LAYOUT, String UNITS, long ... dims) throws Exception {
        long[] maxdims = (long[])dims.clone();
        maxdims[0] = HDF5Constants.H5F_UNLIMITED;
        long[] chunks = (long[])dims.clone();
        chunks[0] = 1L;
        if (ArrayUtil.product(chunks) == 0L) {
            throw new RuntimeException("Empty chunks: " + ArrayUtil.xJoined(chunks));
        }
        while (ArrayUtil.product(chunks) < 1024L) {
            chunks[0] = chunks[0] * 2L;
        }
        dims[0] = 0L;
        int filespace_id = H5.H5Screate_simple(dims.length, dims, maxdims);
        int dcpl_id = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
        H5.H5Pset_shuffle(dcpl_id);
        H5.H5Pset_deflate(dcpl_id, compression_level);
        H5.H5Pset_chunk(dcpl_id, dims.length, chunks);
        String path = parent.getFullName() + "/" + name;
        H5.H5Dcreate(this.output.getFID(), path, type.toNative(), filespace_id, HDF5Constants.H5P_DEFAULT, dcpl_id, HDF5Constants.H5P_DEFAULT);
        H5ScalarDS ds = new H5ScalarDS(this.output, path, "/");
        ((Dataset)ds).init();
        log.info("Created {} with dims=[{}] size=[{}] chunks=[{}]", name, ArrayUtil.xJoined(dims), ArrayUtil.xJoined(maxdims), ArrayUtil.xJoined(chunks));
        ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", TITLE);
        ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", LAYOUT);
        ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", UNITS);
        return ds;
    }

    protected static void extendExtensibleArray(H5ScalarDS ds, long howmuch) throws Exception {
        long[] start = ds.getStartDims();
        long[] dims = ds.getDims();
        long[] selected = ds.getSelectedDims();
        start[0] = dims[0];
        dims[0] = dims[0] + howmuch;
        ds.extend(dims);
        selected[0] = howmuch;
        System.arraycopy(dims, 1, selected, 1, dims.length - 1);
        Object data = ds.getData();
        int length = 0;
        if (data instanceof int[]) {
            length = ((int[])data).length;
        } else if (data instanceof double[]) {
            length = ((double[])data).length;
        } else assert (false);
        if ((long)length < ArrayUtil.product(selected)) {
            log.error("howmuch={} start={} dims={} selected={} getSelected\u2192{} getStride={} getDims={} getStartDims={} getMaxDims={} getChunkSize={} {}\u2194{}\ndata={}", howmuch, start, dims, selected, ds.getSelectedDims(), ds.getStride(), ds.getDims(), ds.getStartDims(), ds.getMaxDims(), ds.getChunkSize(), length, ArrayUtil.product(selected), data);
        }
    }

    protected static void getGridNumbers(int[][] dst, int[] elements, int[] ispecout, IGridCalc source) {
        for (int i = 0; i < elements.length; ++i) {
            for (int j = 0; j < ispecout.length; ++j) {
                dst[i][j] = source.getGridPartNumb(elements[i], ispecout[j]);
                assert (dst[i][j] >= 0) : "" + i + " " + j + " " + dst[i][j];
            }
        }
    }

    static {
        LibUtil.addLibraryPaths("/usr/lib64/jhdf", "/usr/lib64/jhdf5", "/usr/lib/jhdf", "/usr/lib/jhdf5");
        compression_level = Settings.getProperty("neurord.compression", "Compression level in HDF5 output", 1);
        double_t = new H5Datatype(1, 8, -1, -1);
        int_t = new H5Datatype(0, 4, -1, -1);
        long_t = new H5Datatype(0, 8, -1, -1);
        short_str_t = new H5Datatype(3, 100, -1, -1);
    }

    public static class LoadModelResult {
        public final String xml;
        public final long seed;
        public final String[] species;
        public final int[][] population;

        LoadModelResult(String xml, long seed, String[] species, int[][] population) {
            this.xml = xml;
            this.seed = seed;
            this.species = species;
            this.population = population;
        }
    }

    protected class Trial {
        protected final Group group;
        protected final Group sim;
        protected List<PopulationOutput> populations = new ArrayList<PopulationOutput>();
        protected H5ScalarDS event_statistics;
        protected H5ScalarDS statistics_times;
        protected Group events;
        protected List<IGridCalc.Happening> events_cache;
        protected H5ScalarDS events_event;
        protected H5ScalarDS events_kind;
        protected H5ScalarDS events_extent;
        protected H5ScalarDS events_time;
        protected H5ScalarDS events_waited;
        protected H5ScalarDS events_original;
        private boolean initEvents_warning = false;

        protected Trial(Group group) throws Exception {
            this.group = group;
            this.sim = ResultWriterHDF5.this.output.createGroup("output", group);
            ResultWriterHDF5.setAttribute((HObject)this.sim, "TITLE", "results of the simulation");
        }

        protected void close(IGridCalc source) throws Exception {
            if (this.events_cache != null) {
                this.flushEvents(Double.POSITIVE_INFINITY, true);
            }
            for (PopulationOutput output : this.populations) {
                output.flushPopulation(Double.POSITIVE_INFINITY);
            }
        }

        protected void _writeGrid(VolumeGrid vgrid, double startTime, IGridCalc source) throws Exception {
            log.debug("Writing grid at time {} for trial {}", startTime, source.trial());
            assert (ResultWriterHDF5.this.nel == vgrid.size());
            long[] dims = new long[]{ResultWriterHDF5.this.nel};
            long[] chunks = new long[]{ResultWriterHDF5.this.nel};
            String[] memberNames = new String[]{"x0", "y0", "z0", "x1", "y1", "z1", "x2", "y2", "z2", "x3", "y3", "z3", "volume", "deltaZ", "label", "region_name", "region", "type", "group"};
            Object[] memberTypes = new Datatype[memberNames.length];
            Arrays.fill(memberTypes, double_t);
            memberTypes[14] = short_str_t;
            memberTypes[15] = short_str_t;
            memberTypes[16] = int_t;
            memberTypes[17] = short_str_t;
            memberTypes[18] = short_str_t;
            assert (memberTypes.length == 19);
            Vector<Object> data = vgrid.gridData();
            String[] labels = new String[ResultWriterHDF5.this.nel];
            for (int i = 0; i < ResultWriterHDF5.this.nel; ++i) {
                labels[i] = vgrid.getLabel(i);
                if (labels[i] != null) continue;
                labels[i] = "element" + i;
            }
            data.add(labels);
            String[] region_names = vgrid.getElementRegions();
            assert (region_names.length == ResultWriterHDF5.this.nel);
            data.add(region_names);
            List<String> regions = Arrays.asList(vgrid.getRegionLabels());
            int[] region_indices = new int[region_names.length];
            for (int i = 0; i < region_indices.length; ++i) {
                region_indices[i] = regions.indexOf(region_names[i]);
            }
            assert (region_indices.length == ResultWriterHDF5.this.nel);
            data.add(region_indices);
            boolean[] membranes = vgrid.getSubmembranes();
            assert (membranes.length == ResultWriterHDF5.this.nel);
            String[] types = new String[ResultWriterHDF5.this.nel];
            for (int i = 0; i < ResultWriterHDF5.this.nel; ++i) {
                types[i] = membranes[i] ? "submembrane" : "cytosol";
            }
            data.add(types);
            labels = new String[ResultWriterHDF5.this.nel];
            for (int i = 0; i < ResultWriterHDF5.this.nel; ++i) {
                labels[i] = vgrid.getGroupID(i);
                if (labels[i] != null) continue;
                labels[i] = "";
            }
            data.add(labels);
            Dataset grid = ResultWriterHDF5.this.output.createCompoundDS("grid", ResultWriterHDF5.this.model(), dims, null, chunks, compression_level, memberNames, (Datatype[])memberTypes, null, data);
            log.info("Created {} with dims=[{}] size=[{}] chunks=[{}]", "grid", ArrayUtil.xJoined(dims), "", ArrayUtil.xJoined(chunks));
            ResultWriterHDF5.setAttribute((HObject)grid, "TITLE", "voxels");
            ResultWriterHDF5.setAttribute((HObject)grid, "LAYOUT", "[nel \u00d7 {x,y,z, x,y,z, x,y,z, x,y,z, volume, deltaZ, label, region#, type, group}]");
            Dataset ds = ResultWriterHDF5.this.writeArray("neighbors", ResultWriterHDF5.this.model(), vgrid.getPerElementNeighbors(), -1);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "adjacency mapping between voxels");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nel \u00d7 neighbors*]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
            ds = ResultWriterHDF5.this.writeArray("couplings", ResultWriterHDF5.this.model(), vgrid.getPerElementCouplingConstants());
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "coupling rate between voxels");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nel \u00d7 neighbors*]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "nm^2 / nm ?");
        }

        protected void writeSimulationData(IGridCalc source) throws Exception {
            long seed = source.getSimulationSeed();
            log.debug("Writing simulation seed ({}) for trial {}", source.trial());
            ResultWriterHDF5.setAttribute((HObject)this.group, "simulation_seed", seed);
        }

        protected void writeRegionLabels(Group parent, IGridCalc source) throws Exception {
            String[] regions = source.getSource().getVolumeGrid().getRegionLabels();
            Dataset ds = ResultWriterHDF5.this.writeVector("regions", parent, regions);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "names of regions");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nregions]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "text");
        }

        protected void writeStimulationData(Group parent, IGridCalc source) throws Exception {
            StimulationTable table = source.getSource().getStimulationTable();
            Group group = ResultWriterHDF5.this.output.createGroup("stimulation", parent);
            ResultWriterHDF5.setAttribute((HObject)group, "TITLE", "stimulation parameters");
            Object targets = table.getTargetIDs();
            if (((String[])targets).length == 0) {
                log.debug("Not writing stimulation data (empty targets)");
                return;
            }
            Dataset ds = ResultWriterHDF5.this.writeVector("target_names", group, (String)targets);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "names of stimulation targets");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nstimulations]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "text");
            targets = source.getSource().getStimulationTargets();
            ds = ResultWriterHDF5.this.writeArray("targets", group, (int[][])targets, -1);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "stimulated voxels");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[??? \u00d7 ???]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
        }

        protected void writeReactionData(Group parent, IGridCalc source) throws Exception {
            ReactionTable table = source.getSource().getReactionTable();
            Group group = ResultWriterHDF5.this.output.createGroup("reactions", parent);
            ResultWriterHDF5.setAttribute((HObject)group, "TITLE", "reaction scheme");
            int[][] indices = table.getReactantIndices();
            Dataset ds = ResultWriterHDF5.this.writeArray("reactants", group, indices, -1);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "reactant indices");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nreact \u00d7 nreactants*]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
            indices = table.getProductIndices();
            ds = ResultWriterHDF5.this.writeArray("products", group, indices, -1);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "product indices");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nreact \u00d7 nproducts*]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
            int[][] stoichio = table.getReactantStoichiometry();
            ds = ResultWriterHDF5.this.writeArray("reactant_stoichiometry", group, stoichio, -1);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "reactant stoichiometry");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nreact \u00d7 nreactants*]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
            stoichio = table.getProductStoichiometry();
            ds = ResultWriterHDF5.this.writeArray("product_stoichiometry", group, stoichio, -1);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "product stoichiometry");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nreact \u00d7 nproducts*]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
            double[] rates = table.getRates();
            ds = ResultWriterHDF5.this.writeVector("rates", group, rates);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "reaction rates");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nreact]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "transitions/ms");
            int[] pairs = (int[])table.getReversiblePairs().clone();
            for (int i = 0; i < pairs.length; ++i) {
                if (pairs[i] < 0) continue;
                assert (pairs[pairs[i]] == -1);
                pairs[pairs[i]] = i;
            }
            ds = ResultWriterHDF5.this.writeVector("reversible_pairs", group, pairs);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "indices of reverse reaction");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nreact]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
        }

        protected void writeEventData(Group parent, IGridCalc source) throws Exception {
            Collection<IGridCalc.Event> events = source.getEvents();
            if (events == null) {
                log.debug("No dependency data, not writing dependency scheme");
                return;
            }
            Group group = ResultWriterHDF5.this.output.createGroup("events", parent);
            ResultWriterHDF5.setAttribute((HObject)group, "TITLE", "description of all event types");
            String[] descriptions = new String[events.size()];
            int[] types = new int[events.size()];
            int[][] elements = new int[events.size()][2];
            int[][] substrates = new int[events.size()][];
            int[][] stoichiometries = new int[events.size()][];
            Object dependent = null;
            if (source.getSource().writeDependencies()) {
                log.debug("Dependency scheme writing enabled");
                dependent = new int[events.size()][];
            }
            for (IGridCalc.Event event : events) {
                int i = event.event_number();
                descriptions[i] = event.description();
                types[i] = event.event_type().ordinal();
                elements[i][0] = event.element();
                elements[i][1] = event.element2();
                substrates[i] = event.substrates();
                stoichiometries[i] = event.substrate_stoichiometry();
                if (dependent == null) continue;
                Collection<IGridCalc.Event> dep = event.dependent();
                dependent[i] = new int[dep.size()];
                int j = 0;
                for (IGridCalc.Event child : dep) {
                    dependent[i][j++] = child.event_number();
                }
            }
            Dataset ds = ResultWriterHDF5.this.writeVector("descriptions", group, descriptions);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "signatures of reaction channels");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nchannel]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "text");
            ds = ResultWriterHDF5.this.writeArray("elements", group, elements, -1);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "voxel numbers of reaction channels");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nchannel x {source,target}]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "index");
            ds = ResultWriterHDF5.this.writeVector("types", group, types);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "types of reaction channels");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nchannel]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "enumeration");
            ds = ResultWriterHDF5.this.writeArray("substrates", group, substrates, -1);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "event substrates");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nchannel x nspecies*]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
            ds = ResultWriterHDF5.this.writeArray("stoichiometries", group, stoichiometries, 0);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "substrate stoichiometries");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nchannel x nspecies*]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
            if (dependent != null) {
                ds = ResultWriterHDF5.this.writeArray("dependent", group, (int[][])dependent, -1);
                ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "dependent reaction channels");
                ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nchannel x ndependent*]");
                ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
            }
        }

        protected void writeOutputInfo(Group parent, String identifier, int[] which, int[] elements) throws Exception {
            Group group = ResultWriterHDF5.this.output.createGroup(identifier, parent);
            ResultWriterHDF5.this.writeSpeciesVector("species", "names of output species", group, ResultWriterHDF5.this.species, which);
            Dataset ds = ResultWriterHDF5.this.writeVector("elements", group, elements);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "indices of output elements");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nelements]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "indices");
        }

        protected void writeOutputInfo(Group parent) throws Exception {
            if (ResultWriterHDF5.this.ispecout1 != null) {
                this.writeOutputInfo(parent, "__main__", ResultWriterHDF5.this.ispecout1, ArrayUtil.iota(ResultWriterHDF5.this.nel));
            }
            if (ResultWriterHDF5.this.outputSets != null) {
                for (int i = 0; i < ResultWriterHDF5.this.outputSets.size(); ++i) {
                    IOutputSet set = ResultWriterHDF5.this.outputSets.get(i);
                    this.writeOutputInfo(parent, set.getIdentifier(), ResultWriterHDF5.this.ispecout2[i], ResultWriterHDF5.this.elementsout2[i]);
                }
            }
        }

        protected void _writeOutput(int i, double time, IGridCalc source) throws Exception {
            this.writePopulation(i, time, source);
            if (i == 0) {
                this.writeEvents(time, source);
            }
        }

        protected boolean initPopulation(int i, IGridCalc source) throws Exception {
            if (i >= this.populations.size() || this.populations.get(i) == null) {
                int[] ispecout;
                int[] elements;
                String ident;
                if (i == 0) {
                    if (ResultWriterHDF5.this.ispecout1.length == 0) {
                        return false;
                    }
                    ident = "__main__";
                    elements = ArrayUtil.iota(ResultWriterHDF5.this.nel);
                    ispecout = ResultWriterHDF5.this.ispecout1;
                } else {
                    IOutputSet set = ResultWriterHDF5.this.outputSets.get(i - 1);
                    assert (set != null);
                    log.debug("elementsout2: {} {}", new Object[]{ResultWriterHDF5.this.elementsout2, ""});
                    log.debug("i:{} {}", i, ResultWriterHDF5.this.elementsout2[i - 1]);
                    elements = ResultWriterHDF5.this.elementsout2[i - 1];
                    ispecout = ResultWriterHDF5.this.ispecout2[i - 1];
                    ident = set.getIdentifier();
                }
                Group group = ResultWriterHDF5.this.output.createGroup(ident, this.sim);
                PopulationOutput conc = new PopulationOutput(group, ident, elements, ispecout);
                this.populations.add(i, conc);
            }
            return true;
        }

        protected void writePopulation(int i, double time, IGridCalc source) throws Exception {
            if (!this.initPopulation(i, source)) {
                return;
            }
            this.populations.get(i).writePopulation(time, source);
        }

        protected void initEventStatistics(boolean periodic, IGridCalc source, int expected) throws Exception {
            assert (this.event_statistics == null);
            String type = "events";
            this.event_statistics = ResultWriterHDF5.this.createExtensibleArray("event_statistics", this.sim, int_t, "actual event counts since last snapshot", "[times \u00d7 " + type + " \u00d7 species]", "count", 1024L, expected, 2L);
            if (periodic) {
                this.statistics_times = ResultWriterHDF5.this.createExtensibleArray("statistics_times", this.sim, double_t, "times when statistics were written", "[times]", "ms", 1024L);
            }
            if (source.trial() > 0) {
                return;
            }
            String[] descriptions = new String[expected];
            for (IGridCalc.Event ev : source.getEvents()) {
                int stat_index = ev.stat_index();
                if (stat_index < 0) continue;
                descriptions[stat_index] = ev.stat_index_description();
            }
            for (int i = 0; i < descriptions.length; ++i) {
                if (descriptions[i] != null) continue;
                descriptions[i] = "";
            }
            Dataset ds = ResultWriterHDF5.this.writeVector("event_statistics", ResultWriterHDF5.this.model(), descriptions);
            ResultWriterHDF5.setAttribute((HObject)ds, "TITLE", "descriptions of statistics rows");
            ResultWriterHDF5.setAttribute((HObject)ds, "LAYOUT", "[nstatistics]");
            ResultWriterHDF5.setAttribute((HObject)ds, "UNITS", "text");
        }

        protected void writeEventStatistics(double time, IGridCalc source) throws Exception {
            int[][] stats = source.getEventStatistics();
            if (stats == null) {
                log.debug("Not writing event statistics (no data)");
                return;
            }
            if (this.event_statistics == null) {
                this.initEventStatistics(source.getSource().getStatisticsInterval() > 0.0, source, stats.length);
                if (this.event_statistics == null) {
                    return;
                }
            }
            log.debug("Writing event statistics at time {}", time);
            ResultWriterHDF5.extendExtensibleArray(this.event_statistics, 1L);
            long[] dims = this.event_statistics.getDims();
            int[] data = (int[])this.event_statistics.getData();
            ArrayUtil._flatten(data, stats, 2L, 0);
            this.event_statistics.write(data);
            if (this.statistics_times != null) {
                ResultWriterHDF5.extendExtensibleArray(this.statistics_times, 1L);
                double[] data2 = (double[])this.statistics_times.getData();
                data2[0] = time;
                this.statistics_times.write(data2);
            }
        }

        protected void initEvents() throws Exception {
            assert (this.events == null);
            this.events = ResultWriterHDF5.this.output.createGroup("events", this.sim);
            this.events_time = ResultWriterHDF5.this.createExtensibleArray("times", this.events, double_t, "at what time the event happened", "[time]", "ms", 8192L);
            this.events_waited = ResultWriterHDF5.this.createExtensibleArray("waited", this.events, double_t, "time since the previous instance of this event", "[waited]", "ms", 8192L);
            this.events_original = ResultWriterHDF5.this.createExtensibleArray("original_wait", this.events, double_t, "time originally schedule to wait", "[original_wait]", "ms", 8192L);
            this.events_event = ResultWriterHDF5.this.createExtensibleArray("events", this.events, int_t, "index of the event that happened", "[event#]", "", 8192L);
            this.events_kind = ResultWriterHDF5.this.createExtensibleArray("kinds", this.events, int_t, "mechanism of the event that happened", "[kind]", "", 8192L);
            this.events_extent = ResultWriterHDF5.this.createExtensibleArray("extents", this.events, int_t, "the extent of the reaction or event", "[extent]", "count", 8192L);
            long chunk_size = this.events_event.getChunkSize()[0];
            this.events_cache = new ArrayList<IGridCalc.Happening>((int)chunk_size);
        }

        protected void flushEvents(double time, boolean all) throws Exception {
            int m;
            int howmuch;
            int n = this.events_cache.size();
            if (!all) {
                n -= n % 8192;
            }
            for (m = 0; m < n; m += howmuch) {
                int i;
                howmuch = Math.min(n - m, 8192);
                log.debug("Writing {} events at time {}", howmuch, time);
                ResultWriterHDF5.extendExtensibleArray(this.events_time, howmuch);
                Object[] data = (double[])this.events_time.getData();
                for (i = 0; i < howmuch; ++i) {
                    data[i] = this.events_cache.get(m + i).time();
                }
                this.events_time.write(data);
                ResultWriterHDF5.extendExtensibleArray(this.events_waited, howmuch);
                data = (double[])this.events_waited.getData();
                for (i = 0; i < howmuch; ++i) {
                    data[i] = this.events_cache.get(m + i).waited();
                }
                this.events_waited.write(data);
                ResultWriterHDF5.extendExtensibleArray(this.events_original, howmuch);
                data = (double[])this.events_original.getData();
                for (i = 0; i < howmuch; ++i) {
                    data[i] = this.events_cache.get(m + i).original_wait();
                }
                this.events_original.write(data);
                ResultWriterHDF5.extendExtensibleArray(this.events_event, howmuch);
                data = (int[])this.events_event.getData();
                for (i = 0; i < howmuch; ++i) {
                    data[i] = this.events_cache.get(m + i).event_number();
                }
                this.events_event.write(data);
                ResultWriterHDF5.extendExtensibleArray(this.events_kind, howmuch);
                data = (int[])this.events_kind.getData();
                for (i = 0; i < howmuch; ++i) {
                    data[i] = this.events_cache.get(m + i).kind().ordinal();
                }
                this.events_kind.write(data);
                ResultWriterHDF5.extendExtensibleArray(this.events_extent, howmuch);
                data = (int[])this.events_extent.getData();
                for (i = 0; i < howmuch; ++i) {
                    data[i] = this.events_cache.get(m + i).extent();
                }
                this.events_extent.write(data);
            }
            if (m == this.events_cache.size()) {
                this.events_cache.clear();
            } else if (m > 0) {
                this.events_cache = this.events_cache.subList(n, this.events_cache.size());
            }
        }

        protected void writeEvents(double time, IGridCalc source) throws Exception {
            Collection<IGridCalc.Happening> events = source.getHappenings();
            if (events == null) {
                if (!this.initEvents_warning) {
                    log.debug("No events, not writing anything");
                    this.initEvents_warning = true;
                }
                return;
            }
            if (this.events == null) {
                this.initEvents();
            }
            this.events_cache.addAll(events);
            if (this.events_cache.size() > 8192) {
                this.flushEvents(time, false);
            }
        }
    }

    protected class PopulationOutput {
        final H5ScalarDS concs;
        final int[][][] concs_cache;
        final H5ScalarDS times;
        final double[] times_cache;
        protected int concs_times_count;
        final int[] ispecout;
        final int[] elements;

        protected PopulationOutput(Group parent, String name, int[] elements, int[] ispecout) throws Exception {
            int cache_size;
            this.ispecout = ispecout;
            this.elements = elements;
            for (cache_size = 1024; cache_size * elements.length * ispecout.length * 4 > 524288 && cache_size > 1; cache_size /= 2) {
            }
            log.info("Using population cache_size of {}", cache_size);
            this.concs = ResultWriterHDF5.this.createExtensibleArray("population", parent, int_t, "population of species in voxels over time", "[snapshot \u00d7 nel \u00d7 nspecout]", "count", cache_size, elements.length, ispecout.length);
            this.times = ResultWriterHDF5.this.createExtensibleArray("times", parent, double_t, "times when snapshots were written", "[times]", "ms", cache_size);
            this.concs_cache = new int[cache_size][elements.length][ispecout.length];
            this.times_cache = new double[cache_size];
        }

        protected void writePopulation(double time, IGridCalc source) throws Exception {
            ResultWriterHDF5.getGridNumbers(this.concs_cache[this.concs_times_count], this.elements, this.ispecout, source);
            this.times_cache[this.concs_times_count] = time;
            ++this.concs_times_count;
            if (this.concs_times_count == this.times_cache.length) {
                this.flushPopulation(time);
            }
        }

        protected void flushPopulation(double time) throws Exception {
            if (this.concs_times_count == 0) {
                return;
            }
            log.debug("Writing {} pop entries at time {}", this.concs_times_count, time);
            ResultWriterHDF5.extendExtensibleArray(this.concs, this.concs_times_count);
            Object[] data = (int[])this.concs.getData();
            int[][][] cache = this.concs_times_count == this.times_cache.length ? this.concs_cache : (int[][][])Arrays.copyOfRange(this.concs_cache, 0, this.concs_times_count);
            ArrayUtil._flatten(data, cache, (long)cache[0][0].length, 0);
            this.concs.write(data);
            ResultWriterHDF5.extendExtensibleArray(this.times, this.concs_times_count);
            data = (double[])this.times.getData();
            System.arraycopy(this.times_cache, 0, data, 0, this.concs_times_count);
            this.times.write(data);
            this.concs_times_count = 0;
        }
    }
}

