/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.grid;

import neurord.util.ArrayUtil;

public abstract class SecondOrderSolver {
    int[] stoichiometry;
    int[] X0;
    String description;
    double a;
    double b;
    double c;

    public SecondOrderSolver(int[] stoichiometry, int[] X0, String description, double a, double b, double c) {
        this.stoichiometry = stoichiometry;
        this.X0 = X0;
        this.description = description;
        this.a = a;
        this.b = b;
        this.c = c;
    }

    double extent_to_count(double extent, int specie) {
        assert (specie < this.stoichiometry.length);
        double coeff = this.stoichiometry[specie] / this.stoichiometry[0];
        return coeff * (extent - (double)this.X0[0]) + (double)this.X0[specie];
    }

    abstract double extent(double var1);

    double mean(double t, int specie) {
        double a = this.extent(t);
        return this.extent_to_count(a, specie);
    }

    abstract double variance(double var1, int var3);

    static double[] calc_abc(double r_left, int[] rp, int[] rs, int[] X0_left, double r_right, int[] pp, int[] ps, int[] X0_right) {
        int X0;
        int sX;
        double dc;
        double db;
        double da;
        assert (ArrayUtil.sum(rp) <= 2);
        assert (ArrayUtil.sum(pp) <= 2);
        assert (rp.length == rs.length);
        assert (rp.length == X0_left.length);
        assert (pp.length == ps.length);
        assert (pp.length == X0_right.length);
        for (int s : rs) {
            assert (s > 0) : rs;
        }
        for (int s : ps) {
            assert (s > 0) : ps;
        }
        int sA = rs[0];
        int A0 = X0_left[0];
        if (rp.length == 1 && rp[0] == 2) {
            da = 1.0;
            db = -1.0;
            dc = 0.0;
        } else if (rp.length == 2) {
            assert (rp[0] == 1);
            assert (rp[1] == 1);
            int sY = rp[1];
            int Y0 = X0_left[1];
            da = sY / sA;
            db = Y0 - A0 * sY / sA;
            dc = 0.0;
        } else if (rp.length == 1) {
            assert (rp[0] == 1);
            da = 0.0;
            db = 1.0;
            dc = 0.0;
        } else {
            assert (rp.length == 0);
            dc = 0.0;
            db = 0.0;
            da = 0.0;
        }
        double a = r_left * (double)sA * da;
        double b = r_left * (double)sA * db;
        double c = r_left * (double)sA * dc;
        if (rp.length == 1 && rp[0] == 2) {
            sX = ps[0];
            X0 = X0_right[0];
            da = sX * sX / sA / sA;
            db = sX / sA * (2 * (X0 - A0 * sX / sA) - 1);
            dc = (X0 - A0 * sX / sA) * (X0 - A0 * sX / sA - 1);
        } else if (rp.length == 2) {
            assert (rp[0] == 1);
            assert (rp[1] == 1);
            sX = ps[0];
            X0 = X0_right[0];
            int sY = ps[1];
            int Y0 = X0_right[1];
            da = sX * sY / sA / sA;
            db = sY / sA * (X0 - A0 * sX / sA) + sX / sA * (Y0 - A0 * sY / sA);
            dc = (X0 - A0 * sX / sA) * (Y0 - A0 * sY / sA);
        } else if (rp.length == 1) {
            assert (rp[0] == 1);
            sX = ps[0];
            X0 = X0_right[0];
            da = 0.0;
            db = sX / sA;
            dc = X0 - A0 * sX / sA;
        } else {
            assert (rp.length == 0);
            dc = 0.0;
            db = 0.0;
            da = 0.0;
        }
        return new double[]{a += r_right * (double)sA * da, b += r_right * (double)sA * db, c += r_right * (double)sA * dc};
    }

    static double[] I(double[] x, double a, double b, double c) {
        double Delta = b * b - 4.0 * a * c;
        double[] ans = new double[x.length];
        if (Delta > 0.0) {
            double p2;
            double p1;
            double delta = Math.sqrt(Delta);
            if (a > 0.0) {
                p1 = (-b - delta) / 2.0 / a;
                p2 = (-b + delta) / 2.0 / a;
            } else {
                p1 = (-b + delta) / 2.0 / a;
                p2 = (-b - delta) / 2.0 / a;
            }
            assert (p1 < p2);
            for (int i = 0; i < ans.length; ++i) {
                ans[i] = -Math.log(Math.abs((2.0 * a * x[i] + b + delta) / (2.0 * a * x[i] + b - delta))) / delta;
            }
        } else if (Delta == 0.0) {
            for (int i = 0; i < ans.length; ++i) {
                ans[i] = -2.0 / (2.0 * a * x[i] + b);
            }
        } else {
            double delta = Math.sqrt(-Delta);
            for (int i = 0; i < ans.length; ++i) {
                ans[i] = 2.0 * Math.atan((2.0 * a * x[i] + b) / delta) / delta;
            }
        }
        return ans;
    }

    static double[] I_reverse(double[] I, double a, double b, double c, double x0) {
        double Delta = b * b - 4.0 * a * c;
        double[] ans = new double[I.length];
        if (Delta > 0.0) {
            double p2;
            double p1;
            double delta = Math.sqrt(Delta);
            if (a > 0.0) {
                p1 = (-b - delta) / 2.0 / a;
                p2 = (-b + delta) / 2.0 / a;
            } else {
                p1 = (-b + delta) / 2.0 / a;
                p2 = (-b - delta) / 2.0 / a;
            }
            assert (p1 < p2);
            for (int i = 0; i < ans.length; ++i) {
                double frac = (1.0 + Math.exp(delta * I[i])) / (1.0 - Math.exp(delta * I[i]));
                double y = (-b + delta * frac) / 2.0 / a;
                if (x0 <= p1 && y <= p1 || p1 <= x0 && x0 <= p2 && p1 <= y && y <= p2 || p2 <= x0 && p2 <= y) {
                    ans[i] = y;
                    continue;
                }
                y = (-b + delta / frac) / 2.0 / a;
                if (x0 <= p1 && y <= p1 || p1 <= x0 && x0 <= p2 && p1 <= y && y <= p2 || p2 <= x0 && p2 <= y) {
                    ans[i] = y;
                    continue;
                }
                assert (false);
            }
        } else if (Delta == 0.0) {
            for (int i = 0; i < ans.length; ++i) {
                ans[i] = -(b + 2.0 / I[i]) / 2.0 / a;
            }
        } else {
            double delta = Math.sqrt(-Delta);
            for (int i = 0; i < ans.length; ++i) {
                ans[i] = (delta * Math.tan(delta / 2.0 * I[i]) - b) / 2.0 / a;
            }
        }
        return ans;
    }

    public static SecondOrderSolver make_equation(double r_left, double r_right, int[] rp, int[] rs, int[] X0_left, int[] pp, int[] ps, int[] X0_right, int[] ss, int[] X0, String description) {
        assert (ss[0] != 0);
        double[] abc = SecondOrderSolver.calc_abc(r_left, rp, rs, X0_left, r_right, pp, ps, X0_right);
        if (abc[0] != 0.0) {
            return new Equation2(ss, X0, description, abc[0], abc[1], abc[2]);
        }
        if (abc[1] != 0.0) {
            return new Equation1(ss, X0, description, abc[0], abc[1], abc[2]);
        }
        throw new RuntimeException("not implemented");
    }

    static class Equation2
    extends SecondOrderSolver {
        final double _I0;

        Equation2(int[] stoichiometry, int[] X0, String description, double a, double b, double c) {
            super(stoichiometry, X0, description, a, b, c);
            assert (this.a != 0.0);
            this._I0 = Equation2.I(new double[]{X0[0]}, a, b, c)[0];
        }

        @Override
        double extent(double t) {
            return Equation2.I_reverse(new double[]{t + this._I0}, this.a, this.b, this.c, this.X0[0])[0];
        }

        @Override
        double variance(double t, int specie) {
            int X0 = this.X0[specie];
            double X = this.mean(t, specie);
            return (X - (double)X0) * (double)this.stoichiometry[specie] / (double)this.stoichiometry[0];
        }
    }

    static class Equation1
    extends SecondOrderSolver {
        Equation1(int[] stoichiometry, int[] X0, String description, double a, double b, double c) {
            super(stoichiometry, X0, description, a, b, c);
            assert (this.a == 0.0);
            assert (this.b != 0.0);
        }

        @Override
        double extent(double t) {
            return ((double)this.X0[0] + this.c / this.b) * Math.exp(this.b * t) - this.c / this.b;
        }

        @Override
        double variance(double t, int specie) {
            int X0 = this.X0[specie];
            double X = this.mean(t, specie);
            double p = Math.abs(X - (double)X0) / (double)X0;
            return (double)X0 * p * (1.0 - p);
        }
    }
}

