/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.math;

public final class NRRandom {
    private static int jran = 12345;
    private static int im = 714025;
    private static int ia = 1366;
    private static int ic = 150889;

    public static final double random() {
        jran = (jran * ia + ic) % im;
        double ran = 1.0 * (double)jran / (double)im;
        return ran;
    }

    public static int getSeed() {
        return jran;
    }

    public static void setSeed(int jr) {
        jran = jr;
    }

    public static double nextRandom() {
        return NRRandom.random();
    }

    public static double uniformRV() {
        return NRRandom.random();
    }

    public static int weightedSample(double[] rw) {
        int n = rw.length;
        double a = NRRandom.random();
        int inew = 0;
        while (true) {
            double d;
            a -= rw[inew];
            if (!(d > 0.0) || inew >= n - 1) break;
            ++inew;
        }
        return inew;
    }

    public static double gaussianRV() {
        return NRRandom.grv();
    }

    public static double grv() {
        double r = -1.0;
        double ran1 = 0.0;
        double ran2 = 0.0;
        while (r <= 0.0 || r >= 1.0) {
            jran = (jran * ia + ic) % im;
            ran1 = 2.0 * (double)jran / (double)im - 1.0;
            jran = (jran * ia + ic) % im;
            ran2 = 2.0 * (double)jran / (double)im - 1.0;
            r = ran1 * ran1 + ran2 * ran2;
        }
        double fac = Math.sqrt(-2.0 * Math.log(r) / r);
        double g1 = ran1 * fac;
        return g1;
    }
}

