/*
 * Decompiled with CFR 0.152.
 */
package neurord.reduce;

import java.util.ArrayList;
import neurord.inter.FloatValued;
import neurord.inter.SDState;
import neurord.model.InitialConditions;
import neurord.model.SDRun;
import neurord.numeric.StaticCalc;
import neurord.numeric.math.Matrix;
import neurord.xml.ModelReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Reducer {
    static final Logger log = LogManager.getLogger();
    SDRun sdr;
    SDState sds;
    StaticCalc staticCalc;
    InitialConditions icon;
    ArrayList<FloatValued> afv;
    int nv;
    double[] vols;
    int nel;
    int nspec;
    double[][] ctgt;
    public final ModelReader<InitialConditions> ic_loader = new ModelReader<InitialConditions>(InitialConditions.class);

    public Reducer(SDRun sdModel, SDState sdState) {
        this.sdr = sdModel;
        this.sds = sdState;
    }

    public void reduce() throws Exception {
        log.info("Starting reduce");
        this.icon = this.sdr.getInitialConditions();
        this.afv = this.icon.getFloatValuedElements();
        this.nv = this.afv.size();
        double x0 = 10.0;
        double dx = 0.1;
        log.info("The template provides {} accessible concentration values", this.nv);
        this.staticCalc = new StaticCalc(0, this.sdr);
        this.staticCalc.init();
        this.vols = this.staticCalc.getVolumes();
        this.nspec = this.staticCalc.getNSpec();
        this.nel = this.staticCalc.getNel();
        this.ctgt = this.sds.getConc2();
        for (int j = 0; j < this.nv; ++j) {
            this.afv.get(j).setValue(x0);
        }
        double[] c0 = this.staticCalc.getConcentrations();
        int nconc = c0.length;
        log.info("The template provides {} variable quantities", this.nv);
        log.info("After discretization there are {} state variables arising from {} species in {} elements", nconc, this.nspec, this.nel);
        double[][] bm = new double[nconc][this.nv];
        for (int i = 0; i < this.nv; ++i) {
            for (int j = 0; j < this.nv; ++j) {
                this.afv.get(j).setValue(x0);
            }
            this.afv.get(i).setValue(x0 + dx);
            double[] cwk = this.staticCalc.getConcentrations();
            for (int k = 0; k < nconc; ++k) {
                bm[k][i] = (cwk[k] - c0[k]) / dx;
            }
        }
        double[] tgtconc = this.sds.getConc1();
        Matrix b = new Matrix(bm);
        Matrix bt = b.transpose();
        Matrix mtgtconc = new Matrix(Matrix.COLUMN, tgtconc);
        Matrix btb = bt.times(b);
        Matrix btbi = btb.inverse();
        Matrix res = btbi.times(bt.times(mtgtconc));
        double[] fit = res.getColumn(0);
        String[] spres = this.icon.getTotalPreserved();
        if (spres.length > 0) {
            int ncn = spres.length;
            int[] ispeccon = this.staticCalc.getSpecieIndexes(spres);
            String ss = "";
            for (int i = 0; i < ncn; ++i) {
                ss = ss + " " + spres[i] + "(" + ispeccon[i] + ") ";
            }
            log.info("{} constraint(s) on totals for species {}", ncn, ss);
            double[][] q = new double[ncn][this.nv];
            double[] qtgt = new double[ncn];
            for (int icn = 0; icn < ncn; ++icn) {
                int ispec = ispeccon[icn];
                for (int iel = 0; iel < this.nel; ++iel) {
                    for (int i = 0; i < this.nv; ++i) {
                        double[] dArray = q[icn];
                        int n = i;
                        dArray[n] = dArray[n] + this.vols[iel] * bm[iel * this.nspec + ispec][i];
                    }
                    int n = icn;
                    qtgt[n] = qtgt[n] + this.vols[iel] * this.ctgt[iel][ispec];
                }
            }
            Matrix mq = new Matrix(q);
            Matrix mr = new Matrix(Matrix.COLUMN, fit);
            Matrix mc = new Matrix(Matrix.COLUMN, qtgt);
            Matrix wk1 = mq.times(mr).subtract(mc);
            Matrix wk2 = mq.times(btbi).times(mq.transpose());
            Matrix wk3 = mq.transpose().times(wk2.inverse());
            Matrix wk4 = btbi.times(wk3).times(wk1);
            Matrix mrcon = mr.subtract(wk4);
            fit = mrcon.getColumnData();
        }
        this.showFit(fit, b.times(new Matrix(Matrix.COLUMN, fit)).getColumnData());
        for (int j = 0; j < this.nv; ++j) {
            this.afv.get(j).setValue(fit[j]);
        }
        String fout = "reduce-fit.xml";
        this.ic_loader.marshall(this.icon, fout);
        log.info("New initial conditions have been written to {}", fout);
    }

    public void showFit(double[] newvars, double[] mcdat) {
        for (int j = 0; j < this.nv; ++j) {
            this.afv.get(j).setValue(newvars[j]);
        }
        double[][] cfit = this.staticCalc.getElementConcentrations();
        log.info("Average concentrations by species: ");
        for (int ispec = 0; ispec < this.nspec; ++ispec) {
            double a = 0.0;
            double b = 0.0;
            double c = 0.0;
            double vtot = 0.0;
            for (int iel = 0; iel < this.nel; ++iel) {
                a += this.vols[iel] * this.ctgt[iel][ispec];
                b += this.vols[iel] * cfit[iel][ispec];
                c += this.vols[iel] * mcdat[iel * this.nspec + ispec];
                vtot += this.vols[iel];
            }
            log.info("    species " + ispec + " target=" + (a /= vtot) + "  fit=" + (b /= vtot));
        }
    }

    public void printconc(double[][] dat) {
        for (int i = 0; i < this.nel; ++i) {
            String sl = "elt " + i + " ";
            for (int j = 0; j < this.nspec; ++j) {
                sl = sl + String.format("%12.3f", dat[i][j]) + " ";
            }
            log.info(sl);
        }
    }
}

