/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;

public abstract class CompoundDS
extends Dataset {
    private static final long serialVersionUID = -4880399929644095662L;
    public static final String separator = "\u0095";
    protected int numberOfMembers = 0;
    protected String[] memberNames = null;
    protected int[] memberOrders;
    protected Object[] memberDims;
    protected Datatype[] memberTypes = null;
    protected boolean[] isMemberSelected = null;

    public CompoundDS(FileFormat theFile, String name, String path) {
        this(theFile, name, path, null);
    }

    @Deprecated
    public CompoundDS(FileFormat theFile, String name, String path, long[] oid) {
        super(theFile, name, path, oid);
    }

    public final int getMemberCount() {
        return this.numberOfMembers;
    }

    public final int getSelectedMemberCount() {
        int count = 0;
        if (this.isMemberSelected != null) {
            for (int i = 0; i < this.isMemberSelected.length; ++i) {
                if (!this.isMemberSelected[i]) continue;
                ++count;
            }
        }
        return count;
    }

    public final String[] getMemberNames() {
        return this.memberNames;
    }

    public final boolean isMemberSelected(int idx) {
        if (this.isMemberSelected != null && this.isMemberSelected.length > idx) {
            return this.isMemberSelected[idx];
        }
        return false;
    }

    public final void selectMember(int idx) {
        if (this.isMemberSelected != null && this.isMemberSelected.length > idx) {
            this.isMemberSelected[idx] = true;
        }
    }

    public final void setMemberSelection(boolean isSelected) {
        if (this.isMemberSelected == null) {
            return;
        }
        for (int i = 0; i < this.isMemberSelected.length; ++i) {
            this.isMemberSelected[i] = isSelected;
        }
    }

    public final int[] getMemberOrders() {
        return this.memberOrders;
    }

    public final int[] getSelectedMemberOrders() {
        if (this.isMemberSelected == null) {
            return this.memberOrders;
        }
        int idx = 0;
        int[] orders = new int[this.getSelectedMemberCount()];
        for (int i = 0; i < this.isMemberSelected.length; ++i) {
            if (!this.isMemberSelected[i]) continue;
            orders[idx++] = this.memberOrders[i];
        }
        return orders;
    }

    public final int[] getMemeberDims(int i) {
        if (this.memberDims == null) {
            return null;
        }
        return (int[])this.memberDims[i];
    }

    public final Datatype[] getMemberTypes() {
        return this.memberTypes;
    }

    public final Datatype[] getSelectedMemberTypes() {
        if (this.isMemberSelected == null) {
            return this.memberTypes;
        }
        int idx = 0;
        Datatype[] types = new Datatype[this.getSelectedMemberCount()];
        for (int i = 0; i < this.isMemberSelected.length; ++i) {
            if (!this.isMemberSelected[i]) continue;
            types[idx++] = this.memberTypes[i];
        }
        return types;
    }

    @Override
    @Deprecated
    public Dataset copy(Group pgroup, String name, long[] dims, Object data) throws Exception {
        throw new UnsupportedOperationException("Writing a subset of a compound dataset to a new dataset is not implemented.");
    }
}

