/*
 * Decompiled with CFR 0.152.
 */
package neurord.disc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import neurord.disc.Resolution;
import neurord.disc.TreeUtil;
import neurord.numeric.morph.TreePoint;
import neurord.numeric.morph.VolumeGrid;
import neurord.numeric.morph.VolumeSlice;

public class DiscBoxer {
    TreePoint[] srcPoints;
    ArrayList<VolumeSlice> gridAL;
    HashSet<TreePoint> wkpHS;
    Resolution resolution;
    double[] surfaceLayers;

    public DiscBoxer(TreePoint[] pts, double[] sl) {
        this.srcPoints = pts;
        this.surfaceLayers = sl;
        if (sl != null && sl.length > 0) {
            throw new RuntimeException("3d cuboid mesh doesn't handle surface layers yet");
        }
    }

    public VolumeGrid buildGrid(double d, HashMap<String, Double> resHM) {
        this.resolution = new Resolution(d, resHM);
        TreePoint firstpt = null;
        this.wkpHS = new HashSet();
        for (TreePoint tp : this.srcPoints) {
            this.wkpHS.add(tp);
            if (firstpt != null || !tp.isEndPoint()) continue;
            firstpt = tp;
        }
        TreeUtil.parentizeFrom(firstpt, this.srcPoints);
        this.gridAL = new ArrayList();
        VolumeSlice vg0 = null;
        this.wkpHS.remove(firstpt);
        this.recAdd(vg0, firstpt);
        VolumeGrid vgr = new VolumeGrid();
        vgr.importSlices(this.gridAL);
        return vgr;
    }

    private void recAdd(VolumeSlice pGrid, TreePoint tp) {
        String lbl = tp.getLabel();
        tp.partBranchOffset = 0.0;
        for (TreePoint tpn : tp.getNeighbors()) {
            if (!this.wkpHS.contains(tpn)) continue;
            this.wkpHS.remove(tpn);
            if (lbl == null && tpn.nnbr == 1 && tpn.getLabel() != null) {
                lbl = tpn.getLabel();
            }
            VolumeSlice vg = null;
            if (tpn.subAreaPeer != tp) {
                if (tp.subAreaPeer != null && tp.subAreaPeer == tp.parent) {
                    TreePoint par = tp.parent;
                    vg = this.baseGrid(tp, tpn, lbl);
                    pGrid.subPlaneConnect(tp, tpn, vg, par.partBranchOffset);
                    par.partBranchOffset += 2.0 * tpn.getRadius();
                } else if (pGrid == null) {
                    vg = this.baseGrid(tp, tpn, lbl);
                } else {
                    vg = this.baseGrid(tp, tpn, lbl);
                    pGrid.planeConnect(vg);
                }
            }
            lbl = null;
            if (vg != null) {
                this.gridAL.add(vg);
                this.recAdd(vg, tpn);
                continue;
            }
            this.recAdd(pGrid, tpn);
        }
    }

    public VolumeSlice baseGrid(TreePoint tpa, TreePoint tpb, String lbl) {
        double r = 0.5 * (tpa.getRadius() + tpb.getRadius());
        String rgn = tpa.regionClassWith(tpb);
        double delta = this.resolution.getLocalDelta(tpa, tpb);
        VolumeSlice ret = new VolumeSlice(delta, r);
        ret.discFill(tpa, tpb, lbl, rgn);
        return ret;
    }
}

