/*
 * Decompiled with CFR 0.152.
 */
package neurord.disc;

import java.util.concurrent.ConcurrentLinkedQueue;
import neurord.numeric.morph.TreePoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreeUtil {
    static final Logger log = LogManager.getLogger();

    public static void parentizeFrom(TreePoint base, TreePoint[] srcPoints) {
        for (TreePoint tp : srcPoints) {
            tp.iwork = 1;
        }
        ConcurrentLinkedQueue<TreePoint> q = new ConcurrentLinkedQueue<TreePoint>();
        q.add(base);
        while (!q.isEmpty()) {
            TreePoint tp = (TreePoint)q.remove();
            for (int i = 0; i < tp.nnbr; ++i) {
                TreePoint tpn = tp.nbr[i];
                if (tpn.iwork != 1) continue;
                tpn.iwork = 0;
                tpn.parent = tp;
                q.add(tpn);
            }
        }
    }

    public static void orientAC(TreePoint base, TreePoint[] srcPoints) {
        for (TreePoint tp : srcPoints) {
            tp.iwork = 1;
        }
        ConcurrentLinkedQueue<TreePoint> q = new ConcurrentLinkedQueue<TreePoint>();
        q.add(base);
        while (!q.isEmpty()) {
            int i;
            TreePoint tp = (TreePoint)q.remove();
            tp.iwork = 0;
            for (i = 1; i < tp.nnbr; ++i) {
                if (tp.nbr[i] != tp.parent) continue;
                tp.nbr[i] = tp.nbr[0];
                tp.nbr[0] = tp.parent;
                break;
            }
            if (tp.nnbr >= 3) {
                TreeUtil.orientOneAC(tp);
            }
            for (i = 0; i < tp.nnbr; ++i) {
                TreePoint tpn = tp.nbr[i];
                if (tpn.iwork != 1) continue;
                tpn.iwork = 0;
                q.add(tpn);
            }
        }
    }

    private static void orientOneAC(TreePoint tp) {
        int i;
        double[][] ds = new double[tp.nnbr][2];
        TreePoint wk = tp.parent;
        if (tp.distanceTo(wk) < 0.1) {
            wk = wk.parent;
        }
        ds[0][0] = wk.getX() - tp.getX();
        ds[0][1] = wk.getY() - tp.getY();
        for (int i2 = 1; i2 < tp.nnbr; ++i2) {
            wk = tp.nbr[i2];
            if (tp.distanceTo(wk) < 0.1) {
                if (wk.nnbr >= 2) {
                    wk = wk.nbr[1];
                } else {
                    log.error("problem orienting children of {}", tp);
                }
            }
            ds[i2][0] = wk.getX() - tp.getX();
            ds[i2][1] = wk.getY() - tp.getY();
        }
        double[] ang = new double[tp.nnbr];
        for (i = 0; i < tp.nnbr; ++i) {
            ang[i] = Math.atan2(ds[i][1], ds[i][0]);
        }
        for (i = 1; i < tp.nnbr; ++i) {
            ang[i] = (ang[i] - ang[0] + Math.PI * 4) % (Math.PI * 2);
        }
        ang[0] = 0.0;
        assert (tp.nnbr == 3) : "can't handle points with more than three neighbors yet";
        if (ang[1] > ang[2]) {
            TreePoint dum = tp.nbr[1];
            tp.nbr[1] = tp.nbr[2];
            tp.nbr[2] = dum;
        }
    }
}

