/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;
import neurord.model.EndPoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Segment {
    static final Logger log = LogManager.getLogger();
    @XmlAttribute
    public String id;
    @XmlAttribute
    public String region;
    public EndPoint start;
    public EndPoint end;
    private transient boolean resolved = false;

    public String getID() {
        return this.id;
    }

    public void checkResolved(HashMap<String, Segment> segmentHM) {
        if (!this.resolved) {
            this.resolve(segmentHM);
        }
    }

    public void resolve(HashMap<String, Segment> segmentHM) {
        this.start.setSegment(this);
        this.end.setSegment(this);
        this.start.resolve(segmentHM, this.end);
        this.end.resolve(segmentHM, this.start);
        this.start.addNeighbor(this.end);
        this.end.addNeighbor(this.start);
        if (this.region != null) {
            this.start.setRegionWith(this.end, this.region);
            this.end.setRegionWith(this.start, this.region);
        }
        if (this.id != null) {
            this.start.setIDWith(this.end, this.id);
            this.end.setIDWith(this.start, this.id);
        }
        assert (this.start.r > 0.0);
        assert (this.end.r > 0.0);
        this.resolved = true;
    }

    public EndPoint getStart() {
        return this.start;
    }

    public EndPoint getEnd() {
        return this.end;
    }

    public void checkHasPositions() {
        if (!this.start.hasPosition()) {
            throw new RuntimeException("Start point of " + this.id + " has no position: " + this.start);
        }
        if (!this.end.hasPosition()) {
            throw new RuntimeException("Start point of " + this.id + " has no position: " + this.end);
        }
    }
}

