/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import neurord.model.SDRun;
import neurord.numeric.grid.ResultWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseCalc
implements Runnable {
    static final Logger log = LogManager.getLogger();
    public static final double PARTICLES_PUVC = 0.602214179;
    public static final double LN_PARTICLES_PUVC = Math.log(0.602214179);
    public static final double PARTICLES_PUASD = 0.602214179;
    public static final double NM_PER_PARTICLE_PUV = 1.660538783162726;
    protected final ArrayList<ResultWriter> resultWriters = new ArrayList();
    protected final algorithm_t algoID;
    public final boolean writeConcentration;
    private final int trial;
    protected SDRun sdRun;
    protected Hashtable<Integer, Object> results;
    private long seed = -1L;

    public BaseCalc(int trial, SDRun sdRun) {
        this.trial = trial;
        this.sdRun = sdRun;
        this.algoID = sdRun.getAlgorithm();
        this.writeConcentration = output_t.valueOf(sdRun.outputQuantity) == output_t.CONCENTRATION;
        log.info("Writing particle numbers as {}s", sdRun.outputQuantity);
    }

    public int trial() {
        return this.trial;
    }

    public SDRun getSource() {
        return this.sdRun;
    }

    public long getSimulationSeed() {
        if (this.seed == -1L) {
            this.seed = this.sdRun.simulationSeed > 0L ? this.sdRun.simulationSeed + (long)this.trial : (long)Math.abs(new Random().nextInt());
            log.info("Trial {}: running with simulationSeed {}", this.trial(), this.seed);
        }
        return this.seed;
    }

    public void addResultWriter(ResultWriter rw) {
        rw.init("cctdif2d");
        this.resultWriters.add(rw);
    }

    public void storeResultIn(Hashtable<Integer, Object> results) {
        this.results = results;
    }

    protected abstract void _run();

    @Override
    public void run() {
        Serializable result;
        try {
            this._run();
            result = 0;
        }
        catch (Exception e) {
            log.error("{}: failed (seed={})", this, this.seed);
            if (this.results == null) {
                throw e;
            }
            result = e;
        }
        catch (Error e) {
            log.error("{}: failed (seed={})", this, this.seed);
            if (this.results == null) {
                throw e;
            }
            result = e;
        }
        this.results.put(this.trial, result);
    }

    public void close() {
        for (ResultWriter resultWriter : this.resultWriters) {
            resultWriter.close();
        }
    }

    public abstract long getParticleCount();

    public static enum output_t {
        NUMBER,
        CONCENTRATION;

    }

    public static enum algorithm_t {
        INDEPENDENT,
        SHARED,
        PARTICLE;

    }

    public static enum distribution_t {
        BINOMIAL,
        POISSON,
        EXACT;

    }
}

