/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.grid;

import java.util.Arrays;
import java.util.List;
import neurord.model.IOutputSet;
import neurord.model.SDRun;
import neurord.numeric.BaseCalc;
import neurord.numeric.chem.ReactionTable;
import neurord.numeric.grid.IGridCalc;
import neurord.numeric.grid.ResultWriter;
import neurord.numeric.morph.VolumeGrid;
import neurord.util.ArrayUtil;
import neurord.util.Logging;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GridCalc
extends BaseCalc
implements IGridCalc {
    public static final Logger log = LogManager.getLogger();
    ReactionTable rtab;
    double dt;
    public int nel;
    public int nspec;
    public String[] species;
    double[] volumes;
    double[] fdiff;
    int[][] neighbors;
    double[] surfaceAreas;
    final double[] dtsOut;
    private static final double[] intlogs = ArrayUtil.logArray(10000);

    private static double[] makeDtsOut(List<? extends IOutputSet> outputs, double fallback) {
        int nos = outputs != null ? outputs.size() : 0;
        double[] dtsOut = new double[nos];
        log.info("Extracting dts for {} output files", nos);
        for (int i = 0; i < nos; ++i) {
            dtsOut[i] = outputs.get(i).getOutputInterval(fallback);
        }
        return dtsOut;
    }

    protected GridCalc(int trial, SDRun sdRun) {
        super(trial, sdRun);
        this.dtsOut = GridCalc.makeDtsOut(this.sdRun.getOutputSets(), this.sdRun.getFixedStepDt());
    }

    protected void init() {
        VolumeGrid grid = this.sdRun.getVolumeGrid();
        this.nel = grid.size();
        this.volumes = grid.getElementVolumes();
        this.rtab = this.sdRun.getReactionTable();
        this.species = this.rtab.getSpecies();
        this.nspec = this.rtab.getNSpecies();
        this.neighbors = grid.getPerElementNeighbors();
        this.fdiff = this.rtab.getDiffusionConstants();
        this.surfaceAreas = grid.getExposedAreas();
        double dt = this.sdRun.stepSize();
        double other = this.dtsOut.length > 0 ? ArrayUtil.min(this.dtsOut) : Double.POSITIVE_INFINITY;
        this.dt = Math.min(dt, other);
        assert (this.dt > 0.0) : this.dt;
    }

    protected double endtime() {
        return this.sdRun.getEndTime();
    }

    @Override
    protected void _run() {
        double begintime;
        this.init();
        double time = begintime = this.sdRun.getStartTime();
        double endtime = this.endtime();
        for (ResultWriter resultWriter : this.resultWriters) {
            resultWriter.writeGrid(this.sdRun.getVolumeGrid(), time, this);
        }
        log.log(Logging.NOTICE, "Trial {}: running from {} to {} ms", this.trial(), time, endtime);
        long startTime = System.currentTimeMillis();
        double writeTime = time - 1.0E-9;
        double statInterval = this.sdRun.getStatisticsInterval();
        double statTime = time + statInterval;
        double[] writeTimeArray = new double[this.dtsOut.length];
        Arrays.fill(writeTimeArray, -1.0E-9);
        long old_events = 0L;
        long old_wall_time = System.currentTimeMillis();
        log.info("main outputInterval={} outputIntervals={}", this.dt, this.dtsOut);
        while (time <= endtime) {
            if (time >= writeTime) {
                long wall_time = System.currentTimeMillis();
                if (wall_time > old_wall_time + 100L) {
                    long events = this.eventCount();
                    double speed = (double)(events - old_events) / (double)(wall_time - old_wall_time);
                    log.info("Trial {}: time {} dt={} ({}%) events={} {}/ms", this.trial(), time, this.dt, (int)((time - begintime) / (endtime - begintime) * 100.0), events - old_events, (int)speed);
                    old_events = events;
                    old_wall_time = wall_time;
                } else {
                    log.info("Trial {}: time {} dt={}", this.trial(), time, this.dt);
                }
                for (ResultWriter resultWriter : this.resultWriters) {
                    resultWriter.writeOutputInterval(time, this);
                }
                writeTime += this.sdRun.getOutputInterval();
                if (this.sdRun.getStatisticsInterval() > 0.0) {
                    this.resetEventStatistics();
                }
            }
            for (int i = 0; i < this.dtsOut.length; ++i) {
                if (!(time >= writeTimeArray[i])) continue;
                for (ResultWriter resultWriter : this.resultWriters) {
                    resultWriter.writeOutputScheme(i, time, this);
                }
                int n = i;
                writeTimeArray[n] = writeTimeArray[n] + Double.valueOf(this.dtsOut[i]);
            }
            if (statInterval > 0.0 && time > statTime) {
                for (Object resultWriter : this.resultWriters) {
                    resultWriter.writeEventStatistics(time, this);
                }
                statTime += statInterval;
            }
            if (!(time < endtime)) break;
            time += this.advance(time, time + this.dt);
        }
        if (writeTime < time + this.sdRun.getOutputInterval() / 10.0) {
            log.info("Trial {}: time {} dt={} (100%)", this.trial(), time, this.dt);
            for (Object resultWriter : this.resultWriters) {
                resultWriter.writeOutputInterval(time, this);
            }
        }
        for (int i = 0; i < this.dtsOut.length; ++i) {
            if (!(time >= writeTimeArray[i] + Double.valueOf(this.dtsOut[i] / 10.0))) continue;
            for (ResultWriter resultWriter : this.resultWriters) {
                resultWriter.writeOutputScheme(i, time, this);
            }
        }
        if (statInterval > 0.0 && time > statTime - statInterval / 2.0 || statInterval == 0.0) {
            for (Object resultWriter : this.resultWriters) {
                resultWriter.writeEventStatistics(time, this);
            }
        }
        log.info("Trial {}: total number of particles at the end: {}", this.trial(), this.getParticleCount());
        for (Object resultWriter : this.resultWriters) {
            resultWriter.closeTrial(this);
        }
        long endTime = System.currentTimeMillis();
        log.log(Logging.NOTICE, "Trial {}: total run time {} ms", this.trial(), endTime - startTime);
        this.footer();
        this.close();
    }

    protected abstract double advance(double var1, double var3);

    protected void footer() {
    }

    protected abstract long eventCount();

    protected abstract void resetEventStatistics();

    @Override
    public int getNumberElements() {
        return this.nel;
    }

    @Override
    public long getParticleCount() {
        long ret = 0L;
        for (int i = 0; i < this.nel; ++i) {
            for (int j = 0; j < this.nspec; ++j) {
                ret += (long)this.getGridPartNumb(i, j);
            }
        }
        return ret;
    }

    public static final double intlog(int i) {
        if (i <= 0) {
            return intlogs[0];
        }
        return i < intlogs.length ? intlogs[i] : Math.log(i);
    }
}

