/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.morph;

import neurord.numeric.morph.VolumeElement;

public class ElementConnection {
    final VolumeElement a;
    final VolumeElement b;
    final double contactArea;

    public ElementConnection(VolumeElement a, VolumeElement b, double contactArea) {
        for (ElementConnection aconn : a.connections) {
            assert (aconn.getElementB() != b);
        }
        for (ElementConnection bconn : b.connections) {
            assert (bconn.getElementB() != a);
        }
        this.a = a;
        this.b = b;
        this.contactArea = contactArea;
    }

    public VolumeElement getElementA() {
        return this.a;
    }

    public VolumeElement getElementB() {
        return this.b;
    }

    public double getContactArea() {
        return this.contactArea;
    }

    public String toString() {
        return String.format("ElementConnection: %s \u2014 %s contactArea=%f", this.a.getNumber(), this.b.getNumber(), this.contactArea);
    }
}

