/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.morph;

import java.util.ArrayList;
import neurord.geom.Geom;
import neurord.geom.Position;
import neurord.geom.Rotation;
import neurord.geom.Translation;

public class TriangleStrip {
    ArrayList<double[]> wkpts = new ArrayList();

    public void addPoint(double x, double y, double z, double xn, double yn, double zn) {
        double[] wk = new double[]{x, y, z, xn, yn, zn};
        this.wkpts.add(wk);
    }

    public int getLength() {
        return this.wkpts.size();
    }

    public void rotate(Rotation rot) {
        for (double[] wp : this.wkpts) {
            Position cp = Geom.position(wp[0], wp[1], wp[2]);
            Position cv = Geom.position(wp[3], wp[4], wp[5]);
            Position rcp = rot.getRotatedPosition(cp);
            Position rcv = rot.getRotatedPosition(cv);
            wp[0] = rcp.getX();
            wp[1] = rcp.getY();
            wp[2] = rcp.getZ();
            wp[3] = rcv.getX();
            wp[4] = rcv.getY();
            wp[5] = rcv.getZ();
        }
    }

    public void translate(Translation trans) {
        for (double[] wp : this.wkpts) {
            Position cp = Geom.position(wp[0], wp[1], wp[2]);
            Position rcp = trans.getTranslated(cp);
            wp[0] = rcp.getX();
            wp[1] = rcp.getY();
            wp[2] = rcp.getZ();
        }
    }

    public void addPositions(ArrayList<float[]> af) {
        for (double[] w : this.wkpts) {
            float[] f = new float[]{(float)w[0], (float)w[1], (float)w[2]};
            af.add(f);
        }
    }

    public void addNormals(ArrayList<float[]> af) {
        for (double[] w : this.wkpts) {
            float[] f = new float[]{(float)w[3], (float)w[4], (float)w[5]};
            af.add(f);
        }
    }

    public void flip() {
        ArrayList<double[]> wpn = new ArrayList<double[]>();
        for (int i = 0; i < this.wkpts.size(); i += 2) {
            wpn.add(this.wkpts.get(i + 1));
            wpn.add(this.wkpts.get(i));
        }
        this.wkpts = wpn;
    }
}

