/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.morph;

import java.util.ArrayList;
import java.util.Arrays;
import neurord.geom.Position;
import neurord.numeric.morph.ElementConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class VolumeElement {
    static final Logger log = LogManager.getLogger();
    protected final Position center;
    protected final String label;
    protected final String region;
    protected final String groupID;
    protected final double volume;
    protected final double deltaZ;
    protected final double exposedArea;
    protected final double alongArea;
    protected final double sideArea;
    protected final double topArea;
    protected final ArrayList<ElementConnection> connections = new ArrayList();
    protected final Position[] boundary;
    protected final Position[] surfaceBoundary;
    protected int number = -1;
    private boolean fixcon = false;

    public VolumeElement(String label, String region, String groupID, Position[] boundary, Position[] surfaceBoundary, double exposedArea, Position center, double alongArea, double sideArea, double topArea, double volume, double deltaZ) {
        this.label = label;
        this.region = region;
        this.groupID = groupID;
        assert (surfaceBoundary != null || exposedArea == 0.0);
        this.boundary = boundary;
        this.surfaceBoundary = surfaceBoundary;
        this.exposedArea = exposedArea;
        this.center = center;
        this.alongArea = alongArea;
        this.sideArea = sideArea;
        this.topArea = topArea;
        this.volume = volume;
        this.deltaZ = deltaZ;
        log.debug("New {}", this);
    }

    public String toString() {
        return String.format("%s(label=%s, region=%s, groupID=%s, boundary=%s, surfaceBoundary=%s, exposedArea=%g, center=%s, along %g, side %g, top %g, volume=%g, \u0394z=%g,  number=%d)", this.getClass().getSimpleName(), this.label, this.region, this.groupID, Arrays.toString(this.boundary), Arrays.toString(this.surfaceBoundary), this.exposedArea, this.center, this.alongArea, this.sideArea, this.topArea, this.volume, this.deltaZ, this.number);
    }

    public double getAlongArea() {
        return this.alongArea;
    }

    public double getSideArea() {
        return this.sideArea;
    }

    public double getTopArea() {
        return this.topArea;
    }

    public double getX() {
        return this.center.getX();
    }

    public double getY() {
        return this.center.getY();
    }

    public double getZ() {
        return this.center.getZ();
    }

    public boolean isSubmembrane() {
        return this.surfaceBoundary != null;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRegion() {
        return this.region;
    }

    public double getVolume() {
        return this.volume;
    }

    public double getDeltaZ() {
        return this.deltaZ;
    }

    public double getExposedArea() {
        return this.exposedArea;
    }

    public Position[] getBoundary() {
        return this.boundary;
    }

    public Position[] getSurfaceBoundary() {
        return this.surfaceBoundary;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void coupleTo(VolumeElement other, double contactArea) {
        assert (!this.fixcon);
        for (ElementConnection conn : this.connections) {
            assert (conn.getElementB() != other);
        }
        this.connections.add(new ElementConnection(this, other, contactArea));
    }

    public ArrayList<ElementConnection> getConnections() {
        this.fixcon = true;
        return this.connections;
    }

    public void setNumber(int number) {
        assert (number >= 0);
        assert (this.number == -1);
        this.number = number;
    }

    public int getNumber() {
        assert (this.number >= 0);
        return this.number;
    }

    public String getAsText() {
        StringBuffer sb = new StringBuffer();
        if (this.boundary != null) {
            for (Position p : this.boundary) {
                sb.append(String.format("%s(%.5g %.5g %.5g)", sb.length() > 0 ? " " : "", p.getX(), p.getY(), p.getZ()));
            }
        } else {
            sb.append(String.format("%s(%.5g %.5g %.5g)", sb.length() > 0 ? " " : "", this.getX(), this.getY(), this.getZ()));
        }
        return sb.toString();
    }

    public String getHeadings() {
        StringBuffer sb = new StringBuffer();
        if (this.boundary != null) {
            for (int i = 0; i < this.boundary.length; ++i) {
                sb.append(" x" + i + " y" + i + " z" + i);
            }
        } else {
            sb.append(" cx cy cz");
        }
        sb.append(" volume deltaZ");
        return sb.toString();
    }

    public String getAsPlainText() {
        StringBuffer sb = new StringBuffer();
        for (double p : this.getAsNumbers()) {
            sb.append(String.format("%s%.5g", sb.length() > 0 ? " " : "", p));
        }
        return sb.toString();
    }

    private double[] getAsNumbers() {
        if (this.boundary != null) {
            double[] ans = new double[3 * this.boundary.length + 2];
            int i = 0;
            for (Position p : this.getBoundary()) {
                ans[i++] = p.getX();
                ans[i++] = p.getY();
                ans[i++] = p.getZ();
            }
            ans[i++] = this.volume;
            ans[i++] = this.deltaZ;
            assert (i == ans.length);
            return ans;
        }
        return new double[]{this.getX(), this.getY(), this.getZ(), this.volume, this.deltaZ};
    }
}

