/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.pool;

import neurord.model.SDRun;
import neurord.numeric.BaseCalc;
import neurord.numeric.chem.ReactionTable;
import neurord.numeric.math.Column;

public abstract class DeterministicPoolCalc
extends BaseCalc {
    Column mconc;
    ReactionTable rtab;
    double dt;
    double time;

    public DeterministicPoolCalc(int trial, SDRun sdm) {
        super(trial, sdm);
    }

    public final void init() {
        this.rtab = this.sdRun.getReactionTable();
        this.rtab.print();
        this.mconc = new Column(this.sdRun.getRegionConcentrations()[0]);
        this.dt = this.sdRun.getFixedStepDt();
    }

    @Override
    protected void _run() {
        this.init();
        this.mconc.print();
        this.time = this.sdRun.getStartTime();
        double endtime = this.sdRun.getEndTime();
        this.dpcInit();
        while (this.time < endtime) {
            this.time += this.advance();
        }
    }

    public void dpcInit() {
    }

    public abstract double advance();
}

