/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.stochastic;

import java.io.PrintStream;
import neurord.numeric.BaseCalc;
import neurord.numeric.math.Binomial;
import neurord.numeric.math.MersenneTwister;
import neurord.numeric.math.Poisson;
import neurord.numeric.math.RandomGenerator;
import neurord.util.Logging;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StepGenerator {
    static final Logger log = LogManager.getLogger();
    protected final Binomial binomial;
    protected final Poisson poisson;

    public StepGenerator(RandomGenerator random) {
        this.binomial = new Binomial(random);
        this.poisson = new Poisson(random);
    }

    public int nGo(int n, double lnp) {
        return this.versatile_ngo(1, Math.exp(lnp));
    }

    public int versatile_ngo(int n, double p) {
        assert (n >= 0);
        return this.binomial.nextInt(n, p);
    }

    public int poisson(double mean) {
        return this.poisson.nextInt(mean);
    }

    public static void main(String ... args) throws Exception {
        Logging.setLogLevel(null, "", Level.DEBUG);
        Logging.configureConsoleLogging();
        boolean print = true;
        BaseCalc.distribution_t distrib = BaseCalc.distribution_t.valueOf(args[0]);
        int N = Integer.valueOf(args[1]);
        int n = Integer.valueOf(args[2]);
        double p = Double.valueOf(args[3]);
        PrintStream out = args.length <= 4 ? System.out : new PrintStream(args[4]);
        if (args.length >= 6 && args[5].equals("-n")) {
            print = false;
        }
        StepGenerator stepper = new StepGenerator(new MersenneTwister());
        for (int i = 0; i < N; ++i) {
            int x = distrib == BaseCalc.distribution_t.POISSON ? stepper.poisson((double)n * p) : stepper.versatile_ngo(n, p);
            if (!print) continue;
            out.println("" + x);
        }
    }
}

