/*
 * Decompiled with CFR 0.152.
 */
package neurord.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class FileUtil {
    public static String readStringFromFile(File f) {
        String sdat = "null";
        if (f != null) {
            try {
                boolean dogz = f.getName().endsWith(".gz");
                InputStream ins = new FileInputStream(f);
                if (dogz) {
                    ins = new GZIPInputStream(ins);
                }
                InputStreamReader insr = new InputStreamReader(ins);
                BufferedReader fr = new BufferedReader(insr);
                StringBuffer sb = new StringBuffer();
                while (fr.ready()) {
                    sb.append(fr.readLine());
                    sb.append("\n");
                }
                fr.close();
                sdat = sb.toString();
            }
            catch (IOException ex) {
                throw new RuntimeException("file read error", ex);
            }
        }
        return sdat;
    }

    public static boolean writeStringToFile(String sdat, File f) {
        String fnm = f.getName();
        boolean ok = false;
        if (f != null) {
            boolean dogz = fnm.endsWith(".gz");
            try {
                OutputStream fos = new FileOutputStream(f);
                if (dogz) {
                    fos = new GZIPOutputStream(fos);
                }
                OutputStreamWriter osw = new OutputStreamWriter(fos);
                osw.write(sdat, 0, sdat.length());
                osw.close();
                ok = true;
            }
            catch (IOException ex) {
                throw new RuntimeException("File write error, when writing " + fnm);
            }
        }
        return ok;
    }

    public static String getRootName(File f) {
        String fnm;
        int index = (fnm = f.getName()).lastIndexOf(".");
        return fnm.substring(0, index == -1 ? fnm.length() : index);
    }
}

