/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jblas.exceptions.UnsupportedArchitectureException;
import org.jblas.util.ArchFlavor;
import org.jblas.util.Logger;

public class LibraryLoader {
    private Logger logger = Logger.getLogger();
    private String libpath = null;
    private static File tempDir;

    public void loadLibrary(String libname, boolean withFlavor) {
        String flavor = null;
        if (withFlavor) {
            this.logger.debug("Preloading ArchFlavor library.");
            flavor = ArchFlavor.archFlavor();
            if (flavor != null && flavor.equals("sse2")) {
                throw new UnsupportedArchitectureException("Support for SSE2 processors stopped with version 1.2.2. Sorry.");
            }
        }
        this.logger.debug("Found flavor = '" + flavor + "'");
        String loadLibname = libname = System.mapLibraryName(libname);
        if (libname.endsWith("dylib")) {
            loadLibname = libname.replace(".dylib", ".jnilib");
            this.logger.config("Replaced .dylib with .jnilib");
        }
        this.logger.debug("Attempting to load \"" + loadLibname + "\".");
        String[] paths = new String[]{this.fatJarLibraryPath("static", flavor), this.fatJarLibraryPath("dynamic", flavor)};
        InputStream is = this.findLibrary(paths, loadLibname);
        if (is == null) {
            throw new UnsatisfiedLinkError("Couldn't find the resource " + loadLibname + ".");
        }
        this.logger.config("Loading " + loadLibname + " from " + this.libpath + ", copying to " + libname + ".");
        this.loadLibraryFromStream(libname, is);
    }

    private InputStream findLibrary(String[] paths, String libname) {
        InputStream is = null;
        for (String path : paths) {
            is = this.tryPath(path + libname);
            if (is == null) continue;
            this.logger.debug("Found " + libname + " in " + path);
            this.libpath = path;
            break;
        }
        return is;
    }

    private static String unifyOSName(String osname) {
        if (osname.startsWith("Windows")) {
            return "Windows";
        }
        return osname;
    }

    private static String getUnifiedOSName() {
        return LibraryLoader.unifyOSName(System.getProperty("os.name"));
    }

    private String fatJarLibraryPath(String linkage, String flavor) {
        String sep = "/";
        String os_name = LibraryLoader.getUnifiedOSName();
        String os_arch = System.getProperty("os.arch");
        String path = sep + "lib" + sep + linkage + sep + os_name + sep + os_arch + sep;
        if (null != flavor) {
            path = path + flavor + sep;
        }
        return path;
    }

    private InputStream tryPath(String path) {
        Logger.getLogger().debug("Trying path \"" + path + "\".");
        return this.getClass().getResourceAsStream(path);
    }

    private File createTempFile(String name) throws IOException {
        return new File(tempDir + File.separator + name);
    }

    private void loadLibraryFromStream(String libname, InputStream is) {
        try {
            int len;
            File tempfile = this.createTempFile(libname);
            FileOutputStream os = new FileOutputStream(tempfile);
            this.logger.debug("tempfile.getPath() = " + tempfile.getPath());
            long savedTime = System.currentTimeMillis();
            byte[] buf = new byte[8192];
            while ((len = is.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
            os.flush();
            FileInputStream lock = new FileInputStream(tempfile);
            ((OutputStream)os).close();
            double seconds = (double)(System.currentTimeMillis() - savedTime) / 1000.0;
            this.logger.debug("Copying took " + seconds + " seconds.");
            this.logger.debug("Loading library from " + tempfile.getPath() + ".");
            System.load(tempfile.getPath());
            ((InputStream)lock).close();
        }
        catch (IOException io) {
            this.logger.error("Could not create the temp file: " + io.toString() + ".\n");
        }
        catch (UnsatisfiedLinkError ule) {
            this.logger.error("Couldn't load copied link file: " + ule.toString() + ".\n");
            throw ule;
        }
    }

    static {
        final Logger logger = Logger.getLogger();
        try {
            tempDir = File.createTempFile("jblas", "");
            if (!tempDir.delete() || !tempDir.mkdir()) {
                throw new IOException(String.format("Couldn't create directory \"%s\"", tempDir.getAbsolutePath()));
            }
            if (LibraryLoader.getUnifiedOSName() != "Windows") {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        for (File f : tempDir.listFiles()) {
                            logger.info("Deleting " + f.getAbsolutePath());
                            if (f.delete()) continue;
                            logger.warning(String.format("Couldn't delete temporary file \"%s\"", f.getAbsolutePath()));
                        }
                        logger.info("Deleting " + tempDir.getAbsolutePath());
                        if (!tempDir.delete()) {
                            logger.warning(String.format("Couldn't delete temporary directory \"%s\"", tempDir.getAbsolutePath()));
                        }
                    }
                });
            } else {
                new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(1000L);
                            logger.info("Starting temp DLL cleanup task.");
                            int deletedFiles = 0;
                            File jblasTempDir = new File(System.getProperty("java.io.tmpdir"));
                            for (File jblasDir : jblasTempDir.listFiles()) {
                                assert (jblasDir != null);
                                if (jblasDir == tempDir || !jblasDir.isDirectory() || !jblasDir.getName().startsWith("jblas")) continue;
                                for (File oldJblasFile : jblasDir.listFiles()) {
                                    if (!oldJblasFile.delete()) {
                                        logger.debug("Couldn't delete " + oldJblasFile.getAbsolutePath());
                                        continue;
                                    }
                                    logger.debug("Deleted " + oldJblasFile.getAbsolutePath());
                                    ++deletedFiles;
                                }
                            }
                            if (deletedFiles > 0) {
                                logger.info(String.format("Deleted %d unused temp DLL libraries from %s", deletedFiles, jblasTempDir.getAbsolutePath()));
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        }
        catch (IOException ex) {
            logger.error("Couldn't create temporary directory: " + ex.getMessage());
        }
    }
}

