/*
 * Decompiled with CFR 0.152.
 */
package neurord.disc;

import java.util.ArrayList;
import java.util.HashMap;
import neurord.disc.Resolution;
import neurord.numeric.morph.TreePoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SegmentSlicer {
    static final Logger log = LogManager.getLogger();
    TreePoint[] srcPoints;
    static final int FIXED = 1;
    static final int BALANCED = 2;
    int sdstyle;
    int maxnp;
    TreePoint[] outPoints;
    Resolution resolution;

    public SegmentSlicer(TreePoint[] sp) {
        this.srcPoints = sp;
    }

    public TreePoint[] getFixedWidthSlices(double dx, HashMap<String, Double> resHM) {
        this.sdstyle = 1;
        this.resolution = new Resolution(dx, resHM);
        this.maxnp = 20000;
        this.discretize();
        return this.getSlices();
    }

    public TreePoint[] getBalancedSlices(double disqrtr, int mnp) {
        this.sdstyle = 2;
        this.resolution = new Resolution(disqrtr, null);
        this.maxnp = mnp;
        this.discretize();
        return this.getSlices();
    }

    private TreePoint[] getSlices() {
        return this.outPoints;
    }

    private void discretize() {
        int np = this.srcPoints.length;
        double[][][] subdiv = new double[np][6][];
        for (int i = 0; i < np; ++i) {
            this.srcPoints[i].setWork(i);
        }
        int nnp = 0;
        for (int i = 0; i < np; ++i) {
            TreePoint cpa = this.srcPoints[i];
            for (int j = 0; j < cpa.nnbr; ++j) {
                TreePoint cpb = cpa.nbr[j];
                if (cpa.getWork() >= cpb.getWork()) continue;
                if (this.sdstyle == 1) {
                    double localDelta;
                    double dab = cpa.distanceTo(cpb);
                    double distance_over_delta = dab / (localDelta = this.resolution.getLocalDelta(cpa, cpb));
                    int nadd = (int)distance_over_delta - 1;
                    if (nadd < 0) {
                        if (dab < 0.01) {
                            cpb.setSubAreaOf(cpa);
                            cpb.alignTop(cpa, cpa.largestNeighborNot(cpb), cpa.partBranchOffset);
                            cpa.partBranchOffset += 2.0 * cpb.getRadius();
                        } else {
                            log.warn("Distance between points is smaller than the desired element size {} {} {} {}", dab, localDelta, cpa, cpb);
                        }
                        nadd = 0;
                    }
                    double[] dpos = new double[nadd];
                    if (nadd > 0) {
                        for (int ii = 0; ii < nadd; ++ii) {
                            dpos[ii] = (1.0 + (double)ii) / ((double)nadd + 1.0);
                        }
                    }
                    subdiv[i][j] = dpos;
                } else {
                    assert (this.sdstyle == 2) : this.sdstyle;
                    subdiv[i][j] = this.getBalancedSubdivision(cpa, cpb);
                }
                nnp += subdiv[i][j].length;
            }
        }
        if (np + nnp > this.maxnp) {
            log.error("not discretizing: need too many points ({})", np + nnp);
            throw new RuntimeException("need too many points");
        }
        TreePoint[] pr = new TreePoint[np + nnp];
        for (int i = 0; i < np; ++i) {
            pr[i] = this.srcPoints[i];
        }
        int nxp = np;
        for (int i = 0; i < np; ++i) {
            TreePoint cpa = this.srcPoints[i];
            for (int j = 0; j < cpa.nnbr; ++j) {
                double[] div = subdiv[i][j];
                if (div == null || div.length <= 0) continue;
                TreePoint cpb = cpa.nbr[j];
                String newRegion = cpa.regionClassWith(cpb);
                String newID = cpa.segmentIDWith(cpb);
                TreePoint clast = cpa;
                for (int id = 0; id < div.length; ++id) {
                    TreePoint cp = new TreePoint();
                    cp.locateBetween(cpa, cpb, div[id]);
                    cp.addNeighbor(clast);
                    pr[nxp++] = cp;
                    if (id == 0) {
                        cpa.replaceNeighbor(cpb, cp);
                    } else {
                        clast.addNeighbor(cp);
                    }
                    if (id == div.length - 1) {
                        cpb.replaceNeighbor(cpa, cp);
                        cp.addNeighbor(cpb);
                        cp.setIDWith(cpb, newID);
                        cp.setRegionWith(cpb, newRegion);
                    }
                    clast.setIDWith(cp, newID);
                    clast.setRegionWith(cp, newRegion);
                    cp.setIDWith(clast, newID);
                    cp.setRegionWith(clast, newRegion);
                    clast = cp;
                }
            }
        }
        ArrayList<TreePoint[]> cns = new ArrayList<TreePoint[]>();
        for (int i = 0; i < np; ++i) {
            TreePoint cpa = this.srcPoints[i];
            if (!cpa.hasOffsetChildren()) continue;
            for (TreePoint tpoc : cpa.getOffsetChildren()) {
                TreePoint tpn = this.findNearest(cpa, tpoc);
                if (tpn == null) continue;
                TreePoint[] tpa = new TreePoint[]{tpn, tpoc};
                cns.add(tpa);
            }
        }
        for (TreePoint[] tpa : cns) {
            log.info("Patching in {} as child of nearest in parent segment: {}", tpa[1], tpa[0]);
            TreePoint.neighborize(tpa[0], tpa[1]);
        }
        this.outPoints = pr;
    }

    private double[] getFixedSubdivision(TreePoint cpa, TreePoint cpb) {
        double dab = cpa.distanceTo(cpb);
        double localDelta = this.resolution.getLocalDelta(cpa, cpb);
        int nadd = (int)Math.round(dab / localDelta) - 1;
        double[] dpos = new double[nadd];
        if (nadd > 0) {
            for (int i = 0; i < nadd; ++i) {
                dpos[i] = (1.0 + (double)i) / ((double)nadd + 1.0);
            }
        }
        return dpos;
    }

    private double[] getBalancedSubdivision(TreePoint cpa, TreePoint cpb) {
        double dab = cpa.distanceTo(cpb);
        double ra = cpa.getRadius();
        double rb = cpb.getRadius();
        double localDelta = this.resolution.getLocalDelta(cpa, cpb);
        double fdist = 0.0;
        fdist = rb != ra ? 0.6666666666666666 * dab / (rb - ra) * (Math.pow(rb, 1.5) - Math.pow(ra, 1.5)) : dab * Math.sqrt(ra);
        int nadd = (int)(fdist / localDelta);
        double[] dpos = new double[nadd];
        if (nadd > 0) {
            if (Math.abs((ra - rb) / (ra + rb)) < 0.01) {
                for (int i = 0; i < nadd; ++i) {
                    dpos[i] = (1.0 + (double)i) / ((double)nadd + 1.0);
                }
            } else {
                double delf = fdist / (double)(nadd + 1);
                double ffa = (rb - ra) / dab;
                double xa = ra / ffa;
                double xb = rb / ffa;
                double x = xa;
                for (int i = 0; i < nadd + 1; ++i) {
                    double ttt = delf * ffa * 3.0 / 2.0 + Math.pow(ffa * x, 1.5);
                    double dx = Math.pow(ttt, 0.6666666666666666) / ffa - x;
                    x += dx;
                    if (i >= nadd) continue;
                    dpos[i] = (x - xa) / dab;
                }
                if (Math.abs(xb - x) > 1.0E-5) {
                    log.warn("segment division " + xa + " " + xb + " " + x + " " + nadd + " " + dab + " " + ra + " " + rb);
                }
            }
        }
        return dpos;
    }

    public TreePoint findNearest(TreePoint rt, TreePoint tgt) {
        TreePoint ret = rt;
        double dg = rt.distanceTo(tgt);
        for (int i = 0; i < rt.nnbr; ++i) {
            TreePoint tpprev;
            double ds = rt.distanceTo(tgt);
            TreePoint tpp = rt;
            for (TreePoint tpn = rt.nbr[i]; tpn != null && tpn.distanceTo(tgt) < ds; tpn = tpn.oppositeNeighbor(tpprev)) {
                ds = tpn.distanceTo(tgt);
                tpprev = tpp;
                tpp = tpn;
            }
            if (!(ds < dg)) continue;
            ret = tpp;
            dg = ds;
        }
        return ret;
    }
}

