/*
 * Decompiled with CFR 0.152.
 */
package neurord.geom;

import neurord.geom.GTranslation;
import neurord.geom.GVector;
import neurord.geom.Geom;
import neurord.geom.Movable;
import neurord.geom.Position;
import neurord.geom.Rotation;
import neurord.geom.Vector;

public class GRotation
implements Rotation {
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static final int Z_AXIS = 3;
    double[][] mtx = new double[3][3];

    public GRotation() {
        for (int i = 0; i < 3; ++i) {
            this.mtx[i][i] = 1.0;
        }
    }

    public GRotation(int axis, double angle) {
        this();
        double ca = Math.cos(angle);
        double sa = Math.sin(angle);
        if (axis == 1) {
            this.mtx[1][1] = ca;
            this.mtx[1][2] = -sa;
            this.mtx[2][1] = sa;
            this.mtx[2][2] = ca;
        } else if (axis == 2) {
            this.mtx[0][0] = ca;
            this.mtx[0][2] = sa;
            this.mtx[2][0] = -sa;
            this.mtx[2][2] = ca;
        } else {
            assert (axis == 3);
            this.mtx[0][0] = ca;
            this.mtx[0][1] = -sa;
            this.mtx[1][0] = sa;
            this.mtx[1][1] = ca;
        }
    }

    @Override
    public Vector getRotatedVector(Vector v) {
        double[] d = new double[]{v.getDX(), v.getDY(), v.getDZ()};
        double[] r = new double[3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n = i;
                r[n] = r[n] + this.mtx[i][j] * d[j];
            }
        }
        return new GVector(r);
    }

    @Override
    public Position getRotatedPosition(Position p, Position pcenter) {
        Vector v = Geom.fromToVector(pcenter, p);
        Vector vnew = this.getRotatedVector(v);
        GTranslation trans = new GTranslation(vnew);
        return trans.getTranslated(pcenter);
    }

    @Override
    public void rotateAbout(Movable mov, Position pcenter) {
    }

    public GRotation times(GRotation gr1) {
        GRotation ret = new GRotation();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ret.mtx[i][j] = 0.0;
                for (int k = 0; k < 3; ++k) {
                    double[] dArray = ret.mtx[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.mtx[i][k] * gr1.mtx[k][j];
                }
            }
        }
        return ret;
    }

    @Override
    public Position getRotatedPosition(Position p) {
        Vector v = Geom.getToVector(p);
        Vector vr = this.getRotatedVector(v);
        return Geom.endPosition(vr);
    }
}

