/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.grid;

import java.util.Arrays;
import neurord.model.SDRun;
import neurord.numeric.grid.GridCalc;
import neurord.numeric.math.MersenneTwister;
import neurord.numeric.math.RandomGenerator;
import neurord.numeric.morph.VolumeGrid;
import neurord.util.ArrayUtil;
import neurord.util.Logging;
import neurord.util.Settings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class StochasticGridCalc
extends GridCalc {
    public static final Logger log = LogManager.getLogger();
    static final boolean log_events = Settings.getProperty("neurord.log_events", "Log detailed information about every event", false);
    RandomGenerator random;
    int[][] wkA;

    public StochasticGridCalc(int trial, SDRun sdm) {
        super(trial, sdm);
    }

    @Override
    public void init() {
        super.init();
        this.random = new MersenneTwister(this.getSimulationSeed());
        assert (this.nel > 0);
        assert (this.nspec > 0);
        this.wkA = new int[this.nel][this.nspec];
        int[][] pop = this.sdRun.getPopulation();
        if (pop != null) {
            log.info("Using preexisting population");
            if (pop.length != this.wkA.length || pop[0].length != this.wkA[0].length) {
                log.error("Preexisting population shape mismatch (nel\u00d7nspec {} != {})", ArrayUtil.xJoined(pop.length, pop[0].length), ArrayUtil.xJoined(this.wkA.length, this.wkA[0].length));
                throw new RuntimeException("Preexisting population shape mismatch");
            }
            ArrayUtil.copy(pop, this.wkA);
        } else {
            this.initPopulation(this.wkA, this.sdRun);
        }
    }

    protected void initPopulation(int[][] counts, SDRun sdrun) {
        int i;
        log.debug("Initializing population based on volume and surface concentrations");
        String[] species = sdrun.getSpecies();
        VolumeGrid grid = sdrun.getVolumeGrid();
        for (i = 0; i < this.nel; ++i) {
            double v = this.volumes[i];
            String region = grid.getElementRegion(i);
            double[] rcs = sdrun.getRegionConcentration(region);
            for (int j = 0; j < this.nspec; ++j) {
                this.wkA[i][j] = this.random.round(v * rcs[j] * 0.602214179);
                log.debug("el.{} {}: {} \u00d7 {} \u00d7 {} \u2192 {}", i, species[j], v, rcs[j], 0.602214179, this.wkA[i][j]);
            }
            double[] rcs2 = sdrun.getRegionConcentration(grid.getElementRegion(i));
            if (Arrays.equals(rcs, rcs2)) continue;
            log.error("RegionConcentrations are not equal for {} {} {}:\n{}\n{}", i, region, grid.getElementRegion(i), rcs, rcs2);
            throw new RuntimeException("RegionConcentrations are not equal");
        }
        log.debug("volume only:\n{}", (Object[])this.wkA);
        for (i = 0; i < this.nel; ++i) {
            double a = this.surfaceAreas[i];
            if (!(a > 0.0)) continue;
            double[] sds = sdrun.getRegionSurfaceDensity(grid.getElementRegion(i));
            for (int j = 0; j < this.nspec; ++j) {
                if (Double.isNaN(sds[j])) continue;
                this.wkA[i][j] = this.random.round(a * sds[j] * 0.602214179);
            }
            double[] sds2 = sdrun.getRegionSurfaceDensity(grid.getElementRegion(i));
            if (Arrays.equals(sds, sds2)) continue;
            log.error("RegionSurfaceDensities are not equal:\n{}\n{}", sds, sds2);
            throw new RuntimeException("RegionSurfaceDensities are not equal");
        }
        log.debug("with surface:\n{}", (Object[])this.wkA);
    }

    @Override
    protected void footer() {
        log.log(Logging.NOTICE, "Used up {} random numbers", this.random.used());
    }

    @Override
    public boolean preferConcs() {
        return false;
    }

    @Override
    public int getGridPartNumb(int i, int j) {
        return this.wkA[i][j];
    }

    @Override
    public double getGridPartConc(int i, int j) {
        int val = this.getGridPartNumb(i, j);
        return (double)val * 1.660538783162726 / this.volumes[i];
    }
}

