/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.util.List;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;

public abstract class Datatype
extends HObject {
    private static final long serialVersionUID = -581324710549963177L;
    public static final int NATIVE = -1;
    public static final int CLASS_NO_CLASS = -1;
    public static final int CLASS_INTEGER = 0;
    public static final int CLASS_FLOAT = 1;
    public static final int CLASS_CHAR = 2;
    public static final int CLASS_STRING = 3;
    public static final int CLASS_BITFIELD = 4;
    public static final int CLASS_OPAQUE = 5;
    public static final int CLASS_COMPOUND = 6;
    public static final int CLASS_REFERENCE = 7;
    public static final int CLASS_ENUM = 8;
    public static final int CLASS_VLEN = 9;
    public static final int CLASS_ARRAY = 10;
    public static final int ORDER_LE = 0;
    public static final int ORDER_BE = 1;
    public static final int ORDER_VAX = 2;
    public static final int ORDER_NONE = 3;
    public static final int SIGN_NONE = 0;
    public static final int SIGN_2 = 1;
    public static final int NSGN = 2;
    protected int datatypeClass;
    protected int datatypeSize;
    protected int datatypeOrder;
    protected int datatypeSign;
    protected String enumMembers;
    protected Datatype baseType;
    protected long[] dims;

    public Datatype(FileFormat theFile, String name, String path) {
        this(theFile, name, path, null);
    }

    @Deprecated
    public Datatype(FileFormat theFile, String name, String path, long[] oid) {
        super(theFile, name, path, oid);
    }

    public Datatype(int tclass, int tsize, int torder, int tsign) {
        this.datatypeClass = tclass;
        this.datatypeSize = tsize;
        this.datatypeOrder = torder;
        this.datatypeSign = tsign;
        this.enumMembers = null;
        this.baseType = null;
        this.dims = null;
    }

    public Datatype(int type) {
        this(-1, -1, -1, -1);
    }

    public int getDatatypeClass() {
        return this.datatypeClass;
    }

    public int getDatatypeSize() {
        return this.datatypeSize;
    }

    public int getDatatypeOrder() {
        return this.datatypeOrder;
    }

    public int getDatatypeSign() {
        return this.datatypeSign;
    }

    public Datatype getBasetype() {
        return this.baseType;
    }

    public final void setEnumMembers(String enumStr) {
        this.enumMembers = enumStr;
    }

    public final String getEnumMembers() {
        return this.enumMembers;
    }

    public abstract int toNative();

    public abstract void fromNative(int var1);

    public String getDatatypeDescription() {
        String description = "Unknown";
        switch (this.datatypeClass) {
            case 0: {
                if (this.datatypeSign == 0) {
                    description = String.valueOf(this.datatypeSize * 8) + "-bit unsigned integer";
                    break;
                }
                description = String.valueOf(this.datatypeSize * 8) + "-bit integer";
                break;
            }
            case 1: {
                description = String.valueOf(this.datatypeSize * 8) + "-bit floating-point";
                break;
            }
            case 3: {
                description = "String";
                break;
            }
            case 7: {
                description = "Object reference";
                break;
            }
            case 4: {
                description = "Bitfield";
                break;
            }
            case 8: {
                description = "enum";
                break;
            }
            case 10: {
                description = "Array";
                break;
            }
            case 6: {
                description = "Compound ";
                break;
            }
            case 9: {
                description = "Variable-length";
                break;
            }
            default: {
                description = "Unknown";
            }
        }
        return description;
    }

    public abstract boolean isUnsigned();

    @Override
    public int open() {
        return -1;
    }

    @Override
    public abstract void close(int var1);

    @Override
    public List getMetadata() throws Exception {
        return null;
    }

    @Override
    public void writeMetadata(Object info) throws Exception {
    }

    @Override
    public void removeMetadata(Object info) throws Exception {
    }
}

