/*
 * Decompiled with CFR 0.152.
 */
package neurord.disc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import neurord.disc.Resolution;
import neurord.disc.TreeUtil;
import neurord.numeric.morph.TreePoint;
import neurord.numeric.morph.VolumeGrid;
import neurord.numeric.morph.VolumeLine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LineBoxer {
    static final Logger log = LogManager.getLogger();

    public static VolumeGrid buildGrid(TreePoint[] srcPoints, double[] surfaceLayers, double depth, double d, HashMap<String, Double> resHM) {
        Resolution resolution = new Resolution(d, resHM);
        TreePoint firstpt = null;
        HashSet<TreePoint> working_set = new HashSet<TreePoint>();
        for (TreePoint tp : srcPoints) {
            if (firstpt == null && tp.isEndPoint()) {
                firstpt = tp;
                log.debug("Using {} as the starting point", firstpt);
                continue;
            }
            working_set.add(tp);
            log.debug("Will process {} later", tp);
        }
        TreeUtil.parentizeFrom(firstpt, srcPoints);
        ArrayList<VolumeLine> volume_lines = new ArrayList<VolumeLine>();
        LineBoxer.recAdd(surfaceLayers, depth, resolution, working_set, volume_lines, null, firstpt);
        VolumeGrid vgr = new VolumeGrid();
        vgr.importLines(volume_lines);
        return vgr;
    }

    private static void recAdd(double[] surfaceLayers, double depth, Resolution resolution, HashSet<TreePoint> working_set, ArrayList<VolumeLine> volume_lines, VolumeLine pGrid, TreePoint tp) {
        String lbl = tp.getLabel();
        tp.partBranchOffset = 0.0;
        log.debug("Processing {} with {} neighbours", tp, tp.getNeighbors().size());
        for (TreePoint tpn : tp.getNeighbors()) {
            if (working_set.contains(tpn)) {
                working_set.remove(tpn);
                log.debug("Looking at neighbour {}", tpn);
                if (lbl == null && tpn.nnbr == 1) {
                    lbl = tpn.getLabel();
                }
                VolumeLine vg = null;
                if (tpn.subAreaPeer == tp) {
                    log.debug("{}: skipping pt with peer", tpn);
                } else if (tp.subAreaPeer != null && tp.subAreaPeer == tp.parent) {
                    log.debug("{}: first pt after branch", tpn);
                    TreePoint par = tp.parent;
                    log.info("Starting a sub-branch at {} - {} {}", tp, tpn, pGrid);
                    vg = LineBoxer.baseGrid(surfaceLayers, depth, resolution, tp, tpn, lbl);
                    pGrid.subPlaneConnect(tp, tpn, vg, par.partBranchOffset);
                    par.partBranchOffset += 2.0 * tpn.getRadius();
                } else {
                    log.debug("Creating new grid between neighbouring points");
                    vg = LineBoxer.baseGrid(surfaceLayers, depth, resolution, tp, tpn, lbl);
                    if (pGrid != null) {
                        log.debug("Attaching with planeConnect()");
                        pGrid.planeConnect(vg);
                    }
                }
                lbl = null;
                if (vg != null) {
                    volume_lines.add(vg);
                    LineBoxer.recAdd(surfaceLayers, depth, resolution, working_set, volume_lines, vg, tpn);
                    continue;
                }
                LineBoxer.recAdd(surfaceLayers, depth, resolution, working_set, volume_lines, pGrid, tpn);
                continue;
            }
            log.debug("Neighbour {} already removed from the working set", tpn);
        }
    }

    private static VolumeLine baseGrid(double[] surfaceLayers, double depth, Resolution resolution, TreePoint tpa, TreePoint tpb, String lbl) {
        int nsl;
        double delta = resolution.getLocalDelta(tpa, tpb);
        String rgn = tpa.regionClassWith(tpb);
        double r = 0.5 * (tpa.getRadius() + tpb.getRadius()) - 1.0E-7;
        double dsl = 0.0;
        if (surfaceLayers != null && surfaceLayers.length > 0) {
            for (nsl = 0; nsl < surfaceLayers.length && dsl + surfaceLayers[nsl] < r; ++nsl) {
                dsl += surfaceLayers[nsl];
            }
        }
        double dleft = 2.0 * (r - dsl);
        int nreg = 1 + 2 * (int)(dleft / 2.0 / delta);
        double dtot = 2.0 * dsl + (double)nreg * delta;
        VolumeLine ret = new VolumeLine(nsl, nreg, surfaceLayers, dtot, depth);
        ret.lineFill(tpa, tpb, lbl, rgn);
        return ret;
    }
}

