/*
 * Decompiled with CFR 0.152.
 */
package neurord.disc;

import java.io.File;
import java.util.HashMap;
import neurord.disc.DiscSplitter;
import neurord.disc.SegmentSlicer;
import neurord.disc.TreeUtil;
import neurord.numeric.morph.TreePoint;
import neurord.numeric.morph.TreeWriter;
import neurord.numeric.morph.VolumeGrid;

public class TreeCurvedElementDiscretizer {
    TreePoint[] srcPoints;

    public TreeCurvedElementDiscretizer(TreePoint[] points) {
        this.srcPoints = points;
    }

    public VolumeGrid buildGrid(double d, HashMap<String, Double> resHM, double[] surfaceLayers, double mar) {
        TreePoint base = this.srcPoints[0];
        TreeUtil.parentizeFrom(base, this.srcPoints);
        TreeUtil.orientAC(base, this.srcPoints);
        SegmentSlicer ss = new SegmentSlicer(this.srcPoints);
        TreePoint[] slicedPoints = ss.getFixedWidthSlices(d, resHM);
        TreeWriter tw = new TreeWriter(slicedPoints);
        tw.writeSWC(new File("discretized-tree.swc"));
        VolumeGrid vgrid = null;
        DiscSplitter dsplit = new DiscSplitter(slicedPoints, d, resHM, surfaceLayers, mar);
        vgrid = dsplit.buildGrid();
        return vgrid;
    }
}

