/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import neurord.model.Product;
import neurord.model.Reactant;
import neurord.model.Specie;
import neurord.model.SpecieRef;
import neurord.util.Settings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Reaction {
    public static final Logger log = LogManager.getLogger();
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String id;
    @XmlElement(name="Reactant")
    private final ArrayList<Reactant> p_reactants = new ArrayList();
    @XmlElement(name="Product")
    private final ArrayList<Product> p_products = new ArrayList();
    private Double forwardRate;
    private Double reverseRate;
    public Double Q10;
    static final boolean reactions = Settings.getProperty("neurord.reactions", "Allow reactions to happen", true);
    private transient ArrayList<Specie> r_reactants;
    private transient ArrayList<Specie> r_products;

    public String getID() {
        return this.id != null ? this.id : Specie.generateID(this.getName());
    }

    protected static String formatSide(ArrayList<? extends SpecieRef> list) {
        if (list.isEmpty()) {
            return "nil";
        }
        StringBuffer b = new StringBuffer();
        boolean second = false;
        for (SpecieRef specieRef : list) {
            if (second) {
                b.append("+");
            } else {
                second = true;
            }
            if (specieRef.getStochiometry() > 1) {
                b.append("" + specieRef.getStochiometry() + "\u00d7");
            }
            b.append(specieRef.getSpecieID());
        }
        return b.toString();
    }

    public String getName() {
        if (this.name == null) {
            this.name = Reaction.formatSide(this.p_reactants) + "\u2192" + Reaction.formatSide(this.p_products);
        }
        return this.name;
    }

    public double getForwardRate() {
        if (!reactions) {
            return 0.0;
        }
        return this.forwardRate != null ? this.forwardRate : 0.0;
    }

    public double getReverseRate() {
        if (!reactions) {
            return 0.0;
        }
        return this.reverseRate != null ? this.reverseRate : 0.0;
    }

    public void add(Object obj) {
        if (obj instanceof Reactant) {
            this.p_reactants.add((Reactant)obj);
        } else if (obj instanceof Product) {
            this.p_products.add((Product)obj);
        } else {
            throw new RuntimeException("cannot add " + obj);
        }
    }

    public void resolve(HashMap<String, Specie> sphm) {
        if (this.p_reactants.isEmpty()) {
            log.warn("no reactants in reaction {}", this.name);
        }
        this.r_reactants = this.parseRefs(this.p_reactants, sphm);
        this.r_products = this.parseRefs(this.p_products, sphm);
    }

    private ArrayList<Specie> parseRefs(ArrayList<? extends SpecieRef> asr, HashMap<String, Specie> sphm) {
        ArrayList<Specie> ret = new ArrayList<Specie>();
        for (SpecieRef specieRef : asr) {
            Specie sr2 = sphm.get(specieRef.getSpecieID());
            if (sr2 == null) {
                throw new RuntimeException("reaction " + this.name + " mentions unknown specie " + specieRef);
            }
            ret.add(sr2);
        }
        return ret;
    }

    private static int[][] getIndices(ArrayList<Specie> spa, ArrayList<? extends SpecieRef> refs) {
        int n = spa.size();
        int[][] ret = new int[3][n];
        for (int i = 0; i < n; ++i) {
            ret[0][i] = spa.get(i).getIndex();
            ret[1][i] = refs.get(i).getStochiometry();
            ret[2][i] = refs.get(i).getPower();
            assert (ret[0][i] >= 0);
            assert (ret[1][i] >= 1);
            assert (ret[2][i] >= 0);
        }
        return ret;
    }

    public int[][] getReactantIndices() {
        return Reaction.getIndices(this.r_reactants, this.p_reactants);
    }

    public int[][] getProductIndices() {
        return Reaction.getIndices(this.r_products, this.p_products);
    }
}

