/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import javax.xml.bind.annotation.XmlAttribute;
import neurord.util.Settings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Specie {
    public static final Logger log = LogManager.getLogger();
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String id;
    @XmlAttribute
    private Double kdiff;
    @XmlAttribute
    private String kdiffunit;
    private transient int index;
    static final boolean diffusion = Settings.getProperty("neurord.diffusion", "Allow diffusion to happen", true);

    public String getID() {
        return this.id != null ? this.id : Specie.generateID(this.name);
    }

    public static String generateID(String name) {
        return name.replaceAll(" /\\\\", "_");
    }

    public String getName() {
        return this.name;
    }

    public void setIndex(int ict) {
        this.index = ict;
    }

    public int getIndex() {
        return this.index;
    }

    public double getDiffusionConstant() {
        if (!diffusion) {
            return 0.0;
        }
        if (this.kdiff == null) {
            return 0.0;
        }
        return this.kdiff * Specie.getFactor(this.kdiffunit);
    }

    private static double getFactor(String su) {
        if (su == null || su.equals("\u00b5m\u00b2/s") || su.equals("mu2/s")) {
            return 0.001;
        }
        if (su.equals("m2/s")) {
            return 1.0E9;
        }
        if (su.equals("cm\u00b2/s") || su.equals("cm2/s")) {
            return 100000.0;
        }
        if (su.equals("\u00b5m\u00b2/ms") || su.equals("mu2/ms")) {
            return 1.0;
        }
        log.error("Unknown units '{}'", su);
        throw new RuntimeException("Unknown units '" + su + "'");
    }
}

