/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;
import neurord.model.SpineType;
import neurord.numeric.morph.SpinePopulation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpineAllocation {
    static final Logger log = LogManager.getLogger();
    @XmlAttribute
    private String id;
    @XmlAttribute
    private String spineType;
    @XmlAttribute
    private String region;
    @XmlAttribute
    private Double lengthDensity;
    @XmlAttribute
    private Double areaDensity;
    private transient SpineType r_spineType;

    public void resolve(HashMap<String, SpineType> stHM) {
        this.r_spineType = stHM.get(this.spineType);
    }

    public String getID() {
        return this.id;
    }

    public SpinePopulation makePopulation(double depth2D) {
        double density;
        if (this.r_spineType == null) {
            return null;
        }
        if (this.areaDensity != null) {
            density = this.areaDensity;
        } else if (this.lengthDensity != null) {
            density = this.lengthDensity / depth2D / 2.0;
            log.debug("Using areaDensity = {}/{}/2 = {}", this.lengthDensity, depth2D, density);
        } else {
            return null;
        }
        return new SpinePopulation(this.id, this.r_spineType.getProfile(), this.region, density);
    }
}

